/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.AbstractRtuTransport;
import certa.modbus.client.ModbusClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.slf4j.LoggerFactory;

public class RtuOverTcpTransport
extends AbstractRtuTransport {
    private final String remoteAddressString;
    private final int remotePort;
    private final String localAddressString;
    private final int localPort;
    private final int connectTimeout;
    private Socket socket;

    public RtuOverTcpTransport(String string, int n, String string2, int n2, int n3, int n4, int n5, boolean bl) {
        super(n4, n5, bl, LoggerFactory.getLogger(RtuOverTcpTransport.class));
        this.remoteAddressString = string;
        this.remotePort = n;
        this.localAddressString = string2 != null ? string2 : "0.0.0.0";
        this.localPort = n2;
        this.connectTimeout = n3;
    }

    @Override
    protected synchronized boolean openPort() throws IOException {
        if (this.socket == null || this.socket.isClosed()) {
            this.log.info("Opening socket: {}:{} <-> {}:{}, respTO: {}, connTO: {}, pause: {}", this.localAddressString, this.localPort, this.remoteAddressString, this.remotePort, this.timeout, this.connectTimeout, this.pause);
            InetSocketAddress inetSocketAddress = this.localAddressString == null || this.localAddressString.isEmpty() ? null : new InetSocketAddress(InetAddress.getByName(this.localAddressString), this.localPort);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(InetAddress.getByName(this.remoteAddressString), this.remotePort);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                this.log.error("Error opening socket {} (sleep: {}", (Object)inetSocketAddress2, (Object)interruptedException);
            }
            this.socket = new Socket();
            try {
                this.socket.setSoLinger(true, 0);
                this.socket.bind(inetSocketAddress);
                this.socket.connect(inetSocketAddress2, this.connectTimeout);
                this.socket.setSoTimeout(this.timeout);
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            this.log.info("Socket opened: {} <-> {}", (Object)this.socket.getLocalSocketAddress(), (Object)this.socket.getRemoteSocketAddress());
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.log.info("Closing socket");
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.log.error("Error closing socket {}: {}", (Object)this.socket.getRemoteSocketAddress(), (Object)iOException);
            }
            this.log.info("Socket closed");
        }
    }

    @Override
    protected void clearInput() throws IOException {
        InputStream inputStream = this.socket.getInputStream();
        int n = inputStream.available();
        while (n > 0) {
            int n2 = Math.min(n, this.buffer.length);
            inputStream.read(this.buffer, 0, n2);
            if (this.log.isWarnEnabled()) {
                this.log.warn("Unexpected input: " + ModbusPdu.toHex(this.buffer, 0, n2));
            }
            n = inputStream.available();
        }
    }

    @Override
    protected void sendData(int n) throws IOException {
        this.socket.getOutputStream().write(this.buffer, 0, n);
    }

    @Override
    protected boolean readToBuffer(int n, int n2, ModbusClient modbusClient) throws IOException {
        int n3;
        InputStream inputStream = this.socket.getInputStream();
        long l = System.currentTimeMillis();
        long l2 = l + (long)this.timeout;
        int n4 = n;
        int n5 = n2;
        while (l < l2 && n5 > 0) {
            try {
                n3 = inputStream.read(this.buffer, n4, n5);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                n3 = 0;
                this.log.debug("readToBuffer(): SocketTimeoutException");
            }
            if (n3 < 0) {
                throw new IOException("Socket's InputStream is at End Of File");
            }
            n4 += n3;
            if ((n5 -= n3) <= 0) continue;
            l = System.currentTimeMillis();
        }
        n3 = n2 - n5;
        if (n3 < n2) {
            if (n3 > 0 && this.log.isTraceEnabled()) {
                this.log.trace("Read (incomplete): " + ModbusPdu.toHex(this.buffer, 0, n + n3));
            }
            this.log.warn("Response timeout ({} bytes, need {})", (Object)(n + n3), (Object)this.expectedBytes);
            return false;
        }
        return true;
    }
}

