/*
 * Decompiled with CFR 0.152.
 */
package certa.mentor.tool;

import certa.mentor.tool.CommSettingsPanel;
import certa.mentor.tool.ConnectDialog;
import certa.mentor.tool.ConnectionThread;
import certa.mentor.tool.EnterHandler;
import certa.mentor.tool.IntroPanel;
import certa.mentor.tool.Main;
import certa.mentor.tool.RegComboBox;
import certa.mentor.tool.Utils;
import certa.mentor.tool.VersionInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class MainFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    protected JButton btnConnect;
    protected JButton btnDisconnect;
    protected JButton btnClearMemory;
    protected JButton btnClearApp;
    protected JButton btnReboot;
    JLabel lblModel;
    JLabel lblVersion;
    JPanel pnlToolbar;
    JScrollPane scroll;
    JPanel pnlMainContent;
    JPanel pnlWorkContent;
    JPanel pnlStatus;
    JPanel pnlStatusStats;
    JLabel lblStatusNotConnected;
    JLabel lblStatusPort;
    JLabel lblStatusRequests;
    JLabel lblStatusErrors;
    JLabel lblLastCycle;
    JLabel lblMaxCycle;
    JLabel lblBaseErrorsCap;
    JLabel lblBaseErrors;
    JLabel lblStartsCount;
    JLabel lblBatteryCap;
    JLabel lblBattery;
    JLabel lblCpuTempCap;
    JLabel lblCpuTemp;
    JLabel lblEepromWritesCap;
    JLabel lblEepromWrites;
    JLabel lblVxErrorsCap;
    JLabel lblVxErrors;
    JLabel lblVxCycleCap;
    JLabel lblVxCycle;
    JLabel lblVxMaxCycleCap;
    JLabel lblVxMaxCycle;
    JLabel lblModeInit;
    JLabel lblModeNoProg;
    JLabel lblModeCalibr;
    JLabel lblModeProg;
    JLabel lblProgName;
    JLabel lblModeStopped;
    JLabel lblModeFatalError;
    IntroPanel pnlIntro;
    AInputsFilterPanel pnlAnalogInFilter;
    AInputsConfigPanel pnlAnalogInConfig;
    AInputsPtPanel pnlAnalogInPt;
    AInputsNTCPanel pnlAnalogInNTC;
    AInputsTempShiftPanel pnlAnalogTempShift;
    AInputsVoltPanel pnlAnalogInVolt;
    DInputsPanel pnlDigitalIn;
    CountersPanel pnlCounter;
    AOutputsPanel pnlAnalogOut;
    DOutputsPanel pnlDigitalOut;
    FDOPanel pnlFDO;
    RS485ParamsPanel pnlNetParams1;
    RS485ParamsPanel pnlNetParams2;
    RS485ParamsPanel pnlNetParams3;
    RS485ParamsPanel pnlNetParams4;
    ModbusTcpParamsPanel pnlModbusTcpParams;
    EthernetParamsPanel pnlEthernetParams;
    ClockParamsPanel pnlClockParams;
    HmiPasswordsPanel pnlPasswords;
    protected ConnectionThread connection;
    static final String TITLE = "ViCS Tool v" + VersionInfo.fullString;
    static final String PROP_MAXIMIZE = "main.maximized";
    boolean calibration;
    ActionListener connect = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.connection != null) {
                return;
            }
            MainFrame.this.startWait();
            CommSettingsPanel commSettingsPanel = ConnectDialog.showDialog();
            if (commSettingsPanel != null) {
                MainFrame.this.calibration = commSettingsPanel.calibration;
                String string = commSettingsPanel.getDescr();
                MainFrame.this.lblStatusPort.setText(string);
                MainFrame.this.setTitle(TITLE + " - " + string + (MainFrame.this.calibration ? " - \u041a\u0410\u041b\u0418\u0411\u0420\u041e\u0412\u041a\u0410" : ""));
                MainFrame.this.connection = new ConnectionThread(Main.frameInstance(), commSettingsPanel);
            }
        }
    };
    ActionListener disconnect = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.closeConnection();
        }
    };
    ActionListener clearMemory = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JOptionPane.showConfirmDialog(null, "<html>\u041f\u043e\u0441\u043b\u0435 \u0441\u0442\u0438\u0440\u0430\u043d\u0438\u044f \u043f\u0430\u043c\u044f\u0442\u0438, \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u0432\u0435\u0440\u043d\u0435\u0442\u0441\u044f \u043a \u0437\u0430\u0432\u043e\u0434\u0441\u043a\u0438\u043c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u043c.<br>\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 \u0432\u0445\u043e\u0434\u043e\u0432/\u0432\u044b\u0445\u043e\u0434\u043e\u0432 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0441\u044f.<br>\u0421\u0442\u0435\u0440\u0435\u0442\u044c \u0432\u0441\u044e \u043f\u0430\u043c\u044f\u0442\u044c?</html>", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", 0) == 0) {
                MainFrame.this.connection.clearMemory();
                JOptionPane.showMessageDialog(null, "<html>\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043f\u0430\u043c\u044f\u0442\u0438 \u0437\u0430\u043d\u0438\u043c\u0430\u0435\u0442 \u043f\u0440\u0438\u043c\u0435\u0440\u043d\u043e 15 \u0441\u0435\u043a\u0443\u043d\u0434.<br>\u041f\u043e\u0441\u043b\u0435 \u043e\u0447\u0438\u0441\u0442\u043a\u0438 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0441\u044f \u0441 \u0437\u0430\u0432\u043e\u0434\u0441\u043a\u0438\u043c\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u043f\u043e\u0440\u0442\u043e\u0432.</html>");
            }
        }
    };
    ActionListener reboot = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JOptionPane.showConfirmDialog(null, "<html>\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440?</html>", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", 0) == 0) {
                MainFrame.this.connection.rebootController();
            }
        }
    };
    ActionListener clearApp = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JOptionPane.showConfirmDialog(null, "<html>\u0421\u0442\u0435\u0440\u0435\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443?</html>", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", 0) == 0) {
                MainFrame.this.connection.clearApp();
            }
        }
    };
    private int errors = 0;
    private int lastEepromWrites = 0;
    private static String[] AI_TYPE = new String[]{"", "Pt1000", "0...10 V"};
    private static String[] FDO_CFG = new String[]{"", "\u0434\u0438\u0441\u043a\u0440.", "\u0428\u0418\u041c"};
    private static String[] SPEED = new String[]{"", "1200", "2400", "4800", "9600", "19200", "38400"};
    private static String[] STOP_BITS = new String[]{"", "1", "2"};
    private static String[] PARITY = new String[]{"", "NO", "EVEN", "ODD"};
    private static String[] WEEKDAY = new String[]{"", "\u041f\u041d", "\u0412\u0422", "\u0421\u0420", "\u0427\u0422", "\u041f\u0422", "\u0421\u0411", "\u0412\u0421"};
    private static String[] MONTH = new String[]{"", "\u044f\u043d\u0432\u0430\u0440\u044c", "\u0444\u0435\u0432\u0440\u0430\u043b\u044c", "\u043c\u0430\u0440\u0442", "\u0430\u043f\u0440\u0435\u043b\u044c", "\u043c\u0430\u0439", "\u0438\u044e\u043d\u044c", "\u0438\u044e\u043b\u044c", "\u0430\u0432\u0433\u0443\u0441\u0442", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u043e\u043a\u0442\u044f\u0431\u0440\u044c", "\u043d\u043e\u044f\u0431\u0440\u044c", "\u0434\u0435\u043a\u0430\u0431\u0440\u044c"};
    private static String[] SUMMERTIME = new String[]{"", "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e", "\u0417\u0430\u043f. \u0415\u0432\u0440\u043e\u043f\u0430", "\u0426\u0435\u043d\u0442\u0440. \u0415\u0432\u0440\u043e\u043f\u0430", "\u0412\u043e\u0441\u0442. \u0415\u0432\u0440\u043e\u043f\u0430", "\u0421\u0428\u0410, \u041a\u0430\u043d\u0430\u0434\u0430"};
    private static String[] VBAT_CONTROL = new String[]{"", "\u0432\u043a\u043b\u044e\u0447\u0435\u043d", "\u0412\u042b\u041a\u041b\u042e\u0427\u0415\u041d"};

    public MainFrame() {
        super(TITLE);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pnlToolbar = new JPanel(new MigLayout("", "", ""));
        this.btnConnect = new JButton("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c...");
        this.btnConnect.addActionListener(this.connect);
        this.btnDisconnect = new JButton("\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c");
        this.btnDisconnect.addActionListener(this.disconnect);
        this.lblModel = new JLabel(" ");
        this.lblVersion = new JLabel(" ");
        this.lblModeInit = new JLabel("<html><center><b><font color='black'>INIT</font></b></center></html>");
        this.lblModeNoProg = new JLabel("<html><center><b><font color='purple'>\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430<br>\u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430</font></b></center></html>");
        this.lblModeCalibr = new JLabel("<html><center><b><font color='DarkGreen'>\u0420\u0435\u0436\u0438\u043c<br>\u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0438</font></b></center></html>");
        this.lblModeProg = new JLabel("<html><center><b><font color='red'>\u0417\u0430\u043f\u0438\u0441\u044c<br>\u041f\u041e</font></b></center></html>");
        this.lblProgName = new JLabel(" ");
        this.lblModeStopped = new JLabel("<html><center><b><font color='blue'>STOP</font></b></center></html>");
        this.lblModeFatalError = new JLabel("<html><center><b><font color='red'>ERROR</font></b></center></html>");
        this.btnClearMemory = new JButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043f\u0430\u043c\u044f\u0442\u044c");
        this.btnClearMemory.addActionListener(this.clearMemory);
        this.btnClearApp = new JButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443");
        this.btnClearApp.addActionListener(this.clearApp);
        this.btnReboot = new JButton("\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c");
        this.btnReboot.addActionListener(this.reboot);
        this.pnlToolbar.add((Component)this.btnConnect, "");
        this.pnlToolbar.add((Component)this.btnDisconnect, "");
        this.pnlToolbar.add((Component)this.lblModel, "al left, gapx 20");
        this.pnlToolbar.add((Component)this.lblVersion, "al left, gapx 10");
        this.pnlToolbar.add((Component)this.lblModeInit, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeNoProg, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeCalibr, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.btnClearMemory, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeStopped, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeFatalError, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeProg, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblProgName, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.btnClearApp, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.btnReboot, "hidemode 3, al left, gapx 30");
        this.add((Component)this.pnlToolbar, "North");
        this.pnlMainContent = new JPanel(new CardLayout());
        this.pnlWorkContent = new JPanel(new MigLayout(""));
        this.scroll = new JScrollPane(this.pnlWorkContent);
        this.pnlIntro = new IntroPanel();
        this.add((Component)this.pnlMainContent, "Center");
        this.pnlStatus = new JPanel();
        this.pnlStatus.setLayout(new BoxLayout(this.pnlStatus, 0));
        this.pnlStatus.setBorder(BorderFactory.createSoftBevelBorder(1));
        this.pnlStatusStats = new JPanel();
        this.pnlStatusStats.setLayout(new BoxLayout(this.pnlStatusStats, 0));
        this.lblStatusNotConnected = new JLabel("\u041d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
        this.lblStatusPort = new JLabel("");
        this.lblStatusRequests = new JLabel("");
        this.lblStatusErrors = new JLabel("");
        this.lblLastCycle = new JLabel("");
        this.lblMaxCycle = new JLabel("");
        this.lblBaseErrorsCap = new JLabel("    \u041e\u0448\u0438\u0431\u043a\u0438 BASE:");
        this.lblBaseErrors = new JLabel("");
        this.lblStartsCount = new JLabel("");
        this.lblBatteryCap = new JLabel("");
        this.lblBattery = new JLabel("");
        this.lblCpuTempCap = new JLabel("");
        this.lblCpuTemp = new JLabel("");
        this.lblEepromWritesCap = new JLabel("     \u0417\u0430\u043f\u0438\u0441\u044c EEPROM:");
        this.lblEepromWrites = new JLabel("");
        this.lblVxErrorsCap = new JLabel("      VX \u043e\u0448\u0438\u0431\u043a\u0438:");
        this.lblVxErrors = new JLabel("");
        this.lblVxCycleCap = new JLabel("    VX \u0446\u0438\u043a\u043b: ");
        this.lblVxCycle = new JLabel("");
        this.lblVxMaxCycleCap = new JLabel("  (\u043c\u0430\u043a\u0441: ");
        this.lblVxMaxCycle = new JLabel("");
        this.pnlStatusStats.add(this.lblStatusPort);
        this.pnlStatusStats.add(this.lblCpuTempCap);
        this.pnlStatusStats.add(this.lblCpuTemp);
        this.pnlStatusStats.add(this.lblBatteryCap);
        this.pnlStatusStats.add(this.lblBattery);
        this.pnlStatusStats.add(new JLabel("    \u041a-\u0432\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439: "));
        this.pnlStatusStats.add(this.lblStartsCount);
        this.pnlStatusStats.add(this.lblEepromWritesCap);
        this.pnlStatusStats.add(this.lblEepromWrites);
        this.pnlStatusStats.add(this.lblBaseErrorsCap);
        this.pnlStatusStats.add(this.lblBaseErrors);
        this.pnlStatusStats.add(new JLabel("    \u0426\u0438\u043a\u043b \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b: "));
        this.pnlStatusStats.add(this.lblLastCycle);
        this.pnlStatusStats.add(new JLabel("  (\u043c\u0430\u043a\u0441: "));
        this.pnlStatusStats.add(this.lblMaxCycle);
        this.pnlStatusStats.add(new JLabel(") "));
        this.pnlStatusStats.add(this.lblVxErrorsCap);
        this.pnlStatusStats.add(this.lblVxErrors);
        this.pnlStatusStats.add(this.lblVxCycleCap);
        this.pnlStatusStats.add(this.lblVxCycle);
        this.pnlStatusStats.add(this.lblVxMaxCycleCap);
        this.pnlStatusStats.add(this.lblVxMaxCycle);
        this.pnlStatusStats.add(new JLabel(") "));
        this.pnlStatusStats.add(new JLabel("            \u0417\u0430\u043f\u0440\u043e\u0441\u044b: "));
        this.pnlStatusStats.add(this.lblStatusRequests);
        this.pnlStatusStats.add(new JLabel("  \u041e\u0448\u0438\u0431\u043a\u0438: "));
        this.pnlStatusStats.add(this.lblStatusErrors);
        this.pnlStatus.add(this.lblStatusNotConnected);
        this.pnlStatus.add(this.pnlStatusStats);
        this.add((Component)this.pnlStatus, "South");
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(980, 620));
        this.disconnected(null);
        this.pack();
        this.setLocationByPlatform(true);
        this.setExtendedState(6);
    }

    private void createControls() {
        this.pnlWorkContent.removeAll();
        this.pnlAnalogInFilter = new AInputsFilterPanel();
        this.pnlAnalogInConfig = new AInputsConfigPanel();
        this.pnlAnalogInPt = new AInputsPtPanel();
        this.pnlAnalogInNTC = new AInputsNTCPanel();
        this.pnlAnalogTempShift = new AInputsTempShiftPanel();
        this.pnlAnalogInVolt = new AInputsVoltPanel();
        this.pnlDigitalIn = new DInputsPanel(8);
        this.pnlCounter = new CountersPanel();
        this.pnlAnalogOut = new AOutputsPanel();
        this.pnlDigitalOut = new DOutputsPanel();
        this.pnlFDO = new FDOPanel();
        this.pnlNetParams1 = new RS485ParamsPanel(0, "RS485 \u21161");
        this.pnlNetParams2 = new RS485ParamsPanel(4, "RS485 \u21162");
        this.pnlNetParams3 = new RS485ParamsPanel(8, "RS485 \u21163");
        this.pnlNetParams4 = new RS485ParamsPanel(12, "RS485 \u2116 4");
        this.pnlModbusTcpParams = new ModbusTcpParamsPanel();
        this.pnlEthernetParams = new EthernetParamsPanel();
        this.pnlClockParams = new ClockParamsPanel();
        this.pnlPasswords = new HmiPasswordsPanel();
        JLabel jLabel = new JLabel("<html>\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0440\u0442\u043e\u0432 \u0432\u0441\u0442\u0443\u043f\u0430\u044e\u0442 \u0432 \u0441\u0438\u043b\u0443 \u043f\u043e\u0441\u043b\u0435 \u0441\u043d\u044f\u0442\u0438\u044f \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u043a\u0438 Init, \u0438\u043b\u0438 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430.</html>");
        jLabel.setOpaque(true);
        jLabel.setBackground(SystemColor.info);
        jLabel.setForeground(SystemColor.infoText);
        this.pnlWorkContent.add((Component)jLabel, "span");
        this.pnlWorkContent.add((Component)this.pnlNetParams1, "");
        this.pnlWorkContent.add((Component)this.pnlNetParams2, "hidemode 2");
        this.pnlWorkContent.add((Component)this.pnlNetParams3, "hidemode 2");
        this.pnlWorkContent.add((Component)this.pnlNetParams4, "hidemode 2");
        this.pnlWorkContent.add((Component)this.pnlModbusTcpParams, "hidemode 2");
        this.pnlWorkContent.add((Component)this.pnlClockParams, "spany 2, aligny top");
        this.pnlWorkContent.add((Component)this.pnlPasswords, "spany 2, aligny top, wrap");
        this.pnlWorkContent.add((Component)this.pnlEthernetParams, "hidemode 2, span 5, wrap");
        if (this.calibration) {
            this.pnlWorkContent.add((Component)this.pnlAnalogInFilter, "split, span");
            this.pnlWorkContent.add((Component)this.pnlAnalogInConfig, "hidemode 3");
            this.pnlWorkContent.add((Component)this.pnlAnalogInPt, "");
            this.pnlWorkContent.add((Component)this.pnlAnalogInNTC, "hidemode 3");
            this.pnlWorkContent.add((Component)this.pnlAnalogTempShift, "wrap");
            this.pnlWorkContent.add((Component)this.pnlAnalogInVolt, "split, span");
            this.pnlWorkContent.add((Component)this.pnlDigitalIn, "");
            this.pnlWorkContent.add((Component)this.pnlCounter, "");
            this.pnlWorkContent.add((Component)this.pnlAnalogOut, "");
            this.pnlWorkContent.add((Component)this.pnlDigitalOut, "");
            this.pnlWorkContent.add((Component)this.pnlFDO, "hidemode 2");
            this.setExtendedState(6);
        } else {
            this.pnlWorkContent.add((Component)this.pnlAnalogInFilter, "split, span, hidemode 3");
            this.pnlWorkContent.add((Component)this.pnlAnalogInConfig, "hidemode 3");
            this.pnlWorkContent.add((Component)this.pnlAnalogInPt, "hidemode 3");
            this.pnlWorkContent.add((Component)this.pnlAnalogInNTC, "hidemode 3");
            this.pnlWorkContent.add((Component)this.pnlAnalogTempShift, "hidemode 3");
            this.pnlWorkContent.add((Component)this.pnlAnalogInVolt, "hidemode 3");
            this.pnlWorkContent.add((Component)this.pnlDigitalIn, "hidemode 3");
            this.pnlWorkContent.add((Component)this.pnlCounter, "wrap");
            jLabel = new JLabel("<html>\u0415\u0441\u043b\u0438 \u0432\u044b\u0445\u043e\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430 \u0437\u0430\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u043d \u0432 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435, \u0442\u043e \u0435\u0433\u043e \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u0441\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0449\u0435\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435.</html>");
            jLabel.setOpaque(true);
            jLabel.setBackground(SystemColor.info);
            jLabel.setForeground(SystemColor.infoText);
            this.pnlWorkContent.add((Component)jLabel, "span");
            this.pnlWorkContent.add((Component)this.pnlAnalogOut, "split, span");
            this.pnlWorkContent.add((Component)this.pnlDigitalOut, "");
            this.pnlWorkContent.add((Component)this.pnlFDO, "hidemode 2");
        }
    }

    private void resetControls() {
        this.setTitle(TITLE);
        this.btnClearMemory.setVisible(false);
        this.btnClearApp.setVisible(false);
        this.btnReboot.setVisible(false);
        this.lblModel.setText("");
        this.lblVersion.setText("");
        this.lblProgName.setText("");
        this.lblModeInit.setVisible(false);
        this.lblModeNoProg.setVisible(false);
        this.lblModeCalibr.setVisible(false);
        this.lblModeStopped.setVisible(false);
        this.lblModeFatalError.setVisible(false);
        this.lblModeProg.setVisible(false);
        this.lblLastCycle.setText("-");
        this.lblMaxCycle.setText("-");
        this.lblBaseErrors.setText("-");
        this.lblStartsCount.setText("-");
        this.lblCpuTemp.setText("-");
        this.lblBattery.setText("-");
        this.lblEepromWrites.setText("-");
        this.lblStatusRequests.setText("-");
        this.lblStatusErrors.setText("-");
    }

    void startWait() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    void endWait() {
        this.setCursor(null);
    }

    private void showStaticControls(boolean bl) {
        this.pnlWorkContent.setVisible(bl);
        this.btnClearApp.setVisible(bl);
        this.btnClearMemory.setVisible(bl);
        this.btnReboot.setVisible(bl);
        this.lblVersion.setVisible(bl);
        this.lblProgName.setVisible(bl);
    }

    public void connected() {
        this.createControls();
        this.pnlMainContent.removeAll();
        this.pnlMainContent.add(this.scroll);
        this.showStaticControls(false);
        this.scroll.setCursor(Cursor.getPredefinedCursor(3));
        this.btnConnect.setEnabled(false);
        this.btnDisconnect.setEnabled(true);
        this.pnlStatusStats.setVisible(true);
        this.lblStatusNotConnected.setVisible(false);
        this.repaint();
    }

    public void disconnected(String string) {
        this.pnlMainContent.removeAll();
        this.pnlMainContent.add(this.pnlIntro);
        this.btnConnect.setEnabled(true);
        this.btnDisconnect.setEnabled(false);
        this.pnlStatusStats.setVisible(false);
        this.lblStatusNotConnected.setVisible(true);
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
        }
        this.connection = null;
        this.resetControls();
        this.repaint();
    }

    private void updateRegister(JTextField jTextField, ConnectionThread.Register register, int n, int n2, boolean bl) {
        String string = "-";
        if (register.isGood()) {
            string = register.isHex() ? Integer.toHexString(register.getValue()) : Utils.FormatDouble((double)register.getValue() / (double)n, n2);
        }
        if (bl) {
            jTextField.setBackground("1".equals(string) ? Color.GREEN : null);
        }
        String string2 = null;
        if (register.isWriting()) {
            string2 = Utils.FormatDouble((double)register.writingValue() / (double)n, n2);
        }
        this.updateRegisterText(jTextField, string, string2);
    }

    private void updateRegister32(JTextField jTextField, ConnectionThread.Register register, ConnectionThread.Register register2) {
        String string = "-";
        if (register.isGood() && register2.isGood()) {
            string = Long.toString((long)register.getValue() << 16 | (long)register2.getValue());
        }
        String string2 = null;
        if (register.isWriting() || register2.isWriting()) {
            string2 = " ";
        }
        this.updateRegisterText(jTextField, string, string2);
    }

    private void updateRegisterText(JTextField jTextField, String string, String string2) {
        if (string2 != null) {
            string = jTextField.getHorizontalAlignment() == 4 ? " -> " + string : string + " <- ";
        }
        if (!string.equals(jTextField.getText())) {
            jTextField.setText(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        if (this.connection != null) {
            ConnectionThread connectionThread = this.connection;
            synchronized (connectionThread) {
                boolean bl;
                boolean bl2 = bl = this.connection.requestsCount > this.connection.errorsCount;
                if (bl) {
                    this.scroll.setCursor(null);
                    this.showStaticControls(true);
                }
                String string = this.connection.baseModel;
                this.lblModel.setText("<html><b>" + this.connection.model + "</b>" + (string.isEmpty() ? "" : "<br>(" + string + ")</html>"));
                string = this.connection.baseFirmware;
                this.lblVersion.setText("<html><b>v" + this.connection.firmware + "</b>" + (string.isEmpty() ? "" : "<br>BASE v" + string + "</html>"));
                this.lblProgName.setText(this.connection.modeNoProgram ? "" : "<html>\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430:<br><b>" + this.connection.progName + "</b></html>");
                this.lblModeInit.setVisible(this.connection.modeInit);
                this.lblModeNoProg.setVisible(this.connection.modeNoProgram);
                this.lblModeCalibr.setVisible(this.connection.modeCalibration);
                this.btnClearMemory.setVisible(this.connection.modeCalibration);
                this.btnClearApp.setVisible(bl);
                this.btnReboot.setVisible(bl);
                this.lblModeStopped.setVisible(this.connection.modeStopped);
                this.lblModeFatalError.setVisible(this.connection.modeFatalError);
                this.lblModeProg.setVisible(this.connection.modeProgramming);
                this.lblLastCycle.setText(Integer.toString(this.connection.lastCycle));
                this.lblMaxCycle.setText(Integer.toString(this.connection.maxCycle));
                this.lblBaseErrorsCap.setVisible(this.connection.actualBaseErrors);
                this.lblBaseErrors.setVisible(this.connection.actualBaseErrors);
                this.lblBaseErrors.setText(" " + this.connection.baseErrors + " ");
                this.lblStartsCount.setText(Integer.toString(this.connection.startsCount));
                this.lblCpuTempCap.setVisible(this.connection.actualCpuTemp);
                this.lblCpuTemp.setVisible(this.connection.actualCpuTemp);
                this.lblBatteryCap.setVisible(this.connection.actualBattery);
                this.lblBattery.setVisible(this.connection.actualBattery);
                if (this.connection.actualStack) {
                    this.lblBatteryCap.setText("    Stack: ");
                    this.lblCpuTempCap.setText("    RAM: ");
                    this.lblBattery.setText(Utils.FormatDouble((double)(this.connection.batteryVolts * 100.0f), 0));
                    this.lblCpuTemp.setText(Utils.FormatDouble((double)(this.connection.cpuTemp * 10.0f), 0));
                } else {
                    this.lblBatteryCap.setText("    \u0411\u0430\u0442\u0430\u0440\u0435\u0439\u043a\u0430: ");
                    this.lblCpuTempCap.setText("    \u0422\u0435\u043c\u043f-\u0440\u0430: ");
                    this.lblBattery.setText(Utils.FormatDouble((double)this.connection.batteryVolts, 2) + " V ");
                    this.lblCpuTemp.setText(Utils.FormatDouble((double)this.connection.cpuTemp, 1) + " \u00b0C");
                }
                this.lblEepromWritesCap.setVisible(this.connection.actualEepromWrites);
                this.lblEepromWrites.setVisible(this.connection.actualEepromWrites);
                this.lblEepromWrites.setText(" " + this.connection.eepromWrites + " ");
                this.lblVxErrorsCap.setVisible(this.connection.actualVxInfo);
                this.lblVxErrors.setVisible(this.connection.actualVxInfo);
                this.lblVxErrors.setText(" " + this.connection.vxErrors + " ");
                this.lblVxCycleCap.setVisible(this.connection.actualVxInfo);
                this.lblVxCycle.setVisible(this.connection.actualVxInfo);
                this.lblVxCycle.setText(Integer.toString(this.connection.vxCycle));
                this.lblVxMaxCycleCap.setVisible(this.connection.actualVxInfo);
                this.lblVxMaxCycle.setVisible(this.connection.actualVxInfo);
                this.lblVxMaxCycle.setText(Integer.toString(this.connection.vxMaxCycle));
                if (this.connection.baseErrors > 0) {
                    this.lblBaseErrors.setOpaque(true);
                    this.lblBaseErrors.setBackground(Color.MAGENTA);
                } else {
                    this.lblBaseErrors.setOpaque(false);
                    this.lblBaseErrors.setBackground(null);
                }
                if (this.connection.badBattery) {
                    this.lblBattery.setOpaque(true);
                    this.lblBattery.setBackground(Color.RED);
                } else {
                    this.lblBattery.setOpaque(false);
                    this.lblBattery.setBackground(null);
                }
                if (this.connection.eepromWrites != this.lastEepromWrites) {
                    this.lblEepromWrites.setOpaque(true);
                    this.lblEepromWrites.setBackground(Color.YELLOW);
                    this.lastEepromWrites = this.connection.eepromWrites;
                } else {
                    this.lblEepromWrites.setOpaque(false);
                    this.lblEepromWrites.setBackground(null);
                }
                this.lblStatusRequests.setText(" " + Integer.toString(this.connection.requestsCount) + " ");
                int n = this.connection.errorsCount;
                this.lblStatusErrors.setText(" " + Integer.toString(n) + " ");
                if (n != this.errors) {
                    this.errors = n;
                    this.lblStatusErrors.setOpaque(true);
                    this.lblStatusErrors.setBackground(Color.RED);
                } else {
                    this.lblStatusErrors.setOpaque(false);
                    this.lblStatusErrors.setBackground(null);
                }
                this.pnlNetParams1.updateData();
                this.pnlNetParams2.setVisible(this.connection.actualRs485Count >= 2);
                this.pnlNetParams2.updateData();
                this.pnlNetParams3.setVisible(this.connection.actualRs485Count >= 3);
                this.pnlNetParams3.updateData();
                this.pnlNetParams4.setVisible(this.connection.actualRs485Count >= 4);
                this.pnlNetParams4.updateData();
                this.pnlModbusTcpParams.setVisible(this.connection.actualEthernet);
                this.pnlModbusTcpParams.updateData();
                this.pnlEthernetParams.setVisible(this.connection.actualEthernet);
                this.pnlEthernetParams.updateData();
                this.pnlClockParams.updateData();
                this.pnlPasswords.updateData();
                this.pnlDigitalIn.updateData();
                this.pnlCounter.updateData();
                this.pnlAnalogInConfig.setVisible(this.connection.actualAiCfg);
                if (this.connection.actualAiCfg) {
                    this.pnlAnalogInConfig.updateData();
                }
                this.pnlAnalogInFilter.updateData();
                this.pnlAnalogInPt.updateData();
                this.pnlAnalogInNTC.setVisible(this.connection.actualAiNTC);
                if (this.connection.actualAiNTC) {
                    this.pnlAnalogInNTC.updateData();
                }
                this.pnlAnalogTempShift.updateData();
                this.pnlAnalogInVolt.updateData();
                this.pnlAnalogOut.updateData();
                this.pnlDigitalOut.updateData();
                this.pnlFDO.setVisible(this.connection.actualFdoAnalog);
                if (this.connection.actualFdoAnalog) {
                    this.pnlFDO.updateData();
                }
            }
        }
    }

    public void loadConfig(File file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        if (this.connection != null) {
            this.connection.stop();
            ConnectionThread connectionThread = this.connection;
            synchronized (connectionThread) {
                try {
                    this.connection.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeConnection();
        this.setDefaultCloseOperation(3);
        Main.props.saveBool(PROP_MAXIMIZE, this.getExtendedState() == 6);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static JButton createButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private static JTextField createRegView(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        return jTextField;
    }

    private static JTextField createRegEdit(int n, ActionListener actionListener) {
        JTextField jTextField = new JTextField(n);
        jTextField.addKeyListener(new EnterHandler(actionListener, jTextField));
        return jTextField;
    }

    static RegComboBox createRegCombo(String[] stringArray, KeyListener keyListener) {
        RegComboBox regComboBox = new RegComboBox(stringArray);
        regComboBox.addKeyListener(keyListener);
        regComboBox.setSelectedIndex(0);
        return regComboBox;
    }

    private void writeReg(ConnectionThread.Register register, int n, int n2, int n3) {
        this.writeReg(register, n, n2, n3, false);
    }

    private void writeReg(ConnectionThread.Register register, int n, int n2, int n3, boolean bl) {
        if (n >= n2 && n <= n3) {
            this.connection.writeRegister(register, n, bl);
        }
    }

    private void writeRegFromTF(ConnectionThread.Register register, JTextField jTextField, int n, int n2, int n3, JTextField jTextField2) {
        this.writeRegFromTF(register, jTextField, n, n2, n3, jTextField2, false);
    }

    private void writeRegFromTF(ConnectionThread.Register register, JTextField jTextField, int n, int n2, int n3, JTextField jTextField2, boolean bl) {
        if (jTextField2 != null && jTextField2 != jTextField) {
            return;
        }
        int n4 = n2 - 1;
        if (register.isHex()) {
            try {
                n4 = Integer.parseInt(jTextField.getText(), 16);
            }
            catch (Exception exception) {
                n4 = n2 - 1;
            }
        } else {
            double d = Utils.StringToDouble(jTextField.getText());
            jTextField.setText("");
            if (Double.isNaN(d)) {
                return;
            }
            n4 = Utils.Round(d * (double)n);
        }
        if (n4 >= n2 && n4 <= n3) {
            this.connection.writeRegister(register, n4, bl);
        }
    }

    private void writeRegFromTF32(ConnectionThread.Register register, ConnectionThread.Register register2, JTextField jTextField, JTextField jTextField2) {
        if (jTextField2 != null && jTextField2 != jTextField) {
            return;
        }
        long l = -1L;
        try {
            l = Long.parseLong(jTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        jTextField.setText("");
        if (l >= 0L && l <= 0xFFFFFFFFL) {
            this.connection.writeRegister(register, (int)((l & 0xFFFFFFFFFFFF0000L) >> 16), false);
            this.connection.writeRegister(register2, (int)(l & 0xFFFFL), false);
        }
    }

    private static JTextField[] createRegViews(int n, int n2) {
        JTextField[] jTextFieldArray = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            jTextFieldArray[i] = MainFrame.createRegView(n2);
            jTextFieldArray[i].setHorizontalAlignment(4);
        }
        return jTextFieldArray;
    }

    private static JTextField[] createRegEdits(int n, int n2, ActionListener actionListener) {
        JTextField[] jTextFieldArray = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            jTextFieldArray[i] = MainFrame.createRegEdit(n2, actionListener);
        }
        return jTextFieldArray;
    }

    void resetTF(JTextField[] jTextFieldArray) {
        for (int i = 0; i < jTextFieldArray.length; ++i) {
            jTextFieldArray[i].setText("");
        }
    }

    JLabel jumpersImage(String string, String string2) {
        JLabel jLabel = new JLabel(new ImageIcon(Utils.getResource(string)));
        jLabel.setToolTipText(string2);
        return jLabel;
    }

    class ClockParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField tfSeconds;
        JTextField tfMinutes;
        JTextField tfHours;
        JTextField tfDayOfWeek;
        JTextField tfDayOfMonth;
        JTextField tfMonth;
        JTextField tfYear;
        JTextField tfSummerTime;
        JTextField tfCalibr;
        JLabel lblNoVbat;
        JTextField tfNoVbat;
        JTextField tfNewSeconds;
        JTextField tfNewMinutes;
        JTextField tfNewHours;
        JTextField tfNewDayOfWeek;
        JTextField tfNewDayOfMonth;
        JTextField tfNewMonth;
        JTextField tfNewYear;
        JTextField tfSetSecond;
        JTextField tfSetMinute;
        JTextField tfSetHour;
        RegComboBox cbxSetDOW;
        JTextField tfSetDate;
        RegComboBox cbxSetMonth;
        JTextField tfSetYear;
        RegComboBox cbxSetSummerTime;
        JTextField tfSetCalibr;
        RegComboBox cbxSetNoVbat;
        protected JButton btnWrite;
        protected JButton btnSync;

        public ClockParamsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRTC[7], ClockParamsPanel.this.cbxSetSummerTime.getSelectedIndex() - 1, 0, 4);
                            ClockParamsPanel.this.cbxSetSummerTime.setSelectedIndex(0);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[8], ClockParamsPanel.this.tfSetCalibr, 1, -500, 500, null, true);
                            if (MainFrame.this.connection.actHRegsRTC > 9) {
                                MainFrame.this.writeReg(MainFrame.this.connection.hregsRTC[9], ClockParamsPanel.this.cbxSetNoVbat.getSelectedIndex() - 1, 0, 1);
                                ClockParamsPanel.this.cbxSetNoVbat.setSelectedIndex(0);
                            }
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[1], ClockParamsPanel.this.tfSetMinute, 1, 0, 59, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[2], ClockParamsPanel.this.tfSetHour, 1, 0, 23, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRTC[3], ClockParamsPanel.this.cbxSetDOW.getSelectedIndex(), 1, 7);
                            ClockParamsPanel.this.cbxSetDOW.setSelectedIndex(0);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[4], ClockParamsPanel.this.tfSetDate, 1, 1, 31, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRTC[5], ClockParamsPanel.this.cbxSetMonth.getSelectedIndex(), 1, 12);
                            ClockParamsPanel.this.cbxSetMonth.setSelectedIndex(0);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[6], ClockParamsPanel.this.tfSetYear, 1, 0, 99, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[0], ClockParamsPanel.this.tfSetSecond, 1, 0, 59, null, true);
                            ClockParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfSeconds = MainFrame.createRegView(9);
            this.tfMinutes = MainFrame.createRegView(9);
            this.tfHours = MainFrame.createRegView(9);
            this.tfDayOfWeek = MainFrame.createRegView(9);
            this.tfDayOfMonth = MainFrame.createRegView(9);
            this.tfMonth = MainFrame.createRegView(9);
            this.tfYear = MainFrame.createRegView(9);
            this.tfSummerTime = MainFrame.createRegView(9);
            this.tfCalibr = MainFrame.createRegView(9);
            this.lblNoVbat = new JLabel("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c VBAT");
            this.tfNoVbat = MainFrame.createRegView(9);
            this.tfNewSeconds = MainFrame.createRegView(4);
            this.tfNewMinutes = MainFrame.createRegView(4);
            this.tfNewHours = MainFrame.createRegView(4);
            this.tfNewDayOfWeek = MainFrame.createRegView(4);
            this.tfNewDayOfMonth = MainFrame.createRegView(4);
            this.tfNewMonth = MainFrame.createRegView(4);
            this.tfNewYear = MainFrame.createRegView(4);
            this.tfSetSecond = MainFrame.createRegEdit(4, this.write);
            this.tfSetMinute = MainFrame.createRegEdit(4, this.write);
            this.tfSetHour = MainFrame.createRegEdit(4, this.write);
            this.cbxSetDOW = MainFrame.createRegCombo(WEEKDAY, this.enter);
            this.tfSetDate = MainFrame.createRegEdit(4, this.write);
            this.cbxSetMonth = MainFrame.createRegCombo(MONTH, this.enter);
            this.tfSetYear = MainFrame.createRegEdit(4, this.write);
            this.cbxSetSummerTime = MainFrame.createRegCombo(SUMMERTIME, this.enter);
            this.tfSetCalibr = MainFrame.createRegEdit(6, this.write);
            this.cbxSetNoVbat = MainFrame.createRegCombo(VBAT_CONTROL, this.enter);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.btnSync = MainFrame.createButton("\u0417\u0430\u043f. \u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Calendar calendar = Calendar.getInstance();
                    ClockParamsPanel.this.tfSetYear.setText(Integer.toString(calendar.get(1) % 100));
                    ClockParamsPanel.this.cbxSetMonth.setSelectedIndex(calendar.get(2) + 1);
                    ClockParamsPanel.this.tfSetDate.setText(Integer.toString(calendar.get(5)));
                    int n = calendar.get(7) - 1;
                    if (n == 0) {
                        n = 7;
                    }
                    ClockParamsPanel.this.cbxSetDOW.setSelectedIndex(n);
                    ClockParamsPanel.this.tfSetHour.setText(Integer.toString(calendar.get(11)));
                    ClockParamsPanel.this.tfSetMinute.setText(Integer.toString(calendar.get(12)));
                    ClockParamsPanel.this.tfSetSecond.setText(Integer.toString(calendar.get(13)));
                    ClockParamsPanel.this.write.actionPerformed(null);
                }
            });
            this.setBorder(BorderFactory.createTitledBorder("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0447\u0430\u0441\u043e\u0432"));
            if (MainFrame.this.calibration) {
                this.add((Component)this.lblNoVbat, "al right, hidemode 3");
                this.add((Component)this.tfNoVbat, "hidemode 3");
                this.add((Component)this.cbxSetNoVbat, "span 2, wrap, hidemode 3");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430:"), "al right");
                this.add((Component)this.tfCalibr, "");
                this.add((Component)this.tfSetCalibr, "span 2, wrap");
            }
            this.add((Component)new JLabel("\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f:"), "al right");
            this.add((Component)this.tfSummerTime, "");
            this.add((Component)this.cbxSetSummerTime, "span 2, wrap");
            JLabel jLabel = new JLabel("\u0412\u0441\u0435 \u043f\u043e\u043b\u044f \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e\u0442\u0441\u044f \u0432 RTC \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u0435\u043a\u0443\u043d\u0434");
            this.add((Component)jLabel, "span");
            jLabel.setOpaque(true);
            jLabel.setBackground(SystemColor.info);
            jLabel.setForeground(SystemColor.infoText);
            this.add((Component)new JLabel("\u0413\u043e\u0434:"), "al right");
            this.add((Component)this.tfYear, "");
            this.add((Component)this.tfNewYear, "");
            this.add((Component)this.tfSetYear, "wrap");
            this.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446:"), "al right");
            this.add((Component)this.tfMonth, "");
            this.add((Component)this.tfNewMonth, "");
            this.add((Component)this.cbxSetMonth, "wrap");
            this.add((Component)new JLabel("\u0414\u0435\u043d\u044c:"), "al right");
            this.add((Component)this.tfDayOfMonth, "");
            this.add((Component)this.tfNewDayOfMonth, "");
            this.add((Component)this.tfSetDate, "wrap");
            this.add((Component)new JLabel("\u0414\u0435\u043d\u044c \u043d\u0435\u0434\u0435\u043b\u0438:"), "al right");
            this.add((Component)this.tfDayOfWeek, "");
            this.add((Component)this.tfNewDayOfWeek, "");
            this.add((Component)this.cbxSetDOW, "wrap");
            this.add((Component)new JLabel("\u0427\u0430\u0441:"), "al right");
            this.add((Component)this.tfHours, "");
            this.add((Component)this.tfNewHours, "");
            this.add((Component)this.tfSetHour, "wrap");
            this.add((Component)new JLabel("\u041c\u0438\u043d\u0443\u0442\u0430:"), "al right");
            this.add((Component)this.tfMinutes, "");
            this.add((Component)this.tfNewMinutes, "");
            this.add((Component)this.tfSetMinute, "wrap");
            this.add((Component)new JLabel("\u0421\u0435\u043a\u0443\u043d\u0434\u0430:"), "al right");
            this.add((Component)this.tfSeconds, "");
            this.add((Component)this.tfNewSeconds, "");
            this.add((Component)this.tfSetSecond, "wrap");
            this.add((Component)this.btnSync, "span 2, align left");
            this.add((Component)this.btnWrite, "span 2, align right");
        }

        public void updateData() {
            if (this.isVisible()) {
                MainFrame.this.updateRegister(this.tfNewSeconds, MainFrame.this.connection.hregsRTC[0], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewMinutes, MainFrame.this.connection.hregsRTC[1], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewHours, MainFrame.this.connection.hregsRTC[2], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewDayOfWeek, MainFrame.this.connection.hregsRTC[3], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewDayOfMonth, MainFrame.this.connection.hregsRTC[4], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewMonth, MainFrame.this.connection.hregsRTC[5], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewYear, MainFrame.this.connection.hregsRTC[6], 1, 0, false);
                MainFrame.this.updateRegister(this.tfSummerTime, MainFrame.this.connection.hregsRTC[7], 1, 0, false);
                int n = Utils.StringToIntDef(this.tfSummerTime.getText(), -1);
                if (n >= 0 && n < SUMMERTIME.length - 1) {
                    this.tfSummerTime.setText(SUMMERTIME[n + 1]);
                }
                MainFrame.this.updateRegister(this.tfCalibr, MainFrame.this.connection.hregsRTC[8], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNoVbat, MainFrame.this.connection.hregsRTC[9], 1, 0, false);
                n = Utils.StringToIntDef(this.tfNoVbat.getText(), -1);
                if (n >= 0 && n < VBAT_CONTROL.length - 1) {
                    this.tfNoVbat.setText(VBAT_CONTROL[n + 1]);
                }
                this.lblNoVbat.setVisible(MainFrame.this.connection.actHRegsRTC > 9);
                this.tfNoVbat.setVisible(MainFrame.this.connection.actHRegsRTC > 9);
                this.cbxSetNoVbat.setVisible(MainFrame.this.connection.actHRegsRTC > 9);
                MainFrame.this.updateRegister(this.tfSeconds, MainFrame.this.connection.iregsRTC[0], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMinutes, MainFrame.this.connection.iregsRTC[1], 1, 0, false);
                MainFrame.this.updateRegister(this.tfHours, MainFrame.this.connection.iregsRTC[2], 1, 0, false);
                MainFrame.this.updateRegister(this.tfDayOfWeek, MainFrame.this.connection.iregsRTC[3], 1, 0, false);
                n = Utils.StringToIntDef(this.tfDayOfWeek.getText(), -1);
                if (n > 0 && n < WEEKDAY.length) {
                    this.tfDayOfWeek.setText(WEEKDAY[n]);
                }
                MainFrame.this.updateRegister(this.tfDayOfMonth, MainFrame.this.connection.iregsRTC[4], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMonth, MainFrame.this.connection.iregsRTC[5], 1, 0, false);
                n = Utils.StringToIntDef(this.tfMonth.getText(), -1);
                if (n > 0 && n < MONTH.length) {
                    this.tfMonth.setText(MONTH[n]);
                }
                MainFrame.this.updateRegister(this.tfYear, MainFrame.this.connection.iregsRTC[6], 1, 0, false);
            }
        }
    }

    class EthernetParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField[] tfIP;
        JTextField[] tfMask;
        JTextField[] tfGW;
        JTextField[] tfMAC;
        JTextField[] tfSetIP;
        JTextField[] tfSetMask;
        JTextField[] tfSetGW;
        JTextField[] tfSetMAC;
        protected JButton btnWrite;

        public EthernetParamsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[0], EthernetParamsPanel.this.tfSetIP[0], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[1], EthernetParamsPanel.this.tfSetIP[1], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[2], EthernetParamsPanel.this.tfSetIP[2], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[3], EthernetParamsPanel.this.tfSetIP[3], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[4], EthernetParamsPanel.this.tfSetMask[0], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[5], EthernetParamsPanel.this.tfSetMask[1], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[6], EthernetParamsPanel.this.tfSetMask[2], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[7], EthernetParamsPanel.this.tfSetMask[3], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[8], EthernetParamsPanel.this.tfSetGW[0], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[9], EthernetParamsPanel.this.tfSetGW[1], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[10], EthernetParamsPanel.this.tfSetGW[2], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[11], EthernetParamsPanel.this.tfSetGW[3], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[12], EthernetParamsPanel.this.tfSetMAC[0], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[13], EthernetParamsPanel.this.tfSetMAC[1], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[14], EthernetParamsPanel.this.tfSetMAC[2], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[15], EthernetParamsPanel.this.tfSetMAC[3], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[16], EthernetParamsPanel.this.tfSetMAC[4], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[17], EthernetParamsPanel.this.tfSetMAC[5], 1, 0, 255, null);
                            EthernetParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfIP = MainFrame.createRegViews(4, 3);
            this.tfMask = MainFrame.createRegViews(4, 3);
            this.tfGW = MainFrame.createRegViews(4, 3);
            this.tfMAC = MainFrame.createRegViews(6, 3);
            this.tfSetIP = MainFrame.createRegEdits(4, 3, this.write);
            this.tfSetMask = MainFrame.createRegEdits(4, 3, this.write);
            this.tfSetGW = MainFrame.createRegEdits(4, 3, this.write);
            this.tfSetMAC = MainFrame.createRegEdits(6, 3, this.write);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b Ethernet"));
            this.add((Component)new JLabel("  IP:"), "al right");
            this.add((Component)this.tfIP[0], "");
            this.add((Component)this.tfIP[1], "");
            this.add((Component)this.tfIP[2], "");
            this.add((Component)this.tfIP[3], "");
            this.add((Component)new JLabel("   \u041c\u0430\u0441\u043a\u0430:"), "al right");
            this.add((Component)this.tfMask[0], "");
            this.add((Component)this.tfMask[1], "");
            this.add((Component)this.tfMask[2], "");
            this.add((Component)this.tfMask[3], "");
            this.add((Component)new JLabel("   \u0428\u043b\u044e\u0437:"), "al right");
            this.add((Component)this.tfGW[0], "");
            this.add((Component)this.tfGW[1], "");
            this.add((Component)this.tfGW[2], "");
            this.add((Component)this.tfGW[3], "");
            this.add((Component)new JLabel("   MAC:"), "al right");
            this.add((Component)this.tfMAC[0], "");
            this.add((Component)this.tfMAC[1], "");
            this.add((Component)this.tfMAC[2], "");
            this.add((Component)this.tfMAC[3], "");
            this.add((Component)this.tfMAC[4], "");
            this.add((Component)this.tfMAC[5], "wrap");
            this.add((Component)this.tfSetIP[0], "skip 1");
            this.add((Component)this.tfSetIP[1], "");
            this.add((Component)this.tfSetIP[2], "");
            this.add((Component)this.tfSetIP[3], "");
            this.add((Component)this.tfSetMask[0], "skip 1");
            this.add((Component)this.tfSetMask[1], "");
            this.add((Component)this.tfSetMask[2], "");
            this.add((Component)this.tfSetMask[3], "");
            this.add((Component)this.tfSetGW[0], "skip 1");
            this.add((Component)this.tfSetGW[1], "");
            this.add((Component)this.tfSetGW[2], "");
            this.add((Component)this.tfSetGW[3], "");
            this.add((Component)this.tfSetMAC[0], "skip 1");
            this.add((Component)this.tfSetMAC[1], "");
            this.add((Component)this.tfSetMAC[2], "");
            this.add((Component)this.tfSetMAC[3], "");
            this.add((Component)this.tfSetMAC[4], "");
            this.add((Component)this.tfSetMAC[5], "wrap");
            this.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0443\u043b\u0438 \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"), "skip 1, span 17, al left");
            this.add((Component)this.btnWrite, "span 4, align right");
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 12; i <= 17; ++i) {
                    MainFrame.this.connection.hregsEthernet[i].setHex(true);
                }
                MainFrame.this.updateRegister(this.tfIP[0], MainFrame.this.connection.hregsEthernet[0], 1, 0, false);
                MainFrame.this.updateRegister(this.tfIP[1], MainFrame.this.connection.hregsEthernet[1], 1, 0, false);
                MainFrame.this.updateRegister(this.tfIP[2], MainFrame.this.connection.hregsEthernet[2], 1, 0, false);
                MainFrame.this.updateRegister(this.tfIP[3], MainFrame.this.connection.hregsEthernet[3], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMask[0], MainFrame.this.connection.hregsEthernet[4], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMask[1], MainFrame.this.connection.hregsEthernet[5], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMask[2], MainFrame.this.connection.hregsEthernet[6], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMask[3], MainFrame.this.connection.hregsEthernet[7], 1, 0, false);
                MainFrame.this.updateRegister(this.tfGW[0], MainFrame.this.connection.hregsEthernet[8], 1, 0, false);
                MainFrame.this.updateRegister(this.tfGW[1], MainFrame.this.connection.hregsEthernet[9], 1, 0, false);
                MainFrame.this.updateRegister(this.tfGW[2], MainFrame.this.connection.hregsEthernet[10], 1, 0, false);
                MainFrame.this.updateRegister(this.tfGW[3], MainFrame.this.connection.hregsEthernet[11], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[0], MainFrame.this.connection.hregsEthernet[12], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[1], MainFrame.this.connection.hregsEthernet[13], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[2], MainFrame.this.connection.hregsEthernet[14], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[3], MainFrame.this.connection.hregsEthernet[15], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[4], MainFrame.this.connection.hregsEthernet[16], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[5], MainFrame.this.connection.hregsEthernet[17], 1, 0, false);
            }
        }
    }

    class ModbusTcpParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField[] tfPort;
        JTextField[] tfSetPort;
        protected JButton btnWrite;

        public ModbusTcpParamsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            for (int i = 0; i < ModbusTcpParamsPanel.this.tfPort.length; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[18 + i], ModbusTcpParamsPanel.this.tfSetPort[i], 1, 0, 65535, null);
                            }
                            ModbusTcpParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfPort = MainFrame.createRegViews(3, 4);
            this.tfSetPort = MainFrame.createRegEdits(3, 4, this.write);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder("\u041f\u043e\u0440\u0442\u044b MODBUS TCP"));
            for (int i = 0; i < this.tfPort.length; ++i) {
                this.add((Component)new JLabel("\u041f\u043e\u0440\u0442 \u2116" + (i + 1) + ":"), "");
                this.add((Component)this.tfPort[i], "");
                this.add((Component)this.tfSetPort[i], "wrap");
            }
            this.add((Component)this.btnWrite, "span 4, align right");
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 0; i < this.tfPort.length; ++i) {
                    MainFrame.this.updateRegister(this.tfPort[i], MainFrame.this.connection.hregsEthernet[18 + i], 1, 0, false);
                }
            }
        }
    }

    class HmiPasswordsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField[] tfPwd;
        JTextField[] tfSetPwd;
        String[] pwdNames;
        protected JButton btnWrite;

        public HmiPasswordsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            for (int i = 0; i < HmiPasswordsPanel.this.tfPwd.length; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsPasswords[i], HmiPasswordsPanel.this.tfSetPwd[i], 1, 0, 9999, null);
                            }
                            HmiPasswordsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfPwd = MainFrame.createRegViews(3, 4);
            this.tfSetPwd = MainFrame.createRegEdits(3, 4, this.write);
            this.pwdNames = new String[]{"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c:", "\u0421\u0435\u0440\u0432\u0438\u0441:", "\u0420\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a:"};
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder("\u041f\u0430\u0440\u043e\u043b\u0438 \u0434\u043b\u044f \u0434\u0438\u0441\u043f\u043b\u0435\u044f"));
            for (int i = 0; i < this.tfPwd.length; ++i) {
                this.add((Component)new JLabel(this.pwdNames[i]), "");
                this.add((Component)this.tfPwd[i], "");
                this.add((Component)this.tfSetPwd[i], "wrap");
            }
            this.add((Component)this.btnWrite, "span 4, align right");
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 0; i < this.tfPwd.length; ++i) {
                    MainFrame.this.updateRegister(this.tfPwd[i], MainFrame.this.connection.hregsPasswords[i], 1, 0, false);
                }
            }
        }
    }

    class RS485ParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final int startAddr;
        ActionListener write;
        EnterHandler enter;
        JTextField tfNetId;
        JTextField tfNetSpeed;
        JTextField tfNetParity;
        JTextField tfNetStopBits;
        JTextField tfSetNetId;
        RegComboBox cbxSetNetSpeed;
        RegComboBox cbxSetNetParity;
        RegComboBox cbxSetNetStopBits;
        protected JButton btnWrite;

        public RS485ParamsPanel(int n, String string) {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRS485[RS485ParamsPanel.this.startAddr], RS485ParamsPanel.this.tfSetNetId, 1, 1, 254, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRS485[RS485ParamsPanel.this.startAddr + 1], RS485ParamsPanel.this.cbxSetNetSpeed.getSelectedIndex() - 1, 0, 5);
                            RS485ParamsPanel.this.cbxSetNetSpeed.setSelectedIndex(0);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRS485[RS485ParamsPanel.this.startAddr + 2], RS485ParamsPanel.this.cbxSetNetStopBits.getSelectedIndex(), 1, 2);
                            RS485ParamsPanel.this.cbxSetNetStopBits.setSelectedIndex(0);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRS485[RS485ParamsPanel.this.startAddr + 3], RS485ParamsPanel.this.cbxSetNetParity.getSelectedIndex() - 1, 0, 2);
                            RS485ParamsPanel.this.cbxSetNetParity.setSelectedIndex(0);
                            RS485ParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfNetId = MainFrame.createRegView(6);
            this.tfNetSpeed = MainFrame.createRegView(6);
            this.tfNetParity = MainFrame.createRegView(6);
            this.tfNetStopBits = MainFrame.createRegView(6);
            this.tfSetNetId = MainFrame.createRegEdit(4, this.write);
            this.cbxSetNetSpeed = MainFrame.createRegCombo(SPEED, this.enter);
            this.cbxSetNetParity = MainFrame.createRegCombo(PARITY, this.enter);
            this.cbxSetNetStopBits = MainFrame.createRegCombo(STOP_BITS, this.enter);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.startAddr = n;
            this.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441:"), "al right");
            this.add((Component)this.tfNetId, "");
            this.add((Component)this.tfSetNetId, "wrap");
            this.add((Component)new JLabel("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c:"), "al right");
            this.add((Component)this.tfNetSpeed, "");
            this.add((Component)this.cbxSetNetSpeed, "wrap");
            this.add((Component)new JLabel("\u0427\u0435\u0442\u043d\u043e\u0441\u0442\u044c:"), "al right");
            this.add((Component)this.tfNetParity, "");
            this.add((Component)this.cbxSetNetParity, "wrap");
            this.add((Component)new JLabel("\u0421\u0442\u043e\u043f-\u0431\u0438\u0442\u044b:"), "al right");
            this.add((Component)this.tfNetStopBits, "");
            this.add((Component)this.cbxSetNetStopBits, "wrap");
            this.add((Component)this.btnWrite, "span 2, align right");
        }

        private String parityString(int n) {
            if (++n >= 0 && n < PARITY.length) {
                return PARITY[n];
            }
            return Integer.toString(n);
        }

        public void updateData() {
            if (this.isVisible()) {
                ConnectionThread.Register register;
                MainFrame.this.updateRegister(this.tfNetId, MainFrame.this.connection.hregsRS485[this.startAddr], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNetSpeed, MainFrame.this.connection.hregsRS485[this.startAddr + 1], 1, 0, false);
                int n = Utils.StringToIntDef(this.tfNetSpeed.getText(), -1);
                if (n >= 0 && n < SPEED.length - 1) {
                    this.tfNetSpeed.setText(SPEED[n + 1]);
                }
                MainFrame.this.updateRegisterText(this.tfNetParity, (register = MainFrame.this.connection.hregsRS485[this.startAddr + 3]).isGood() ? this.parityString(register.getValue()) : "-", register.needWrite ? this.parityString(register.writingValue()) : null);
                MainFrame.this.updateRegister(this.tfNetStopBits, MainFrame.this.connection.hregsRS485[this.startAddr + 2], 1, 0, false);
            }
        }
    }

    class UpDownHandler
    extends KeyAdapter {
        private final ConnectionThread.Register reg;
        private final JTextField tf;

        public UpDownHandler(ConnectionThread.Register register, JTextField jTextField) {
            this.reg = register;
            this.tf = jTextField;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incRegValue(int n) {
            if (MainFrame.this.connection != null) {
                ConnectionThread connectionThread = MainFrame.this.connection;
                synchronized (connectionThread) {
                    if (this.reg.isGood()) {
                        int n2 = Utils.StringToIntDef(this.tf.getText(), -1);
                        if (n2 < 0) {
                            int n3 = n2 = this.reg.needWrite ? this.reg.valueToWrite : this.reg.getValue();
                        }
                        if ((n2 += n) >= 0 && n2 <= 1023) {
                            MainFrame.this.connection.writeRegister(this.reg, n2, false);
                            this.tf.setText(Integer.toString(n2));
                        }
                    }
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38) {
                this.incRegValue(keyEvent.isControlDown() ? 10 : 1);
            }
            if (keyEvent.getKeyCode() == 40) {
                this.incRegValue(keyEvent.isControlDown() ? -10 : -1);
            }
            if (keyEvent.getKeyCode() == 27) {
                this.tf.setText("");
            }
        }
    }

    class AOutputsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        ActionListener all10;
        ActionListener all0;
        JTextField[] tfOut;
        JTextField[] tfDAC;
        JTextField[] tfW;
        JTextField[] tfSetW;
        JTextField[] tfSetOut;
        JLabel[] labels;
        JButton[] btnPlus;
        JButton[] btnMinus;

        public AOutputsPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n;
                            int n2 = MainFrame.this.connection.actualAoCount;
                            int n3 = n = MainFrame.this.connection.actualAiNTC ? MainFrame.this.connection.actualAiCount * 5 : MainFrame.this.connection.actualAiCount * 3;
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < n2; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs50xx[0 + i], AOutputsPanel.this.tfSetOut[i], 100, 0, 1000, jTextField);
                                if (!MainFrame.this.calibration) continue;
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsCal[n + i], AOutputsPanel.this.tfSetW[i], 1, 0, 65535, jTextField);
                            }
                            AOutputsPanel.this.updateData();
                        }
                    }
                }
            };
            this.all10 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < MainFrame.this.connection.actualAoCount; ++i) {
                        AOutputsPanel.this.tfSetOut[i].setText("10");
                    }
                }
            };
            this.all0 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < MainFrame.this.connection.actualAoCount; ++i) {
                        AOutputsPanel.this.tfSetOut[i].setText("0");
                    }
                }
            };
            this.tfOut = MainFrame.createRegViews(6, 10);
            this.tfDAC = MainFrame.createRegViews(6, 5);
            this.tfW = MainFrame.createRegViews(6, 10);
            this.tfSetW = MainFrame.createRegEdits(6, 5, this.writeData);
            this.tfSetOut = MainFrame.createRegEdits(6, 5, this.writeData);
            this.labels = new JLabel[6];
            this.btnPlus = new JButton[6];
            this.btnMinus = new JButton[6];
            this.setBorder(BorderFactory.createTitledBorder("\u0410\u043d\u0430\u043b\u043e\u0433\u043e\u0432\u044b\u0435 \u0432\u044b\u0445\u043e\u0434\u044b"));
            this.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435, \u0412"), "skip 1, span 2, al left");
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("\u0426\u0410\u041f"), "span 1, al right");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u043e\u0432\u043a\u0430 W"), "span 2, al right, wrap");
            }
            for (int i = 0; i < 6; ++i) {
                this.labels[i] = new JLabel("AO" + (i + 1) + ": ");
                this.add((Component)this.labels[i], MainFrame.this.calibration ? "al right, hidemode 3" : "al right, newline, hidemode 3");
                this.add((Component)this.tfOut[i], "hidemode 3");
                this.add((Component)this.tfSetOut[i], "hidemode 3");
                if (!MainFrame.this.calibration) continue;
                this.add((Component)this.tfDAC[i], "hidemode 3");
                this.add((Component)this.tfW[i], "hidemode 3");
                this.add((Component)this.tfSetW[i], "hidemode 3");
                this.btnPlus[i] = MainFrame.createButton("+", new IncAction(this.tfW[i], this.tfSetW[i], 1));
                this.btnMinus[i] = MainFrame.createButton("-", new IncAction(this.tfW[i], this.tfSetW[i], -1));
                this.add((Component)this.btnPlus[i], "hidemode 3");
                this.add((Component)this.btnMinus[i], "wrap, hidemode 3");
            }
            JPanel jPanel = new JPanel(new MigLayout("", "", ""));
            jPanel.add((Component)MainFrame.createButton("\u0412\u0441\u0435 10", this.all10), "");
            jPanel.add((Component)MainFrame.createButton("\u0412\u0441\u0435 0", this.all0), "");
            jPanel.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.writeData), "");
            this.add((Component)jPanel, MainFrame.this.calibration ? "span, al right" : "span, al right, newline");
        }

        public void updateData() {
            if (this.isVisible()) {
                int n;
                int n2;
                int n3 = MainFrame.this.connection.actualAoCount;
                for (n2 = 0; n2 < 6; ++n2) {
                    n = n2 < n3 ? 1 : 0;
                    this.tfOut[n2].setVisible(n != 0);
                    this.tfDAC[n2].setVisible(n != 0);
                    this.tfW[n2].setVisible(n != 0);
                    this.tfSetW[n2].setVisible(n != 0);
                    this.tfSetOut[n2].setVisible(n != 0);
                    this.labels[n2].setVisible(n != 0);
                    if (this.btnPlus[n2] != null) {
                        this.btnPlus[n2].setVisible(n != 0);
                    }
                    if (this.btnMinus[n2] == null) continue;
                    this.btnMinus[n2].setVisible(n != 0);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    MainFrame.this.updateRegister(this.tfOut[n2], MainFrame.this.connection.hregs50xx[0 + n2], 100, 2, false);
                }
                n2 = MainFrame.this.connection.actualAiNTC ? MainFrame.this.connection.actualAiCount * 4 : MainFrame.this.connection.actualAiCount * 3;
                for (n = 0; n < n3; ++n) {
                    MainFrame.this.updateRegister(this.tfDAC[n], MainFrame.this.connection.iregs52xx[n2 + n], 1, 0, false);
                }
                n2 = MainFrame.this.connection.actualAiNTC ? MainFrame.this.connection.actualAiCount * 5 : MainFrame.this.connection.actualAiCount * 3;
                for (n = 0; n < n3; ++n) {
                    MainFrame.this.updateRegister(this.tfW[n], MainFrame.this.connection.hregsCal[n2 + n], 1, 0, false);
                }
            }
        }
    }

    class CountersPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        ActionListener all0;
        JTextField[] tfCounter;
        JTextField[] tfSetCounter;
        JLabel[] labels;

        public CountersPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n = MainFrame.this.connection.actualAoCount + (MainFrame.this.connection.actualFdoAnalog ? MainFrame.this.connection.actualFdoCount : 0);
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < MainFrame.this.connection.actualCntCount; ++i) {
                                MainFrame.this.writeRegFromTF32(MainFrame.this.connection.hregs50xx[n + i * 2], MainFrame.this.connection.hregs50xx[n + i * 2 + 1], CountersPanel.this.tfSetCounter[i], jTextField);
                            }
                            CountersPanel.this.updateData();
                        }
                    }
                }
            };
            this.all0 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < MainFrame.this.connection.actualCntCount; ++i) {
                        CountersPanel.this.tfSetCounter[i].setText("0");
                    }
                }
            };
            this.tfCounter = MainFrame.createRegViews(10, 10);
            this.tfSetCounter = MainFrame.createRegEdits(10, 9, this.writeData);
            this.labels = new JLabel[10];
            this.setBorder(BorderFactory.createTitledBorder("\u0421\u0447\u0435\u0442\u0447\u0438\u043a\u0438 \u0438\u043c\u043f\u0443\u043b\u044c\u0441\u043e\u0432"));
            for (int i = 0; i < 10; ++i) {
                this.labels[i] = new JLabel("DIxx: ");
                this.add((Component)this.labels[i], "al right, newline, hidemode 3");
                this.add((Component)this.tfCounter[i], "hidemode 3");
                this.add((Component)this.tfSetCounter[i], "hidemode 3");
            }
            JPanel jPanel = new JPanel(new MigLayout("", "", ""));
            jPanel.add((Component)MainFrame.createButton("\u0412\u0441\u0435 0", this.all0), "");
            jPanel.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.writeData), "");
            this.add((Component)jPanel, "span, al right, newline");
        }

        public void updateData() {
            if (this.isVisible()) {
                int n = MainFrame.this.connection.actualAoCount + (MainFrame.this.connection.actualFdoAnalog ? MainFrame.this.connection.actualFdoCount : 0);
                for (int i = 0; i < 10; ++i) {
                    boolean bl = i < MainFrame.this.connection.actualCntCount;
                    this.labels[i].setText("DI" + (i + MainFrame.this.connection.actualAiCount + 1) + ": ");
                    this.labels[i].setVisible(bl);
                    this.tfCounter[i].setVisible(bl);
                    this.tfSetCounter[i].setVisible(bl);
                    if (!bl) continue;
                    ConnectionThread.Register register = MainFrame.this.connection.hregs50xx[n + i * 2];
                    ConnectionThread.Register register2 = MainFrame.this.connection.hregs50xx[n + i * 2 + 1];
                    MainFrame.this.updateRegister32(this.tfCounter[i], register, register2);
                }
            }
        }
    }

    class FDOPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField tfMode;
        JTextField tfDO;
        JTextField tfPWM;
        RegComboBox cbxSetMode;
        JTextField tfSetPWM;
        protected JButton btnWrite;

        public FDOPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs50xx[MainFrame.this.connection.actualAoCount], FDOPanel.this.tfSetPWM, 1, 0, 100, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregs61xx[0], FDOPanel.this.cbxSetMode.getSelectedIndex() - 1, 0, 1);
                            FDOPanel.this.cbxSetMode.setSelectedIndex(0);
                            FDOPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfMode = MainFrame.createRegView(7);
            this.tfDO = MainFrame.createRegView(7);
            this.tfPWM = MainFrame.createRegView(7);
            this.cbxSetMode = MainFrame.createRegCombo(FDO_CFG, this.enter);
            this.tfSetPWM = MainFrame.createRegEdit(4, this.write);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder("\u041f\u043e\u043b\u0443\u043f\u0440\u043e\u0432\u043e\u0434\u043d\u0438\u043a\u043e\u0432\u044b\u0439 \u0432\u044b\u0445\u043e\u0434"));
            this.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c:"), "al right");
            this.add((Component)this.tfMode, "");
            this.add((Component)this.cbxSetMode, "wrap");
            this.add((Component)new JLabel("\u0414\u0438\u0441\u043a\u0440.:"), "al right");
            this.add((Component)this.tfDO, "");
            JButton jButton = new JButton("1/0");
            jButton.addActionListener(new FDOAction(0));
            this.add((Component)jButton, "wrap");
            this.add((Component)new JLabel("\u0428\u0418\u041c (%):"), "al right");
            this.add((Component)this.tfPWM, "");
            this.add((Component)this.tfSetPWM, "wrap");
            this.add((Component)this.btnWrite, "skip 1, span 2");
        }

        private String modeString(int n) {
            if (++n >= 0 && n < FDO_CFG.length) {
                return FDO_CFG[n];
            }
            return Integer.toString(n);
        }

        public void updateData() {
            if (this.isVisible()) {
                MainFrame.this.updateRegister(this.tfPWM, MainFrame.this.connection.hregs50xx[MainFrame.this.connection.actualAoCount], 1, 0, false);
                MainFrame.this.updateRegister(this.tfDO, MainFrame.this.connection.coils[MainFrame.this.connection.actualRelayCount], 1, 0, true);
                ConnectionThread.Register register = MainFrame.this.connection.hregs61xx[0];
                MainFrame.this.updateRegisterText(this.tfMode, register.isGood() ? this.modeString(register.getValue()) : "-", register.needWrite ? this.modeString(register.writingValue()) : null);
            }
        }
    }

    class DOutputsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener coilsOn;
        ActionListener coilsOff;
        JTextField[] tfCoils;
        JButton[] btnOut;
        JLabel[] lblOut;

        public DOutputsPanel() {
            JButton jButton;
            super(new MigLayout("", "", ""));
            this.coilsOn = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n;
                            for (n = 0; n < MainFrame.this.connection.actualRelayCount; ++n) {
                                MainFrame.this.writeReg(MainFrame.this.connection.coils[n], 1, 0, 1);
                            }
                            for (n = 0; n < MainFrame.this.connection.actualFdoCount; ++n) {
                                MainFrame.this.writeReg(MainFrame.this.connection.coils[MainFrame.this.connection.actualRelayCount + n], 1, 0, 1);
                            }
                            DOutputsPanel.this.updateData();
                        }
                    }
                }
            };
            this.coilsOff = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n;
                            for (n = 0; n < MainFrame.this.connection.actualRelayCount; ++n) {
                                MainFrame.this.writeReg(MainFrame.this.connection.coils[n], 0, 0, 1);
                            }
                            for (n = 0; n < MainFrame.this.connection.actualFdoCount; ++n) {
                                MainFrame.this.writeReg(MainFrame.this.connection.coils[MainFrame.this.connection.actualRelayCount + n], 0, 0, 1);
                            }
                            DOutputsPanel.this.updateData();
                        }
                    }
                }
            };
            this.tfCoils = MainFrame.createRegViews(12, 7);
            this.btnOut = new JButton[12];
            this.lblOut = new JLabel[12];
            this.setBorder(BorderFactory.createTitledBorder("\u0414\u0438\u0441\u043a\u0440\u0435\u0442\u043d\u044b\u0435 \u0432\u044b\u0445\u043e\u0434\u044b"));
            for (int i = 0; i < this.tfCoils.length; ++i) {
                this.lblOut[i] = i < 10 ? new JLabel("DO" + (i + 1)) : new JLabel("FDO" + (i + 1 - 10));
                this.add((Component)this.lblOut[i], "al right, hidemode 3");
                this.add((Component)this.tfCoils[i], "hidemode 3");
                jButton = new JButton("1/0");
                if (i < 10) {
                    jButton.addActionListener(new DOAction(i));
                } else {
                    jButton.addActionListener(new FDOAction(i - 10));
                }
                this.add((Component)jButton, "wrap, hidemode 3");
                this.btnOut[i] = jButton;
            }
            JPanel jPanel = new JPanel(new MigLayout("", "", ""));
            jButton = new JButton("\u0412\u0441\u0435 1");
            jButton.addActionListener(this.coilsOn);
            jPanel.add((Component)jButton, "");
            jButton = new JButton("\u0412\u0441\u0435 0");
            jButton.addActionListener(this.coilsOff);
            jPanel.add((Component)jButton, "");
            this.add((Component)jPanel, "span, al center");
        }

        public void updateData() {
            if (this.isVisible()) {
                int n;
                for (n = 0; n < this.tfCoils.length; ++n) {
                    boolean bl = n < MainFrame.this.connection.actualRelayCount || n >= 10 && n < 10 + MainFrame.this.connection.actualFdoCount;
                    this.lblOut[n].setVisible(bl);
                    this.btnOut[n].setVisible(bl);
                    this.tfCoils[n].setVisible(bl);
                }
                for (n = 0; n < MainFrame.this.connection.actualRelayCount; ++n) {
                    MainFrame.this.updateRegister(this.tfCoils[n], MainFrame.this.connection.coils[n], 1, 0, true);
                }
                for (n = 0; n < MainFrame.this.connection.actualFdoCount; ++n) {
                    MainFrame.this.updateRegister(this.tfCoils[10 + n], MainFrame.this.connection.coils[MainFrame.this.connection.actualRelayCount + n], 1, 0, true);
                }
            }
        }
    }

    class FDOAction
    implements ActionListener {
        final int index;

        public FDOAction(int n) {
            this.index = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.connection != null) {
                ConnectionThread connectionThread = MainFrame.this.connection;
                synchronized (connectionThread) {
                    ConnectionThread.Register register = MainFrame.this.connection.coils[MainFrame.this.connection.actualRelayCount + this.index];
                    int n = register.getValue();
                    MainFrame.this.writeReg(register, n == 0 ? 1 : 0, 0, 1);
                    MainFrame.this.updateData();
                }
            }
        }
    }

    class DOAction
    implements ActionListener {
        final int index;

        public DOAction(int n) {
            this.index = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.connection != null) {
                ConnectionThread connectionThread = MainFrame.this.connection;
                synchronized (connectionThread) {
                    ConnectionThread.Register register = MainFrame.this.connection.coils[this.index];
                    int n = register.getValue();
                    MainFrame.this.writeReg(register, n == 0 ? 1 : 0, 0, 1);
                    MainFrame.this.updateData();
                }
            }
        }
    }

    class DInputsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField[] tfDI;
        JLabel[] lblDI;
        JLabel lblJumpers;

        public DInputsPanel(int n) {
            super(new MigLayout("", "[][]20[][]20[][]", ""));
            this.tfDI = MainFrame.createRegViews(22, 4);
            this.lblDI = new JLabel[22];
            this.lblJumpers = MainFrame.this.jumpersImage("pt1000.png", "\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u0435\u043a \u0434\u043b\u044f \u0434\u0438\u0441\u043a\u0440\u0435\u0442\u043d\u043e\u0433\u043e \u0432\u0445\u043e\u0434\u0430");
            this.setBorder(BorderFactory.createTitledBorder("\u0414\u0438\u0441\u043a\u0440\u0435\u0442\u043d\u044b\u0435 \u0432\u0445\u043e\u0434\u044b"));
            int n2 = 0;
            int n3 = n;
            int n4 = n * 2;
            this.add((Component)this.lblJumpers, "span, al left, hidemode 3");
            boolean bl = false;
            boolean bl2 = false;
            while (!bl) {
                if (n2 < n) {
                    this.lblDI[n2] = new JLabel("DI" + (n2 + 1) + ": ");
                    this.add((Component)this.lblDI[n2], "al right, hidemode 2");
                    this.add((Component)this.tfDI[n2], "hidemode 2");
                } else {
                    bl = true;
                    if (bl2) break;
                    this.add((Component)new JLabel(" "), "");
                    this.add((Component)new JLabel(" "), "");
                }
                if (n3 < this.tfDI.length && n3 < n * 2) {
                    this.lblDI[n3] = new JLabel("DI" + (n3 + 1) + ": ");
                    this.add((Component)this.lblDI[n3], "al right, hidemode 2");
                    this.add((Component)this.tfDI[n3], "hidemode 2");
                } else {
                    bl2 = true;
                    if (bl) break;
                    this.add((Component)new JLabel(" "), "");
                    this.add((Component)new JLabel(" "), "");
                }
                if (n4 < this.tfDI.length) {
                    this.lblDI[n4] = new JLabel("DI" + (n4 + 1) + ": ");
                    this.add((Component)this.lblDI[n4], "al right, hidemode 2");
                    this.add((Component)this.tfDI[n4], "wrap, hidemode 2");
                } else {
                    if (bl2) break;
                    this.add((Component)new JLabel(" "), "");
                    this.add((Component)new JLabel(" "), "wrap");
                }
                ++n2;
                ++n3;
                ++n4;
            }
        }

        public void updateData() {
            if (this.isVisible()) {
                this.lblJumpers.setVisible(MainFrame.this.connection.actualJumpers);
                for (int i = 0; i < this.tfDI.length; ++i) {
                    boolean bl = i < MainFrame.this.connection.actualDiCount;
                    this.tfDI[i].setVisible(bl);
                    if (this.lblDI[i] != null) {
                        this.lblDI[i].setVisible(bl);
                    }
                    if (!bl) continue;
                    MainFrame.this.updateRegister(this.tfDI[i], MainFrame.this.connection.dinputs[i], 1, 0, true);
                }
            }
        }
    }

    class AInputsVoltPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        JLabel[] labels;
        JButton[] btn1;
        JTextField[] tfVoltage;
        JTextField[] tfADCVolt;
        JTextField[] tfCalVolt;
        JTextField[] tfSetVolt;
        JLabel lblJumpers;

        public AInputsVoltPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n;
                            int n2 = MainFrame.this.connection.actualAiCount;
                            int n3 = n = MainFrame.this.connection.actualAiNTC ? n2 * 4 : n2 * 2;
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < n2; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsCal[n + i], AInputsVoltPanel.this.tfSetVolt[i], 1, 0, 65535, jTextField);
                            }
                            AInputsVoltPanel.this.updateData();
                        }
                    }
                }
            };
            this.labels = new JLabel[14];
            this.btn1 = new JButton[14];
            this.tfVoltage = MainFrame.createRegViews(14, MainFrame.this.calibration ? 4 : 8);
            this.tfADCVolt = MainFrame.createRegViews(14, 5);
            this.tfCalVolt = MainFrame.createRegViews(14, 10);
            this.tfSetVolt = MainFrame.createRegEdits(14, 5, this.writeData);
            this.lblJumpers = MainFrame.this.jumpersImage("volts.png", "\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u0435\u043a \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u044f");
            this.setBorder(BorderFactory.createTitledBorder("\u0410\u043d. \u0432\u0445\u043e\u0434\u044b 0-10 \u0412"));
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("<html><b>U =  10 \u0412</b></html>"), "skip 3, span 3, al center, wrap");
            }
            this.add((Component)this.lblJumpers, "al left, hidemode 2");
            this.add((Component)new JLabel("\u041d\u0430\u043f\u0440., \u0412"), MainFrame.this.calibration ? "al center" : "al center, wrap");
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("\u0410\u0426\u041f"), "al center");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 U"), "span 3, al right, wrap");
            }
            for (int i = 0; i < 14; ++i) {
                this.labels[i] = new JLabel("AI" + (i + 1) + ": ");
                this.add((Component)this.labels[i], "al right, hidemode 3");
                this.add((Component)this.tfVoltage[i], MainFrame.this.calibration ? "hidemode 3" : "wrap, hidemode 3");
                if (!MainFrame.this.calibration) continue;
                this.add((Component)this.tfADCVolt[i], "hidemode 3");
                this.add((Component)this.tfCalVolt[i], "hidemode 3");
                this.add((Component)this.tfSetVolt[i], "hidemode 3");
                this.btn1[i] = MainFrame.createButton("<-", new CopyAction(this.tfADCVolt[i], this.tfSetVolt[i]));
                this.add((Component)this.btn1[i], "wrap, hidemode 3");
            }
            if (MainFrame.this.calibration) {
                this.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.writeData), "span, al right");
            }
        }

        public void reset() {
            MainFrame.this.resetTF(this.tfSetVolt);
        }

        public void updateData() {
            if (this.isVisible()) {
                int n;
                int n2;
                this.lblJumpers.setVisible(MainFrame.this.connection.actualJumpers);
                int n3 = MainFrame.this.connection.actualAiCount;
                for (n2 = 0; n2 < 14; ++n2) {
                    n = n2 < n3 ? 1 : 0;
                    this.labels[n2].setVisible(n != 0);
                    this.tfVoltage[n2].setVisible(n != 0);
                    this.tfADCVolt[n2].setVisible(n != 0);
                    this.tfCalVolt[n2].setVisible(n != 0);
                    this.tfSetVolt[n2].setVisible(n != 0);
                    if (this.btn1[n2] == null) continue;
                    this.btn1[n2].setVisible(n != 0);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    n = MainFrame.this.connection.actualAiNTC ? n3 * 3 : n3 * 2;
                    MainFrame.this.updateRegister(this.tfVoltage[n2], MainFrame.this.connection.iregs52xx[n + n2], 100, 2, false);
                    if (!MainFrame.this.calibration) continue;
                    MainFrame.this.updateRegister(this.tfADCVolt[n2], MainFrame.this.connection.iregs52xx[0 + n2], 1, 0, false);
                    n = MainFrame.this.connection.actualAiNTC ? n3 * 4 : n3 * 2;
                    MainFrame.this.updateRegister(this.tfCalVolt[n2], MainFrame.this.connection.hregsCal[n + n2], 1, 0, false);
                }
            }
        }
    }

    class AInputsTempShiftPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        JLabel[] labels;
        JTextField[] tfdT;
        JTextField[] tfSetdT;

        public AInputsTempShiftPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n;
                            int n2 = MainFrame.this.connection.actualAiCount;
                            int n3 = n = MainFrame.this.connection.actualFdoAnalog ? MainFrame.this.connection.actualFdoCount : 0;
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < n2; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs61xx[n + i], AInputsTempShiftPanel.this.tfSetdT[i], 10, -100, 100, jTextField);
                            }
                            AInputsTempShiftPanel.this.updateData();
                        }
                    }
                }
            };
            this.labels = new JLabel[14];
            this.tfdT = MainFrame.createRegViews(14, 6);
            this.tfSetdT = MainFrame.createRegEdits(14, 5, this.writeData);
            this.setBorder(BorderFactory.createTitledBorder("\u041f\u043e\u043f\u0440\u0430\u0432\u043a\u0438 \u0442\u0435\u043c\u043f\u0435\u0440\u0430\u0442\u0443\u0440"));
            this.add((Component)new JLabel("dT, \u00b0C"), "al center, span, wrap");
            for (int i = 0; i < 14; ++i) {
                this.labels[i] = new JLabel("AI" + (i + 1) + ": ");
                this.add((Component)this.labels[i], "al right, hidemode 3");
                this.add((Component)this.tfdT[i], "hidemode 3");
                this.add((Component)this.tfSetdT[i], "wrap, hidemode 3");
            }
            this.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.writeData), "span, al right");
        }

        public void updateData() {
            if (this.isVisible()) {
                int n;
                int n2 = MainFrame.this.connection.actualAiCount;
                int n3 = MainFrame.this.connection.actualFdoAnalog ? MainFrame.this.connection.actualFdoCount : 0;
                for (n = 0; n < 14; ++n) {
                    boolean bl = n < n2;
                    this.labels[n].setVisible(bl);
                    this.tfdT[n].setVisible(bl);
                    this.tfSetdT[n].setVisible(bl);
                }
                for (n = 0; n < n2; ++n) {
                    MainFrame.this.updateRegister(this.tfdT[n], MainFrame.this.connection.hregs61xx[n3 + n], 10, 1, false);
                }
            }
        }
    }

    class AInputsNTCPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        JLabel[] labels;
        JButton[] btn1;
        JButton[] btn2;
        JTextField[] tfTempNTC;
        JTextField[] tfADCNTC;
        JTextField[] tfR1NTC;
        JTextField[] tfR2NTC;
        JTextField[] tfSetR1NTC;
        JTextField[] tfSetR2NTC;
        JLabel lblJumpers;

        public AInputsNTCPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n = MainFrame.this.connection.actualAiCount;
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < n; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsCal[n * 2 + i], AInputsNTCPanel.this.tfSetR1NTC[i], 1, 0, 65535, jTextField);
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsCal[n * 3 + i], AInputsNTCPanel.this.tfSetR2NTC[i], 1, 0, 65535, jTextField);
                            }
                            AInputsNTCPanel.this.updateData();
                        }
                    }
                }
            };
            this.labels = new JLabel[14];
            this.btn1 = new JButton[14];
            this.btn2 = new JButton[14];
            this.tfTempNTC = MainFrame.createRegViews(14, MainFrame.this.calibration ? 4 : 8);
            this.tfADCNTC = MainFrame.createRegViews(14, 5);
            this.tfR1NTC = MainFrame.createRegViews(14, 10);
            this.tfR2NTC = MainFrame.createRegViews(14, 10);
            this.tfSetR1NTC = MainFrame.createRegEdits(14, 5, this.writeData);
            this.tfSetR2NTC = MainFrame.createRegEdits(14, 5, this.writeData);
            this.lblJumpers = MainFrame.this.jumpersImage("ntc.png", "\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u0435\u043a \u0434\u043b\u044f \u0434\u0430\u0442\u0447\u0438\u043a\u0430 NTC");
            this.setBorder(BorderFactory.createTitledBorder("\u0410\u043d. \u0432\u0445\u043e\u0434\u044b NTC 10k"));
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("<html><b>R1 =  842,7 \u041e\u043c</b> (&gt;105 \u00b0C)</html>"), "skip 3, span 3, al center");
                this.add((Component)new JLabel("<html><b>R\u221e</b> (&lt;-40 \u00b0C)</html>"), "skip 1, span 3, al center, wrap");
            }
            this.add((Component)this.lblJumpers, "al left, hidemode 2");
            this.add((Component)new JLabel("\u0422\u0435\u043c\u043f., \u00b0C"), MainFrame.this.calibration ? "al center" : "al center, wrap");
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("\u0410\u0426\u041f"), "al center");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 R1"), "span 3, al right");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 R\u221e"), "span 4, al right, wrap");
            }
            for (int i = 0; i < 14; ++i) {
                this.labels[i] = new JLabel("AI" + (i + 1) + ": ");
                this.add((Component)this.labels[i], "al right, hidemode 3");
                this.add((Component)this.tfTempNTC[i], MainFrame.this.calibration ? "hidemode 3" : "wrap, hidemode 3");
                if (!MainFrame.this.calibration) continue;
                this.add((Component)this.tfADCNTC[i], "hidemode 3");
                this.add((Component)this.tfR1NTC[i], "hidemode 3");
                this.add((Component)this.tfSetR1NTC[i], "hidemode 3");
                this.btn1[i] = MainFrame.createButton("<-", new CopyAction(this.tfADCNTC[i], this.tfSetR1NTC[i]));
                this.add((Component)this.btn1[i], "");
                this.add((Component)this.tfR2NTC[i], "skip 1, hidemode 3");
                this.add((Component)this.tfSetR2NTC[i], "");
                this.btn2[i] = MainFrame.createButton("<-", new CopyAction(this.tfADCNTC[i], this.tfSetR2NTC[i]));
                this.add((Component)this.btn2[i], "wrap, hidemode 3");
            }
            if (MainFrame.this.calibration) {
                this.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.writeData), "span, al right");
            }
        }

        public void updateData() {
            if (this.isVisible()) {
                int n;
                this.lblJumpers.setVisible(MainFrame.this.connection.actualJumpers);
                int n2 = MainFrame.this.connection.actualAiCount;
                for (n = 0; n < 14; ++n) {
                    boolean bl = n < n2;
                    this.labels[n].setVisible(bl);
                    this.tfTempNTC[n].setVisible(bl);
                    this.tfADCNTC[n].setVisible(bl);
                    this.tfR1NTC[n].setVisible(bl);
                    this.tfSetR1NTC[n].setVisible(bl);
                    if (this.btn1[n] != null) {
                        this.btn1[n].setVisible(bl);
                    }
                    this.tfR2NTC[n].setVisible(bl);
                    this.tfSetR2NTC[n].setVisible(bl);
                    if (this.btn2[n] == null) continue;
                    this.btn2[n].setVisible(bl);
                }
                for (n = 0; n < n2; ++n) {
                    MainFrame.this.updateRegister(this.tfTempNTC[n], MainFrame.this.connection.iregs52xx[n2 * 2 + n], 10, 1, false);
                    if (!MainFrame.this.calibration) continue;
                    MainFrame.this.updateRegister(this.tfADCNTC[n], MainFrame.this.connection.iregs52xx[0 + n], 1, 0, false);
                    MainFrame.this.updateRegister(this.tfR1NTC[n], MainFrame.this.connection.hregsCal[n2 * 2 + n], 1, 0, false);
                    MainFrame.this.updateRegister(this.tfR2NTC[n], MainFrame.this.connection.hregsCal[n2 * 3 + n], 1, 0, false);
                }
            }
        }
    }

    class AInputsPtPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        JLabel[] labels;
        JButton[] btn1;
        JButton[] btn2;
        JTextField[] tfTempPt;
        JTextField[] tfADCPt;
        JTextField[] tfR1Pt;
        JTextField[] tfR2Pt;
        JTextField[] tfSetR1Pt;
        JTextField[] tfSetR2Pt;
        JLabel lblJumpers;

        public AInputsPtPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n = MainFrame.this.connection.actualAiCount;
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < n; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsCal[0 + i], AInputsPtPanel.this.tfSetR1Pt[i], 1, 0, 65535, jTextField);
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsCal[n + i], AInputsPtPanel.this.tfSetR2Pt[i], 1, 0, 65535, jTextField);
                            }
                            AInputsPtPanel.this.updateData();
                        }
                    }
                }
            };
            this.labels = new JLabel[14];
            this.btn1 = new JButton[14];
            this.btn2 = new JButton[14];
            this.tfTempPt = MainFrame.createRegViews(14, MainFrame.this.calibration ? 4 : 8);
            this.tfADCPt = MainFrame.createRegViews(14, 5);
            this.tfR1Pt = MainFrame.createRegViews(14, 10);
            this.tfR2Pt = MainFrame.createRegViews(14, 10);
            this.tfSetR1Pt = MainFrame.createRegEdits(14, 5, this.writeData);
            this.tfSetR2Pt = MainFrame.createRegEdits(14, 5, this.writeData);
            this.lblJumpers = MainFrame.this.jumpersImage("pt1000.png", "\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u0435\u043a \u0434\u043b\u044f \u0434\u0430\u0442\u0447\u0438\u043a\u0430 Pt1000");
            this.setBorder(BorderFactory.createTitledBorder("\u0410\u043d. \u0432\u0445\u043e\u0434\u044b Pt1000"));
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("<html><b>R1 =  842,7 \u041e\u043c</b> (-40 \u00b0C)</html>"), "skip 3, span 3, al center");
                this.add((Component)new JLabel("<html><b>R2 = 1535,8 \u041e\u043c</b> (140 \u00b0C)</html>"), "skip 1, span 3, al center, wrap");
            }
            this.add((Component)this.lblJumpers, "al left, hidemode 2");
            this.add((Component)new JLabel("\u0422\u0435\u043c\u043f., \u00b0C"), MainFrame.this.calibration ? "al center" : "al center, wrap");
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("\u0410\u0426\u041f"), "al center");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 R1"), "span 3, al right");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 R2"), "span 4, al right, wrap");
            }
            for (int i = 0; i < 14; ++i) {
                this.labels[i] = new JLabel("AI" + (i + 1) + ": ");
                this.add((Component)this.labels[i], "al right, hidemode 3");
                this.add((Component)this.tfTempPt[i], MainFrame.this.calibration ? "hidemode 3" : "wrap, hidemode 3");
                if (!MainFrame.this.calibration) continue;
                this.add((Component)this.tfADCPt[i], "hidemode 3");
                this.add((Component)this.tfR1Pt[i], "hidemode 3");
                this.add((Component)this.tfSetR1Pt[i], "hidemode 3");
                this.btn1[i] = MainFrame.createButton("<-", new CopyAction(this.tfADCPt[i], this.tfSetR1Pt[i]));
                this.add((Component)this.btn1[i], "hidemode 3");
                this.add((Component)this.tfR2Pt[i], "skip 1, hidemode 3");
                this.add((Component)this.tfSetR2Pt[i], "hidemode 3");
                this.btn2[i] = MainFrame.createButton("<-", new CopyAction(this.tfADCPt[i], this.tfSetR2Pt[i]));
                this.add((Component)this.btn2[i], "wrap, hidemode 3");
            }
            if (MainFrame.this.calibration) {
                this.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.writeData), "span, al right");
            }
        }

        public void updateData() {
            if (this.isVisible()) {
                int n;
                this.lblJumpers.setVisible(MainFrame.this.connection.actualJumpers);
                int n2 = MainFrame.this.connection.actualAiCount;
                for (n = 0; n < 14; ++n) {
                    boolean bl = n < n2;
                    this.labels[n].setVisible(bl);
                    this.tfTempPt[n].setVisible(bl);
                    this.tfADCPt[n].setVisible(bl);
                    this.tfR1Pt[n].setVisible(bl);
                    this.tfSetR1Pt[n].setVisible(bl);
                    if (this.btn1[n] != null) {
                        this.btn1[n].setVisible(bl);
                    }
                    this.tfR2Pt[n].setVisible(bl);
                    this.tfSetR2Pt[n].setVisible(bl);
                    if (this.btn2[n] == null) continue;
                    this.btn2[n].setVisible(bl);
                }
                for (n = 0; n < n2; ++n) {
                    MainFrame.this.updateRegister(this.tfTempPt[n], MainFrame.this.connection.iregs52xx[n2 + n], 10, 1, false);
                    if (!MainFrame.this.calibration) continue;
                    MainFrame.this.updateRegister(this.tfADCPt[n], MainFrame.this.connection.iregs52xx[0 + n], 1, 0, false);
                    MainFrame.this.updateRegister(this.tfR1Pt[n], MainFrame.this.connection.hregsCal[0 + n], 1, 0, false);
                    MainFrame.this.updateRegister(this.tfR2Pt[n], MainFrame.this.connection.hregsCal[n2 + n], 1, 0, false);
                }
            }
        }
    }

    class AInputsConfigPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        ActionListener allPt;
        ActionListener allVolts;
        JLabel[] labels;
        JTextField[] tfType;
        RegComboBox[] cbxSetType;

        public AInputsConfigPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n = MainFrame.this.connection.actualAiCount;
                            int n2 = n * 2 + (MainFrame.this.connection.actualFdoAnalog ? MainFrame.this.connection.actualFdoCount : 0);
                            RegComboBox regComboBox = actionEvent != null ? (actionEvent.getSource() instanceof RegComboBox ? (RegComboBox)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < n; ++i) {
                                if (regComboBox != null && regComboBox != AInputsConfigPanel.this.cbxSetType[i]) continue;
                                MainFrame.this.writeReg(MainFrame.this.connection.hregs61xx[n2 + i], AInputsConfigPanel.this.cbxSetType[i].getSelectedIndex() - 1, 0, 1);
                                AInputsConfigPanel.this.cbxSetType[i].setSelectedIndex(0);
                            }
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.allPt = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < MainFrame.this.connection.actualAiCount; ++i) {
                        AInputsConfigPanel.this.cbxSetType[i].setSelectedIndex(1);
                    }
                }
            };
            this.allVolts = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < MainFrame.this.connection.actualAiCount; ++i) {
                        AInputsConfigPanel.this.cbxSetType[i].setSelectedIndex(2);
                    }
                }
            };
            this.labels = new JLabel[14];
            this.tfType = MainFrame.createRegViews(14, 6);
            this.cbxSetType = new RegComboBox[14];
            this.setBorder(BorderFactory.createTitledBorder("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0432\u0445\u043e\u0434\u043e\u0432"));
            JLabel jLabel = new JLabel("\u0422\u0438\u043f \u0441\u0438\u0433\u043d\u0430\u043b\u0430");
            this.add((Component)jLabel, "al center, span, wrap");
            for (int i = 0; i < 14; ++i) {
                this.labels[i] = new JLabel("AI" + (i + 1) + ": ");
                this.add((Component)this.labels[i], "al right, hidemode 3");
                this.add((Component)this.tfType[i], "hidemode 3");
                this.cbxSetType[i] = MainFrame.createRegCombo(AI_TYPE, this.enter);
                this.add((Component)this.cbxSetType[i], "wrap, hidemode 3");
            }
            JPanel jPanel = new JPanel(new MigLayout("", "", ""));
            jPanel.add((Component)MainFrame.createButton("\u0412\u0441\u0435 Pt1000", this.allPt), "al left");
            jPanel.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write), "wrap, al right");
            jPanel.add((Component)MainFrame.createButton("\u0412\u0441\u0435 0-10 V", this.allVolts), "al left");
            this.add((Component)jPanel, "span, al right, newline");
        }

        public void updateData() {
            if (this.isVisible()) {
                int n;
                int n2;
                int n3 = MainFrame.this.connection.actualAiCount;
                int n4 = n3 * 2 + (MainFrame.this.connection.actualFdoAnalog ? MainFrame.this.connection.actualFdoCount : 0);
                for (n2 = 0; n2 < 14; ++n2) {
                    n = n2 < n3 ? 1 : 0;
                    this.labels[n2].setVisible(n != 0);
                    this.tfType[n2].setVisible(n != 0);
                    this.cbxSetType[n2].setVisible(n != 0);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    MainFrame.this.updateRegister(this.tfType[n2], MainFrame.this.connection.hregs61xx[n4 + n2], 1, 0, false);
                    n = Utils.StringToIntDef(this.tfType[n2].getText(), -1);
                    if (n < 0 || n >= AI_TYPE.length - 1) continue;
                    this.tfType[n2].setText(AI_TYPE[n + 1]);
                }
            }
        }
    }

    class AInputsFilterPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        JLabel[] labels;
        JTextField[] tfFlt;
        JTextField[] tfSetFlt;

        public AInputsFilterPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            int n = MainFrame.this.connection.actualAiCount;
                            int n2 = MainFrame.this.connection.actualAiCount + (MainFrame.this.connection.actualFdoAnalog ? MainFrame.this.connection.actualFdoCount : 0);
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < n; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs61xx[n2 + i], AInputsFilterPanel.this.tfSetFlt[i], 1, 0, 10000, jTextField);
                            }
                            AInputsFilterPanel.this.updateData();
                        }
                    }
                }
            };
            this.labels = new JLabel[14];
            this.tfFlt = MainFrame.createRegViews(14, 6);
            this.tfSetFlt = MainFrame.createRegEdits(14, 5, this.writeData);
            this.setBorder(BorderFactory.createTitledBorder("\u0424\u0438\u043b\u044c\u0442\u0440\u044b \u0430\u043d. \u0432\u0445\u043e\u0434\u043e\u0432"));
            JLabel jLabel = new JLabel("\u041a-\u0442 \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438");
            jLabel.setToolTipText("\u041a\u043e\u0435\u0444\u0444\u0438\u0446\u0438\u0435\u043d\u0442 \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438 - \u044d\u0442\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0446\u0438\u043a\u043b\u043e\u0432, \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0443\u0441\u0440\u0435\u0434\u043d\u044f\u0435\u0442\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0410\u0426\u041f");
            this.add((Component)jLabel, "al center, span, wrap");
            for (int i = 0; i < 14; ++i) {
                this.labels[i] = new JLabel("AI" + (i + 1) + ": ");
                this.add((Component)this.labels[i], "al right, hidemode 3");
                this.add((Component)this.tfFlt[i], "hidemode 3");
                this.add((Component)this.tfSetFlt[i], "wrap, hidemode 3");
            }
            this.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.writeData), "span, al right");
        }

        public void updateData() {
            if (this.isVisible()) {
                int n;
                int n2 = MainFrame.this.connection.actualAiCount;
                int n3 = MainFrame.this.connection.actualAiCount + (MainFrame.this.connection.actualFdoAnalog ? MainFrame.this.connection.actualFdoCount : 0);
                for (n = 0; n < 14; ++n) {
                    boolean bl = n < n2;
                    this.labels[n].setVisible(bl);
                    this.tfFlt[n].setVisible(bl);
                    this.tfSetFlt[n].setVisible(bl);
                }
                for (n = 0; n < n2; ++n) {
                    MainFrame.this.updateRegister(this.tfFlt[n], MainFrame.this.connection.hregs61xx[n3 + n], 1, 0, false);
                }
            }
        }
    }

    class IncAction
    implements ActionListener {
        final JTextField src;
        final JTextField tgt;
        final int step;

        IncAction(JTextField jTextField, JTextField jTextField2, int n) {
            this.src = jTextField;
            this.tgt = jTextField2;
            this.step = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = Utils.StringToIntDef(this.tgt.getText(), -1);
            if (n < 0) {
                n = Utils.StringToIntDef(this.src.getText(), -1);
            }
            if (n > 0) {
                if ((n += this.step) < 0) {
                    n = 0;
                }
                if (n > 65535) {
                    n = 65535;
                }
                this.tgt.setText(Integer.toString(n));
            }
            this.tgt.requestFocusInWindow();
        }
    }

    class CopyAction
    implements ActionListener {
        final JTextField src;
        final JTextField tgt;

        CopyAction(JTextField jTextField, JTextField jTextField2) {
            this.src = jTextField;
            this.tgt = jTextField2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.tgt.setText(this.src.getText());
            this.tgt.requestFocusInWindow();
        }
    }
}

