/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.util;

import certa.vics.compiler.Program;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeSysBin {
    private static final Logger log = LoggerFactory.getLogger(MakeSysBin.class);
    private static final int IMAGE_HEADER = 12;

    private static int readHexByte(FileReader fr) throws Exception {
        int hi = Character.digit(fr.read(), 16);
        int lo = Character.digit(fr.read(), 16);
        if (hi < 0 || lo < 0) {
            throw new Exception("Invalid HEX file");
        }
        return hi * 16 + lo;
    }

    public static void main(String[] args) {
        block45: {
            try {
                byte[] bin;
                int binSize;
                int model;
                String fileName;
                block44: {
                    if (args.length < 4) {
                        System.out.println("Command line parameters: <HEX_file> <model> 0x<address> <max_size>");
                        return;
                    }
                    fileName = args[0];
                    model = Integer.parseInt(args[1]);
                    int startAddress = Integer.parseInt(args[2].replaceFirst("0x", ""), 16);
                    int maxSize = Integer.parseInt(args[3]);
                    binSize = 0;
                    bin = new byte[maxSize];
                    Arrays.fill(bin, (byte)-1);
                    try (FileReader fr = new FileReader(fileName);){
                        byte type;
                        byte[] line = new byte[255];
                        int offset = 0;
                        block21: while (true) {
                            int t;
                            if ((t = fr.read()) != -1 && (char)t != ':') {
                                continue;
                            }
                            if (t == -1) {
                                throw new Exception("Unexpected end of file");
                            }
                            int count = MakeSysBin.readHexByte(fr);
                            int lineSize = count + 4;
                            int sum = count;
                            for (int i = 0; i < lineSize; ++i) {
                                line[i] = (byte)MakeSysBin.readHexByte(fr);
                                sum += line[i];
                            }
                            if ((byte)sum != 0) {
                                throw new Exception("Invalid checksum");
                            }
                            int addr = ((line[0] & 0xFF) << 8) + (line[1] & 0xFF);
                            type = line[2];
                            if (type == 1) {
                                break block44;
                            }
                            if (type == 2) {
                                if (count != 2) {
                                    throw new Exception("Invalid byte count for record type = 2");
                                }
                                offset = ((line[3] & 0xFF) << 8) + (line[4] & 0xFF);
                                offset <<= 4;
                                continue;
                            }
                            if (type == 4) {
                                if (count != 2) {
                                    throw new Exception("Invalid byte count for record type = 4");
                                }
                                offset = ((line[3] & 0xFF) << 8) + (line[4] & 0xFF);
                                offset <<= 16;
                                continue;
                            }
                            if (type == 0) {
                                if (offset == 0x10000000) continue;
                                int pos = offset + addr - startAddress;
                                if (pos < 0) {
                                    throw new Exception("Invalid address (<" + String.format("%08X", startAddress) + ")");
                                }
                                if ((binSize = Math.max(binSize, pos + count)) > maxSize - 12) {
                                    throw new Exception("Image buffer overflow");
                                }
                                int i = 0;
                                while (true) {
                                    if (i >= count) continue block21;
                                    bin[pos + i] = line[3 + i];
                                    ++i;
                                }
                            }
                            if (type != 3 && type != 5) break;
                        }
                        throw new Exception("Unknown record type: " + type);
                    }
                }
                int p = fileName.lastIndexOf(".");
                fileName = fileName.substring(0, p) + ".vics-bin";
                if (binSize > 0) {
                    System.out.println("Writing " + fileName);
                    try (FileOutputStream stream = new FileOutputStream(fileName);){
                        stream.write(86);
                        stream.write(73);
                        stream.write((byte)(model >>> 8));
                        stream.write((byte)model);
                        stream.write((byte)(binSize >>> 24));
                        stream.write((byte)(binSize >>> 16));
                        stream.write((byte)(binSize >>> 8));
                        stream.write((byte)binSize);
                        int crc32 = Program.calcFlashCRC32(bin, 0, binSize);
                        stream.write((byte)(crc32 >>> 24));
                        stream.write((byte)(crc32 >>> 16));
                        stream.write((byte)(crc32 >>> 8));
                        stream.write((byte)crc32);
                        stream.write(bin, 0, binSize);
                        break block45;
                    }
                }
                System.out.println("Nothing to write");
            }
            catch (NoSuchFileException e) {
                System.out.println("");
                System.out.println("ERROR. File not found: " + e.getMessage());
            }
            catch (Throwable e) {
                System.out.println("");
                System.out.println("ERROR (" + e.getClass().getName() + "): " + e.getMessage());
                System.out.println("");
                if (System.getProperty("debug") != null) {
                    e.printStackTrace();
                }
                log.error("EXCEPTION", e);
            }
        }
    }
}

