/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.util;

import certa.modbus.client.ModbusClientTransport;
import certa.modbus.client.RtuOverTcpTransport;
import certa.modbus.client.RtuTransportJSerialComm;
import certa.modbus.client.TcpTransport;
import certa.vics.compiler.Program;
import certa.vics.modbus.VicsModbusClient;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlashSysBin {
    private static final Logger log = LoggerFactory.getLogger(FlashSysBin.class);
    public static final int MAX_RETRIES = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            if (args.length < 4) {
                System.out.println("Command line parameters: RTU|TCP|RTUoverTCP <COM_port:baud:N|O|E:stop>|<IP_address:port> <id> <filename>");
                return;
            }
            File file = new File(args[3]);
            byte[] bin = Files.readAllBytes(file.toPath());
            if (bin.length <= 12) {
                return;
            }
            ModbusClientTransport transport = null;
            String type = args[0];
            String[] comm = args[1].split(":");
            if ("RTU".equalsIgnoreCase(type)) {
                transport = new RtuTransportJSerialComm(comm[0], Integer.parseInt(comm[1]), 8, "O".equalsIgnoreCase(comm[2]) ? 1 : ("E".equalsIgnoreCase(comm[2]) ? 2 : 0), Integer.parseInt(comm[3]), 10000, 100);
            } else if ("TCP".equalsIgnoreCase(type)) {
                transport = new TcpTransport(comm[0], Integer.parseInt(comm[1]), null, 0, 10000, 10000, 100, true);
            } else if ("RTUoverTCP".equalsIgnoreCase(type)) {
                transport = new RtuOverTcpTransport(comm[0], Integer.parseInt(comm[1]), null, 0, 10000, 10000, 100, true);
            } else {
                throw new Exception("Unknown transport: " + type);
            }
            int id = Integer.parseInt(args[2]);
            if (bin[0] != 86 || bin[1] != 73) {
                throw new Exception("Invalid signature");
            }
            int model = VicsModbusClient.bytesToInt16(bin[3], bin[2], true);
            int size = VicsModbusClient.bytesToInt32(bin[7], bin[6], bin[5], bin[4]);
            if (size != bin.length - 12) {
                throw new Exception("Invalid size");
            }
            int crc32 = VicsModbusClient.bytesToInt32(bin[11], bin[10], bin[9], bin[8]);
            if (crc32 != Program.calcFlashCRC32(bin, 12, size)) {
                throw new Exception("Invalid CRC32");
            }
            System.out.println();
            System.out.println("Device model: " + model + ", image size: " + bin.length + ", CRC32: 0x" + String.format("%08X", crc32));
            System.out.println("transport: " + transport);
            try (VicsModbusClient mc = new VicsModbusClient();){
                int chunk;
                mc.setTransport(transport);
                System.out.println();
                System.out.println("Write system image");
                for (int addr = 0; addr < bin.length; addr += chunk) {
                    chunk = Math.min(128, bin.length - addr);
                    byte[] cdata = Arrays.copyOfRange(bin, addr, addr + chunk);
                    mc.InitWriteSysImgRequest(id, model, addr, cdata.length, cdata);
                    if (!mc.execRequest(3, false)) {
                        throw new Exception(mc.getResultAsString());
                    }
                    System.out.print(".");
                }
                System.out.println();
                System.out.println("Writing done. Send RESET command");
                mc.InitWriteSysImgRequest(id, model, -1, 0, bin);
                mc.execRequest(0, true);
                System.out.println("OK");
            }
        }
        catch (NoSuchFileException e) {
            System.out.println("");
            System.out.println("ERROR. File not found: " + e.getMessage());
        }
        catch (Throwable e) {
            System.out.println("");
            System.out.println("ERROR (" + e.getClass().getName() + "): " + e.getMessage());
            System.out.println("");
            if (System.getProperty("debug") != null) {
                e.printStackTrace();
            }
            log.error("EXCEPTION", e);
        }
    }
}

