/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.modbus;

import certa.modbus.client.ModbusClient;

public class VicsModbusClient
extends ModbusClient {
    public static final byte EXT_FN_WRITE_MEM = 100;
    public static final byte EXT_FN_READ_MEM = 101;
    public static final byte EXT_FN_WRITE_SYS_IMG = 103;
    public static final byte EXT_FN_READ_SYS_IMG = 104;
    public static final byte MEM_TYPE_RAM = 0;
    public static final byte MEM_TYPE_EEPROM = 1;
    public static final byte MEM_TYPE_NVRAM = 2;
    public static final byte MEM_TYPE_FLASH = 3;
    public static final byte MEM_TYPE_EXT_EEPROM = 4;
    public static final int CMD_CLEAR_APP = 18546;
    public static final int CMD_REBOOT = 369;
    public static final int MAX_DATA_CHUNK = 128;

    public void InitWriteMemRequest(int serverId, int model, int firmware, int memType, int addr, int size, byte[] data) {
        if (size > data.length) {
            size = data.length;
        }
        this.initRequest(serverId, 9 + size, (byte)100, model, firmware, -1, -1, 1);
        this.writeByteToPDU(5, (byte)memType);
        this.writeInt16ToPDU(6, addr);
        this.writeByteToPDU(8, (byte)size);
        for (int i = 0; i < size; ++i) {
            this.writeByteToPDU(i + 9, data[i]);
        }
    }

    public void InitReadMemRequest(int serverId, int model, int firmware, int memType, int addr, int size) {
        this.initRequest(serverId, 9, (byte)101, model, firmware, -1, -1, 2 + size);
        this.writeByteToPDU(5, (byte)memType);
        this.writeInt16ToPDU(6, addr);
        this.writeByteToPDU(8, (byte)size);
    }

    public void InitWriteSysImgRequest(int serverId, int model, int addr, int size, byte[] data) {
        if (size > data.length) {
            size = data.length;
        }
        this.initRequest(serverId, 8 + size, (byte)103, model, addr >> 16, -1, -1, 1);
        this.writeInt16ToPDU(5, addr);
        this.writeByteToPDU(7, (byte)size);
        for (int i = 0; i < size; ++i) {
            this.writeByteToPDU(i + 8, data[i]);
        }
    }

    public void InitReadSysImgRequest(int serverId, int addr, int size) {
        this.initRequest(serverId, 6, (byte)104, addr >> 16, addr, -1, -1, 2 + size);
        this.writeByteToPDU(5, (byte)size);
    }
}

