/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeAction;
import certa.vics.ide.ui.UiEditor;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class UiActions
extends ActionsBundle {
    final UiEditor editor;
    public final Action moveRight = new Move(this, "\u0412\u043d\u0443\u0442\u0440\u044c", "right.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043d\u0443\u0442\u0440\u044c", 0, KeyStroke.getKeyStroke("control RIGHT"), 3);
    public final Action moveLeft = new Move(this, "\u041d\u0430\u0440\u0443\u0436\u0443", "left.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u043d\u0430\u0440\u0443\u0436\u0443", 0, KeyStroke.getKeyStroke("control LEFT"), 2);
    public final Action moveUp = new Move(this, "\u0412\u0432\u0435\u0440\u0445", "up.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0432\u0435\u0440\u0445", 0, KeyStroke.getKeyStroke("control UP"), 0);
    public final Action moveDown = new Move(this, "\u0412\u043d\u0438\u0437", "down.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043d\u0438\u0437", 0, KeyStroke.getKeyStroke("control DOWN"), 1);
    public final Action delete = new Delete(this, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", "delete.png", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b", 0, KeyStroke.getKeyStroke("DELETE"));
    public final Action addVar = new AddVar(this, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e", "add_ui_var.png", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440/\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0432 \u043c\u0435\u043d\u044e", 0, null);
    public final Action addMenu = new AddMenu(this, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u0434\u043c\u0435\u043d\u044e", "add_ui_menu.png", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", 0, null);
    public final Action duplicate = new Duplicate(this, "\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "duplicate.png", "\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c", 0, KeyStroke.getKeyStroke("control D"));
    public final Action copy = new Copy(this, "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "copy.png", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(67, 2), false);
    public final Action cut = new Copy(this, "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", "cut.png", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(88, 2), true);
    public final Action paste = new Paste(this, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", "paste.png", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(86, 2));

    public UiActions(UiEditor editor) {
        super(editor);
        this.editor = editor;
    }

    public class Duplicate
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Duplicate(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return UiActions.this.editor.hasSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.duplicateItem();
        }
    }

    public class AddVar
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public AddVar(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.createItemVar();
        }
    }

    public class AddMenu
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public AddMenu(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.createItemMenu();
        }
    }

    public class Paste
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Paste(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.pasteFromClipboard();
        }
    }

    public class Copy
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final boolean cut;

        public Copy(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean cut) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.cut = cut;
        }

        @Override
        public boolean canExec() {
            return UiActions.this.editor.hasSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.copyToClipboard(this.cut);
        }
    }

    public class Delete
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Delete(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return UiActions.this.editor.hasSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UiActions.this.editor.deleteSelected();
        }
    }

    public class Move
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        public static final int MOVE_UP = 0;
        public static final int MOVE_DOWN = 1;
        public static final int MOVE_LEFT = 2;
        public static final int MOVE_RIGHT = 3;
        private final int dir;

        public Move(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, int direction) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.dir = direction;
        }

        @Override
        public boolean canExec() {
            if (UiActions.this.editor.focusedItem != null) {
                switch (this.dir) {
                    case 0: {
                        return UiActions.this.editor.focusedItem.getParent().canMoveChildUp(UiActions.this.editor.focusedItem);
                    }
                    case 1: {
                        return UiActions.this.editor.focusedItem.getParent().canMoveChildDown(UiActions.this.editor.focusedItem);
                    }
                    case 2: {
                        return UiActions.this.editor.focusedItem.getParent().canMoveChildOut(UiActions.this.editor.focusedItem);
                    }
                    case 3: {
                        return UiActions.this.editor.focusedItem.getParent().canMoveChildDeeper(UiActions.this.editor.focusedItem);
                    }
                }
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UiActions.this.editor.focusedItem != null) {
                switch (this.dir) {
                    case 0: {
                        UiActions.this.editor.focusedItem.getParent().moveChildUp(UiActions.this.editor.focusedItem);
                        break;
                    }
                    case 1: {
                        UiActions.this.editor.focusedItem.getParent().moveChildDown(UiActions.this.editor.focusedItem);
                        break;
                    }
                    case 2: {
                        UiActions.this.editor.focusedItem.getParent().moveChildOut(UiActions.this.editor.focusedItem);
                        break;
                    }
                    case 3: {
                        UiActions.this.editor.focusedItem.getParent().moveChildDeeper(UiActions.this.editor.focusedItem);
                    }
                }
                UiActions.this.editor.updateVarRefs();
            }
        }
    }
}

