/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ports;

import certa.vics.compiler.ModbusSlaveProfile;
import certa.vics.compiler.Port;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.MainFrame;
import certa.vics.ide.modbus.ModbusSlaveEditor;
import certa.vics.ide.ports.PortsEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class TcpSlaveParamsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final PortsEditor editor;
    final Port port;
    final int portIndex;
    final JComboBox<String> cbxSlaveProfile;
    final JCheckBox cbGateway;
    boolean isModified;
    boolean inUpdate = false;

    public TcpSlaveParamsPanel(PortsEditor editor, Port port, int portIndex) {
        this.editor = editor;
        this.port = port;
        this.portIndex = portIndex;
        this.cbxSlaveProfile = new JComboBox<String>(new DefaultComboBoxModel<String>(ModbusSlaveEditor.PROFILES));
        this.cbxSlaveProfile.setFocusable(false);
        this.cbxSlaveProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TcpSlaveParamsPanel.this.updateSlaveProfile();
            }
        });
        this.cbGateway = new JCheckBox("\u0428\u043b\u044e\u0437 \u0432 RS485_" + (portIndex + 1));
        this.cbGateway.setFocusable(false);
        this.cbGateway.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TcpSlaveParamsPanel.this.updateGateway();
            }
        });
        this.setLayout(new MigLayout(""));
        this.setBorder(BorderFactory.createTitledBorder("\u041f\u043e\u0440\u0442 Modbus_TCP_" + (portIndex + 1)));
        this.add((Component)new JLabel("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u044b MODBUS:"), "");
        this.add(this.cbxSlaveProfile, "");
        this.add((Component)this.cbGateway, "gap 20px, hidemode 3");
    }

    private void updateSlaveProfile() {
        if (this.inUpdate) {
            return;
        }
        int index = this.cbxSlaveProfile.getSelectedIndex();
        ModbusSlaveProfile p = null;
        if (index >= 0) {
            p = this.editor.mainFrame.program.slaveProfiles[index];
        }
        if (p != this.port.slaveProfile) {
            this.port.slaveProfile = p;
            this.markModified();
        }
        this.editor.updateControls();
        MainFrame.instance.actions.update();
    }

    private void updateGateway() {
        if (this.inUpdate) {
            return;
        }
        Port[] rs485Ports = this.editor.mainFrame.program.rs485Ports;
        if (rs485Ports.length > this.portIndex && rs485Ports[this.portIndex].isRs485Master) {
            boolean oldGw = rs485Ports[this.portIndex].isRs485TcpGateway;
            boolean newGw = this.cbGateway.isSelected();
            if (newGw != oldGw) {
                rs485Ports[this.portIndex].isRs485TcpGateway = newGw;
                this.markModified();
                this.editor.reloadPorts(this.port);
            }
        }
        this.editor.updateControls();
        MainFrame.instance.actions.update();
    }

    void updateData() {
        if (this.inUpdate) {
            return;
        }
    }

    protected void markModified() {
        this.isModified = true;
        this.editor.markModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(Program prg) {
        this.inUpdate = true;
        try {
            int index = -1;
            for (int i = 0; i < prg.slaveProfiles.length; ++i) {
                if (prg.slaveProfiles[i] != this.port.slaveProfile) continue;
                index = i;
                break;
            }
            this.cbxSlaveProfile.setSelectedIndex(index);
            if (prg.rs485Ports.length > this.portIndex && prg.rs485Ports[this.portIndex].isRs485Master) {
                this.cbGateway.setVisible(true);
                this.cbGateway.setSelected(prg.rs485Ports[this.portIndex].isRs485TcpGateway);
            } else {
                this.cbGateway.setVisible(false);
            }
        }
        finally {
            this.inUpdate = false;
        }
    }

    public void compileData(Schedule sch, Program prg) throws SyntaxError {
    }
}

