/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ports;

import certa.vics.Utils;
import certa.vics.compiler.ModbusMasterProfile;
import certa.vics.compiler.ModbusMasterRequest;
import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.Port;
import certa.vics.compiler.Variable;
import certa.vics.ide.DialogErrorLabel;
import certa.vics.ide.IdeAction;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.modbus.ModbusTableView;
import certa.vics.ide.modbus.RegView;
import certa.vics.ide.ports.PortsEditor;
import certa.vics.ide.ports.RequestView;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class Rs485MasterParamsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    final PortsEditor editor;
    final Port port;
    final int portIndex;
    JPanel pnlMasterProps;
    JTextField tfTimeout;
    JTextField tfPause;
    JLabel lblGateways;
    final ArrayList<RequestView> masterRequests = new ArrayList();
    final ModbusTableView requestRegisters;
    RequestsListModel requestsModel;
    JList<RequestView> requestsList;
    JScrollPane requestsScroll;
    IdeUtils.BorderedPanel pnlReqList;
    JToolBar reqListToolBar;
    JSplitPane masterSplitter;
    IdeUtils.BorderedPanel pnlReqProps;
    JPanel pnlReqPropsTop;
    JComboBox<String> cbxFunction;
    static final String[] FUNCTIONS = new String[]{"1 (Read Coils)", "2 (Read Discrete Inputs)", "3 (Read Holding Registers)", "4 (Read Input Registers)", "5 (Write Single Coil)", "6 (Write Single Register)", "15 (Write Multiple Coils)", "16 (Write Multiple Registers)"};
    static final int[] FUNCTION_CODES = new int[]{1, 2, 3, 4, 5, 6, 15, 16};
    JTextField tfSlaveId;
    DialogErrorLabel lblSlaveIdError;
    JTextField tfStartAddr;
    DialogErrorLabel lblStartAddrError;
    JComboBox<VariableRef> cbxCmdVar;
    JComboBox<VariableRef> cbxResultVar;
    JComboBox<VariableRef> cbxErrCountVar;
    JComboBox<String> cbxVxModulesCount;
    JLabel lblVxCountError;
    boolean isModified;
    boolean inUpdate = false;
    ActionListener updateVxModulesCount = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Rs485MasterParamsPanel.this.updateData();
        }
    };
    final IdeAction addRequest = new IdeAction(null, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441", "add_item.png", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441", 0, null){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestView r = new RequestView(1, 1, 0, null, null, null);
            Rs485MasterParamsPanel.this.masterRequests.add(r);
            Rs485MasterParamsPanel.this.markModified();
            Rs485MasterParamsPanel.this.requestsModel.update();
            Rs485MasterParamsPanel.this.requestsList.setSelectedValue(r, true);
        }
    };
    final IdeAction deleteRequest = new IdeAction(null, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", "delete.png", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441", 0, null){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canExec() {
            return Rs485MasterParamsPanel.this.requestsList.getSelectedValue() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestView rv = Rs485MasterParamsPanel.this.requestsList.getSelectedValue();
            if (rv != null) {
                if (!IdeUtils.confirmDialog("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 '" + rv.toString() + "'?")) {
                    return;
                }
                Rs485MasterParamsPanel.this.masterRequests.remove(rv);
                Rs485MasterParamsPanel.this.markModified();
                Rs485MasterParamsPanel.this.requestsModel.update();
                Rs485MasterParamsPanel.this.setRequestControls();
            }
        }
    };
    final IdeAction moveRequestUp = new IdeAction(null, "\u0412\u0432\u0435\u0440\u0445", "up.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u044b\u0448\u0435", 0, null){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canExec() {
            int i = Rs485MasterParamsPanel.this.requestsList.getSelectedIndex();
            return i > 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = Rs485MasterParamsPanel.this.requestsList.getSelectedIndex();
            if (i > 0) {
                RequestView r = Rs485MasterParamsPanel.this.masterRequests.get(i - 1);
                Rs485MasterParamsPanel.this.masterRequests.set(i - 1, Rs485MasterParamsPanel.this.masterRequests.get(i));
                Rs485MasterParamsPanel.this.masterRequests.set(i, r);
                Rs485MasterParamsPanel.this.markModified();
                Rs485MasterParamsPanel.this.requestsModel.update();
                Rs485MasterParamsPanel.this.requestsList.setSelectedIndex(i - 1);
            }
        }
    };
    final IdeAction moveRequestDown = new IdeAction(null, "\u0412\u043d\u0438\u0437", "down.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u043d\u0438\u0436\u0435", 0, null){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canExec() {
            int i = Rs485MasterParamsPanel.this.requestsList.getSelectedIndex();
            return i >= 0 && i < Rs485MasterParamsPanel.this.masterRequests.size() - 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = Rs485MasterParamsPanel.this.requestsList.getSelectedIndex();
            if (i >= 0 && i < Rs485MasterParamsPanel.this.masterRequests.size() - 1) {
                RequestView r = Rs485MasterParamsPanel.this.masterRequests.get(i + 1);
                Rs485MasterParamsPanel.this.masterRequests.set(i + 1, Rs485MasterParamsPanel.this.masterRequests.get(i));
                Rs485MasterParamsPanel.this.masterRequests.set(i, r);
                Rs485MasterParamsPanel.this.markModified();
                Rs485MasterParamsPanel.this.requestsModel.update();
                Rs485MasterParamsPanel.this.requestsList.setSelectedIndex(i + 1);
            }
        }
    };
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Rs485MasterParamsPanel.this.updateData();
        }
    };
    DocumentListener masterEditUpdate = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            Rs485MasterParamsPanel.this.updateData();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            Rs485MasterParamsPanel.this.updateData();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            Rs485MasterParamsPanel.this.updateData();
        }
    };
    InputVerifier inputVerifier = new InputVerifier(){

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            Rs485MasterParamsPanel.this.updateData();
            return true;
        }

        @Override
        public boolean verify(JComponent input) {
            return true;
        }
    };

    public Rs485MasterParamsPanel(final PortsEditor editor, Port port, int portIndex) {
        this.editor = editor;
        this.port = port;
        this.portIndex = portIndex;
        if (port.masterProfile == null) {
            port.masterProfile = new ModbusMasterProfile();
        }
        ActionListener update = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rs485MasterParamsPanel.this.updateData();
            }
        };
        this.pnlMasterProps = new JPanel(new MigLayout(""));
        JLabel lbl = new JLabel("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 (\u043c\u0441):");
        lbl.setToolTipText("\u0412\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441");
        this.pnlMasterProps.add((Component)lbl, "");
        this.tfTimeout = new JTextField(6);
        this.tfTimeout.getDocument().addDocumentListener(this.masterEditUpdate);
        this.tfTimeout.setInputVerifier(this.inputVerifier);
        this.pnlMasterProps.add((Component)this.tfTimeout, "");
        lbl = new JLabel("\u041f\u0430\u0443\u0437\u0430 (\u043c\u0441):");
        lbl.setToolTipText("\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0430\u0443\u0437\u0443 \u043c\u0435\u0436\u0434\u0443 \u0437\u0430\u043f\u0440\u043e\u0441\u0430\u043c\u0438 \u043d\u0435 \u043c\u0435\u043d\u0435\u0435 10 \u043c\u0441");
        this.pnlMasterProps.add((Component)lbl, "gap 20px");
        this.tfPause = new JTextField(6);
        this.tfPause.getDocument().addDocumentListener(this.masterEditUpdate);
        this.tfPause.setInputVerifier(this.inputVerifier);
        this.pnlMasterProps.add((Component)this.tfPause, "");
        lbl = new JLabel("\u041c\u043e\u0434\u0443\u043b\u0438 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f:");
        lbl.setToolTipText("\u041c\u043e\u0434\u0443\u043b\u0438 \u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u0422\u041e\u041b\u042c\u041a\u041e \u041a \u041e\u0414\u041d\u041e\u041c\u0423 \u041f\u041e\u0420\u0422\u0423");
        this.lblVxCountError = new DialogErrorLabel("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0441 \u0434\u0440\u0443\u0433\u0438\u043c \u043f\u043e\u0440\u0442\u043e\u043c");
        this.lblVxCountError.setToolTipText(lbl.getToolTipText());
        this.pnlMasterProps.add((Component)lbl, "gap 20px");
        this.cbxVxModulesCount = new JComboBox();
        String[] s = new String[editor.mainFrame.program.device.MaxVxModules + 1];
        for (int i = 0; i < s.length; ++i) {
            s[i] = Integer.toString(i);
        }
        this.cbxVxModulesCount.setModel(new DefaultComboBoxModel<String>(s));
        this.cbxVxModulesCount.setMaximumRowCount(20);
        this.cbxVxModulesCount.addActionListener(this.updateVxModulesCount);
        this.pnlMasterProps.add(this.cbxVxModulesCount, "");
        this.pnlMasterProps.add((Component)this.lblVxCountError, "hidemode 3");
        this.lblGateways = new JLabel("");
        this.pnlMasterProps.add((Component)this.lblGateways, "gap 20px");
        this.pnlReqList = new IdeUtils.BorderedPanel(new JPanel(new BorderLayout()), "\u0421\u043f\u0438\u0441\u043e\u043a \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432"){
            private static final long serialVersionUID = 1L;

            @Override
            public void titleClicked() {
                Rs485MasterParamsPanel.this.pnlReqList.requestFocusInWindow();
            }

            @Override
            protected void focusChanged() {
                editor.actions.update();
            }
        };
        this.reqListToolBar = IdeUtils.newToolBar();
        this.reqListToolBar.add(this.addRequest).setFocusable(false);
        this.reqListToolBar.add(this.moveRequestUp).setFocusable(false);
        this.reqListToolBar.add(this.moveRequestDown).setFocusable(false);
        this.reqListToolBar.addSeparator();
        this.reqListToolBar.add(this.deleteRequest).setFocusable(false);
        this.requestsModel = new RequestsListModel();
        this.requestsList = new JList<RequestView>(this.requestsModel);
        this.requestsList.setSelectionMode(0);
        this.requestsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Rs485MasterParamsPanel.this.setRequestControls();
            }
        });
        MouseListener ml = IdeUtils.createOnClickFocuser(this.requestsList);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add(this.requestsList);
        pnl.addMouseListener(ml);
        pnl.setBackground(this.requestsList.getBackground());
        JScrollPane scroll = new JScrollPane(pnl);
        this.pnlReqList.addMouseListener(ml);
        this.pnlReqList.add((Component)this.reqListToolBar, "North");
        this.pnlReqList.add((Component)scroll, "Center");
        this.pnlReqProps = new IdeUtils.BorderedPanel(new JPanel(new BorderLayout()), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430"){
            private static final long serialVersionUID = 1L;

            @Override
            public void titleClicked() {
                Rs485MasterParamsPanel.this.pnlReqProps.requestFocusInWindow();
            }

            @Override
            protected void focusChanged() {
                editor.actions.update();
            }
        };
        this.requestRegisters = new ModbusTableView(editor, "Registers", false, false, null, true);
        this.pnlReqPropsTop = new JPanel(new MigLayout("insets 8 8 8 8", "", ""));
        JLabel lbl0 = new JLabel("\u0424\u0443\u043d\u043a\u0446\u0438\u044f:");
        lbl0.setToolTipText("\u041d\u043e\u043c\u0435\u0440 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 MODBUS");
        this.cbxFunction = new JComboBox<String>(new DefaultComboBoxModel<String>(FUNCTIONS));
        this.cbxFunction.addActionListener(update);
        JLabel lbl1 = new JLabel("ID \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:");
        lbl1.setToolTipText("\u0421\u0435\u0442\u0435\u0432\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 slave-\u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u0430\u0434\u0440\u0435\u0441\u043e\u0432\u0430\u043d \u0437\u0430\u043f\u0440\u043e\u0441");
        this.tfSlaveId = new JTextField(6);
        this.tfSlaveId.getDocument().addDocumentListener(this.masterEditUpdate);
        this.tfSlaveId.setInputVerifier(this.inputVerifier);
        this.lblSlaveIdError = new DialogErrorLabel("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 ID");
        JLabel lbl2 = new JLabel("\u0410\u0434\u0440\u0435\u0441 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430:");
        lbl2.setToolTipText("\u0410\u0434\u0440\u0435\u0441 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435. \u041e\u0442 0 \u0434\u043e 65535 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0440\u0430\u0437\u043c\u0435\u0440\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b.");
        this.tfStartAddr = new JTextField(6);
        this.tfStartAddr.getDocument().addDocumentListener(this.masterEditUpdate);
        this.tfStartAddr.setInputVerifier(this.inputVerifier);
        this.lblStartAddrError = new DialogErrorLabel("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441");
        JLabel lbl3 = new JLabel("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 (\u0430\u0432\u0442\u043e\u0441\u0431\u0440\u043e\u0441):");
        lbl3.setToolTipText("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0442\u0438\u043f\u0430 BOOL \u0434\u043b\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        this.cbxCmdVar = new JComboBox();
        this.cbxCmdVar.addActionListener(update);
        JLabel lbl4 = new JLabel("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442:");
        lbl4.setToolTipText("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0442\u0438\u043f\u0430 BOOL \u0434\u043b\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        this.cbxResultVar = new JComboBox();
        this.cbxResultVar.addActionListener(update);
        JLabel lbl5 = new JLabel("\u0421\u0447\u0435\u0442\u0447\u0438\u043a \u043e\u0448\u0438\u0431\u043e\u043a:");
        lbl5.setToolTipText("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0442\u0438\u043f\u0430 INT \u0434\u043b\u044f \u043f\u043e\u0434\u0441\u0447\u0435\u0442\u0430 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043e\u0448\u0438\u0431\u043e\u043a");
        this.cbxErrCountVar = new JComboBox();
        this.cbxErrCountVar.addActionListener(update);
        this.pnlReqPropsTop.add((Component)lbl1, "alignx right");
        this.pnlReqPropsTop.add((Component)this.tfSlaveId, "");
        this.pnlReqPropsTop.add((Component)this.lblSlaveIdError, "");
        this.pnlReqPropsTop.add((Component)lbl0, "newline, alignx right");
        this.pnlReqPropsTop.add(this.cbxFunction, "span");
        this.pnlReqPropsTop.add((Component)lbl2, "newline, alignx right");
        this.pnlReqPropsTop.add((Component)this.tfStartAddr, "");
        this.pnlReqPropsTop.add((Component)this.lblStartAddrError, "");
        this.pnlReqPropsTop.add((Component)lbl3, "newline, alignx right");
        this.pnlReqPropsTop.add(this.cbxCmdVar, "span");
        this.pnlReqPropsTop.add((Component)lbl4, "newline, alignx right");
        this.pnlReqPropsTop.add(this.cbxResultVar, "span");
        this.pnlReqPropsTop.add((Component)lbl5, "newline, alignx right");
        this.pnlReqPropsTop.add(this.cbxErrCountVar, "span");
        this.pnlReqProps.add((Component)this.pnlReqPropsTop, "North");
        this.pnlReqProps.add((Component)this.requestRegisters, "Center");
        this.masterSplitter = new JSplitPane(1, this.pnlReqList, this.pnlReqProps);
        IdeUtils.setupDivider(this.masterSplitter);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlMasterProps, "North");
        this.add((Component)this.masterSplitter, "Center");
    }

    void setControls() {
        this.inUpdate = true;
        ModbusMasterProfile profile = this.port.masterProfile;
        this.tfTimeout.setText(Integer.toString(profile.timeout));
        this.tfPause.setText(Integer.toString(profile.pause));
        this.cbxVxModulesCount.setSelectedIndex(profile.vxModules);
        Port[] tcpPorts = this.editor.mainFrame.program.tcpSlavePorts;
        Port[] rs485Ports = this.editor.mainFrame.program.rs485Ports;
        String s = "+\u0417\u0430\u043f\u0440\u043e\u0441\u044b \u0438\u0437 ";
        boolean gw = false;
        if (tcpPorts.length > this.portIndex && this.port.isRs485TcpGateway) {
            s = s + "Modbus_TCP_" + (this.portIndex + 1);
            gw = true;
        }
        for (int i = 0; i < rs485Ports.length; ++i) {
            Port p = rs485Ports[i];
            if (p.isRs485Master || p.gatewayTargetRS485index != this.portIndex) continue;
            s = s + (gw ? ", " : "") + "RS485_" + (i + 1);
            gw = true;
        }
        this.lblGateways.setText(gw ? s : "");
        if (this.requestsList.getSelectedIndex() < 0 && this.requestsList.getModel().getSize() > 0) {
            this.requestsList.setSelectedIndex(0);
        }
        this.inUpdate = false;
        this.setRequestControls();
    }

    void setRequestControls() {
        this.inUpdate = true;
        RequestView rq = this.requestsList.getSelectedValue();
        this.pnlReqProps.setContentsVisible(rq != null);
        if (rq != null) {
            int t = rq.function;
            if (t >= 1 && t <= 6) {
                this.cbxFunction.setSelectedIndex(t - 1);
            } else if (t == 15 || t == 16) {
                this.cbxFunction.setSelectedIndex(t - 9);
            } else {
                this.cbxFunction.setSelectedIndex(0);
            }
            this.tfSlaveId.setText(Integer.toString(rq.id));
            this.tfStartAddr.setText(Integer.toString(rq.address));
            this.setVarInCombo(this.cbxCmdVar, rq.varCmd);
            this.setVarInCombo(this.cbxResultVar, rq.varResult);
            this.setVarInCombo(this.cbxErrCountVar, rq.varErrorCounter);
            this.requestRegisters.setRegList(rq.address, rq.regs, rq.isDiscrete(), rq.varsWritable(), this.editor.mainFrame.getVarsEditor());
        } else {
            this.requestRegisters.loadRegs(null, null, null);
        }
        this.inUpdate = false;
        this.addRequest.update();
        this.deleteRequest.update();
        this.moveRequestUp.update();
        this.moveRequestDown.update();
        this.updateData();
    }

    void updateVxError() {
        this.lblVxCountError.setVisible(false);
        int t = this.cbxVxModulesCount.getSelectedIndex();
        if (t > 0) {
            for (Port p : this.editor.mainFrame.program.rs485Ports) {
                if (!p.hasMasterProfile() || p.masterProfile.vxModules <= 0 || p == this.port) continue;
                this.lblVxCountError.setVisible(true);
                break;
            }
        }
    }

    void updateData() {
        if (this.inUpdate) {
            return;
        }
        int t = Utils.StringToIntDef(this.tfTimeout.getText(), -1);
        if (t >= 0 && t <= 65535 && this.port.masterProfile.timeout != t) {
            this.markModified();
            this.port.masterProfile.timeout = t;
        }
        if ((t = Utils.StringToIntDef(this.tfPause.getText(), -1)) >= 0 && t <= 65535 && this.port.masterProfile.pause != t) {
            this.markModified();
            this.port.masterProfile.pause = t;
        }
        if ((t = this.cbxVxModulesCount.getSelectedIndex()) >= 0 && t <= this.editor.mainFrame.program.device.MaxVxModules && this.port.masterProfile.vxModules != t) {
            this.markModified();
            this.port.masterProfile.vxModules = t;
        }
        this.updateVxError();
        RequestView rq = this.requestsList.getSelectedValue();
        if (rq != null) {
            boolean ok;
            t = this.cbxFunction.getSelectedIndex();
            boolean bl = ok = t >= 0;
            if (ok) {
                rq.function = this.updateInt(rq.function, FUNCTION_CODES[t]);
            }
            this.lblSlaveIdError.setVisible(!(ok = RequestView.correctId(t = Utils.StringToIntDef(this.tfSlaveId.getText(), -1))));
            if (ok) {
                rq.id = this.updateInt(rq.id, t);
            }
            this.lblStartAddrError.setVisible(!(ok = RequestView.correctAddress(t = Utils.StringToIntDef(this.tfStartAddr.getText(), -1), this.requestRegisters.list.size())));
            if (ok) {
                rq.address = this.updateInt(rq.address, t);
                this.requestRegisters.setStartAddress(t, rq.isDiscrete(), rq.varsWritable(), this.editor.mainFrame.getVarsEditor());
            }
            rq.varCmd = this.updateVar(rq.varCmd, (VariableRef)this.cbxCmdVar.getSelectedItem());
            rq.varResult = this.updateVar(rq.varResult, (VariableRef)this.cbxResultVar.getSelectedItem());
            rq.varErrorCounter = this.updateVar(rq.varErrorCounter, (VariableRef)this.cbxErrCountVar.getSelectedItem());
        }
        this.editor.updateVarRefs();
    }

    void setVarInCombo(JComboBox<VariableRef> combo, VariableRef var) {
        combo.setSelectedItem(null);
        combo.setSelectedItem(var);
    }

    private int updateInt(int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.markModified();
        }
        return newValue;
    }

    private VariableRef updateVar(VariableRef oldValue, VariableRef newValue) {
        if (oldValue == null || newValue == null) {
            if (newValue != oldValue) {
                this.markModified();
            }
        } else if (!oldValue.equals(newValue)) {
            this.markModified();
        }
        return newValue;
    }

    protected void markModified() {
        this.isModified = true;
        this.editor.markModified();
    }

    public void loadData(VariablesEditor ved) {
        this.inUpdate = true;
        ModbusMasterProfile profile = this.port.masterProfile;
        this.masterRequests.clear();
        for (int i = 0; i < profile.requests.size(); ++i) {
            ModbusMasterRequest src = profile.requests.get(i);
            RequestView rq = new RequestView(src.func, src.id, src.addr, ved.makeRef(src.varCmd), ved.makeRef(src.varResult), ved.makeRef(src.varErrCount));
            this.masterRequests.add(rq);
            for (int j = 0; j < src.registers.size(); ++j) {
                ModbusReg sr = src.registers.get(j);
                rq.regs.add(new RegView(ved.makeRef(sr.var), sr.digits));
            }
        }
        this.updateVarList();
        this.inUpdate = false;
    }

    void saveData() {
        this.port.masterProfile.clear();
        for (int i = 0; i < this.masterRequests.size(); ++i) {
            RequestView rq = this.masterRequests.get(i);
            this.port.masterProfile.allocRequest(rq.function, rq.id, rq.address, this.getCompiledVar(rq.varCmd, false, true, false, false), this.getCompiledVar(rq.varResult, true, true, false, false), this.getCompiledVar(rq.varErrorCounter, true, false, true, false));
            for (int j = 0; j < rq.regs.size(); ++j) {
                RegView reg = rq.regs.get(j);
                Variable v = this.getCompiledVar(reg.var, rq.varsWritable(), true, true, true);
                this.port.masterProfile.allocVar(v, reg.digits);
            }
        }
    }

    public void updateVarRefs() {
        for (RequestView rq : this.masterRequests) {
            if (rq.varCmd != null) {
                rq.varCmd.varDef.addModbusRef(rq, true);
            }
            if (rq.varErrorCounter != null) {
                rq.varErrorCounter.varDef.addModbusRef(rq, true);
            }
            if (rq.varResult != null) {
                rq.varResult.varDef.addModbusRef(rq, true);
            }
            for (RegView r : rq.regs) {
                if (r.var == null) continue;
                r.var.varDef.addModbusRef(r, rq.varsWritable());
            }
        }
        this.requestsModel.update();
    }

    public void updateVarList() {
        VariablesEditor ved = this.editor.mainFrame.getVarsEditor();
        this.requestRegisters.updateVarList(ved);
        this.requestRegisters.model.fireTableDataChanged();
        ArrayList<VariableRef> vars = ved.getAllVariables(true, 0);
        Vector<VariableRef> vector = new Vector<VariableRef>();
        vector.add(null);
        for (VariableRef v : vars) {
            if (v == null || v.type() != 1 || !v.isWritableInFbd()) continue;
            vector.add(v);
        }
        this.cbxCmdVar.setModel(new DefaultComboBoxModel(vector));
        vector = new Vector();
        vector.add(null);
        for (VariableRef v : vars) {
            if (v == null || v.type() != 1 || !v.isWritableInFbd()) continue;
            vector.add(v);
        }
        this.cbxResultVar.setModel(new DefaultComboBoxModel(vector));
        vector = new Vector();
        vector.add(null);
        for (VariableRef v : vars) {
            if (v == null || v.type() != 2 || !v.isWritableInFbd()) continue;
            vector.add(v);
        }
        this.cbxErrCountVar.setModel(new DefaultComboBoxModel(vector));
        this.setControls();
    }

    Variable getCompiledVar(VariableRef vr, boolean writable, boolean needBool, boolean needInt, boolean needFloat) {
        if (vr == null) {
            return null;
        }
        if (writable && !vr.isWritableInFbd()) {
            return null;
        }
        if (vr.type() == 1 && !needBool) {
            return null;
        }
        if (vr.type() == 2 && !needInt) {
            return null;
        }
        if (vr.type() == 3 && !needFloat) {
            return null;
        }
        return vr.getCompiledVar();
    }

    class RequestsListModel
    extends AbstractListModel<RequestView> {
        private static final long serialVersionUID = 1L;

        RequestsListModel() {
        }

        @Override
        public int getSize() {
            return Rs485MasterParamsPanel.this.masterRequests.size();
        }

        @Override
        public RequestView getElementAt(int index) {
            if (index >= 0 && index < Rs485MasterParamsPanel.this.masterRequests.size()) {
                return Rs485MasterParamsPanel.this.masterRequests.get(index);
            }
            return null;
        }

        void update() {
            this.fireContentsChanged(this, 0, Rs485MasterParamsPanel.this.masterRequests.size());
        }
    }
}

