/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.vics.Utils;
import certa.vics.ide.modbus.PollDialog;
import certa.vics.ide.schedule.ScheduleCell;
import certa.vics.ide.schedule.ScheduleCellEditor;
import certa.vics.ide.schedule.ScheduleEditor;
import certa.vics.ide.schedule.ScheduleTableView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

class ModbusScheduleTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    final ScheduleTableView tableView;
    final PollDialog dialog;
    final ScheduleEditor editor;
    final ModbusScheduleCell[][] cells = new ModbusScheduleCell[7][13];
    JTable table;
    ScheduleTableModel model;
    JPanel pnlParams;
    JLabel lblType;
    final ArrayList<ModbusScheduleCell> selList = new ArrayList();
    SchedCellRenderer cellRenderer;
    static final String[] DAY_NAMES = new String[]{"\u041f\u041d", "\u0412\u0422", "\u0421\u0420", "\u0427\u0422", "\u041f\u0422", "\u0421\u0411", "\u0412\u0421"};
    int focusedRow = 0;
    int focusedCol = 0;

    public ModbusScheduleTable(PollDialog dialog, ScheduleEditor editor, ScheduleTableView tableView) {
        this.dialog = dialog;
        this.editor = editor;
        this.tableView = tableView;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < this.cells[x].length; ++y) {
                this.cells[x][y] = new ModbusScheduleCell(this, x, y);
            }
        }
        this.model = new ScheduleTableModel();
        this.table = new JTable(this.model);
        this.pnlParams = new JPanel(new MigLayout("", "", ""));
        this.pnlParams.add((Component)new JLabel("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f: "), "");
        this.pnlParams.add((Component)new JLabel("<html><b>" + tableView.getVarName() + "</b></html>"), "wrap");
        this.pnlParams.add((Component)new JLabel("\u0417\u0430\u043f\u0438\u0441\u044c: "), "");
        this.lblType = new JLabel("");
        this.pnlParams.add((Component)this.lblType, "wrap");
        this.pnlParams.add((Component)new JLabel("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435: "), "");
        this.pnlParams.add((Component)new JLabel(tableView.getEnableName()), "wrap");
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlParams, "North");
        JScrollPane scroll = new JScrollPane(this.table);
        this.add((Component)scroll, "Center");
        this.setupTable();
    }

    int getEventsCount(int dayIndex) {
        if (dayIndex >= 0 && dayIndex <= 6) {
            return this.cells[dayIndex][0].i1;
        }
        return 0;
    }

    void updateSelList() {
        this.selList.clear();
        int[] rows = this.table.getSelectedRows();
        int[] columns = this.table.getSelectedColumns();
        for (int r : rows) {
            for (int c : columns) {
                if (!this.table.isCellSelected(r, c)) continue;
                this.selList.add(this.cells[c][r]);
            }
        }
    }

    private void showPopup(MouseEvent e) {
        block6: {
            ModbusScheduleCell c0;
            block7: {
                if (e.getComponent() != this.table) break block6;
                this.table.requestFocusInWindow();
                int r = this.table.rowAtPoint(e.getPoint());
                int c = this.table.columnAtPoint(e.getPoint());
                if (r < 0 || c < 0) {
                    return;
                }
                if (!this.table.isCellSelected(r, c)) {
                    return;
                }
                this.focusedCol = c;
                this.focusedRow = r;
                if (this.selList.size() < 0) break block6;
                this.updateSelList();
                if (this.selList.size() <= 0) break block6;
                c0 = this.selList.get(0);
                if (c0.y != 0) break block7;
                Integer count = c0.i1;
                Object[] list = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
                count = (Integer)JOptionPane.showInputDialog(this, "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u0439", "\u0412\u044b\u0431\u043e\u0440", 3, null, list, count);
                if (count == null) break block6;
                for (int i = 0; i < this.selList.size(); ++i) {
                    this.selList.get(i).writeCount(count);
                }
                break block6;
            }
            if (c0.y <= this.cells[c0.x][0].i1) {
                ScheduleCell tc = new ScheduleCell(this.tableView, true);
                tc.update(c0.i1, c0.i2, (double)c0.i3 / Math.pow(10.0, this.tableView.getDigits()));
                if (ScheduleCellEditor.showDialog(tc, 0, 0, this.dialog)) {
                    for (int i = 0; i < this.selList.size(); ++i) {
                        this.selList.get(i).writeEvent(tc.getHour(), tc.getMinute(), Utils.Round(tc.getValue() * Math.pow(10.0, this.tableView.getDigits())));
                    }
                }
            }
        }
    }

    private void setupTable() {
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setAutoCreateRowSorter(false);
        this.table.setFillsViewportHeight(false);
        this.table.setAutoResizeMode(0);
        this.table.setSelectionMode(1);
        this.table.setCellSelectionEnabled(true);
        JTableHeader th = this.table.getTableHeader();
        th.setReorderingAllowed(false);
        th.setFont(th.getFont().deriveFont(1));
        this.cellRenderer = new SchedCellRenderer();
        this.table.setDefaultRenderer(ModbusScheduleCell.class, this.cellRenderer);
        Dimension cs = this.cellRenderer.figureOutSize();
        this.table.setRowHeight(cs.height);
        TableColumnModel cm = this.table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn tc = cm.getColumn(i);
            tc.setPreferredWidth(cs.width);
            tc.setResizable(false);
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ModbusScheduleTable.this.updateSelList();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.getClickCount() == 2 || me.isPopupTrigger()) {
                    ModbusScheduleTable.this.showPopup(me);
                } else {
                    super.mousePressed(me);
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    ModbusScheduleTable.this.showPopup(me);
                } else {
                    super.mouseReleased(me);
                }
            }
        });
    }

    class SchedCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        int h;

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                ModbusScheduleCell c = (ModbusScheduleCell)value;
                if (c.y == 0) {
                    this.setText("<html>&ensp;\u0441\u043e\u0431\u044b\u0442\u0438\u0439: " + c.i1 + "</html>");
                } else if (c.y <= c.table.getEventsCount(c.x)) {
                    String time = (c.i1 < 10 ? "0" : "") + c.i1 + ":" + (c.i2 < 10 ? "0" : "") + c.i2;
                    ScheduleTableView tv = c.table.tableView;
                    int dig = tv.getDigits();
                    String v = Utils.FormatDouble((double)c.i3 / Math.pow(10.0, dig), dig);
                    this.setText("<html>&ensp;" + time + "&emsp;<b>" + v + "</b></html>");
                } else {
                    this.setText("");
                }
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (hasFocus) {
                ModbusScheduleTable.this.focusedRow = row;
                ModbusScheduleTable.this.focusedCol = col;
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            return this;
        }

        Dimension figureOutSize() {
            return new Dimension(140, 28);
        }
    }

    class ScheduleTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        ScheduleTableModel() {
        }

        @Override
        public int getRowCount() {
            return 13;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            return DAY_NAMES[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ModbusScheduleCell.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ModbusScheduleTable.this.cells[columnIndex][rowIndex];
        }
    }

    class ModbusScheduleCell {
        final ModbusScheduleTable table;
        final int x;
        final int y;
        int i1;
        int i2;
        int i3;
        int digits;

        public ModbusScheduleCell(ModbusScheduleTable table, int x, int y) {
            this.table = table;
            this.x = x;
            this.y = y;
        }

        void writeEvent(int i1, int i2, int i3) {
            if (this.y > 0 && this.y <= this.table.cells[this.x][0].i1) {
                ModbusScheduleTable.this.dialog.connection.schedule[2 + 3 * (this.y - 1) + 37 * this.x].writeValue(i1);
                ModbusScheduleTable.this.dialog.connection.schedule[3 + 3 * (this.y - 1) + 37 * this.x].writeValue(i2);
                ModbusScheduleTable.this.dialog.connection.schedule[4 + 3 * (this.y - 1) + 37 * this.x].writeValue(i3);
            }
        }

        void writeCount(int i1) {
            if (this.y == 0) {
                ModbusScheduleTable.this.dialog.connection.schedule[1 + 37 * this.x].writeValue(i1);
            }
        }
    }
}

