/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.vics.Utils;
import certa.vics.ide.IdeTableCellRenderer;
import certa.vics.ide.modbus.ConnectionThread;
import certa.vics.ide.modbus.PollDialog;
import certa.vics.ide.modbus.RegView;
import certa.vics.ide.modbus.Register;
import certa.vics.ide.variables.VariableRef;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

class ModbusRegsTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    final String regName;
    boolean isBool;
    boolean isWritable;
    public static final int COL_ADDRESS = 0;
    public static final int COL_VAR = 1;
    public static final int COL_VALUE = 2;
    public static final int COL_COMMENT = 3;
    public static final String[] COLUMNS = new String[]{"\u0410\u0434\u0440\u0435\u0441", "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"};
    static final int[] DEF_COLUMNS_W = new int[]{50, 200, 80, 500};
    ArrayList<RegView> list;
    int[] values;
    boolean[] unsigned;
    boolean[] bad;
    boolean[] writing;
    final PollDialog dialog;
    EditableTable table;
    PollTableModel model;
    IdeTableCellRenderer commentRender = new IdeTableCellRenderer(2, 8);
    JTextField tfValueEdit;

    public ModbusRegsTable(PollDialog dialog, String regName, boolean isBool, boolean isWritable) {
        this.dialog = dialog;
        this.regName = regName;
        this.isBool = isBool;
        this.isWritable = isWritable;
        this.model = new PollTableModel();
        this.table = new EditableTable(this.model);
        this.tfValueEdit = new JTextField();
        this.setupTable();
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.table);
        this.add((Component)scroll, "Center");
    }

    private void setupTable() {
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setAutoCreateRowSorter(false);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setCellRenderer(new IdeTableCellRenderer(4, 8));
        cm.getColumn(2).setCellRenderer(new IdeTableCellRenderer(2, 8));
        if (this.isWritable) {
            cm.getColumn(2).setCellEditor(new SelectAllCellEditor(this.tfValueEdit));
        }
        cm.getColumn(3).setCellRenderer(this.commentRender);
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn c = cm.getColumn(i);
            if (c.getCellRenderer() != null) continue;
            c.setCellRenderer(new IdeTableCellRenderer(2, 8));
        }
        int height = this.table.getRowHeight();
        this.table.setRowHeight(height + 6);
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            cm.getColumn(i).setPreferredWidth(DEF_COLUMNS_W[i]);
        }
    }

    public void setRegList(ArrayList<RegView> regs) {
        this.list = regs;
        this.values = new int[this.list.size()];
        this.unsigned = new boolean[this.list.size()];
        for (int i = 0; i < this.list.size(); ++i) {
            RegView rv = this.list.get(i);
            this.unsigned[i] = rv.var != null && rv.var.type() == 2 && rv.var.shortName().contains("(+)");
        }
        this.bad = new boolean[this.list.size()];
        Arrays.fill(this.bad, true);
        this.writing = new boolean[this.list.size()];
        this.model.fireTableDataChanged();
        this.updateTableView();
    }

    public void stopEditing() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    protected void updateTableView() {
        TableColumn col = this.table.getTableHeader().getColumnModel().getColumn(this.table.convertColumnIndexToView(3));
        int w = 100;
        for (int r = 0; r < this.list.size(); ++r) {
            JLabel c = (JLabel)this.commentRender.getTableCellRendererComponent(this.table, this.model.getValueAt(r, 3), false, false, r, 3);
            Dimension ps = c.getPreferredSize();
            this.table.setRowHeight(r, ps.height + 4);
            w = Math.max(w, ps.width + 30);
        }
        col.setMinWidth(w);
        col.setPreferredWidth(w);
    }

    class PollTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        PollTableModel() {
        }

        @Override
        public int getRowCount() {
            if (ModbusRegsTable.this.list != null) {
                return ModbusRegsTable.this.list.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return VariableRef.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            RegView reg = ModbusRegsTable.this.list.get(rowIndex);
            return columnIndex == 2 && ModbusRegsTable.this.isWritable && reg.var != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2 && ModbusRegsTable.this.dialog.connection != null) {
                ConnectionThread connectionThread = ModbusRegsTable.this.dialog.connection;
                synchronized (connectionThread) {
                    if (aValue instanceof String) {
                        String s = (String)aValue;
                        double t = Utils.StringToDouble(s);
                        if (Double.isNaN(t)) {
                            return;
                        }
                        RegView src = ModbusRegsTable.this.list.get(rowIndex);
                        if (src.var == null) {
                            return;
                        }
                        int v = src.var.type() == 3 ? Utils.Round(t * Math.pow(10.0, src.digits)) : Utils.Round(t);
                        Register dst = (ModbusRegsTable.this.isBool ? ModbusRegsTable.this.dialog.connection.coils : ModbusRegsTable.this.dialog.connection.hregs)[rowIndex];
                        if (v >= Short.MIN_VALUE && v <= 65535) {
                            dst.writeValue(v);
                            this.fireTableCellUpdated(rowIndex, columnIndex);
                        }
                    }
                }
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RegView rv = ModbusRegsTable.this.list.get(rowIndex);
            if (columnIndex == 0) {
                return Integer.toString(rowIndex);
            }
            if (columnIndex == 1) {
                if (rv.var != null) {
                    return rv.var;
                }
                return null;
            }
            if (columnIndex == 2) {
                if (rv.var != null) {
                    String wm;
                    String string = wm = ModbusRegsTable.this.writing[rowIndex] ? "<-" : "";
                    if (ModbusRegsTable.this.bad[rowIndex]) {
                        return "-";
                    }
                    if (rv.var.type() == 3) {
                        return Utils.FormatDouble((double)ModbusRegsTable.this.values[rowIndex] / Math.pow(10.0, rv.digits), rv.digits) + wm;
                    }
                    return ModbusRegsTable.this.values[rowIndex] + wm;
                }
                return null;
            }
            if (columnIndex == 3) {
                if (rv.var != null) {
                    double v = rv.var.getInitValue();
                    return "<html>" + (v == v ? "<i>(" + Utils.numToString(v) + ")</i>&emsp;" : "") + rv.var.varDef.getCommentHtml() + "</html>";
                }
                return " ";
            }
            return null;
        }
    }

    private class SelectAllCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public SelectAllCellEditor(final JTextField textField) {
            super(textField);
            textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    textField.selectAll();
                }
            });
        }
    }

    private class EditableTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public EditableTable(TableModel dm) {
            super(dm);
        }

        @Override
        public boolean editCellAt(int row, int column, EventObject e) {
            boolean result = super.editCellAt(row, column, e);
            Component editor = this.getEditorComponent();
            if (editor != null && editor instanceof JTextComponent) {
                ((JTextComponent)editor).selectAll();
            }
            return result;
        }
    }
}

