/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.AFbdPin;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.OutputPin;
import certa.vics.ide.variables.VariableDef;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.json.JSONException;
import org.json.JSONObject;

public class FbdNumber
extends AFbdItem {
    static final Color BODY_COLOR;
    static final Color HOVER_COLOR;
    protected OutputPin outPin;
    protected double value;
    static final String JSON_TYPE = "type";
    static final String JSON_VALUE = "value";
    static final Font VALUE_FONT;

    public FbdNumber(FbdPage page, int type) throws JSONException, FbdLoadError {
        super(page, null);
        this.outPin = new OutputPin(this, type, null, 0);
    }

    public FbdNumber(FbdPage page, JSONObject src) throws JSONException, FbdLoadError {
        super(page, src);
        assert (src != null);
        String s = src.getString(JSON_TYPE);
        int type = Variable.stringToType(s);
        if (type == 0) {
            throw new FbdLoadError("Unknown num type: \"" + s + "\"");
        }
        this.value = src.getDouble(JSON_VALUE);
        if (type == 1) {
            this.value = this.value != 0.0 ? 1.0 : 0.0;
        } else if (type == 2) {
            this.value = (int)this.value;
        }
        this.outPin = new OutputPin(this, type, null, 0);
    }

    public void setValue(double v) {
        if (this.value != v) {
            this.value = v;
            this.markModified();
        }
    }

    @Override
    protected void init(JSONObject src) throws JSONException, FbdLoadError {
        this.padLeft = 1;
        this.padTop = 0;
        this.cellBounds.width = 2 + this.padLeft;
        this.cellBounds.height = 1 + this.padTop;
    }

    @Override
    public void saveToJson(JSONObject jso) throws JSONException {
        super.saveToJson(jso);
        jso.put(JSON_TYPE, Variable.typeToString(this.outPin.type));
        jso.put(JSON_VALUE, Utils.numToString(this.value));
    }

    @Override
    public void paintShape(Graphics2D g2d) {
        this.updateBounds();
        g2d.setColor(this.page.editor.hoveredView == this ? HOVER_COLOR : BODY_COLOR);
        g2d.fillRect(this.pxBounds.x, this.pxBounds.y, this.pxBounds.width, this.pxBounds.height);
        g2d.setStroke(SHAPE_STROKE);
        g2d.setColor(Color.DARK_GRAY);
        g2d.drawRect(this.pxBounds.x, this.pxBounds.y, this.pxBounds.width, this.pxBounds.height);
        String vs = Utils.numToString(this.value);
        g2d.setFont(VALUE_FONT);
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(vs, g2d);
        g2d.setColor(Color.BLACK);
        g2d.drawString(vs, this.pxBounds.x + this.pxBounds.width - (int)rect.getWidth() - 4, this.pxBounds.y + this.pxBounds.height - 3);
        this.paintFocus(g2d);
    }

    @Override
    public void paintLinks(Graphics2D g2d) {
        this.outPin.paint(g2d);
    }

    @Override
    protected void resolveLinks(boolean strict) throws FbdLoadError {
    }

    @Override
    public OutputPin getOutput(int index) {
        if (index == 0) {
            return this.outPin;
        }
        return null;
    }

    @Override
    public int getOutputIndex(OutputPin pin) {
        if (this.outPin != null && this.outPin == pin) {
            return 0;
        }
        return -1;
    }

    @Override
    public void compileOutputVars() throws SyntaxError {
        this.outPin.setCompiledVar(this.page.editor.allocNumberConst(this.outPin.type, this.value));
    }

    @Override
    public void compileInputVars() throws SyntaxError {
    }

    @Override
    public void updateBounds() {
        this.pxBounds.x = (this.cellBounds.x + 1) * 27;
        this.pxBounds.y = this.cellBounds.y * 27 + 5;
        this.pxBounds.width = (this.cellBounds.width - 1) * 27;
        this.pxBounds.height = this.cellBounds.height * 27 - 11;
    }

    @Override
    public AFbdPin getPinAt(int x, int y) {
        if (this.outPin.bounds.contains(x, y)) {
            return this.outPin;
        }
        return null;
    }

    @Override
    public AFbdPin getPinAt(Rectangle r) {
        if (this.outPin.bounds.intersects(r)) {
            return this.outPin;
        }
        return null;
    }

    @Override
    public void disconnectAll() {
        this.outPin.disconnectTargets();
    }

    static {
        HOVER_COLOR = BODY_COLOR = VariableDef.FLASH_COLOR;
        VALUE_FONT = new Font("Sans", 0, 12);
    }
}

