/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeAction;
import certa.vics.ide.MainFrame;
import certa.vics.ide.fbd.ADynInputsOperation;
import certa.vics.ide.fbd.ADynOutputsOperation;
import certa.vics.ide.fbd.AFbdBlock;
import certa.vics.ide.fbd.AFbdItem;
import certa.vics.ide.fbd.AFbdView;
import certa.vics.ide.fbd.BlockCreateDialog;
import certa.vics.ide.fbd.FbdCommentText;
import certa.vics.ide.fbd.FbdEditor;
import certa.vics.ide.fbd.FbdNumber;
import certa.vics.ide.fbd.FbdVariable;
import certa.vics.ide.fbd.InputsEditDialog;
import certa.vics.ide.fbd.NumberEditDialog;
import certa.vics.ide.fbd.OrderEditDialog;
import certa.vics.ide.fbd.OutputsEditDialog;
import certa.vics.ide.fbd.TextEditDialog;
import certa.vics.ide.fbd.VariableSelectDialog;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class FbdActions
extends ActionsBundle {
    final FbdEditor editor;
    public final Action delete = new Delete(this, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", "delete.png", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b", 0, KeyStroke.getKeyStroke("DELETE"));
    public final Action selectAll = new SelectAll(this, "\u0412\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0441\u0451", null, "\u0412\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435", 0, KeyStroke.getKeyStroke(65, 2));
    public final Action itemHelp = new ItemHelp(this, "\u0421\u043f\u0440\u0430\u0432\u043a\u0430", "item_help.png", "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430", 0, KeyStroke.getKeyStroke("F1"));
    public final EditProps editProps = new EditProps(this, "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430", "props.png", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430", 0, KeyStroke.getKeyStroke("ENTER"));
    public final IdeAction duplicate = new CreateVarCopy(this, "\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "duplicate.png", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u043e\u043f\u0438\u044e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", 0, KeyStroke.getKeyStroke(68, UNI_CTRL_MASK));
    public final ChangeVar changeVar = new ChangeVar(this, "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e", "editor_vars.png", "\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u0443 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e \u043d\u0430 \u0434\u0440\u0443\u0433\u0443\u044e", 0, null);
    public final EditOrder editOrder = new EditOrder(this, "\u041f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440", "order.png", "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0431\u043b\u043e\u043a\u0430", 0, KeyStroke.getKeyStroke("SPACE"));
    public final Action copy = new Copy(this, "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "copy.png", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(67, 2), false);
    public final Action cut = new Copy(this, "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", "cut.png", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(88, 2), true);
    public final Action paste = new Paste(this, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", "paste.png", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", 0, KeyStroke.getKeyStroke(86, 2));
    public final Action moveRight = new Move(this, "\u0412\u043f\u0440\u0430\u0432\u043e", "right.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043f\u0440\u0430\u0432\u043e", 0, KeyStroke.getKeyStroke("control RIGHT"), true, true);
    public final Action moveLeft = new Move(this, "\u0412\u043b\u0435\u0432\u043e", "left.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043b\u0435\u0432\u043e", 0, KeyStroke.getKeyStroke("control LEFT"), true, false);
    public final Action moveDown = new Move(this, "\u0412\u043d\u0438\u0437", "down.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u043d\u0438\u0437", 0, KeyStroke.getKeyStroke("control DOWN"), false, true);
    public final Action moveUp = new Move(this, "\u0412\u0432\u0435\u0440\u0445", "up.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u0432\u0435\u0440\u0445", 0, KeyStroke.getKeyStroke("control UP"), false, false);
    public final Action addNumber = new AddNumber(this, "\u0427\u0438\u0441\u043b\u043e", null, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0447\u0438\u0441\u043b\u043e", 0, KeyStroke.getKeyStroke(78, 0));
    public final Action addVariable = new AddVariable(this, "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f", null, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e", 0, KeyStroke.getKeyStroke(86, 0));
    public final Action addBlock = new AddBlock(this, "\u0411\u043b\u043e\u043a", null, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0431\u043b\u043e\u043a", 0, KeyStroke.getKeyStroke(66, 0));
    public final Action addCommentT = new AddComment(this, "\u0422\u0435\u043a\u0441\u0442", null, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0439 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 0, KeyStroke.getKeyStroke(84, 0), true);
    public final Action addCommentR = new AddComment(this, "\u0420\u0430\u043c\u043a\u0430", null, "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0443\u044e \u0440\u0430\u043c\u043a\u0443", 0, KeyStroke.getKeyStroke(70, 0), false);
    public final Action addPopup = new AddPopup(this, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", "add_item.png", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", 0, null);
    public final EditComment editComment = new EditComment(this, "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c", null, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442", 0, null);
    public final Action connectNum = new ConnectNum(this, "\u0427\u0438\u0441\u043b\u043e", null, "\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0447\u0438\u0441\u043b\u043e", 0, null);
    public final Action connectVar = new ConnectVar(this, "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f", null, "\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e", 0, null);

    public FbdActions(FbdEditor editor) {
        super(editor);
        this.editor = editor;
    }

    public class ConnectVar
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public ConnectVar(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdActions.this.editor.connectVariable();
        }
    }

    public class ConnectNum
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public ConnectNum(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdActions.this.editor.connectNumber();
        }
    }

    public class EditComment
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public EditComment(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        public void perform(Component dlgOwner, int screenX, int screenY) {
            if (FbdActions.this.editor.focusedView instanceof FbdCommentText) {
                FbdCommentText ct = (FbdCommentText)FbdActions.this.editor.focusedView;
                String s = TextEditDialog.showDialog(ct.getText(), dlgOwner, screenX, screenY);
                if (s != null) {
                    ct.setText(s);
                }
                FbdActions.this.editor.commitAction();
            }
        }

        @Override
        public boolean canExec() {
            return FbdActions.this.editor.focusedView instanceof FbdCommentText;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.perform(FbdActions.this.editor.paneScroll, -1, -1);
        }
    }

    public class AddPopup
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        private final JPopupMenu popup;

        public AddPopup(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.popup = new JPopupMenu();
            this.popup.add(FbdActions.this.addNumber);
            this.popup.add(FbdActions.this.addVariable);
            this.popup.add(FbdActions.this.addBlock);
            this.popup.add(FbdActions.this.addCommentT);
            this.popup.add(FbdActions.this.addCommentR);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e != null && e.getSource() instanceof Component) {
                Component c = (Component)e.getSource();
                this.popup.show(c, 0, c.getHeight());
            }
        }
    }

    public class AddComment
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        private final boolean isText;

        public AddComment(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean isText) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.isText = isText;
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int x = -1;
            int y = -1;
            if (e != null && e.getSource() instanceof JMenuItem && ((JMenuItem)e.getSource()).getParent() == FbdActions.this.editor.popupEmpty) {
                x = FbdActions.this.editor.popupX;
                y = FbdActions.this.editor.popupY;
            }
            FbdActions.this.editor.createComment(this.isText, x, y);
        }
    }

    public class AddBlock
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public AddBlock(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdActions.this.editor.createBlock();
        }
    }

    public class AddVariable
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public AddVariable(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdActions.this.editor.createVariable();
        }
    }

    public class AddNumber
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public AddNumber(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdActions.this.editor.createNumber();
        }
    }

    public class Move
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        private final boolean onX;
        private final boolean incr;

        public Move(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean onX, boolean incr) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.onX = onX;
            this.incr = incr;
        }

        @Override
        public boolean canExec() {
            return FbdActions.this.editor.hasSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FbdActions.this.editor.hasSelection()) {
                for (AFbdView view : FbdActions.this.editor.page.selectedList) {
                    if (!(view instanceof AFbdItem) || !(this.onX ? !((AFbdItem)view).pushX(this.incr, true, true) : !((AFbdItem)view).pushY(this.incr, true, true))) continue;
                    return;
                }
                for (AFbdView view : FbdActions.this.editor.page.selectedList) {
                    if (view instanceof AFbdItem) {
                        if (this.onX) {
                            ((AFbdItem)view).pushX(this.incr, true, false);
                            continue;
                        }
                        ((AFbdItem)view).pushY(this.incr, true, false);
                        continue;
                    }
                    if (this.onX) {
                        view.pxBounds.x = view.pxBounds.x + (this.incr ? 1 : -1) * 27;
                        view.pxBounds.x = Math.max(1, view.pxBounds.x);
                    } else {
                        view.pxBounds.y = view.pxBounds.y + (this.incr ? 1 : -1) * 27;
                        view.pxBounds.y = Math.max(1, view.pxBounds.y);
                    }
                    FbdActions.this.editor.markModified();
                }
                FbdActions.this.editor.scrollToFocused();
                FbdActions.this.editor.commitAction();
            }
        }
    }

    public class Paste
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Paste(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdActions.this.editor.pasteFromClipboard();
        }
    }

    public class Copy
    extends IdeAction {
        private static final long serialVersionUID = 1L;
        final boolean cut;

        public Copy(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean cut) {
            super(bundle, text, image, desc, mnemonic, accelerator);
            this.cut = cut;
        }

        @Override
        public boolean canExec() {
            return FbdActions.this.editor.hasSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdActions.this.editor.copyToClipboard(this.cut);
        }
    }

    public class EditOrder
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public EditOrder(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        public void perform(int x, int y) {
            AFbdItem item = FbdActions.this.editor.focusedItem;
            if (item instanceof AFbdBlock) {
                AFbdBlock b = (AFbdBlock)item;
                Point p = new Point(b.pxBounds.x, b.pxBounds.y);
                SwingUtilities.convertPointToScreen(p, FbdActions.this.editor.pane);
                OrderEditDialog.showDialog(b, FbdActions.this.editor.paneScroll, p.x, p.y);
                FbdActions.this.editor.commitAction();
            }
        }

        @Override
        public boolean canExec() {
            return FbdActions.this.editor.focusedItem instanceof AFbdBlock;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.perform(-1, -1);
        }
    }

    public class ChangeVar
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public ChangeVar(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            AFbdItem item = FbdActions.this.editor.focusedItem;
            return item instanceof FbdVariable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFbdItem item = FbdActions.this.editor.focusedItem;
            if (item == null) {
                return;
            }
            Point p = new Point(item.pxBounds.x, item.pxBounds.y);
            SwingUtilities.convertPointToScreen(p, FbdActions.this.editor.pane);
            if (item instanceof FbdVariable) {
                VariableSelectDialog.showDialog((FbdVariable)item, 0, FbdActions.this.editor.paneScroll, p.x, p.y);
                FbdActions.this.editor.commitAction();
            }
        }
    }

    public class CreateVarCopy
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public CreateVarCopy(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            AFbdItem item = FbdActions.this.editor.focusedItem;
            return item instanceof FbdVariable && !((FbdVariable)item).getVariable().varDef.isSystem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariableRef vr;
            AFbdItem item = FbdActions.this.editor.focusedItem;
            if (item == null) {
                return;
            }
            if (item instanceof FbdVariable && (vr = ((FbdVariable)item).getVariable()) != null) {
                VariablesEditor ved = MainFrame.instance.getVarsEditor();
                VariableDef newVar = ved.duplicateVariable(vr.varDef);
                if (newVar != null) {
                    FbdActions.this.editor.createVariable(newVar);
                } else {
                    FbdActions.this.editor.focusView(item);
                }
            }
        }
    }

    public class EditProps
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public EditProps(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        public void perform(Component dlgOwner, int screenX, int screenY) {
            VariableRef vr;
            AFbdItem item = FbdActions.this.editor.focusedItem;
            if (item == null) {
                return;
            }
            Point p = new Point(item.pxBounds.x, item.pxBounds.y);
            SwingUtilities.convertPointToScreen(p, FbdActions.this.editor.pane);
            if (item instanceof ADynInputsOperation) {
                InputsEditDialog.showDialog((ADynInputsOperation)item, dlgOwner, p.x, p.y);
                FbdActions.this.editor.commitAction();
            } else if (item instanceof ADynOutputsOperation) {
                OutputsEditDialog.showDialog((ADynOutputsOperation)item, dlgOwner, p.x, p.y);
                FbdActions.this.editor.commitAction();
            } else if (item instanceof FbdNumber) {
                NumberEditDialog.showDialog((FbdNumber)item, dlgOwner, p.x, p.y);
                FbdActions.this.editor.commitAction();
            } else if (item instanceof FbdVariable && (vr = ((FbdVariable)item).getVariable()) != null) {
                MainFrame.instance.getVarsEditor().selectAndEditVar(vr.varDef);
            }
        }

        @Override
        public boolean canExec() {
            AFbdItem item = FbdActions.this.editor.focusedItem;
            return item instanceof ADynInputsOperation || item instanceof ADynOutputsOperation || item instanceof FbdNumber || item instanceof FbdVariable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.perform(FbdActions.this.editor.paneScroll, -1, -1);
        }
    }

    public class UndoRedo
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public UndoRedo(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator, boolean redo) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class ItemHelp
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public ItemHelp(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return FbdActions.this.editor.focusedItem instanceof AFbdBlock || FbdActions.this.editor.focusedItem instanceof FbdVariable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FbdActions.this.editor.focusedItem instanceof AFbdBlock) {
                AFbdBlock b = (AFbdBlock)FbdActions.this.editor.focusedItem;
                BlockCreateDialog.showHelpDialog(b.getClass(), FbdActions.this.editor.paneScroll);
            } else if (FbdActions.this.editor.focusedItem instanceof FbdVariable) {
                MainFrame.instance.actions.varsHelp.actionPerformed(null);
            }
        }
    }

    public class SelectAll
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public SelectAll(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdActions.this.editor.selectAll();
        }
    }

    public class Delete
    extends IdeAction {
        private static final long serialVersionUID = 1L;

        public Delete(ActionsBundle bundle, String text, String image, String desc, int mnemonic, KeyStroke accelerator) {
            super(bundle, text, image, desc, mnemonic, accelerator);
        }

        @Override
        public boolean canExec() {
            return FbdActions.this.editor.hasSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FbdActions.this.editor.deleteSelected();
            FbdActions.this.editor.commitAction();
        }
    }
}

