/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.AlphanumComparator;
import certa.vics.compiler.CompilerError;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VariablesBlock {
    public final String name;
    public final String memType;
    public final boolean readOnly;
    public int startAddress;
    public final Map<String, Variable> map = new LinkedHashMap<String, Variable>();
    private Variable lastVar;
    public static final int MAX_ARCHIVED_ALARMS = 255;

    public VariablesBlock(String name, String memType, boolean readOnly) {
        this.name = name;
        this.memType = memType;
        this.readOnly = readOnly;
    }

    public void clear() {
        this.map.clear();
        this.lastVar = null;
    }

    protected void registerVariable(Variable var) throws SyntaxError {
        String key = var.name.toUpperCase();
        if (this.map.containsKey(key)) {
            throw new SyntaxError("Duplicate variable \"" + var.name + "\" in \"" + this.name + "\"");
        }
        this.map.put(key, var);
        this.lastVar = var;
    }

    public List<Variable> reallocAlarms() throws CompilerError {
        ArrayList<Variable> alarms1 = new ArrayList<Variable>();
        ArrayList<Variable> alarms2 = new ArrayList<Variable>();
        ArrayList<Variable> vars = new ArrayList<Variable>();
        for (Variable v : this.map.values()) {
            if (v.alarm) {
                if (v.archived) {
                    alarms1.add(v);
                    continue;
                }
                alarms2.add(v);
                continue;
            }
            vars.add(v);
        }
        if (alarms1.size() > 255) {
            throw new CompilerError("Too much archived alarms (" + alarms1.size() + "). Maximum is " + 255);
        }
        Collections.sort(alarms1, new AlphanumComparator());
        Collections.sort(alarms2, new AlphanumComparator());
        int offset = 0;
        for (Variable v : alarms1) {
            v.offset = offset;
            offset += v.getSize();
            this.lastVar = v;
        }
        for (Variable v : alarms2) {
            v.offset = offset;
            offset += v.getSize();
            this.lastVar = v;
        }
        for (Variable v : vars) {
            v.offset = offset;
            offset += v.getSize();
            this.lastVar = v;
        }
        alarms1.addAll(alarms2);
        return alarms1;
    }

    public Variable createDeviceVar(String name, int type, int offset) throws SyntaxError {
        return new Variable(false, name, type, false, false, offset, this, null, 0, 0, null);
    }

    public Variable createSimpleVar(String name, int type, boolean alarm, boolean archived, boolean hidden) throws SyntaxError {
        return new Variable(hidden, name, type, alarm, archived, this.getSize(), this, null, 0, 0, null);
    }

    public Variable createArrayVar(String name, int type, int arraySize, VariablesBlock constBlock) throws SyntaxError {
        return new Variable(false, name, type, false, false, this.getSize(), this, null, 0, arraySize, constBlock);
    }

    public Variable createArrayItemVar(Variable arrayStart, int index) throws SyntaxError {
        return new Variable(true, arrayStart.arrayName + "[" + index + "]", arrayStart.type, false, false, this.getSize(), this, arrayStart, index, 0, null);
    }

    public Variable locateVar(String name, int type) {
        Variable var;
        int p = name.indexOf(".size");
        if (p > 0) {
            name = name.substring(0, p) + "[0]";
        }
        if ((var = this.map.get(name.toUpperCase())) != null && var.type == type) {
            if (p > 0) {
                return var.arraySizeVar;
            }
            return var;
        }
        return null;
    }

    public int getSize() {
        if (this.lastVar != null) {
            return this.lastVar.offset + this.lastVar.getSize();
        }
        return 0;
    }

    public String toString() {
        return this.memType;
    }
}

