/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Schedule {
    public static final int EVENTS_COUNT = 12;
    public final int number;
    public int digits = 0;
    public double min = 0.0;
    public double max = 0.0;
    public boolean strict = false;
    public Variable var = null;
    public Variable enabled = null;
    public int[][] times = new int[7][0];
    public double[][] values = new double[7][0];
    private String varStr = null;
    private String enabledStr = null;
    public static String PAR_STRICT = "strict";
    public static String PAR_VAR = "var";
    public static String PAR_ENABLED_VAR = "enable";
    public static String PAR_DIGITS = "digits";
    public static String PAR_MIN = "min";
    public static String PAR_MAX = "max";
    public static String PAR_DAY = "day";

    public Schedule(int number) {
        this.number = number;
    }

    public void resolve(Program prg) throws SyntaxError {
        if (this.var == null && !Utils.strEmpty(this.varStr)) {
            this.var = prg.locateVar(this.varStr);
        }
        if (this.enabled == null && !Utils.strEmpty(this.enabledStr)) {
            this.enabled = prg.locateVar(this.enabledStr);
        }
        if (this.enabled != null && this.enabled.type != 1) {
            throw new SyntaxError("Variable must be boolean (" + this.enabled.fullName() + ")");
        }
        this.varStr = null;
        this.enabledStr = null;
        this.validate();
    }

    private int decodeDigits(String s) throws SyntaxError {
        int d = Program.decodeInt(s, "Invalid number");
        if (d < 0 || d > 3) {
            throw new SyntaxError("Invalid digits count: " + d + ". Must be 0, 1, 2, 3");
        }
        return d;
    }

    private void decodeArray(String s, int dayIndex) throws SyntaxError {
        int i;
        if (dayIndex < 0 || dayIndex > 6) {
            throw new SyntaxError("Invalid day index");
        }
        if (Utils.strEmpty(s)) {
            this.times[dayIndex] = new int[0];
            this.values[dayIndex] = new double[0];
            return;
        }
        int[] tmp1 = new int[12];
        double[] tmp2 = new double[12];
        StringTokenizer st = new StringTokenizer(s, ";");
        for (i = 0; st.hasMoreTokens() && i < tmp1.length; ++i) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken(), ":");
            if (st2.countTokens() != 2) {
                throw new SyntaxError("Invalid day string: '" + s + "'");
            }
            String ts = st2.nextToken();
            try {
                tmp1[i] = Integer.parseInt(ts, 10);
                ts = st2.nextToken();
                tmp2[i] = Double.parseDouble(ts);
                continue;
            }
            catch (NumberFormatException e) {
                throw new SyntaxError("Invalid number: \"" + ts + "\"");
            }
        }
        this.times[dayIndex] = Arrays.copyOfRange(tmp1, 0, i);
        this.values[dayIndex] = Arrays.copyOfRange(tmp2, 0, i);
    }

    public String encodeArray(int dayIndex) {
        if (this.times[dayIndex].length < 1) {
            return null;
        }
        int[] t = this.times[dayIndex];
        double[] v = this.values[dayIndex];
        String res = Integer.toString(t[0]) + ":" + Double.toString(v[0]);
        for (int i = 1; i < t.length; ++i) {
            res = res + ";" + Integer.toString(t[i]) + ":" + Double.toString(v[i]);
        }
        return res;
    }

    public void setParam(String paramName, String value, Program prg) throws SyntaxError {
        try {
            if (paramName.equalsIgnoreCase(PAR_STRICT)) {
                this.strict = Integer.decode(value) != 0;
            } else if (paramName.equalsIgnoreCase(PAR_VAR)) {
                this.varStr = value.equals("0") ? null : value;
            } else if (paramName.equalsIgnoreCase(PAR_ENABLED_VAR)) {
                this.enabledStr = value.equals("0") ? null : value;
            } else if (paramName.equalsIgnoreCase(PAR_DIGITS)) {
                this.digits = this.decodeDigits(value);
            } else if (paramName.equalsIgnoreCase(PAR_MIN)) {
                this.min = Double.parseDouble(value);
            } else if (paramName.equalsIgnoreCase(PAR_MAX)) {
                this.max = Double.parseDouble(value);
            } else if (paramName.toLowerCase().startsWith(PAR_DAY)) {
                this.decodeArray(value, Utils.StringToIntDef(paramName.substring(3, 4), 0) - 1);
            }
        }
        catch (NumberFormatException e) {
            throw new SyntaxError("Invalid number: " + value);
        }
    }

    public void validate() throws SyntaxError {
    }
}

