/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.AlphanumComparator;
import certa.vics.compiler.Variable;
import java.util.TreeSet;

public class MenuVariables {
    public final TreeSet<Variable> boolVars1 = new TreeSet<Object>(new AlphanumComparator());
    public final TreeSet<Variable> boolVars2 = new TreeSet<Object>(new AlphanumComparator());
    public final TreeSet<Variable> intVars = new TreeSet<Object>(new AlphanumComparator());
    public final TreeSet<Variable> floatVars = new TreeSet<Object>(new AlphanumComparator());

    public void clear() {
        this.boolVars1.clear();
        this.boolVars2.clear();
        this.intVars.clear();
        this.floatVars.clear();
    }

    public void addVar(Variable var, boolean forVisible) {
        if (var.type == 1) {
            if (forVisible) {
                this.boolVars1.add(var);
            } else {
                this.boolVars2.add(var);
            }
        } else if (var.type == 2) {
            this.intVars.add(var);
        } else if (var.type == 3) {
            this.floatVars.add(var);
        }
    }

    public void optimizeVars() {
        this.boolVars2.removeAll(this.boolVars1);
    }

    public int getVarRegNumber(Variable var) {
        if (var.type == 1) {
            if (this.boolVars1.contains(var)) {
                return 10000 + this.boolVars1.headSet(var).size();
            }
            if (this.boolVars2.contains(var)) {
                return 10000 + this.boolVars1.size() + this.boolVars2.headSet(var).size();
            }
            return 0;
        }
        if (var.type == 2) {
            return this.intVars.contains(var) ? 10000 + this.intVars.headSet(var).size() : 0;
        }
        if (var.type == 3) {
            return this.floatVars.contains(var) ? 20000 + 2 * this.floatVars.headSet(var).size() : 0;
        }
        return 0;
    }

    public int getVisibilityVarIndex(Variable var) {
        if (var != null && var.type == 1 && this.boolVars1.contains(var)) {
            return this.boolVars1.headSet(var).size();
        }
        return 255;
    }
}

