/*
 * Decompiled with CFR 0.152.
 */
package certa.model;

import java.util.Arrays;

public class ModelPID {
    static final double Kp = 5.0;
    static final double Ti = 80.0;
    static final double Td = 0.0;
    static final double DB = 0.0;
    static final double object_K = 0.1;
    static final double object_T = 120.0;
    static final int object_tau = 1000;
    static final int TIME_SPAN = 500000;
    static final int LOG_PERIOD = 1000;
    static final int PID_PERIOD = 100;
    static int time_cs = 0;
    static int time_s = 0;
    static double valve_pos = 0.0;
    static double object_out = 0.0;
    static double setpoint = 5.0;
    static double e1 = 0.0;
    static double PV1 = 0.0;
    static double D1 = 0.0;
    static double u1 = 0.0;
    static int prevTime = 0;
    static boolean haveD1;
    static final DelayBuffer delayed_obj_in;

    static void controller() {
        int timer = time_cs;
        int t100 = timer - prevTime;
        if (t100 >= 100) {
            double dt = (double)t100 / 100.0;
            double e = setpoint - object_out;
            double dP = e - e1;
            double dI = e1 * dt / 80.0;
            double D = -(object_out - PV1) / dt;
            double dD = haveD1 ? (D - D1) * 0.0 : 0.0;
            valve_pos = e < -0.0 || e > 0.0 ? u1 + 5.0 * (dP + dI + dD) : u1;
            if (valve_pos < 0.0) {
                valve_pos = 0.0;
            }
            if (valve_pos > 100.0) {
                valve_pos = 100.0;
            }
            e1 = e;
            PV1 = object_out;
            D1 = D;
            haveD1 = true;
            u1 = valve_pos;
            prevTime = timer;
        } else {
            valve_pos = u1;
        }
    }

    static void object() {
        double dt = 0.01;
        object_out = (0.1 * delayed_obj_in.get() * dt + 120.0 * object_out) / (120.0 + dt);
        delayed_obj_in.put(valve_pos);
        if (time_cs == 200000) {
            object_out += 2.0;
        }
    }

    public static void main(String[] args) {
        for (time_cs = 0; time_cs <= 500000; ++time_cs) {
            if (time_cs > 0 && time_cs % 100 == 0) {
                ++time_s;
            }
            ModelPID.object();
            ModelPID.controller();
            if (time_cs % 1000 != 0) continue;
            System.out.println(time_s + " " + valve_pos + " " + object_out);
        }
    }

    static {
        delayed_obj_in = new DelayBuffer(1000);
    }

    static class DelayBuffer {
        final double[] data;
        int ptr = 0;

        DelayBuffer(int size) {
            this.data = new double[size];
            Arrays.fill(this.data, 0.0);
        }

        void put(double value) {
            this.data[this.ptr] = value;
            this.ptr = (this.ptr + 1) % this.data.length;
        }

        double get() {
            return this.data[this.ptr];
        }
    }
}

