/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.server;

import certa.modbus.ModbusPdu;
import certa.modbus.server.AModbusServer;
import certa.modbus.server.ModbusTcpServer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

class ModbusTcpServerConnection
extends ModbusPdu
implements Runnable,
Closeable {
    private AtomicBoolean active = new AtomicBoolean(true);
    private final Thread thread;
    private final Socket socket;
    private final AModbusServer server;
    private final byte[] buffer = new byte[260];

    public ModbusTcpServerConnection(AModbusServer server, Socket socket) {
        this.server = server;
        this.socket = socket;
        this.thread = new Thread(null, this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void close() {
        if (this.active.getAndSet(false)) {
            this.server.log.debug("Closing connection");
            this.thread.interrupt();
            this.closeSocket();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.server.log.error("EXCEPTION in ModbusTcpServerConnection.close()", e);
        }
    }

    private boolean waitRequest() throws IOException {
        InputStream in = this.socket.getInputStream();
        int res = in.read(this.buffer, 0, 6);
        if (res < 0) {
            this.server.log.trace("End of Stream");
            this.close();
            return false;
        }
        if (res < 6) {
            this.server.logData("Read (incomplete MBAP): ", this.buffer, 0, res);
            this.server.log.warn("Error reading MBAP header");
            this.close();
            return false;
        }
        int len = ModbusTcpServerConnection.bytesToInt16(this.buffer[5], this.buffer[4], true);
        if (len < 2 || len > this.buffer.length - 6) {
            this.server.logData("Read (invalid length): ", this.buffer, 0, res);
            this.server.log.warn("Invalid data length: {}", (Object)len);
            this.close();
            return false;
        }
        res = in.read(this.buffer, 6, len);
        if (res < len) {
            this.server.logData("Read (incomplete PDU): ", this.buffer, 0, res + 6);
            this.server.log.warn("Error reading PDU");
            this.close();
            return false;
        }
        this.server.logData("Read (complete): ", this.buffer, 0, len + 6);
        this.pduSize = len - 1;
        System.arraycopy(this.buffer, 7, this.pdu, 0, this.pduSize);
        return true;
    }

    private void sendResponse() throws IOException {
        if (this.pduSize == 0) {
            return;
        }
        this.buffer[4] = ModbusTcpServerConnection.highByte(this.pduSize + 1);
        this.buffer[5] = ModbusTcpServerConnection.lowByte(this.pduSize + 1);
        System.arraycopy(this.pdu, 0, this.buffer, 7, this.pduSize);
        int size = this.pduSize + 7;
        this.server.logData("Write: ", this.buffer, 0, size);
        this.socket.getOutputStream().write(this.buffer, 0, size);
    }

    @Override
    public void run() {
        this.server.log.debug("CONNECTION THREAD START");
        this.server.log.info("Client connected: {}", (Object)this.socket.getRemoteSocketAddress());
        try {
            try {
                while (this.active.get() && !Thread.currentThread().isInterrupted()) {
                    if (this.waitRequest()) {
                        if (!this.server.processor.processRequest(this)) continue;
                        this.sendResponse();
                        continue;
                    }
                    Thread.sleep(1000L);
                }
            }
            finally {
                this.active.set(false);
                this.closeSocket();
            }
        }
        catch (SocketTimeoutException toe) {
            this.server.log.debug("Client timeout");
        }
        catch (InterruptedException toe) {
        }
        catch (Throwable t) {
            this.server.log.error("CONNECTION THREAD TERMINATED ", t);
        }
        ((ModbusTcpServer)this.server).unregisterConnection(this);
        this.server.log.debug("CONNECTION THREAD END");
        this.server.log.info("Client disconnected: {}", (Object)this.socket.getRemoteSocketAddress());
    }
}

