/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.ModbusClient;
import certa.modbus.client.ModbusClientTransport;
import org.slf4j.Logger;

public abstract class AbstractTcpTransport
implements ModbusClientTransport {
    protected final Logger log;
    protected int timeout;
    protected final int pause;
    protected final boolean keepConnection;
    protected int transactionId = 0;
    protected final byte[] buffer = new byte[260];
    protected int expectedBytes;

    public AbstractTcpTransport(int timeout, int pause, boolean keepConnection, Logger log) {
        this.log = log;
        this.timeout = timeout;
        this.pause = pause;
        this.keepConnection = keepConnection;
    }

    protected abstract void openPort() throws Exception;

    protected abstract void clearInput() throws Exception;

    protected abstract void sendData(int var1) throws Exception;

    protected abstract boolean readToBuffer(int var1, int var2, ModbusClient var3) throws Exception;

    @Override
    public void sendRequest(ModbusClient modbusClient) throws Exception {
        if (this.pause > 0) {
            Thread.sleep(this.pause);
        }
        this.openPort();
        this.clearInput();
        ++this.transactionId;
        if (this.transactionId > 65535) {
            this.transactionId = 1;
        }
        this.buffer[0] = ModbusPdu.highByte(this.transactionId);
        this.buffer[1] = ModbusPdu.lowByte(this.transactionId);
        this.buffer[2] = 0;
        this.buffer[3] = 0;
        int size = modbusClient.getPduSize() + 1;
        this.buffer[4] = ModbusPdu.highByte(size);
        this.buffer[5] = ModbusPdu.lowByte(size);
        this.buffer[6] = modbusClient.getServerId();
        modbusClient.readFromPdu(0, modbusClient.getPduSize(), this.buffer, 7);
        size = modbusClient.getPduSize() + 7;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Write: " + ModbusPdu.toHex(this.buffer, 0, size));
        }
        this.sendData(size);
    }

    protected void logData(String kind, int start, int length) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Read ({}): {}", (Object)kind, (Object)ModbusPdu.toHex(this.buffer, start, length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitResponse(ModbusClient modbusClient) throws Exception {
        this.openPort();
        boolean disconnect = !this.keepConnection;
        try {
            this.expectedBytes = modbusClient.getExpectedPduSize() + 7;
            if (!this.readToBuffer(0, 8, modbusClient)) {
                disconnect = true;
                int n = 1;
                return n;
            }
            int tid = ModbusPdu.bytesToInt16(this.buffer[1], this.buffer[0], true);
            if (tid != this.transactionId) {
                this.logData("bad transaction", 0, 8);
                this.log.warn("waitResponse(): Invalid transaction id: {} (expected: {})", (Object)tid, (Object)this.transactionId);
                disconnect = true;
                int n = 3;
                return n;
            }
            if (this.buffer[6] != modbusClient.getServerId()) {
                this.logData("bad id", 0, 8);
                this.log.warn("waitResponse(): Invalid server id: {} (expected: {})", (Object)this.buffer[6], (Object)modbusClient.getServerId());
                int n = 3;
                return n;
            }
            if ((this.buffer[7] & 0x7F) != modbusClient.getFunction()) {
                this.logData("bad function", 0, 8);
                this.log.warn("waitResponse(): Invalid function: {} (expected: {})", (Object)this.buffer[7], (Object)modbusClient.getFunction());
                int n = 3;
                return n;
            }
            if ((this.buffer[7] & 0x80) != 0) {
                this.expectedBytes = 9;
                if (!this.readToBuffer(8, 1, modbusClient)) {
                    int n = 1;
                    return n;
                }
                this.logData("exception", 0, this.expectedBytes);
                modbusClient.setPduSize(2);
                modbusClient.writeToPdu(this.buffer, 7, 2, 0);
                int n = 2;
                return n;
            }
            int size = modbusClient.getExpectedPduSize();
            if (!this.readToBuffer(8, size - 1, modbusClient)) {
                int n = 1;
                return n;
            }
            this.logData("normal", 0, this.expectedBytes);
            modbusClient.setPduSize(size);
            modbusClient.writeToPdu(this.buffer, 7, size, 0);
            int n = 0;
            return n;
        }
        finally {
            if (disconnect) {
                this.close();
            }
        }
    }
}

