/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.variables;

import certa.vics.Utils;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class VarsMapDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static VarsMapDialog dialog;
    boolean okPressed;
    JButton btnOk;
    VarsTableModel model;
    JTable table;
    JComboBox<DestVarInfo> cmbxVarlist;
    ArrayList<VariablesEditor.NewVarInfo> srcVars;
    ArrayList<DestVarInfo> destVars;
    final DestVarInfo DST_IGNORE = new DestVarInfo("\u043d\u0435 \u0432\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c", null);
    final DestVarInfo DST_CREATE = new DestVarInfo("\u0441\u043e\u0437\u0434\u0430\u0442\u044c", null);
    static final String STR_PREFIX = "\u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430  ";
    HashMap<String, DestVarInfo> destVarCache = new HashMap();

    public static boolean showDialog(String title, ArrayList<VariablesEditor.NewVarInfo> varList, Map<String, String> resultMap) {
        dialog = new VarsMapDialog(MainFrame.instance, title, varList);
        dialog.setLocationRelativeTo(dialog.getParent());
        VarsMapDialog.dialog.btnOk.requestFocusInWindow();
        VarsMapDialog.dialog.okPressed = false;
        dialog.setVisible(true);
        if (VarsMapDialog.dialog.okPressed) {
            dialog.makeMap(resultMap);
            dialog = null;
            return true;
        }
        dialog = null;
        return false;
    }

    private VarsMapDialog(JFrame parent, String title, ArrayList<VariablesEditor.NewVarInfo> vars) {
        super(parent, title);
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.okPressed = true;
                dialog.setVisible(false);
            }
        };
        this.srcVars = vars;
        this.destVars = new ArrayList(this.srcVars.size());
        for (int i = 0; i < this.srcVars.size(); ++i) {
            this.destVars.add(this.DST_CREATE);
        }
        this.model = new VarsTableModel();
        this.table = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                VariablesEditor.NewVarInfo vi = VarsMapDialog.this.srcVars.get(this.convertRowIndexToModel(row));
                VarsMapDialog.this.updateVarList(vi.parsedName.type, vi);
                return super.prepareEditor(editor, row, column);
            }
        };
        this.cmbxVarlist = new JComboBox();
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnl = new JPanel(new BorderLayout());
        pane.add((Component)pnl, "grow,wrap");
        JScrollPane scroll = new JScrollPane(this.table);
        pnl.add((Component)scroll, "Center");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.setupTable();
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.setMinimumSize(new Dimension(320, 200));
        this.pack();
        this.setResizable(true);
    }

    private DestVarInfo allocDestVarInfo(String title, String varName) {
        DestVarInfo dvi = this.destVarCache.get(title);
        if (dvi == null) {
            dvi = new DestVarInfo(title, varName);
            this.destVarCache.put(title, dvi);
        }
        return dvi;
    }

    public void updateVarList(int type, VariablesEditor.NewVarInfo var) {
        VariablesEditor ved = MainFrame.instance.getVarsEditor();
        ArrayList<VariableRef> varList = ved.getAllVariables(true, type);
        Vector<DestVarInfo> lst = new Vector<DestVarInfo>(varList.size() + 2);
        lst.add(this.DST_CREATE);
        lst.add(this.DST_IGNORE);
        for (VariableRef vr : varList) {
            if (var.written && !vr.isWritable() || var.writtenInFbd && !vr.isWritableInFbd() || var.arraySize > 0 && vr.arraySize() != var.arraySize) continue;
            if (var.arraySize > 0) {
                lst.add(this.allocDestVarInfo(STR_PREFIX + vr.varDef.getName(), vr.varDef.getFullName()));
                continue;
            }
            lst.add(this.allocDestVarInfo(STR_PREFIX + vr.shortName(), vr.fullName()));
        }
        varList.add(0, null);
        this.cmbxVarlist.setModel(new DefaultComboBoxModel(lst));
    }

    void makeMap(Map<String, String> map) {
        map.clear();
        for (int i = 0; i < this.srcVars.size(); ++i) {
            VariablesEditor.NewVarInfo vi = this.srcVars.get(i);
            DestVarInfo dst = this.destVars.get(i);
            if (dst == this.DST_IGNORE) continue;
            if (dst == this.DST_CREATE) {
                map.put(vi.fullName, vi.fullName);
                continue;
            }
            map.put(vi.fullName, dst.varName);
        }
    }

    private void setupTable() {
        this.table.setTableHeader(null);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setAutoCreateRowSorter(false);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(4);
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(false);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String cm = ((VariablesEditor.NewVarInfo)value).comment;
                c.setToolTipText(Utils.strEmpty(cm) ? null : "<html>" + cm + "</html>");
                return c;
            }
        });
        cm.getColumn(1).setCellEditor(new DefaultCellEditor(this.cmbxVarlist));
        int height = this.table.getRowHeight();
        this.table.setRowHeight(height + 6);
    }

    class VarsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        VarsTableModel() {
        }

        @Override
        public int getRowCount() {
            return VarsMapDialog.this.srcVars.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0432 \u0431\u0443\u0444\u0435\u0440\u0435";
            }
            return "\u0421\u0432\u044f\u0437\u0430\u0442\u044c \u0441";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return VariablesEditor.NewVarInfo.class;
            }
            return DestVarInfo.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1 && aValue instanceof DestVarInfo) {
                VarsMapDialog.this.destVars.set(rowIndex, (DestVarInfo)aValue);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return VarsMapDialog.this.srcVars.get(rowIndex);
            }
            if (columnIndex == 1) {
                return VarsMapDialog.this.destVars.get(rowIndex);
            }
            return null;
        }
    }

    class DestVarInfo {
        final String title;
        final String varName;

        DestVarInfo(String title, String varName) {
            this.title = title;
            this.varName = varName;
        }

        public String toString() {
            return this.title;
        }
    }
}

