/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.Utils;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.ClipboardUtils;
import certa.vics.ide.DialogErrorLabel;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.IdeTableCellRenderer;
import certa.vics.ide.IdeTableHeaderRender;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.AMenuItemView;
import certa.vics.ide.ui.MenuItemMenuView;
import certa.vics.ide.ui.MenuItemVariableView;
import certa.vics.ide.ui.UiActions;
import certa.vics.ide.ui.UiStringsTableModel;
import certa.vics.ide.ui.UiTreeDataModel;
import certa.vics.ide.ui.VariableCreateDialog;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UiEditor
extends IdeEditor
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    static final String CARD_EMPTY = "empty";
    static final String CARD_ITEM = "item";
    static final String[] ACCESS = new String[]{"\u0411\u0435\u0437 \u043f\u0430\u0440\u043e\u043b\u044f", "User", "Service", "Developer"};
    static final String[] FLOAT_FORMATS = new String[]{"\u0426\u0435\u043b\u044b\u0435 (\u0448\u0430\u0433 1)", "\u0414\u0435\u0441\u044f\u0442\u044b\u0435 (\u0448\u0430\u0433 0.1)", "\u0421\u043e\u0442\u044b\u0435 (\u0448\u0430\u0433 0.01)", "\u0422\u044b\u0441\u044f\u0447\u043d\u044b\u0435 (\u0448\u0430\u0433 0.001)"};
    private static String[] INT_FORMATS = new String[]{"\u0427\u0438\u0441\u043b\u043e", "\u0422\u0435\u043a\u0441\u0442"};
    JPopupMenu popupMenu;
    UiActions actions;
    final MainFrame mainFrame;
    MenuItemMenuView mainMenu;
    UiTreeDataModel treeModel;
    private JTree tree;
    AMenuItemView focusedItem;
    MenuItemVariableView focusedVarItem;
    JPanel pnlParamsCards;
    JPanel pnlEmptyParams;
    JPanel pnlItemParams;
    JLabel lblItemType;
    JTextField tfName;
    JComboBox<String> cbxAccess;
    JPanel pnlVarParams;
    JComboBox<VariableRef> cbxVar;
    JLabel lblVarType;
    JCheckBox chkVarEditable;
    JComboBox<String> cbxVarIntFmt;
    JComboBox<String> cbxVarFloatFmt;
    JPanel pnlVarMinMax;
    JTextField tfVarMin;
    JTextField tfVarMax;
    JLabel lblVarMinError;
    JLabel lblVarMaxError;
    JPanel pnlVarStrings;
    JComboBox<String> cbxStringsCount;
    JTable tblStrings;
    UiStringsTableModel stringsModel = new UiStringsTableModel(this);
    boolean inUpdate;
    private static final String JSON_MENU_ITEMS = "menuItems";

    public UiEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u043c\u0435\u043d\u044e", false);
        this.setBackground(Color.WHITE);
        this.mainFrame = mainFrame;
        this.treeModel = new UiTreeDataModel();
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.addTreeSelectionListener(this);
        this.tree.setLargeModel(true);
        this.tree.setComponentPopupMenu(this.popupMenu);
        IdeUtils.bindActions(this.tree, this.actions);
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public int getSourceActions(JComponent c) {
                return 3;
            }

            @Override
            public Transferable createTransferable(JComponent c) {
                if (UiEditor.this.focusedItem == null) {
                    return null;
                }
                return new AddingItem(UiEditor.this.focusedItem);
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport info) {
                return info.isDrop() && info.isDataFlavorSupported(AddingItem.FLAVOR);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport info) {
                if (info.isDrop() && info.isDataFlavorSupported(AddingItem.FLAVOR)) {
                    TreePath path = ((JTree.DropLocation)info.getDropLocation()).getPath();
                    Transferable t = info.getTransferable();
                    try {
                        AMenuItemView newItem = (AMenuItemView)t.getTransferData(AddingItem.FLAVOR);
                        MenuItemMenuView menu = newItem.getParent();
                        if (menu != null && menu.deleteChild(newItem)) {
                            UiEditor.this.treeModel.fireStructureChanged(menu);
                        }
                        AMenuItemView target = path != null ? (AMenuItemView)path.getLastPathComponent() : null;
                        menu = UiEditor.this.mainMenu;
                        if (target != null) {
                            menu = target instanceof MenuItemMenuView ? (MenuItemMenuView)target : target.getParent();
                        }
                        ArrayList<AMenuItemView> items = menu.getItems();
                        int i = -1;
                        if (target != null) {
                            i = items.indexOf(target);
                        }
                        if (i >= 0) {
                            items.add(i + 1, newItem);
                        } else {
                            items.add(newItem);
                        }
                        newItem.setParent(menu);
                        UiEditor.this.treeModel.fireStructureChanged(menu);
                        UiEditor.this.focusItem(newItem);
                    }
                    catch (Exception e) {
                        Utils.ProcessException(e, false);
                        return false;
                    }
                }
                return true;
            }
        });
        this.pnlEmptyParams = new JPanel(new GridBagLayout());
        JLabel lbl = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043b\u0438 \u0441\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043c\u0435\u043d\u044e");
        lbl.setToolTipText("\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0443 \"\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u043e\u0434\u043c\u0435\u043d\u044e\" \u0438\u043b\u0438 \"\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e\" \u043d\u0430 \u043f\u0430\u043d\u0435\u043b\u0438 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        this.pnlEmptyParams.add(lbl);
        this.lblItemType = new JLabel("<>");
        this.lblItemType.setFont(this.lblItemType.getFont().deriveFont(1));
        this.tfName = new JTextField(25);
        this.cbxAccess = new JComboBox<String>(new DefaultComboBoxModel<String>(ACCESS));
        this.cbxVar = new JComboBox();
        this.cbxVar.setMaximumRowCount(20);
        this.lblVarType = new JLabel("<>");
        this.chkVarEditable = new JCheckBox("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
        this.cbxVarFloatFmt = new JComboBox<String>(new DefaultComboBoxModel<String>(FLOAT_FORMATS));
        this.cbxVarIntFmt = new JComboBox<String>(new DefaultComboBoxModel<String>(INT_FORMATS));
        this.tfVarMin = new JTextField(10);
        this.tfVarMax = new JTextField(10);
        this.lblVarMinError = new DialogErrorLabel("MinError");
        this.lblVarMaxError = new DialogErrorLabel("MaxError");
        this.cbxStringsCount = new JComboBox();
        for (int i = 1; i <= 30; ++i) {
            this.cbxStringsCount.addItem(Integer.toString(i));
        }
        this.tblStrings = new JTable(this.stringsModel);
        this.tblStrings.setFillsViewportHeight(true);
        this.tblStrings.getTableHeader().setReorderingAllowed(false);
        this.tblStrings.setSelectionMode(0);
        this.tblStrings.getTableHeader().setDefaultRenderer(new IdeTableHeaderRender());
        this.tblStrings.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.tblStrings.getColumnModel().getColumn(0).setCellRenderer(new IdeTableCellRenderer(4, 8));
        this.tblStrings.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.tblStrings.getColumnModel().getColumn(1).setCellRenderer(new IdeTableCellRenderer(2, 8));
        this.pnlVarParams = new JPanel(new MigLayout("insets 0, fill", "[80][grow]", "[][][][][grow]"));
        this.pnlVarParams.add((Component)new JLabel("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f:"), "al right");
        this.pnlVarParams.add(this.cbxVar, "spanx");
        this.pnlVarParams.add((Component)this.lblVarType, "newline, skip 1, spanx");
        this.pnlVarParams.add((Component)this.chkVarEditable, "newline, skip 1, spanx");
        this.pnlVarParams.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442:"), "newline, al right");
        this.pnlVarParams.add(this.cbxVarFloatFmt, "hidemode 3, spanx");
        this.pnlVarParams.add(this.cbxVarIntFmt, "hidemode 3");
        this.pnlVarMinMax = new JPanel(new MigLayout("insets 0", "[80]", ""));
        this.pnlVarMinMax.add((Component)new JLabel("\u041c\u0438\u043d\u0438\u043c\u0443\u043c:"), "newline, al right");
        this.pnlVarMinMax.add((Component)this.tfVarMin, "");
        this.pnlVarMinMax.add((Component)this.lblVarMinError, "hidemode 3, spanx");
        this.pnlVarMinMax.add((Component)new JLabel("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c:"), "newline, al right");
        this.pnlVarMinMax.add((Component)this.tfVarMax, "");
        this.pnlVarMinMax.add((Component)this.lblVarMaxError, "hidemode 3, spanx");
        this.pnlVarStrings = new JPanel(new MigLayout("insets 0", "[80][grow]", "[][grow]"));
        this.pnlVarStrings.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u043e\u043a:"), "al right");
        this.pnlVarStrings.add(this.cbxStringsCount, "spanx");
        JScrollPane scroller = new JScrollPane(this.tblStrings);
        scroller.setMinimumSize(new Dimension(200, 80));
        scroller.setPreferredSize(new Dimension(400, 80));
        this.pnlItemParams = new JPanel(new MigLayout("insets 8 8 8 8", "[80][grow]", "[][][][grow]"));
        this.pnlItemParams.add((Component)this.lblItemType, "spanx");
        this.pnlItemParams.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), "newline, al right");
        this.pnlItemParams.add((Component)this.tfName, "");
        this.pnlItemParams.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f:"), "newline, al right");
        this.pnlItemParams.add(this.cbxAccess, "");
        this.pnlItemParams.add((Component)this.pnlVarParams, "newline, grow, spanx, aligny top");
        this.pnlVarParams.add((Component)this.pnlVarMinMax, "newline, grow, spanx, hidemode 3");
        this.pnlVarParams.add((Component)this.pnlVarStrings, "newline, grow, spanx, hidemode 3");
        this.pnlVarStrings.add((Component)scroller, "newline, span, growy");
        this.pnlParamsCards = new JPanel(new CardLayout());
        this.pnlParamsCards.add((Component)this.pnlEmptyParams, CARD_EMPTY);
        this.pnlParamsCards.add((Component)this.pnlItemParams, CARD_ITEM);
        JPanel pnlLeft = new JPanel(new BorderLayout());
        pnlLeft.setMinimumSize(new Dimension(100, 100));
        pnlLeft.setPreferredSize(new Dimension(500, 100));
        scroller = new JScrollPane(this.tree);
        pnlLeft.add((Component)scroller, "Center");
        JPanel pnlRight = new JPanel(new BorderLayout());
        pnlRight.setMinimumSize(new Dimension(200, 100));
        scroller = new JScrollPane(this.pnlParamsCards);
        pnlRight.add((Component)scroller, "Center");
        JSplitPane masterSplitter = new JSplitPane(1, pnlLeft, pnlRight);
        IdeUtils.setupDivider(masterSplitter);
        this.add((Component)masterSplitter, "Center");
        this.tfName.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                if (!UiEditor.this.inUpdate && UiEditor.this.focusedItem != null) {
                    UiEditor.this.focusedItem.setName(UiEditor.this.tfName.getText());
                    UiEditor.this.fireSelItemChanged();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.cbxAccess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!UiEditor.this.inUpdate && UiEditor.this.focusedItem != null) {
                    UiEditor.this.focusedItem.setAccess(UiEditor.this.cbxAccess.getSelectedIndex());
                    UiEditor.this.fireSelItemChanged();
                }
            }
        });
        this.cbxVar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!UiEditor.this.inUpdate && UiEditor.this.focusedVarItem != null) {
                    UiEditor.this.focusedVarItem.setVar((VariableRef)UiEditor.this.cbxVar.getSelectedItem());
                    UiEditor.this.updateVarProps();
                    UiEditor.this.fireSelItemChanged();
                    UiEditor.this.updateVarRefs();
                }
            }
        });
        this.chkVarEditable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!UiEditor.this.inUpdate && UiEditor.this.focusedVarItem != null) {
                    UiEditor.this.focusedVarItem.setWritable(UiEditor.this.chkVarEditable.isSelected());
                    UiEditor.this.updateVarProps();
                    UiEditor.this.fireSelItemChanged();
                    UiEditor.this.updateVarRefs();
                }
            }
        });
        this.cbxVarIntFmt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!UiEditor.this.inUpdate && UiEditor.this.focusedVarItem != null) {
                    UiEditor.this.focusedVarItem.setIsText(UiEditor.this.cbxVarIntFmt.getSelectedIndex() > 0);
                    UiEditor.this.updateVarProps();
                    UiEditor.this.fireSelItemChanged();
                }
            }
        });
        this.tfVarMin.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                if (!UiEditor.this.inUpdate && UiEditor.this.focusedVarItem != null) {
                    if (!UiEditor.this.focusedVarItem.setMinAsString(UiEditor.this.tfVarMin.getText())) {
                        UiEditor.this.lblVarMinError.setText("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \"" + UiEditor.this.tfVarMin.getText() + "\"");
                    } else {
                        UiEditor.this.lblVarMinError.setText("");
                    }
                    UiEditor.this.fireSelItemChanged();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.tfVarMax.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                if (!UiEditor.this.inUpdate && UiEditor.this.focusedVarItem != null) {
                    if (!UiEditor.this.focusedVarItem.setMaxAsString(UiEditor.this.tfVarMax.getText())) {
                        UiEditor.this.lblVarMaxError.setText("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \"" + UiEditor.this.tfVarMax.getText() + "\"");
                    } else {
                        UiEditor.this.lblVarMaxError.setText("");
                    }
                    UiEditor.this.fireSelItemChanged();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.cbxVarFloatFmt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!UiEditor.this.inUpdate && UiEditor.this.focusedVarItem != null) {
                    UiEditor.this.focusedVarItem.setNumDigits(UiEditor.this.cbxVarFloatFmt.getSelectedIndex());
                    UiEditor.this.updateVarProps();
                    UiEditor.this.fireSelItemChanged();
                }
            }
        });
        this.cbxStringsCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!UiEditor.this.inUpdate && UiEditor.this.focusedVarItem != null) {
                    UiEditor.this.focusedVarItem.setStringsCount(UiEditor.this.cbxStringsCount.getSelectedIndex() + 1);
                    UiEditor.this.fireSelItemChanged();
                    UiEditor.this.stringsModel.fireTableChanged();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVarProps() {
        if (this.focusedItem == null) {
            return;
        }
        boolean prevUpdate = this.inUpdate;
        this.inUpdate = true;
        try {
            this.lblItemType.setText("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440/\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
            this.pnlVarParams.setVisible(true);
            VariableRef var = this.focusedVarItem.getVar();
            if (var != null) {
                boolean isFloat = var.type() == 3;
                boolean isBool = var.type() == 1;
                boolean isText = this.focusedVarItem.isText();
                this.cbxVar.setSelectedItem(var);
                this.cbxVarFloatFmt.setVisible(isFloat);
                this.cbxVarFloatFmt.setSelectedIndex(this.focusedVarItem.getNumDigits());
                this.cbxVarIntFmt.setVisible(!isFloat);
                this.cbxVarIntFmt.setSelectedIndex(isText ? 1 : 0);
                this.pnlVarStrings.setVisible(isText);
                this.cbxStringsCount.setSelectedIndex(this.focusedVarItem.textStrings.size() - 1);
                this.stringsModel.fireTableChanged();
                this.chkVarEditable.setSelected(this.focusedVarItem.isWritable());
                this.chkVarEditable.setEnabled(var.varDef.isWritable());
                this.pnlVarMinMax.setVisible(this.focusedVarItem.isWritable() && !isText);
                this.tfVarMin.setText(this.focusedVarItem.getMinAsString());
                this.tfVarMin.setEnabled(!isBool);
                this.lblVarMinError.setText("");
                this.tfVarMax.setText(this.focusedVarItem.getMaxAsString());
                this.tfVarMax.setEnabled(!isBool);
                if (this.focusedVarItem.getNumMax() <= this.focusedVarItem.getNumMin()) {
                    this.lblVarMaxError.setText("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043c\u0438\u043d\u0438\u043c\u0443\u043c\u0430");
                } else {
                    this.lblVarMaxError.setText("");
                }
                switch (var.type()) {
                    case 1: {
                        this.lblVarType.setText("Boolean");
                        break;
                    }
                    case 2: {
                        this.lblVarType.setText("Integer");
                        break;
                    }
                    case 3: {
                        this.lblVarType.setText("Float");
                        break;
                    }
                    default: {
                        this.lblVarType.setText("???");
                        break;
                    }
                }
            } else {
                this.pnlVarParams.setVisible(false);
            }
        }
        finally {
            this.inUpdate = prevUpdate;
        }
    }

    private void fireSelItemChanged() {
        this.treeModel.fireItemChanged(this.tree.getSelectionPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        boolean prevUpdate = this.inUpdate;
        this.inUpdate = true;
        try {
            this.focusedItem = null;
            this.focusedVarItem = null;
            Object node = this.tree.getLastSelectedPathComponent();
            if (node == null) {
                this.setCard(CARD_EMPTY);
            } else if (node instanceof AMenuItemView) {
                this.setCard(CARD_ITEM);
                this.focusedItem = (AMenuItemView)node;
                this.tfName.setText(this.focusedItem.getName());
                this.cbxAccess.setSelectedIndex(this.focusedItem.getAccess());
                if (node instanceof MenuItemVariableView) {
                    this.focusedVarItem = (MenuItemVariableView)node;
                    this.updateVarProps();
                } else {
                    this.lblItemType.setText("\u041f\u043e\u0434\u0440\u0430\u0437\u0434\u0435\u043b \u043c\u0435\u043d\u044e");
                    this.pnlVarParams.setVisible(false);
                }
            } else {
                this.setCard(CARD_EMPTY);
            }
        }
        finally {
            this.inUpdate = prevUpdate;
            this.actions.update();
        }
    }

    private void setCard(String cardName) {
        CardLayout cl = (CardLayout)this.pnlParamsCards.getLayout();
        cl.show(this.pnlParamsCards, cardName);
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new UiActions(this);
        this.menu.add(new JMenuItem(this.actions.copy));
        this.menu.add(new JMenuItem(this.actions.cut));
        this.menu.add(new JMenuItem(this.actions.paste));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.duplicate));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.moveUp));
        this.menu.add(new JMenuItem(this.actions.moveDown));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.moveLeft));
        this.menu.add(new JMenuItem(this.actions.moveRight));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.addVar));
        this.menu.add(new JMenuItem(this.actions.addMenu));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.delete));
        this.toolBar.add(MainFrame.instance.actions.exportUi).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.copy).setFocusable(false);
        this.toolBar.add(this.actions.cut).setFocusable(false);
        this.toolBar.add(this.actions.paste).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.duplicate).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.moveUp).setFocusable(false);
        this.toolBar.add(this.actions.moveDown).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.moveLeft).setFocusable(false);
        this.toolBar.add(this.actions.moveRight).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.addVar).setFocusable(false);
        this.toolBar.add(this.actions.addMenu).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.delete).setFocusable(false);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new JMenuItem(this.actions.copy));
        this.popupMenu.add(new JMenuItem(this.actions.cut));
        this.popupMenu.add(new JMenuItem(this.actions.paste));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.duplicate));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.addVar));
        this.popupMenu.add(new JMenuItem(this.actions.addMenu));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.moveUp));
        this.popupMenu.add(new JMenuItem(this.actions.moveDown));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.moveLeft));
        this.popupMenu.add(new JMenuItem(this.actions.moveRight));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.delete));
        return this.actions;
    }

    @Override
    public void clear() {
        this.mainMenu = new MenuItemMenuView(this, null, 0, "", null);
        this.updateView();
        this.updateVarRefs();
        this.updateVarList();
    }

    public boolean hasSelection() {
        return this.focusedItem != null;
    }

    public void duplicateItem() {
        if (this.focusedItem != null) {
            MenuItemMenuView menu = this.focusedItem.getParent();
            AMenuItemView item = menu.duplicateChild(this.focusedItem);
            this.treeModel.fireStructureChanged(menu);
            this.tree.setSelectionPath(new TreePath(item.getPath()));
        }
    }

    public void createItemVar() {
        VariableRef v = VariableCreateDialog.showDialog(this.tree, -1, -1);
        if (v == null) {
            return;
        }
        AMenuItemView item = null;
        MenuItemMenuView menu = this.mainMenu;
        if (this.focusedItem != null) {
            if (this.focusedItem instanceof MenuItemMenuView) {
                menu = (MenuItemMenuView)this.focusedItem;
            } else {
                menu = this.focusedItem.getParent();
                item = this.focusedItem;
            }
        }
        item = menu.createChildVar(item, null, v);
        this.treeModel.fireStructureChanged(menu);
        this.focusItem(item);
    }

    public void createItemMenu() {
        MenuItemMenuView menu = this.mainMenu;
        AMenuItemView item = null;
        if (this.focusedItem != null) {
            menu = this.focusedItem.getParent();
            item = this.focusedItem;
        }
        item = menu.createChildMenu(item, null);
        this.treeModel.fireStructureChanged(menu);
        this.focusItem(item);
    }

    public void deleteSelected() {
        TreePath[] selection = this.tree.getSelectionPaths();
        if (selection.length > 1 && !IdeUtils.confirmDialog("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b (" + selection.length + " \u0448\u0442.)?")) {
            return;
        }
        for (TreePath path : selection) {
            MenuItemMenuView menu;
            AMenuItemView item = (AMenuItemView)path.getLastPathComponent();
            if (item instanceof MenuItemMenuView) {
                menu = (MenuItemMenuView)item;
                int count = menu.getItems().size();
                if (selection.length == 1 && count > 0 && !IdeUtils.confirmDialog("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0434\u043c\u0435\u043d\u044e \"" + menu.getName() + "\" \u0441\u043e \u0432\u0441\u0435\u043c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u044b\u043c (" + count + ")?")) {
                    return;
                }
            }
            if (!(menu = item.getParent()).deleteChild(item)) continue;
            this.treeModel.fireStructureChanged(menu);
        }
        this.updateVarRefs();
        this.tree.setSelectionPath(null);
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
    }

    private void updateView() {
        this.treeModel.setRoot(this.mainMenu);
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.mainMenu = new MenuItemMenuView(this, null, 0, "", null);
        this.mainMenu.loadItems(this.mainFrame.program.mainMenu);
        this.updateView();
        this.updateVarRefs();
        this.updateVarList();
    }

    @Override
    public void initNewProgram() {
        this.mainMenu = new MenuItemMenuView(this, null, 0, "", null);
        this.updateView();
        this.updateVarRefs();
        this.updateVarList();
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        this.mainFrame.program.mainMenu.clear();
        this.mainMenu.compileItems(this.mainFrame.program.mainMenu);
    }

    @Override
    public void saveProps() {
    }

    @Override
    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearMenuRefs();
        this.mainMenu.updateVarRefs();
    }

    @Override
    public void updateVarList() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ArrayList<Object> varList = ved == null ? new ArrayList(0) : ved.getAllVariables(true, 0);
        this.cbxVar.setModel(new DefaultComboBoxModel(new Vector(varList)));
    }

    @Override
    public void titleClicked() {
        this.initFocus();
    }

    @Override
    public void initFocus() {
        this.tree.requestFocusInWindow();
    }

    public void copyToClipboard(boolean cut) {
        TreePath[] selpaths = this.tree.getSelectionPaths();
        if (selpaths == null) {
            return;
        }
        ArrayList<AMenuItemView> list = new ArrayList<AMenuItemView>();
        for (TreePath path : selpaths) {
            boolean ok = true;
            for (TreePath p : selpaths) {
                if (p == path || !p.isDescendant(path)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            list.add((AMenuItemView)path.getLastPathComponent());
        }
        ClipboardUtils.putData(this.saveForClipboard(list), 'u');
        if (cut) {
            this.deleteSelected();
        }
    }

    public void pasteFromClipboard() {
        JSONObject json = ClipboardUtils.getData('u');
        if (json != null) {
            try {
                this.loadFromClipboard(json);
            }
            catch (Throwable e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this.mainFrame, e.getClass().getSimpleName() + ": " + e.getMessage(), "Error", 0);
            }
        }
    }

    private JSONObject saveForClipboard(ArrayList<AMenuItemView> list) {
        JSONArray jsa = new JSONArray();
        ArrayList<VariableDef> vars = new ArrayList<VariableDef>();
        for (AMenuItemView item : list) {
            JSONObject jso = new JSONObject();
            item.saveToJSON(jso, vars);
            jsa.put(jso);
        }
        JSONObject jsonClipboard = new JSONObject();
        VariablesEditor.saveToJson(jsonClipboard, vars);
        jsonClipboard.put(JSON_MENU_ITEMS, jsa);
        return jsonClipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromClipboard(JSONObject json) throws JSONException, SyntaxError, FbdLoadError {
        JSONArray jsa = json.optJSONArray(JSON_MENU_ITEMS);
        if (jsa == null) {
            return;
        }
        HashMap<String, String> varMap = new HashMap<String, String>();
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        if (!ved.loadFromClipboard(json, false, false, varMap)) {
            return;
        }
        AMenuItemView item = this.focusedItem;
        MenuItemMenuView menu = this.mainMenu;
        if (item != null) {
            menu = item instanceof MenuItemMenuView ? (MenuItemMenuView)item : item.getParent();
        }
        ved.setVarMap(varMap);
        ArrayList<TreePath> newItems = new ArrayList<TreePath>();
        try {
            for (int i = 0; i < jsa.length(); ++i) {
                AMenuItemView t = menu.createItemFromJSON(item, jsa.getJSONObject(i));
                if (t == null) continue;
                item = t;
                newItems.add(new TreePath(item.getPath()));
            }
        }
        finally {
            ved.setVarMap(null);
        }
        this.treeModel.fireStructureChanged(menu);
        this.tree.setSelectionPath(null);
        if (newItems.size() > 0) {
            this.tree.setSelectionPaths(newItems.toArray(new TreePath[0]));
        }
    }

    private String accessString(AMenuItemView item) {
        if (item.getAccess() > 0) {
            return "&nbsp;*" + item.accessString() + "*";
        }
        return "";
    }

    private void exportItem(AMenuItemView item, String tab, StringBuilder sb) {
        if (item instanceof MenuItemMenuView) {
            if (item != this.mainMenu) {
                sb.append("<tr><td colspan='3'>").append(tab).append("[<b>").append(item.getName()).append("</b>]").append(this.accessString(item)).append("</td></tr>\n");
                tab = tab + "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            MenuItemMenuView menu = (MenuItemMenuView)item;
            for (AMenuItemView i : menu.getItems()) {
                this.exportItem(i, tab, sb);
            }
        } else if (item instanceof MenuItemVariableView) {
            String name = "----";
            String comment = "";
            MenuItemVariableView vi = (MenuItemVariableView)item;
            if (vi.getVar() != null) {
                name = vi.getName();
                comment = vi.getVar().varDef.getCommentHtml();
                if (Utils.strEmpty(name)) {
                    name = vi.getVar().shortName();
                }
                name = name.replace("_", "&nbsp;");
                name = name.replace(" ", "&nbsp;");
            }
            sb.append("<tr><td>").append(tab).append(name).append(this.accessString(item)).append("</td><td>").append(vi.isWritable() ? "W</td><td>" : "R</td><td>").append(vi.getValueHint()).append("<br><i>").append(comment).append("</i></td></tr>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportHTML(File file) throws IOException {
        MainFrame.instance.startWaitCursor();
        try {
            try (PrintWriter pw = new PrintWriter(file, "UTF-8");){
                String prgName = Utils.clearFileExt(MainFrame.instance.getCurrentFile().getName(), "vics-fbd");
                pw.println("<!DOCTYPE html>");
                pw.println("<head>");
                pw.println("<meta charset=\"utf-8\" />");
                pw.println("<title>" + prgName + " menu</title>");
                pw.println("<style>");
                pw.println("body {padding: 1em;}");
                pw.println("table {border-collapse: collapse; table-layout:fixed;}");
                pw.println("table, th, td {border: 1px solid black;}");
                pw.println("th, td {padding: 0.2em 1em; vertical-align: middle;}");
                pw.println("</style>");
                pw.println("</head>");
                pw.println("<body>");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                pw.println("<h1>" + prgName + " menu</h1>");
                pw.println("<p>" + dateFormat.format(new Date()));
                pw.println("<p>" + MainFrame.instance.program.comment.replace("\n", "<br>"));
                StringBuilder sb = new StringBuilder();
                this.exportItem(this.mainMenu, "", sb);
                pw.println("<p>");
                pw.println("<table>");
                pw.println(sb.toString());
                pw.println("</table>");
                pw.println("</body>");
                pw.println("</html>");
            }
            catch (Exception e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getSimpleName(), 0);
            }
        }
        finally {
            MainFrame.instance.stopWaitCursor();
        }
    }

    public void focusItem(AMenuItemView item) {
        TreePath path = new TreePath(item.getPath());
        this.tree.makeVisible(path);
        this.tree.setSelectionPath(path);
    }

    public static class AddingItem
    implements Transferable {
        public static final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + AMenuItemView.class.getName(), "Menu item");
        private static final DataFlavor[] flavors = new DataFlavor[]{FLAVOR};
        AMenuItemView data;

        public AddingItem(AMenuItemView data) {
            this.data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return FLAVOR.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(FLAVOR)) {
                return this.data;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

