/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.Utils;
import certa.vics.compiler.MenuItemMenu;
import certa.vics.compiler.MenuItemVariable;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.AMenuItemView;
import certa.vics.ide.ui.MenuItemMenuView;
import certa.vics.ide.ui.UiEditor;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariableRef;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class MenuItemVariableView
extends AMenuItemView {
    private VariableRef var;
    private boolean isText;
    protected final ArrayList<String> textStrings = new ArrayList(0);
    private boolean isWritable;
    private int numDigits;
    private int numMin;
    private int numMax;
    static final int MAX_DIGITS = 3;
    static final String JSON_VAR = "var";
    static final String JSON_ISTEXT = "isText";
    static final String JSON_STRINGS = "strings";
    static final String JSON_ISWRITABLE = "isWritable";
    static final String JSON_NUMDIGITS = "numDigits";
    static final String JSON_NUMMIN = "numMin";
    static final String JSON_NUMMAX = "numMax";

    public MenuItemVariableView(UiEditor editor, MenuItemMenuView parent, int access, String name, MenuItemVariableView src) {
        super(editor, parent, access, name);
        if (src != null) {
            this.copyFrom(src);
        }
    }

    public MenuItemVariableView(UiEditor editor, MenuItemMenuView parent, int access, String name, VariableRef var) {
        super(editor, parent, access, name);
        this.var = var;
    }

    private void copyFrom(MenuItemVariableView src) {
        this.var = src.var;
        this.isText = src.isText;
        this.textStrings.clear();
        this.textStrings.addAll(src.textStrings);
        this.isWritable = src.isWritable;
        this.numDigits = src.numDigits;
        this.numMin = src.numMin;
        this.numMax = src.numMax;
    }

    private String getStrings() {
        String res = "";
        for (int i = 0; i < this.textStrings.size(); ++i) {
            res = res + (i > 0 ? "|" : "") + this.textStrings.get(i);
        }
        return res;
    }

    public void setStringsCount(int newSize) {
        if (newSize != this.textStrings.size()) {
            this.editor.markModified();
        }
        while (this.textStrings.size() < newSize) {
            this.textStrings.add("" + this.textStrings.size());
        }
        if (newSize > 0) {
            while (this.textStrings.size() > newSize) {
                this.textStrings.remove(this.textStrings.size() - 1);
            }
        }
    }

    public void setString(int index, String str) {
        if (index >= 0 && index < this.textStrings.size() && !str.equals(this.textStrings.get(index))) {
            this.textStrings.set(index, str);
            this.editor.markModified();
        }
    }

    public VariableRef getVar() {
        return this.var;
    }

    public void setVar(VariableRef var) {
        if (this.var != var) {
            this.editor.markModified();
        }
        this.var = var;
    }

    public boolean isText() {
        return this.isText && this.var != null && this.var.type() != 3;
    }

    public void setIsText(boolean isText) {
        if (this.isText != isText) {
            this.editor.markModified();
        }
        this.isText = isText;
        if (isText && this.textStrings.size() == 0) {
            this.textStrings.add("text 0");
        }
    }

    public boolean isWritable() {
        return this.isWritable && this.var != null && this.var.varDef.isWritable();
    }

    public void setWritable(boolean isWritable) {
        if (this.isWritable != isWritable) {
            this.editor.markModified();
        }
        this.isWritable = isWritable;
    }

    public int getNumDigits() {
        if (this.var != null && this.var.type() == 3) {
            return this.numDigits >= 0 && this.numDigits <= 3 ? this.numDigits : 0;
        }
        return 0;
    }

    public void setNumDigits(int numDigits) {
        if (this.numDigits != numDigits) {
            this.editor.markModified();
        }
        this.numDigits = numDigits;
    }

    static int limitInt16(int v) {
        if (v < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        if (v > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        return v;
    }

    public int getNumMin() {
        if (this.var != null) {
            switch (this.var.type()) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return MenuItemVariableView.limitInt16(this.numMin);
                }
                case 3: {
                    return this.numMin;
                }
            }
        }
        return 0;
    }

    public void setNumMin(int numMin) {
        if (this.numMin != numMin) {
            this.editor.markModified();
        }
        this.numMin = numMin;
    }

    public int getNumMax() {
        if (this.var != null) {
            switch (this.var.type()) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return MenuItemVariableView.limitInt16(this.numMax);
                }
                case 3: {
                    return this.numMax;
                }
            }
        }
        return 0;
    }

    public void setNumMax(int numMax) {
        if (this.numMax != numMax) {
            this.editor.markModified();
        }
        this.numMax = numMax;
    }

    private double parseMinMax(String s) {
        double d = Utils.StringToDouble(s);
        if (!Double.isFinite(d)) {
            return Double.NaN;
        }
        if (this.var != null) {
            switch (this.var.type()) {
                case 1: {
                    if (d == 1.0 || d == 0.0) {
                        return d;
                    }
                    return Double.NaN;
                }
                case 2: {
                    if (d >= -32768.0 && d <= 32767.0) {
                        return d;
                    }
                    return Double.NaN;
                }
                case 3: {
                    return d * Math.pow(10.0, this.numDigits);
                }
            }
            return Double.NaN;
        }
        return Double.NaN;
    }

    public boolean setMinAsString(String sMin) {
        double d = this.parseMinMax(sMin);
        if (Double.isFinite(d)) {
            this.numMin = Utils.Round(d);
            return true;
        }
        return false;
    }

    public boolean setMaxAsString(String sMax) {
        double d = this.parseMinMax(sMax);
        if (Double.isFinite(d)) {
            this.numMax = Utils.Round(d);
            return true;
        }
        return false;
    }

    public String getMinAsString() {
        if (this.var != null) {
            int num = this.getNumMin();
            return this.var.type() == 3 ? Utils.FormatDouble((double)num / Math.pow(10.0, this.numDigits), this.numDigits) : Integer.toString(num);
        }
        return "";
    }

    public String getMaxAsString() {
        if (this.var != null) {
            int num = this.getNumMax();
            return this.var.type() == 3 ? Utils.FormatDouble((double)num / Math.pow(10.0, this.numDigits), this.numDigits) : Integer.toString(num);
        }
        return "";
    }

    public String getValueHint() {
        if (this.isText()) {
            return this.getStrings();
        }
        return this.isWritable() ? this.getMinAsString() + " ... " + this.getMaxAsString() : Utils.FormatDouble(0.0, this.getNumDigits());
    }

    @Override
    public String toString() {
        String s = super.getName();
        if (this.var != null) {
            s = Utils.strEmpty(s) ? this.var.shortName().replace('_', ' ') : s + " (" + this.var.shortName() + ")";
            s = (this.isWritable() ? "[W]   " : "[R]   ") + s + "    (" + this.getValueHint() + ")";
            s = s + (this.getAccess() > 0 ? "    *" + this.accessString() + "*" : "");
        }
        return s;
    }

    public void loadItem(MenuItemVariable item) {
        this.var = MainFrame.instance.getVarsEditor().makeRef(item.getVariable());
        this.isText = item.isText;
        this.textStrings.clear();
        this.textStrings.addAll(item.textStrings);
        this.isWritable = item.isWritable();
        this.numDigits = item.getNumDigits();
        this.numMin = item.getNumMin();
        this.numMax = item.getNumMax();
    }

    public MenuItemVariable compileItem(MenuItemMenu parent) {
        MenuItemVariable item = new MenuItemVariable(parent, this.getAccess(), this.getName(), this.isText());
        if (this.isText()) {
            item.textStrings.addAll(this.textStrings);
        }
        item.setVariable(this.var.getCompiledVar());
        item.setWritable(this.isWritable());
        item.setNumDigits(this.getNumDigits());
        item.setNumMin(this.getNumMin());
        item.setNumMax(this.getNumMax());
        return item;
    }

    void saveVar(VariableRef vr, String key, JSONObject jso, ArrayList<VariableDef> vars) {
        if (vr != null) {
            jso.put(key, vr.fullName());
            if (vars != null) {
                vars.add(vr.varDef);
            }
        }
    }

    @Override
    public void saveToJSON(JSONObject jso, ArrayList<VariableDef> vars) {
        super.saveToJSON(jso, vars);
        this.saveVar(this.var, JSON_VAR, jso, vars);
        jso.put(JSON_ISTEXT, this.isText);
        if (this.isText) {
            JSONArray jsa = new JSONArray();
            for (String s : this.textStrings) {
                jsa.put(s);
            }
            jso.put(JSON_STRINGS, jsa);
        }
        jso.put(JSON_ISWRITABLE, this.isWritable);
        jso.put(JSON_NUMDIGITS, this.numDigits);
        jso.put(JSON_NUMMIN, this.numMin);
        jso.put(JSON_NUMMAX, this.numMax);
    }

    VariableRef loadVar(String key, JSONObject jso) {
        String s = jso.optString(key);
        if (!Utils.strEmpty(s)) {
            return this.editor.mainFrame.getVarsEditor().locateVar(s);
        }
        return null;
    }

    @Override
    public void loadFromJSON(JSONObject jso) {
        super.loadFromJSON(jso);
        this.var = this.loadVar(JSON_VAR, jso);
        this.isText = jso.optBoolean(JSON_ISTEXT, false);
        if (this.isText) {
            this.textStrings.clear();
            JSONArray jsa = jso.optJSONArray(JSON_STRINGS);
            if (jsa != null) {
                for (int i = 0; i < jsa.length(); ++i) {
                    this.textStrings.add(jsa.optString(i, Integer.toString(i)));
                }
            }
        }
        this.isWritable = jso.optBoolean(JSON_ISWRITABLE, false);
        this.numDigits = jso.optInt(JSON_NUMDIGITS, 0);
        if (this.numDigits < 0) {
            this.numDigits = 0;
        }
        if (this.numDigits >= 3) {
            this.numDigits = 3;
        }
        this.numMin = jso.optInt(JSON_NUMMIN, 0);
        this.numMax = jso.optInt(JSON_NUMMAX, 0);
    }

    @Override
    public void updateVarRefs() {
        if (this.var != null) {
            this.var.varDef.addMenuRef(this, this.isWritable);
        }
    }
}

