/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.compiler.AMenuItem;
import certa.vics.compiler.MenuItemMenu;
import certa.vics.compiler.MenuItemVariable;
import certa.vics.ide.ui.AMenuItemView;
import certa.vics.ide.ui.MenuItemVariableView;
import certa.vics.ide.ui.UiEditor;
import certa.vics.ide.variables.VariableDef;
import certa.vics.ide.variables.VariableRef;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class MenuItemMenuView
extends AMenuItemView {
    private ArrayList<AMenuItemView> items = new ArrayList();
    static final String JSON_ITEMS = "items";

    public MenuItemMenuView(UiEditor editor, MenuItemMenuView parent, int access, String name, MenuItemMenuView src) {
        super(editor, parent, access, name);
        if (src != null) {
            this.copyFrom(src);
        }
    }

    private void copyFrom(MenuItemMenuView src) {
        for (AMenuItemView item : src.items) {
            if (item instanceof MenuItemMenuView) {
                new MenuItemMenuView(this.editor, this, item.getAccess(), item.getName(), (MenuItemMenuView)item);
                continue;
            }
            if (!(item instanceof MenuItemVariableView)) continue;
            new MenuItemVariableView(this.editor, this, item.getAccess(), item.getName(), (MenuItemVariableView)item);
        }
    }

    public boolean isMain() {
        return this.getParent() == null;
    }

    public ArrayList<AMenuItemView> getItems() {
        return this.items;
    }

    public void loadItems(MenuItemMenu menu) {
        this.items.clear();
        for (AMenuItem item : menu.items) {
            AMenuItemView view;
            if (item instanceof MenuItemVariable) {
                view = new MenuItemVariableView(this.editor, this, item.getAccess(), item.getName(), (MenuItemVariableView)null);
                ((MenuItemVariableView)view).loadItem((MenuItemVariable)item);
                continue;
            }
            if (item instanceof MenuItemMenu) {
                view = new MenuItemMenuView(this.editor, this, item.getAccess(), item.getName(), null);
                ((MenuItemMenuView)view).loadItems((MenuItemMenu)item);
                continue;
            }
            throw new Error("MenuItemMenuView load error (1)");
        }
    }

    public void compileItems(MenuItemMenu parentMenu) {
        for (AMenuItemView view : this.items) {
            if (view instanceof MenuItemVariableView) {
                ((MenuItemVariableView)view).compileItem(parentMenu);
                continue;
            }
            if (!(view instanceof MenuItemMenuView)) continue;
            ((MenuItemMenuView)view).compileItems(new MenuItemMenu(parentMenu, view.getAccess(), view.getName()));
        }
    }

    public MenuItemMenuView createChildMenu(AMenuItemView sibling, JSONObject src) {
        int i = -1;
        if (sibling != null) {
            i = this.items.indexOf(sibling);
        }
        MenuItemMenuView view = new MenuItemMenuView(this.editor, null, 0, "menu " + this.items.size(), null);
        if (i >= 0) {
            this.items.add(i + 1, view);
        } else {
            this.items.add(view);
        }
        if (src != null) {
            view.loadFromJSON(src);
        }
        this.editor.markModified();
        view.setParent(this);
        return view;
    }

    public MenuItemVariableView createChildVar(AMenuItemView sibling, JSONObject src, VariableRef var) {
        int i = -1;
        if (sibling != null) {
            i = this.items.indexOf(sibling);
        }
        MenuItemVariableView view = new MenuItemVariableView(this.editor, null, 0, "", (MenuItemVariableView)null);
        if (i >= 0) {
            this.items.add(i + 1, view);
        } else {
            this.items.add(view);
        }
        if (src != null) {
            view.loadFromJSON(src);
        } else {
            view.setVar(var);
        }
        this.editor.markModified();
        view.setParent(this);
        return view;
    }

    public boolean deleteChild(AMenuItemView child) {
        boolean res = this.items.remove(child);
        if (res) {
            this.editor.markModified();
        }
        return res;
    }

    public boolean canMoveChildUp(AMenuItemView child) {
        return child.getParent().getItems().indexOf(child) > 0;
    }

    public boolean canMoveChildDown(AMenuItemView child) {
        ArrayList<AMenuItemView> items = child.getParent().getItems();
        return items.size() > 1 && items.indexOf(child) < items.size() - 1;
    }

    public boolean canMoveChildDeeper(AMenuItemView child) {
        ArrayList<AMenuItemView> items = child.getParent().getItems();
        int i = items.indexOf(child);
        while (++i < items.size()) {
            if (!(items.get(i) instanceof MenuItemMenuView)) continue;
            return true;
        }
        return false;
    }

    public boolean canMoveChildOut(AMenuItemView child) {
        return child.getParent() != this.editor.mainMenu;
    }

    public void moveChildUp(AMenuItemView child) {
        ArrayList<AMenuItemView> items = child.getParent().getItems();
        int i = items.indexOf(child);
        if (i > 0) {
            items.remove(i);
            items.add(i - 1, child);
            this.editor.treeModel.fireStructureChanged(this);
            this.editor.markModified();
            this.editor.focusItem(child);
        }
    }

    public void moveChildDown(AMenuItemView child) {
        ArrayList<AMenuItemView> items = child.getParent().getItems();
        int i = items.indexOf(child);
        int size = items.size();
        if (size > 1 && i < size - 1) {
            items.remove(i);
            items.add(i + 1, child);
            this.editor.treeModel.fireStructureChanged(this);
            this.editor.markModified();
            this.editor.focusItem(child);
        }
    }

    public void moveChildDeeper(AMenuItemView child) {
        ArrayList<AMenuItemView> items = child.getParent().getItems();
        int i = items.indexOf(child);
        while (++i < items.size()) {
            if (!(items.get(i) instanceof MenuItemMenuView)) continue;
            MenuItemMenuView submenu = (MenuItemMenuView)items.get(i);
            items.remove(child);
            submenu.items.add(0, child);
            child.setParent(submenu);
            this.editor.treeModel.fireStructureChanged(this);
            this.editor.markModified();
            this.editor.focusItem(child);
            return;
        }
    }

    public void moveChildOut(AMenuItemView child) {
        ArrayList<AMenuItemView> items = child.getParent().getItems();
        int i = items.indexOf(child);
        if (i >= 0 && this != this.editor.mainMenu) {
            items.remove(i);
            i = this.getParent().items.indexOf(this);
            this.getParent().items.add(i, child);
            child.setParent(this.getParent());
            this.editor.treeModel.fireStructureChanged(this.getParent());
            this.editor.markModified();
            this.editor.focusItem(child);
        }
    }

    public AMenuItemView duplicateChild(AMenuItemView child) {
        AMenuItemView item = null;
        if (child instanceof MenuItemVariableView) {
            item = new MenuItemVariableView(this.editor, null, child.getAccess(), child.getName(), (MenuItemVariableView)child);
        } else if (child instanceof MenuItemMenuView) {
            item = new MenuItemMenuView(this.editor, null, child.getAccess(), child.getName(), (MenuItemMenuView)child);
        }
        if (item != null) {
            item.setParent(this);
            this.items.add(this.items.indexOf(child) + 1, item);
        }
        return item;
    }

    @Override
    public void saveToJSON(JSONObject jso, ArrayList<VariableDef> vars) {
        super.saveToJSON(jso, vars);
        JSONArray jsa = new JSONArray();
        for (AMenuItemView item : this.items) {
            JSONObject t = new JSONObject();
            item.saveToJSON(t, vars);
            jsa.put(t);
        }
        jso.put(JSON_ITEMS, jsa);
    }

    public AMenuItemView createItemFromJSON(AMenuItemView sibling, JSONObject jso) {
        String cname = jso.optString("class");
        if (MenuItemMenuView.class.getSimpleName().equals(cname)) {
            return this.createChildMenu(sibling, jso);
        }
        if (MenuItemVariableView.class.getSimpleName().equals(cname)) {
            return this.createChildVar(sibling, jso, null);
        }
        return null;
    }

    @Override
    public void loadFromJSON(JSONObject jso) {
        super.loadFromJSON(jso);
        this.items.clear();
        JSONArray jsa = jso.optJSONArray(JSON_ITEMS);
        if (jsa != null) {
            for (int i = 0; i < jsa.length(); ++i) {
                this.createItemFromJSON(null, jsa.getJSONObject(i));
            }
        }
    }

    @Override
    public void updateVarRefs() {
        for (AMenuItemView item : this.items) {
            item.updateVarRefs();
        }
    }
}

