/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.ui.MenuItemMenuView;
import certa.vics.ide.ui.UiEditor;
import certa.vics.ide.variables.VariableDef;
import java.util.ArrayList;
import org.json.JSONObject;

public abstract class AMenuItemView {
    public final UiEditor editor;
    private MenuItemMenuView parent;
    private int access;
    private String name;
    static final int MAX_ACCESS = 3;
    static final String JSON_CLASS = "class";
    static final String JSON_NAME = "name";
    static final String JSON_ACCESS = "access";

    public AMenuItemView(UiEditor editor, MenuItemMenuView parent, int access, String name) {
        this.editor = editor;
        this.parent = parent;
        this.access = access;
        this.name = name;
        if (parent != null) {
            parent.getItems().add(this);
        }
    }

    public String accessString() {
        switch (this.access) {
            case 1: {
                return "USER";
            }
            case 2: {
                return "SERVICE";
            }
            case 3: {
                return "DEVELOPER";
            }
        }
        return "";
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        if (this.access != access) {
            this.editor.markModified();
        }
        this.access = access;
    }

    public void setParent(MenuItemMenuView parent) {
        if (this.parent != parent) {
            this.editor.markModified();
        }
        this.parent = parent;
    }

    public Object[] getPath() {
        AMenuItemView item;
        int depth = 0;
        for (item = this; item != null; item = item.getParent()) {
            ++depth;
        }
        Object[] res = new Object[depth];
        int i = 0;
        for (item = this; item != null; item = item.getParent()) {
            res[depth - ++i] = item;
        }
        return res;
    }

    public String toString() {
        String s = this.access > 0 ? "    *" + this.accessString() + "*" : "";
        return this.name + s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != name) {
            this.editor.markModified();
        }
        this.name = name;
    }

    public MenuItemMenuView getParent() {
        return this.parent;
    }

    public String getTipText() {
        return null;
    }

    public void saveToJSON(JSONObject jso, ArrayList<VariableDef> vars) {
        jso.put(JSON_CLASS, this.getClass().getSimpleName());
        jso.put(JSON_NAME, this.name);
        jso.put(JSON_ACCESS, this.access);
    }

    public void loadFromJSON(JSONObject jso) {
        this.name = jso.optString(JSON_NAME);
        this.access = jso.optInt(JSON_ACCESS, 0);
        if (this.access < 0) {
            this.access = 0;
        }
        if (this.access >= 3) {
            this.access = 3;
        }
    }

    public abstract void updateVarRefs();
}

