/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.schedule;

import certa.vics.Utils;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.schedule.ScheduleCell;
import certa.vics.ide.schedule.ScheduleEditor;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class ScheduleTableView
extends JPanel {
    private static final long serialVersionUID = 1L;
    final ScheduleEditor editor;
    public final int number;
    final ScheduleCell[][] cells = new ScheduleCell[7][12];
    static final String[] FLOAT_FORMATS = new String[]{"\u0426\u0435\u043b\u044b\u0435 (\u0448\u0430\u0433 1)", "\u0414\u0435\u0441\u044f\u0442\u044b\u0435 (\u0448\u0430\u0433 0.1)", "\u0421\u043e\u0442\u044b\u0435 (\u0448\u0430\u0433 0.01)", "\u0422\u044b\u0441\u044f\u0447\u043d\u044b\u0435 (\u0448\u0430\u0433 0.001)"};
    JPanel pnlParams;
    JPanel pnlType;
    ButtonGroup rgSchedType;
    JRadioButton rbTypeEvent;
    JRadioButton rbTypeStrict;
    JPanel pnlEnable;
    JComboBox<VariableRef> cmbxEnVar;
    JLabel lblEnable;
    JPanel pnlVariable;
    JPanel pnlVarFormat;
    JComboBox<VariableRef> cmbxVar;
    JComboBox<String> cmbxVarFloatFmt;
    JLabel lblVarStep;
    JLabel lblVarMin;
    JLabel lblVarMax;
    JTextField tfVarMin;
    JTextField tfVarMax;
    JTextField tfVarMin0;
    JTextField tfVarMax1;
    JTable table;
    ScheduleTableModel model;
    VariableRef var;
    VariableRef varEnable;
    int digits;
    double min;
    double max;
    boolean strict;
    boolean isModified;
    private MouseListener focuser = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            ScheduleTableView.this.table.requestFocusInWindow();
        }
    };
    boolean inUpdate = false;
    final ArrayList<ScheduleCell> selList = new ArrayList();
    SchedCellRenderer cellRenderer;
    static final String[] DAY_NAMES = new String[]{"\u041f\u041d", "\u0412\u0422", "\u0421\u0420", "\u0427\u0422", "\u041f\u0422", "\u0421\u0411", "\u0412\u0421"};
    int focusedRow = 0;
    int focusedCol = 0;

    public ScheduleTableView(final ScheduleEditor editor, int number) {
        this.editor = editor;
        this.number = number;
        for (ScheduleCell[] cl : this.cells) {
            for (int i = 0; i < cl.length; ++i) {
                cl[i] = new ScheduleCell(this, false);
            }
        }
        this.model = new ScheduleTableModel();
        this.table = new JTable(this.model);
        ActionListener update = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScheduleTableView.this.updateData();
            }
        };
        ActionListener updateWithRefs = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ScheduleTableView.this.inUpdate) {
                    return;
                }
                ScheduleTableView.this.updateData();
                editor.updateVarRefs();
            }
        };
        DocumentListener editNum = new DocumentListener(){

            public void doUpdate() {
                if (!ScheduleTableView.this.inUpdate) {
                    ScheduleTableView.this.updateData();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doUpdate();
            }
        };
        this.pnlParams = new JPanel(new MigLayout("insets 0 0 n 0", "", ""));
        this.pnlType = new JPanel(new GridLayout(0, 1));
        this.pnlType.setBorder(BorderFactory.createTitledBorder("\u0417\u0430\u043f\u0438\u0441\u044c"));
        this.rgSchedType = new ButtonGroup();
        this.rbTypeEvent = new JRadioButton("\u041f\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044e");
        this.rbTypeStrict = new JRadioButton("\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e");
        this.rgSchedType.add(this.rbTypeEvent);
        this.rgSchedType.add(this.rbTypeStrict);
        this.rbTypeEvent.addActionListener(update);
        this.rbTypeStrict.addActionListener(update);
        this.pnlType.add(this.rbTypeEvent);
        this.pnlType.add(this.rbTypeStrict);
        this.pnlEnable = new JPanel(new MigLayout("", "", ""));
        this.pnlEnable.setBorder(BorderFactory.createTitledBorder("\u0423\u0441\u043b\u043e\u0432\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u044b"));
        this.pnlEnable.setToolTipText("\u0415\u0441\u043b\u0438 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f-\u0443\u0441\u043b\u043e\u0432\u0438\u0435 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430, \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e");
        this.cmbxEnVar = new JComboBox();
        this.cmbxEnVar.setMaximumRowCount(20);
        this.cmbxEnVar.addActionListener(updateWithRefs);
        this.lblEnable = new JLabel("\u0420\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u0432\u0441\u0435\u0433\u0434\u0430");
        this.pnlEnable.add(this.cmbxEnVar, "wrap");
        this.pnlEnable.add((Component)this.lblEnable, "");
        this.pnlVariable = new JPanel(new MigLayout("", "[grow]", "[][nogrid]"));
        this.pnlVariable.setBorder(BorderFactory.createTitledBorder("\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f"));
        this.cmbxVar = new JComboBox();
        this.cmbxVar.setMaximumRowCount(20);
        this.cmbxVar.addActionListener(updateWithRefs);
        this.pnlVarFormat = new JPanel(new MigLayout("insets 0", "[grow]", "[nogrid]"));
        this.cmbxVarFloatFmt = new JComboBox<String>(new DefaultComboBoxModel<String>(FLOAT_FORMATS));
        this.cmbxVarFloatFmt.addActionListener(update);
        this.lblVarStep = new JLabel("\u0428\u0430\u0433:");
        this.lblVarMin = new JLabel("\u041c\u0438\u043d.:");
        this.tfVarMin = new JTextField(8);
        this.tfVarMin.getDocument().addDocumentListener(editNum);
        this.lblVarMax = new JLabel("\u041c\u0430\u043a\u0441.:");
        this.tfVarMax = new JTextField(8);
        this.tfVarMax.getDocument().addDocumentListener(editNum);
        this.tfVarMin0 = new JTextField("0", 8);
        this.tfVarMin0.setEnabled(false);
        this.tfVarMin0.setVisible(false);
        this.tfVarMax1 = new JTextField("1", 8);
        this.tfVarMax1.setEnabled(false);
        this.tfVarMax1.setVisible(false);
        this.pnlVariable.add(this.cmbxVar, "growx, wrap");
        this.pnlVarFormat.add((Component)this.lblVarStep, "hidemode 3");
        this.pnlVarFormat.add(this.cmbxVarFloatFmt, "hidemode 3");
        this.pnlVarFormat.add((Component)this.lblVarMin, "");
        this.pnlVarFormat.add((Component)this.tfVarMin, "hidemode 2");
        this.pnlVarFormat.add((Component)this.tfVarMin0, "hidemode 2");
        this.pnlVarFormat.add((Component)this.lblVarMax, "");
        this.pnlVarFormat.add((Component)this.tfVarMax, "hidemode 2");
        this.pnlVarFormat.add((Component)this.tfVarMax1, "hidemode 2");
        this.pnlVariable.add((Component)this.pnlVarFormat, "");
        this.pnlParams.add((Component)this.pnlVariable, "growy");
        this.pnlParams.add((Component)this.pnlType, "growy");
        this.pnlParams.add((Component)this.pnlEnable, "growy");
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlParams, "North");
        JScrollPane scroll = new JScrollPane(this.table);
        this.add((Component)scroll, "Center");
        scroll.addMouseListener(this.focuser);
        this.pnlParams.addMouseListener(this.focuser);
        this.table.getTableHeader().addMouseListener(this.focuser);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "none");
        IdeUtils.bindActions(this.table, editor.actions);
        this.setupTable();
    }

    public String getTitle() {
        return this.number + ": " + (this.var != null ? this.var.shortName() : "-- ");
    }

    public String getVarName() {
        return this.var != null ? this.var.shortName() : "--";
    }

    public String getEnableName() {
        return this.varEnable != null ? this.varEnable.shortName() : "--";
    }

    public String getType() {
        return this.strict ? "\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e" : "\u043f\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u044e";
    }

    public boolean isPresent() {
        return this.var != null;
    }

    public VariableRef getVar() {
        return this.var;
    }

    public VariableRef getVarEnable() {
        return this.varEnable;
    }

    public int getDigits() {
        return this.var != null && this.var.type() == 3 ? this.digits : 0;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isStrict() {
        return this.strict;
    }

    protected void markModified() {
        this.isModified = true;
        this.editor.markModified();
    }

    void setVarInCombo(JComboBox<VariableRef> combo, VariableRef var) {
        combo.setSelectedItem(null);
        combo.setSelectedItem(var);
    }

    public void updateVarList(List<VariableRef> varList, List<VariableRef> enList) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().cancelCellEditing();
        }
        this.inUpdate = true;
        try {
            this.cmbxVar.setModel(new DefaultComboBoxModel<VariableRef>(new Vector<VariableRef>(varList)));
            this.cmbxEnVar.setModel(new DefaultComboBoxModel<VariableRef>(new Vector<VariableRef>(enList)));
            this.setVarInCombo(this.cmbxVar, this.var);
            this.setVarInCombo(this.cmbxEnVar, this.varEnable);
        }
        finally {
            this.inUpdate = false;
        }
        this.updateData();
    }

    private void clearCells() {
        for (ScheduleCell[] cl : this.cells) {
            for (int i = 0; i < cl.length; ++i) {
                cl[i].clear();
            }
        }
    }

    String valueToString(double v) {
        return Utils.FormatDouble(v, this.getDigits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData(Schedule sch, VariablesEditor ved) {
        this.clearCells();
        if (sch != null) {
            this.var = ved.makeRef(sch.var);
            this.varEnable = ved.makeRef(sch.enabled);
            this.digits = sch.digits;
            this.min = sch.min;
            this.max = sch.max;
            this.strict = sch.strict;
            for (int day = 0; day < 7; ++day) {
                int[] times = sch.times[day];
                double[] values = sch.values[day];
                for (int i = 0; i < times.length; ++i) {
                    this.cells[day][i].load(times[i], values[i]);
                }
            }
        } else {
            this.varEnable = null;
            this.var = null;
            this.digits = 0;
            this.min = 0.0;
            this.max = 0.0;
            this.strict = false;
        }
        this.inUpdate = true;
        try {
            this.tfVarMin.setText(this.valueToString(this.min));
            this.tfVarMax.setText(this.valueToString(this.max));
            this.cmbxVarFloatFmt.setSelectedIndex(this.digits);
            if (this.strict) {
                this.rbTypeStrict.setSelected(true);
            } else {
                this.rbTypeEvent.setSelected(true);
            }
        }
        finally {
            this.inUpdate = false;
        }
        this.editor.refreshVarLists();
        this.updateVarList(this.editor.varList, this.editor.enableList);
        this.model.fireTableDataChanged();
    }

    public void compileData(Schedule sch, Program prg) throws SyntaxError {
        sch.var = this.var != null ? this.var.getCompiledVar() : null;
        sch.enabled = this.varEnable != null ? this.varEnable.getCompiledVar() : null;
        sch.digits = this.digits;
        sch.min = !Double.isNaN(this.min) ? this.min : 0.0;
        sch.max = !Double.isNaN(this.max) ? this.max : 0.0;
        sch.strict = this.strict;
        for (int day = 0; day < 7; ++day) {
            ScheduleCell[] cl = this.cells[day];
            int n = 0;
            for (int i = 0; i < cl.length; ++i) {
                if (cl[i].empty) continue;
                ++n;
            }
            sch.times[day] = new int[n];
            int[] times = sch.times[day];
            sch.values[day] = new double[n];
            double[] values = sch.values[day];
            n = 0;
            for (int i = 0; i < cl.length; ++i) {
                if (cl[i].empty) continue;
                times[n] = cl[i].makeTime();
                values[n] = cl[i].value;
                ++n;
            }
        }
    }

    void updateVarTooltip(JComboBox<VariableRef> combo, VariableRef var) {
        combo.setToolTipText(null);
        if (var != null && !Utils.strEmpty(var.varDef.getCommentHtml())) {
            combo.setToolTipText("<html>" + var.varDef.getCommentHtml() + "</html>");
        }
    }

    void updateData() {
        if (this.inUpdate) {
            return;
        }
        this.inUpdate = true;
        VariableRef var = (VariableRef)this.cmbxVar.getSelectedItem();
        this.updateVarTooltip(this.cmbxVar, var);
        VariableRef varEnable = (VariableRef)this.cmbxEnVar.getSelectedItem();
        this.updateVarTooltip(this.cmbxEnVar, varEnable);
        int digits = this.digits;
        double min = this.min;
        double max = this.max;
        boolean strict = this.strict;
        this.lblEnable.setVisible(varEnable == null);
        this.pnlVarFormat.setVisible(var != null);
        this.table.setVisible(var != null);
        if (var != null) {
            strict = this.rbTypeStrict.isSelected();
            boolean isFloat = var.type() == 3;
            this.lblVarStep.setVisible(isFloat);
            this.cmbxVarFloatFmt.setVisible(isFloat);
            if (isFloat) {
                digits = this.cmbxVarFloatFmt.getSelectedIndex();
            }
            boolean isBool = var.type() == 1;
            this.tfVarMin.setVisible(!isBool);
            this.tfVarMin0.setVisible(!this.tfVarMin.isVisible());
            this.lblVarMin.setEnabled(this.tfVarMin.isVisible());
            this.tfVarMax.setVisible(!isBool);
            this.tfVarMax1.setVisible(!this.tfVarMax.isVisible());
            this.lblVarMax.setEnabled(this.tfVarMax.isVisible());
            if (isBool) {
                this.tfVarMax1.setText("1");
            }
            if (!isBool) {
                min = Utils.StringToDouble(this.tfVarMin.getText());
                max = Utils.StringToDouble(this.tfVarMax.getText());
                if (!Double.isNaN(min) && !Double.isNaN(max) && max <= min) {
                    // empty if block
                }
            } else {
                min = 0.0;
                max = Utils.StringToDouble(this.tfVarMax1.getText());
            }
        }
        this.inUpdate = false;
        if (!VariableRef.sameVar(var, this.var) || !VariableRef.sameVar(varEnable, this.varEnable) || digits != this.digits || min != this.min || max != this.max || strict != this.strict) {
            this.markModified();
        }
        this.var = var;
        this.varEnable = varEnable;
        this.digits = digits;
        this.min = min;
        this.max = max;
        this.strict = strict;
        this.editor.tabbedPane.setTitleAt(this.number - 1, this.getTitle());
        this.model.fireTableDataChanged();
    }

    void updateSelList() {
        this.selList.clear();
        int[] rows = this.table.getSelectedRows();
        int[] columns = this.table.getSelectedColumns();
        for (int r : rows) {
            for (int c : columns) {
                if (!this.table.isCellSelected(r, c)) continue;
                this.selList.add(this.cells[c][r]);
            }
        }
    }

    List<ScheduleCell> getSelectedCells() {
        return this.selList;
    }

    private void showPopup(MouseEvent e, boolean doubleclick) {
        if ((e.isPopupTrigger() || doubleclick) && e.getComponent() == this.table) {
            this.table.requestFocusInWindow();
            int r = this.table.rowAtPoint(e.getPoint());
            int c = this.table.columnAtPoint(e.getPoint());
            if (r < 0 || c < 0) {
                return;
            }
            if (!this.table.isCellSelected(r, c)) {
                return;
            }
            this.focusedCol = c;
            this.focusedRow = r;
            if (this.selList.size() >= 0) {
                if (doubleclick) {
                    this.editor.actions.editProps.actionPerformed(null);
                } else {
                    this.editor.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    private void setupTable() {
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setAutoCreateRowSorter(false);
        this.table.setFillsViewportHeight(false);
        this.table.setAutoResizeMode(0);
        this.table.setSelectionMode(1);
        this.table.setCellSelectionEnabled(true);
        JTableHeader th = this.table.getTableHeader();
        th.setReorderingAllowed(false);
        th.setFont(th.getFont().deriveFont(1));
        this.cellRenderer = new SchedCellRenderer();
        this.table.setDefaultRenderer(ScheduleCell.class, this.cellRenderer);
        Dimension cs = this.cellRenderer.figureOutSize();
        this.table.setRowHeight(cs.height);
        TableColumnModel cm = this.table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn tc = cm.getColumn(i);
            tc.setPreferredWidth(cs.width);
            tc.setResizable(false);
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ScheduleTableView.this.updateSelList();
                ScheduleTableView.this.editor.actions.update();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                ScheduleTableView.this.showPopup(me, me.getClickCount() == 2);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScheduleTableView.this.showPopup(e, false);
            }
        });
    }

    public class SchedCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        int h;

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else {
                ScheduleCell c = (ScheduleCell)value;
                this.setText(c.empty ? "" : "<html>&ensp;" + c.getTimeString() + "&emsp;<b>" + ScheduleTableView.this.valueToString(c.value) + "</b></html>");
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (hasFocus) {
                ScheduleTableView.this.focusedRow = row;
                ScheduleTableView.this.focusedCol = col;
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            return this;
        }

        Dimension figureOutSize() {
            return new Dimension(140, 28);
        }
    }

    class ScheduleTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        ScheduleTableModel() {
        }

        @Override
        public int getRowCount() {
            return 12;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            return DAY_NAMES[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return ScheduleCell.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ScheduleTableView.this.cells[columnIndex][rowIndex];
        }
    }
}

