/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.schedule;

import certa.vics.ide.schedule.ScheduleTableView;

public class ScheduleCell {
    final ScheduleTableView table;
    final boolean isTemp;
    int hour;
    int minute;
    double value;
    boolean empty = true;

    public ScheduleCell(ScheduleTableView table, boolean isTemp) {
        this.table = table;
        this.isTemp = isTemp;
    }

    public void load(int time, double value) {
        this.hour = this.limit(time / 100, 0, 23);
        this.minute = this.limit(time % 100, 0, 59);
        this.value = value;
        this.empty = false;
    }

    private int limit(int src, int min, int max) {
        if (src > max) {
            return max;
        }
        if (src < min) {
            return min;
        }
        return src;
    }

    int makeTime() {
        return this.hour * 100 + this.minute;
    }

    String getTimeString() {
        return (this.hour < 10 ? "0" : "") + this.hour + ":" + (this.minute < 10 ? "0" : "") + this.minute;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public double getValue() {
        return this.value;
    }

    public void update(int newHour, int newMinute, double newValue) {
        if (this.empty || newHour != this.hour || newMinute != this.minute || newValue != this.value) {
            this.hour = newHour;
            this.minute = newMinute;
            this.value = newValue;
            this.empty = false;
            if (!this.isTemp) {
                this.table.markModified();
            }
        }
    }

    public void clear() {
        this.empty = true;
        this.hour = 0;
        this.minute = 0;
        this.value = 0.0;
    }
}

