/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.vics.Utils;
import certa.vics.compiler.ModbusSlaveProfile;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.MainFrame;
import certa.vics.ide.modbus.ModbusActions;
import certa.vics.ide.modbus.ModbusTableView;
import certa.vics.ide.modbus.RegView;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.json.JSONObject;

public class ModbusSlaveEditor
extends IdeEditor {
    private static final long serialVersionUID = 1L;
    public static final String[] PROFILES = new String[3];
    ModbusActions actions;
    protected final MainFrame mainFrame;
    final ModbusTableView[] inputs = new ModbusTableView[PROFILES.length];
    final ModbusTableView[] coils = new ModbusTableView[PROFILES.length];
    final ModbusTableView[] iregs = new ModbusTableView[PROFILES.length];
    final ModbusTableView[] hregs = new ModbusTableView[PROFILES.length];
    final ArrayList<ModbusTableView>[] tabs = new ArrayList[PROFILES.length];
    JComboBox<String> cbxProfile;
    JPanel cardPanel;
    int currentProfile = 0;
    JTabbedPane[] slaveTabbedPane = new JTabbedPane[PROFILES.length];
    static final String PROP_KEY = "modbus";
    private boolean inUpdate;
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ModbusSlaveEditor.this.updateData();
        }
    };
    DocumentListener masterEditUpdate = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            ModbusSlaveEditor.this.updateData();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ModbusSlaveEditor.this.updateData();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ModbusSlaveEditor.this.updateData();
        }
    };

    public ModbusSlaveEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 MODBUS", true);
        this.mainFrame = mainFrame;
        this.cbxProfile = new JComboBox<String>(new DefaultComboBoxModel<String>(PROFILES));
        this.cbxProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModbusSlaveEditor.this.updateProfile();
            }
        });
        this.toolBar.add(this.cbxProfile).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(MainFrame.instance.actions.connectModbus).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(MainFrame.instance.actions.exportModbus).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(MainFrame.instance.actions.modbusHelp).setFocusable(false);
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        for (int i = 0; i < PROFILES.length; ++i) {
            this.inputs[i] = new ModbusTableView(this, "INPUTS", true, false, "modbus.inputs", false);
            this.coils[i] = new ModbusTableView(this, "COILS", true, true, "modbus.coils", false);
            this.iregs[i] = new ModbusTableView(this, "INPUT REGS", false, false, "modbus.iregs", false);
            this.hregs[i] = new ModbusTableView(this, "HOLDING REGS", false, true, "modbus.hregs", false);
            this.slaveTabbedPane[i] = new JTabbedPane();
            this.tabs[i] = new ArrayList();
            this.addTab(i, this.inputs[i], "Inputs \u2116 " + (i + 1), "Read only 1-bit discretes");
            this.addTab(i, this.coils[i], "Coils \u2116 " + (i + 1), "Writable 1-bit discretes");
            this.addTab(i, this.iregs[i], "Input registers \u2116 " + (i + 1), "Read only 16-bit registers");
            this.addTab(i, this.hregs[i], "Holding registers \u2116 " + (i + 1), "Writable 16-bit registers");
            this.slaveTabbedPane[i].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ModbusSlaveEditor.this.initFocus();
                }
            });
            this.slaveTabbedPane[i].addMouseListener(this.focuser);
            this.cardPanel.add((Component)this.slaveTabbedPane[i], PROFILES[i]);
        }
        this.add((Component)this.cardPanel, "Center");
        this.loadProps();
    }

    public int getCurrentProfileIndex() {
        return this.currentProfile;
    }

    void setControls() {
        this.inUpdate = true;
        this.cbxProfile.setSelectedIndex(this.currentProfile);
        this.inUpdate = false;
    }

    void updateData() {
        if (this.inUpdate) {
            return;
        }
        this.updateVarRefs();
    }

    private void addTab(int index, ModbusTableView table, String title, String hint) {
        this.slaveTabbedPane[index].addTab(title, null, table, hint);
        this.tabs[index].add(table);
    }

    private void updateProfile() {
        if (this.inUpdate) {
            return;
        }
        int prof = this.cbxProfile.getSelectedIndex();
        if (prof != this.currentProfile) {
            this.currentProfile = prof;
            if (this.currentProfile < 0) {
                this.currentProfile = 0;
            }
            CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
            cardLayout.show(this.cardPanel, PROFILES[this.currentProfile]);
            this.updateControls();
            MainFrame.instance.actions.update();
        }
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new ModbusActions(this);
        return this.actions;
    }

    private void syncTabs(int index) {
        for (int i = 0; i < this.slaveTabbedPane.length; ++i) {
            if (i == this.currentProfile) continue;
            this.slaveTabbedPane[i].setSelectedIndex(index);
        }
    }

    @Override
    public void titleClicked() {
        int i;
        if (this.currentProfile >= 0 && (i = this.slaveTabbedPane[this.currentProfile].getSelectedIndex()) >= 0) {
            this.tabs[this.currentProfile].get((int)i).table.requestFocusInWindow();
            this.syncTabs(i);
        }
    }

    @Override
    public void initFocus() {
        int i;
        if (this.currentProfile >= 0 && (i = this.slaveTabbedPane[this.currentProfile].getSelectedIndex()) >= 0) {
            ModbusTableView t = this.tabs[this.currentProfile].get(i);
            t.table.requestFocusInWindow();
            t.updateVarList(this.mainFrame.getVarsEditor());
            this.syncTabs(i);
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < PROFILES.length; ++i) {
            this.inputs[i].loadRegs(null, null, null);
            this.coils[i].loadRegs(null, null, null);
            this.iregs[i].loadRegs(null, null, null);
            this.hregs[i].loadRegs(null, null, null);
        }
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
        for (int i = 0; i < PROFILES.length; ++i) {
            for (ModbusTableView t : this.tabs[i]) {
                t.isModified = false;
            }
        }
    }

    private void loadData() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        for (int i = 0; i < PROFILES.length; ++i) {
            ModbusSlaveProfile slave = this.mainFrame.program.slaveProfiles[i];
            this.inputs[i].loadRegs(slave, slave.Inputs, ved);
            this.coils[i].loadRegs(slave, slave.Coils, ved);
            this.iregs[i].loadRegs(slave, slave.IRs, ved);
            this.hregs[i].loadRegs(slave, slave.HRs, ved);
        }
        this.updateVarList();
        this.updateProfile();
    }

    @Override
    public void initNewProgram() {
        this.loadData();
        this.updateVarRefs();
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.loadData();
        this.updateVarRefs();
        this.markSavedToDisk();
    }

    Variable getCompiledVar(VariableRef vr, boolean writable, boolean needBool, boolean needInt, boolean needFloat) {
        if (vr == null) {
            return null;
        }
        if (writable && !vr.isWritableInFbd()) {
            return null;
        }
        if (vr.type() == 1 && !needBool) {
            return null;
        }
        if (vr.type() == 2 && !needInt) {
            return null;
        }
        if (vr.type() == 3 && !needFloat) {
            return null;
        }
        return vr.getCompiledVar();
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        for (int i = 0; i < PROFILES.length; ++i) {
            ModbusSlaveProfile slave = this.mainFrame.program.slaveProfiles[i];
            this.inputs[i].compileRegs(slave, 1);
            this.coils[i].compileRegs(slave, 2);
            this.iregs[i].compileRegs(slave, 3);
            this.hregs[i].compileRegs(slave, 4);
        }
    }

    private void loadProps() {
    }

    @Override
    public void saveProps() {
    }

    public void updateSlaveVarRefs() {
        for (int i = 0; i < PROFILES.length; ++i) {
            for (ModbusTableView t : this.tabs[i]) {
                for (RegView r : t.list) {
                    if (r.var == null) continue;
                    r.var.varDef.addModbusRef(r, t.isWritable);
                }
            }
        }
    }

    @Override
    public void updateVarRefs() {
        this.mainFrame.getPortsEditor().updateVarRefs();
    }

    void setVarInCombo(JComboBox<VariableRef> combo, VariableRef var) {
        combo.setSelectedItem(null);
        combo.setSelectedItem(var);
    }

    @Override
    public void updateVarList() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        for (int i = 0; i < PROFILES.length; ++i) {
            for (ModbusTableView t : this.tabs[i]) {
                t.updateVarList(ved);
                t.model.fireTableDataChanged();
            }
        }
        this.setControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportText(File file, int profileIndex) {
        MainFrame.instance.startWaitCursor();
        try {
            try (PrintWriter pw = new PrintWriter(file, "UTF-8");){
                String prgName = Utils.clearFileExt(MainFrame.instance.getCurrentFile().getName(), "vics-fbd");
                pw.println("<!DOCTYPE html>");
                pw.println("<head>");
                pw.println("<meta charset=\"utf-8\" />");
                pw.println("<title>" + prgName + ", MODBUS profile #" + (profileIndex + 1) + "</title>");
                pw.println("<style>");
                pw.println("body {padding: 1em;}");
                pw.println("table {border-collapse: collapse; table-layout:fixed;}");
                pw.println("table, th, td {border: 1px solid black;}");
                pw.println("th, td {padding: 0.2em 1em; vertical-align: middle;}");
                pw.println("</style>");
                pw.println("</head>");
                pw.println("<body>");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                pw.println("<h1>" + prgName + ", MODBUS profile #" + (profileIndex + 1) + "</h1>");
                pw.println("<p>" + dateFormat.format(new Date()));
                pw.println("<p style='font-family:monospace'>" + MainFrame.instance.program.comment.replace("\n", "<br>"));
                pw.println("<h2>Discrete inputs <small>(read function: 2)</small></h2>");
                this.inputs[profileIndex].printData(pw, false, false);
                pw.println("<h2>Coils <small>(read function: 1, write function: 5)</small></h2>");
                this.coils[profileIndex].printData(pw, false, true);
                pw.println("<h2>Input registers <small>(read function: 4)</small></h2>");
                this.iregs[profileIndex].printData(pw, true, false);
                pw.println("<h2>Holding registers <small>(read function: 3, write function: 6)</small></h2>");
                this.hregs[profileIndex].printData(pw, true, true);
                pw.println("</body>");
                pw.println("</html>");
            }
            catch (Exception e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getSimpleName(), 0);
            }
        }
        finally {
            MainFrame.instance.stopWaitCursor();
        }
    }

    static {
        for (int i = 0; i < PROFILES.length; ++i) {
            ModbusSlaveEditor.PROFILES[i] = "\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u2116 " + (i + 1);
        }
    }
}

