/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeAction;
import certa.vics.ide.MainFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.im.InputContext;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class IdeUtils {
    public static boolean confirmDialog(Object msg) {
        return JOptionPane.showConfirmDialog(null, msg, "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", 0) == 0;
    }

    public static void bindActions(JComponent c, ActionsBundle actions) {
        InputMap imap = c.getInputMap();
        ActionMap amap = c.getActionMap();
        for (IdeAction a : actions.list) {
            if (a.accelerator == null) continue;
            imap.put(a.accelerator, a);
            amap.put(a, a);
        }
    }

    public static void setupDivider(JSplitPane split) {
        split.setBorder(null);
        split.setDividerSize(8);
        SplitPaneUI ui = split.getUI();
        if (ui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)ui).getDivider().setBorder(null);
        }
    }

    public static JComponent addMargins(JComponent c, int top, int left, int bottom, int right) {
        c.setBorder(new CompoundBorder(new EmptyBorder(top, left, bottom, right), c.getBorder()));
        return c;
    }

    public static JToolBar newToolBar() {
        JToolBar tb = new JToolBar(){
            private static final long serialVersionUID = 1L;

            @Override
            public void addSeparator() {
                this.addSeparator(new Dimension(16, 28));
            }
        };
        tb.setFloatable(false);
        tb.setRollover(true);
        tb.setLayout(new FlowLayout(0, 0, 0));
        return tb;
    }

    public static JButton newPopupButton(final JPopupMenu popup, String imageFile, String toolTip) {
        JButton button = new JButton();
        button.setFocusable(false);
        button.setIcon(Utils.loadImageIcon(imageFile));
        button.setToolTipText(toolTip);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        return button;
    }

    public static MouseListener createOnClickFocuser(final Component target) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                target.requestFocusInWindow();
            }
        };
    }

    public static void setColumnOrder(TableColumnModel columnModel, int[] indices) {
        int i;
        if (columnModel.getColumnCount() != indices.length) {
            throw new IllegalArgumentException("Indices count != columns count");
        }
        TableColumn[] column = new TableColumn[indices.length];
        for (i = 0; i < column.length; ++i) {
            column[i] = columnModel.getColumn(indices[i]);
        }
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        for (i = 0; i < column.length; ++i) {
            columnModel.addColumn(column[i]);
        }
    }

    public static class IdeDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public IdeDialog(JFrame parent, String title) {
            super(parent, title, true);
        }

        @Override
        public InputContext getInputContext() {
            return MainFrame.instance.getInputContext();
        }
    }

    public static abstract class BorderedPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected JPanel bar;
        protected JLabel text;
        protected JPanel contents;
        protected MyLineBorder border;
        protected MouseListener focuser = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.titleClicked();
            }
        };
        private static BorderedPanel focusedPanel;

        public BorderedPanel(JPanel contents, String title) {
            super(new BorderLayout());
            this.border = new MyLineBorder();
            this.contents = contents;
            this.bar = new JPanel(new FlowLayout(0, 4, 0));
            this.text = new JLabel(title);
            this.bar.add(this.text);
            super.add((Component)this.bar, "First");
            super.add((Component)contents, "Center");
            this.setBorder(this.border);
            this.unfocus();
            this.bar.addMouseListener(this.focuser);
            contents.addMouseListener(this.focuser);
        }

        public void setContentsVisible(boolean visible) {
            this.contents.setVisible(visible);
        }

        public void titleClicked() {
        }

        protected abstract void focusChanged();

        @Override
        public void add(Component comp, Object constraints) {
            this.contents.add(comp, constraints);
        }

        public void setTitle(String text) {
            this.text.setText(text);
        }

        private void unfocus() {
            this.bar.setBackground(SystemColor.inactiveCaption);
            this.border.setLineColor(SystemColor.inactiveCaptionBorder);
            this.text.setForeground(SystemColor.inactiveCaptionText);
        }

        public void updateFocus(Component focusOwner) {
            if (this.contents.isAncestorOf(focusOwner) && focusedPanel != this) {
                BorderedPanel prev = focusedPanel;
                focusedPanel = this;
                this.bar.setBackground(SystemColor.activeCaption);
                this.border.setLineColor(SystemColor.activeCaption);
                this.text.setForeground(SystemColor.activeCaptionText);
                if (prev != null) {
                    prev.unfocus();
                    prev.focusChanged();
                }
                this.focusChanged();
            }
        }

        public boolean isFocused() {
            return focusedPanel == this;
        }
    }

    static class MyLineBorder
    extends LineBorder {
        private static final long serialVersionUID = 1L;

        public MyLineBorder() {
            super(Color.BLACK, 1);
        }

        public void setLineColor(Color color) {
            this.lineColor = color;
        }
    }
}

