/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.VariablesBlock;

public class Variable {
    public static final int TYPE_BOOL = 1;
    public static final int TYPE_INT = 2;
    public static final int TYPE_FLOAT = 3;
    public final boolean hidden;
    public final String name;
    public final String arrayName;
    public final int type;
    public final boolean alarm;
    protected int offset;
    public final VariablesBlock block;
    public final Variable[] arrayItems;
    public final Variable arraySizeVar;
    public final Variable arrayStart;
    public final int indexInArray;
    public String comment = "";
    public double initValue = Double.NaN;
    private String fullName;
    private String fullArrayName;
    private String fullArrayNameSize;
    private static int sizeCounter = 0;

    public Variable(boolean hidden, String name, int type, boolean alarm, int offset, VariablesBlock block, Variable arrayStart, int indexInArray, int arraySize, VariablesBlock constBlock) throws SyntaxError {
        this.hidden = hidden;
        this.type = type;
        this.alarm = alarm;
        this.offset = offset;
        this.block = block;
        if (arraySize > 0) {
            this.name = name + "[0]";
            this.arrayName = name;
            this.fullName = block.name + "." + Variable.typeToString(type) + "." + this.name;
            this.fullArrayName = block.name + "." + Variable.typeToString(type) + "." + this.arrayName;
            this.fullArrayNameSize = block.name + "." + Variable.typeToString(type) + "." + this.arrayName + "{" + arraySize + "}";
            block.registerVariable(this);
            this.arrayItems = new Variable[arraySize];
            this.arrayItems[0] = this;
            for (int i = 1; i < arraySize; ++i) {
                this.arrayItems[i] = block.createArrayItemVar(this, i);
            }
            this.arraySizeVar = new Variable(true, "__arraySize" + sizeCounter++, 2, false, constBlock.getSize(), constBlock, this, -1, 0, null);
            this.arraySizeVar.initValue = arraySize;
            this.arrayStart = this;
            this.indexInArray = 0;
        } else {
            this.name = name;
            this.arrayName = name;
            this.fullName = arrayStart != null && indexInArray < 0 ? arrayStart.fullArrayName + ".size" : block.name + "." + Variable.typeToString(type) + "." + this.name;
            this.fullArrayName = this.fullName;
            this.fullArrayNameSize = this.fullName;
            block.registerVariable(this);
            this.arrayItems = null;
            this.arraySizeVar = null;
            this.arrayStart = arrayStart;
            this.indexInArray = indexInArray;
        }
    }

    public String fullName() {
        return this.fullName;
    }

    public String arrayName() {
        return this.arrayName;
    }

    public String fullArrayName() {
        return this.fullArrayName;
    }

    public String fullArrayNameSize() {
        return this.fullArrayNameSize;
    }

    public boolean hasInitValue() {
        return !Double.isNaN(this.initValue) && !Double.isInfinite(this.initValue);
    }

    public boolean hasRamInitValue() {
        return !Double.isNaN(this.initValue) && !Double.isInfinite(this.initValue) && this.initValue != 0.0;
    }

    public boolean isArray() {
        return this.arrayItems != null;
    }

    public int arraySize() {
        if (this.arrayItems != null) {
            return this.arrayItems.length;
        }
        return 0;
    }

    public String toString() {
        if (this.arrayItems != null) {
            return this.fullName + " (size: " + this.arrayItems.length + ")";
        }
        return this.fullName;
    }

    public static String typeToString(int type) {
        if (type == 1) {
            return "b";
        }
        if (type == 2) {
            return "i";
        }
        if (type == 3) {
            return "f";
        }
        return "?";
    }

    public static String typeToUpperString(int type) {
        if (type == 1) {
            return "B";
        }
        if (type == 2) {
            return "I";
        }
        if (type == 3) {
            return "F";
        }
        return "?";
    }

    public static int stringToType(String s) {
        if (s.equalsIgnoreCase("b")) {
            return 1;
        }
        if (s.equalsIgnoreCase("i")) {
            return 2;
        }
        if (s.equalsIgnoreCase("f")) {
            return 3;
        }
        return 0;
    }

    public int getSize() {
        if (this.type == 1) {
            return 1;
        }
        if (this.type == 2) {
            return 2;
        }
        return 4;
    }

    public int getAddress() {
        return this.offset + this.block.startAddress;
    }

    public int fillInitValue(byte[] buf, int offset) {
        double v;
        double d = v = this.hasInitValue() ? this.initValue : 0.0;
        if (this.type == 3) {
            return Program.fillWord32(Float.floatToIntBits((float)v), buf, offset);
        }
        if (this.type == 2) {
            return Program.fillWord((int)Math.round(v), buf, offset);
        }
        return Program.fillByte((int)Math.round(v), buf, offset);
    }

    public static class NameParser {
        public final String domain;
        public final int type;
        public final String name;

        public NameParser(String fullName) throws SyntaxError {
            int i1 = fullName.indexOf(46);
            int i2 = fullName.indexOf(46, i1 + 1);
            if (i1 <= 0 || i2 != i1 + 2 || i2 > fullName.length() - 2) {
                throw new SyntaxError("Invalid variable name: \"" + fullName + "\"");
            }
            this.domain = fullName.substring(0, i1);
            this.type = Variable.stringToType(fullName.substring(i1 + 1, i2));
            if (this.type == 0) {
                throw new SyntaxError("Invalid variable type: \"" + fullName + "\"");
            }
            this.name = fullName.substring(i2 + 1);
            if (this.name.contains(" ")) {
                throw new SyntaxError("Variable name contains spaces: \"" + fullName + "\"");
            }
        }
    }
}

