/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import java.util.ArrayList;

public class ModbusMasterRequest {
    protected String varCmdStr;
    protected String varResultStr;
    protected String varErrCountStr;
    public Variable varCmd;
    public Variable varResult;
    public Variable varErrCount;
    public int func;
    public int id;
    public int addr;
    public final ArrayList<ModbusReg> registers = new ArrayList();

    public ModbusMasterRequest(int func, int id, int addr, String cmdVar, String resultVar, String errCountVar) {
        this.varCmdStr = cmdVar;
        this.varResultStr = resultVar;
        this.varErrCountStr = errCountVar;
        this.func = func;
        this.id = id;
        this.addr = addr;
    }

    public ModbusMasterRequest(int func, int id, int addr, Variable cmdVar, Variable resultVar, Variable errCountVar) {
        this.varCmd = cmdVar;
        this.varResult = resultVar;
        this.varErrCount = errCountVar;
        this.func = func;
        this.id = id;
        this.addr = addr;
    }

    protected void resolve(Program prg) throws SyntaxError {
        if (this.varCmd == null && !Utils.strEmpty(this.varCmdStr)) {
            this.varCmd = prg.locateVar(this.varCmdStr);
            if (this.varCmd.type != 1) {
                throw new SyntaxError("Invalid variable type for request command (must be bool)");
            }
        }
        if (this.varResult == null && !Utils.strEmpty(this.varResultStr)) {
            this.varResult = prg.locateVar(this.varResultStr);
            if (this.varResult.type != 1) {
                throw new SyntaxError("Invalid variable type for request result (must be bool)");
            }
        }
        if (this.varErrCount == null && !Utils.strEmpty(this.varErrCountStr)) {
            this.varErrCount = prg.locateVar(this.varErrCountStr);
            if (this.varErrCount.type != 2) {
                throw new SyntaxError("Invalid variable type for request errors counter (must be integer)");
            }
        }
        this.varCmdStr = null;
        this.varResultStr = null;
        this.varErrCountStr = null;
        int i = 0;
        for (ModbusReg r : this.registers) {
            r.resolve("reg" + i++, prg);
        }
    }

    protected void allocVar(Variable var, int digits) {
        int addr = this.addr + this.registers.size();
        if (addr < 0 || addr > 65535) {
            throw new IndexOutOfBoundsException("Invalid register address: " + addr);
        }
        this.registers.add(new ModbusReg(var, digits));
    }

    protected void allocUnresolved(String var, int digits) throws SyntaxError {
        int addr = this.addr + this.registers.size();
        if (addr < 0 || addr > 65535) {
            throw new IndexOutOfBoundsException("Invalid register address: " + addr);
        }
        this.registers.add(new ModbusReg(var, digits));
    }

    public int normalRegsCount() {
        return Math.min(this.maxSize(), this.registers.size());
    }

    public int getFlashSize() {
        int s = this.normalRegsCount();
        if (s > 0) {
            return 14 + s * 3;
        }
        return 0;
    }

    public int maxSize() {
        if (this.func == 1 || this.func == 2 || this.func == 15) {
            return 256;
        }
        if (this.func == 3 || this.func == 4 || this.func == 16) {
            return 125;
        }
        if (this.func == 5 || this.func == 6) {
            return 1;
        }
        return 0;
    }

    protected int fillFlash(byte[] buf, int offset) throws SyntaxError {
        if (this.getFlashSize() == 0) {
            return offset;
        }
        offset = Program.fillWord(this.getFlashSize(), buf, offset);
        offset = Program.fillWord(this.varCmd != null ? this.varCmd.getAddress() : 0, buf, offset);
        offset = Program.fillWord(this.varResult != null ? this.varResult.getAddress() : 0, buf, offset);
        offset = Program.fillWord(this.varErrCount != null ? this.varErrCount.getAddress() : 0, buf, offset);
        offset = Program.fillByte((byte)this.func, buf, offset);
        offset = Program.fillByte((byte)this.id, buf, offset);
        offset = Program.fillWord(this.addr, buf, offset);
        int count = this.normalRegsCount();
        offset = Program.fillWord(count, buf, offset);
        for (int i = 0; i < count; ++i) {
            ModbusReg r = this.registers.get(i);
            int addr = 0;
            int type = 0;
            if (r.var != null) {
                addr = r.var.getAddress();
                type = Program.varTypeEncode(r.var.type, r.digits);
            }
            offset = Program.fillWord(addr, buf, offset);
            offset = Program.fillByte((byte)type, buf, offset);
        }
        return offset;
    }
}

