/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.ModbusMasterRequest;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import java.util.ArrayList;

public class ModbusMasterProfile {
    public static final int DEF_TIMEOUT = 400;
    public static final int DEF_PAUSE = 100;
    public int timeout = 400;
    public int pause = 100;
    public final ArrayList<ModbusMasterRequest> requests = new ArrayList();
    private ModbusMasterRequest req;

    public void clear() {
        this.requests.clear();
    }

    protected void resolveLinks(Program prg) throws SyntaxError {
        for (ModbusMasterRequest r : this.requests) {
            r.resolve(prg);
        }
    }

    public void allocUnresolvedRequest(int func, int id, int address, String varCmd, String varResult, String varErrCount) {
        this.req = new ModbusMasterRequest(func, id, address, varCmd, varResult, varErrCount);
        this.requests.add(this.req);
    }

    public void allocRequest(int func, int id, int address, Variable varCmd, Variable varResult, Variable varErrCount) {
        this.req = new ModbusMasterRequest(func, id, address, varCmd, varResult, varErrCount);
        this.requests.add(this.req);
    }

    public void allocUnresolvedVar(String var, int digits) throws SyntaxError {
        this.req.allocUnresolved(var, digits);
    }

    public void allocVar(Variable var, int digits) {
        this.req.allocVar(var, digits);
    }

    public int getFlashSize() {
        int size = 8;
        for (ModbusMasterRequest r : this.requests) {
            size += r.getFlashSize();
        }
        return size;
    }

    public int fillFlash(boolean gateway, byte[] buf, int offset) throws SyntaxError {
        int rcount = 0;
        for (ModbusMasterRequest r : this.requests) {
            if (r.getFlashSize() <= 0) continue;
            ++rcount;
        }
        offset = Program.fillByte(1, buf, offset);
        offset = Program.fillByte(gateway ? 1 : 0, buf, offset);
        offset = Program.fillWord(rcount, buf, offset);
        offset = Program.fillWord(this.timeout, buf, offset);
        offset = Program.fillWord(this.pause, buf, offset);
        for (int i = 0; i < this.requests.size(); ++i) {
            offset = this.requests.get(i).fillFlash(buf, offset);
        }
        return offset;
    }
}

