/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import java.util.ArrayList;

public class MenuString {
    public static char STRINGS_LIST_SEPARATOR_CHAR = (char)65073;
    private static final String table1 = "\u2302\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f";
    private static final String table2 = "\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0401\u0451\u0404\u0454\u0407\u0457\u040e\u045e\u00b0\u2219\u00b7\u221a\u2116\u00a4\u25a0\u00a0";

    private MenuString() {
    }

    static byte utf8CharToCP866(char c) {
        if (c <= '~') {
            return (byte)c;
        }
        int i = table1.indexOf(c);
        if (i >= 0) {
            return (byte)(127 + i);
        }
        i = table2.indexOf(c);
        if (i >= 0) {
            return (byte)(224 + i);
        }
        if (c == '\u0406') {
            return 73;
        }
        if (c == '\u0456') {
            return 105;
        }
        return 63;
    }

    public static int compileToCP866(String s, byte[] buffer, int offset) {
        if (Utils.strEmpty(s)) {
            s = "_";
        }
        s = MenuString.makeNormal(s);
        buffer[offset++] = (byte)s.length();
        for (int i = 0; i < s.length(); ++i) {
            buffer[offset++] = MenuString.utf8CharToCP866(s.charAt(i));
        }
        return offset;
    }

    public static String makeSaveable(String str) {
        if (Utils.strEmpty(str)) {
            return "_";
        }
        return str.trim().replace(' ', '_');
    }

    public static String makeNormal(String str) {
        if (Utils.strEmpty(str)) {
            return "";
        }
        return str.replace('_', ' ').trim();
    }

    public static int compiledSize(String s) {
        return Utils.strEmpty(s) ? 2 : s.length() + 1;
    }

    public static String saveStrings(ArrayList<String> list) {
        String res = "";
        for (int i = 0; i < list.size(); ++i) {
            if (res.length() > 0) {
                res = res + STRINGS_LIST_SEPARATOR_CHAR;
            }
            res = res + MenuString.makeSaveable(list.get(i));
        }
        if (Utils.strEmpty(res)) {
            res = "_";
        }
        return res;
    }

    public static void parseStrings(String src, ArrayList<String> list) {
        list.clear();
        String[] tokens = src.split("" + STRINGS_LIST_SEPARATOR_CHAR);
        if (tokens != null) {
            for (int i = 0; i < tokens.length; ++i) {
                list.add(MenuString.makeNormal(tokens[i]));
            }
        }
    }
}

