/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.compiler.AMenuItem;
import certa.vics.compiler.CompilerError;
import certa.vics.compiler.MenuItemMenu;
import certa.vics.compiler.MenuString;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import java.util.ArrayList;

public class MenuItemVariable
extends AMenuItem {
    public final boolean isText;
    public final ArrayList<String> textStrings = new ArrayList(0);
    private Variable variable;
    private String varName;
    private boolean isWritable;
    private int numDigits;
    private int numMin;
    private int numMax;

    public MenuItemVariable(MenuItemMenu parent, int access, String name, boolean isText) {
        super(parent, access, name);
        this.isText = isText;
    }

    public void parseStrings(String src) {
        MenuString.parseStrings(src, this.textStrings);
    }

    public String saveStrings() {
        return MenuString.saveStrings(this.textStrings);
    }

    public int getNumMin() {
        return this.numMin;
    }

    public void setNumMin(int numMin) {
        this.numMin = numMin;
    }

    public int getNumMax() {
        return this.numMax;
    }

    public void setNumMax(int numMax) {
        this.numMax = numMax;
    }

    public int getNumDigits() {
        return this.numDigits;
    }

    public void setNumDigits(int numDigits) {
        this.numDigits = numDigits;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public void setWritable(boolean isWritable) {
        this.isWritable = isWritable;
    }

    @Override
    public void resolveLinks(Program program) throws SyntaxError {
        if (this.variable == null && !Utils.strEmpty(this.varName)) {
            this.variable = program.locateVar(this.varName);
        }
        if (this.variable != null) {
            program.menuVars.addVar(this.variable);
        }
    }

    @Override
    public String getDisplayName() {
        String s = super.getName();
        if (Utils.strEmpty(s) && this.variable != null) {
            return this.variable.name;
        }
        return s;
    }

    @Override
    public void compileStrings(Program prg) throws CompilerError {
        super.compileStrings(prg);
        if (this.isText) {
            prg.menuStrings.compileStrings(this.textStrings);
        }
    }

    @Override
    public int compile(Program prg, byte[] buffer, int offset) throws CompilerError {
        int newOffset = super.compile(prg, buffer, offset);
        if (buffer != null) {
            int reg;
            if (this.variable == null) {
                throw new CompilerError("Cannot compile NULL variable");
            }
            int varType = 0;
            if (this.variable.type == 1) {
                varType = 1;
            } else if (this.variable.type == 2) {
                varType = 2;
            } else if (this.variable.type == 3) {
                varType = 3;
            }
            int txtAddr = 0;
            int len = this.numDigits;
            if (this.isText) {
                txtAddr = prg.menuStrings.getStringsAddress(this.textStrings);
                len = this.textStrings.size();
                this.numMin = 0;
                int n = this.numMax = len > 0 ? len - 1 : 0;
            }
            if ((reg = prg.menuVars.getVarRegNumber(this.variable)) <= 0) {
                throw new CompilerError("MenuItemVariable compile error (1)");
            }
            if (this.getHeaderSize() != 5) {
                throw new CompilerError("MenuItemVariable compile error (2)");
            }
            buffer[offset + 5] = (byte)((varType & 0x3F) << 1 | (this.isWritable ? 1 : 0));
            buffer[offset + 6] = (byte)len;
            buffer[offset + 7] = (byte)txtAddr;
            buffer[offset + 8] = (byte)(txtAddr >> 8);
            buffer[offset + 9] = (byte)reg;
            buffer[offset + 10] = (byte)(reg >> 8);
            buffer[offset + 11] = 0;
            buffer[offset + 12] = 0;
            buffer[offset + 13] = 0;
            buffer[offset + 14] = 0;
            if (this.isWritable) {
                if (newOffset - offset != 23) {
                    throw new CompilerError("MenuItemVariable compile error (3)");
                }
                buffer[offset + 15] = (byte)this.numMin;
                buffer[offset + 16] = (byte)(this.numMin >> 8);
                buffer[offset + 17] = (byte)(this.numMin >> 16);
                buffer[offset + 18] = (byte)(this.numMin >> 24);
                buffer[offset + 19] = (byte)this.numMax;
                buffer[offset + 20] = (byte)(this.numMax >> 8);
                buffer[offset + 21] = (byte)(this.numMax >> 16);
                buffer[offset + 22] = (byte)(this.numMax >> 24);
            } else if (newOffset - offset != 15) {
                throw new CompilerError("MenuItemVariable compile error (4)");
            }
        }
        return newOffset;
    }

    @Override
    public int getSize() {
        return this.isWritable ? 23 : 15;
    }

    @Override
    public int getBinaryType() {
        return 2;
    }
}

