/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.server;

import certa.modbus.server.AModbusServer;
import certa.modbus.server.ModbusTcpServerConnection;
import certa.modbus.server.RequestProcessor;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcpServer
extends AModbusServer
implements Runnable {
    public static final int MAX_CONNECTIONS = 10;
    private final String localAddressString;
    private final int localPort;
    private final int clientTimeout;
    private AtomicBoolean active = new AtomicBoolean(false);
    private Thread thread;
    private List<ModbusTcpServerConnection> connections = new ArrayList<ModbusTcpServerConnection>(10);
    private volatile ServerSocket serverSocket;

    public ModbusTcpServer(String localIP, int localPort, int clientTimeout, int inputsStart, int inputsCount, int coilsStart, int coilsCount, int iregsStart, int iregsCount, int hregsStart, int hregsCount, RequestProcessor processor) {
        super(inputsStart, inputsCount, coilsStart, coilsCount, iregsStart, iregsCount, hregsStart, hregsCount, processor);
        this.localAddressString = localIP != null ? localIP : "0.0.0.0";
        this.localPort = localPort;
        this.clientTimeout = clientTimeout;
    }

    @Override
    public void Start() {
        if (!this.active.getAndSet(true)) {
            this.log.info("Starting server");
            this.thread = new Thread(null, this);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    @Override
    public void Stop() {
        if (this.active.getAndSet(false)) {
            this.log.info("Stopping server");
            this.thread.interrupt();
            this.closeSocket();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.thread = null;
        }
    }

    private void closeSocket() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception e) {
            this.log.error("EXCEPTION in serverSocket.close()", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 12[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptConnection(Socket socket) throws SocketException {
        socket.setSoTimeout(this.clientTimeout);
        List<ModbusTcpServerConnection> list = this.connections;
        synchronized (list) {
            if (this.connections.size() < 10) {
                this.connections.add(new ModbusTcpServerConnection(this, socket));
            } else {
                this.log.warn("Too many connections");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterConnection(ModbusTcpServerConnection conn) {
        List<ModbusTcpServerConnection> list = this.connections;
        synchronized (list) {
            this.connections.remove(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections() {
        List<ModbusTcpServerConnection> list = this.connections;
        synchronized (list) {
            for (ModbusTcpServerConnection c : this.connections) {
                c.close();
            }
        }
    }

    @Override
    protected Logger getLog() {
        return LoggerFactory.getLogger(ModbusTcpServer.class);
    }
}

