/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.tools;

import certa.modbus.client.ModbusClientTransport;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.Variable;
import certa.vics.modbus.VicsModbusClient;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flash {
    private static final Logger log = LoggerFactory.getLogger(Flash.class);
    public final Program program;
    private ProgressListener listener;
    private int step;

    public Flash(Program program) {
        this.program = program;
    }

    public void writeProgram(String comPort, int id, int password) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashBinaryData(ModbusClientTransport transport, int id, int password) throws Exception {
        if (this.program == null || this.program.device == null) {
            return;
        }
        try (VicsModbusClient mc = new VicsModbusClient();){
            mc.setTransport(transport);
            this.clearApplication(mc, id);
            this.writeFlash(mc, id);
            this.writeIntEeprom(mc, id);
            this.writeNvRam(mc, id);
            this.writeExtEeprom(mc, id);
            this.rebootDevice(mc, id);
        }
    }

    private void clearApplication(VicsModbusClient mc, int id) throws Exception {
        if (mc == null) {
            this.step += 2;
            return;
        }
        log.info("Get device info");
        mc.InitReadAInputsRequest(id, 6000, 2);
        if (mc.execRequest()) {
            this.notifyStep();
            int model = mc.getResponseRegister(6000, true);
            int fw = mc.getResponseRegister(6001, true) / 100;
            log.info("Model: {}, firmware: {}", (Object)model, (Object)fw);
            if (model != this.program.device.ModelId) {
                throw new Exception("Incompatible device");
            }
            if (fw != this.program.device.Firmware) {
                throw new Exception("Incompatible firmware");
            }
            log.info("Clear application");
            mc.InitWriteRegisterRequest(id, 7000, 18546);
            if (!mc.execRequest()) {
                throw new Exception(mc.getResultAsString());
            }
        } else {
            throw new Exception(mc.getResultAsString());
        }
        this.notifyStep();
        log.info("OK");
    }

    private void rebootDevice(VicsModbusClient mc, int id) throws Exception {
        if (mc == null) {
            ++this.step;
            return;
        }
        log.info("Reboot device");
        mc.InitWriteRegisterRequest(id, 7000, 369);
        mc.execRequest(true);
        this.notifyStep();
        Thread.sleep(2000L);
    }

    private int chunksCount(int bytesCount) {
        int i = bytesCount / 244;
        if (bytesCount % 244 > 0) {
            ++i;
        }
        return i;
    }

    private void writeChunk(VicsModbusClient mc, int id, byte[] data, int chunk, int startAddr, int memType, int dataSize) throws Exception {
        if (mc == null) {
            ++this.step;
            return;
        }
        int addr = chunk * 244;
        byte[] cdata = Arrays.copyOfRange(data, addr, addr + Math.min(244, dataSize - addr));
        mc.InitWriteMemRequest(id, this.program.device.ModelId, this.program.device.Firmware, memType, addr += startAddr, cdata.length, cdata);
        if (!mc.execRequest()) {
            throw new Exception(mc.getResultAsString());
        }
        this.notifyStep();
    }

    public void writeFlash(VicsModbusClient mc, int id) throws Exception {
        for (int i = 0; i < this.chunksCount(this.program.flash.length); ++i) {
            this.writeChunk(mc, id, this.program.flash, i, 0, 3, this.program.flash.length);
        }
    }

    public void writeIntEeprom(VicsModbusClient mc, int id) throws Exception {
        byte[] buf = new byte[32];
        for (Variable v : this.program.device.SysStoreVars.map.values()) {
            if (Double.isNaN(v.initValue)) continue;
            this.writeChunk(mc, id, buf, 0, v.getAddress() & 0x3FFF, 1, v.fillInitValue(buf, 0));
        }
        for (int i = 0; i < this.chunksCount(this.program.eeprom.length); ++i) {
            this.writeChunk(mc, id, this.program.eeprom, i, this.program.EepromVars.startAddress & 0x3FFF, 1, this.program.eeprom.length);
        }
    }

    public void writeNvRam(VicsModbusClient mc, int id) throws Exception {
        byte[] buf = new byte[32];
        for (Variable v : this.program.device.SysExtVars.map.values()) {
            if (Double.isNaN(v.initValue)) continue;
            this.writeChunk(mc, id, buf, 0, v.getAddress() & 0x3FFF, 2, v.fillInitValue(buf, 0));
        }
        for (int i = 0; i < this.chunksCount(this.program.nvram.length); ++i) {
            this.writeChunk(mc, id, this.program.nvram, i, this.program.NvramVars.startAddress & 0x3FFF, 2, this.program.nvram.length);
        }
    }

    public void writeExtEeprom(VicsModbusClient mc, int id) throws Exception {
        if (!this.program.hasSchedule()) {
            return;
        }
        int block = 512;
        for (int i = 0; i < this.program.Schedules.items.length; ++i) {
            Schedule s = this.program.Schedules.items[i];
            if (s.var == null) continue;
            byte[] data = Arrays.copyOfRange(this.program.Schedules.eeprom, block * i, block * (i + 1));
            for (int j = 0; j < this.chunksCount(block); ++j) {
                this.writeChunk(mc, id, data, j, this.program.device.ExtEepromScheduleStart + block * i, 4, block);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getWriteStepsCount() {
        int res;
        int tmp = this.step;
        this.step = 0;
        try {
            try {
                this.clearApplication(null, 0);
                this.writeFlash(null, 0);
                this.writeIntEeprom(null, 0);
                this.writeNvRam(null, 0);
                this.writeExtEeprom(null, 0);
                this.rebootDevice(null, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            res = this.step;
            this.step = tmp;
        }
        return res;
    }

    public int getReadStepsCount() {
        return 10;
    }

    public void registerProgListener(ProgressListener listener) {
        this.listener = listener;
    }

    public int initWriteProgress() {
        return this.getWriteStepsCount();
    }

    public int initReadProgress() {
        return this.getReadStepsCount();
    }

    private void notifyStep() {
        ++this.step;
        if (this.listener != null) {
            this.listener.updateStep(this.step);
        }
    }

    public static interface ProgressListener {
        public void updateStep(int var1);
    }
}

