/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.variables;

import certa.vics.Utils;
import certa.vics.compiler.Program;
import certa.vics.ide.DialogErrorLabel;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.ide.variables.VariableDef;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class SysVariableDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static SysVariableDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JLabel lblName;
    JLabel lblComment;
    JTextField tfValue;
    JLabel lblValueError;
    Program program;
    double value;
    int valueType;

    public static boolean showDialog(VariableDef varDef) {
        if (dialog == null) {
            dialog = new SysVariableDialog(MainFrame.instance);
        }
        SysVariableDialog.dialog.tfValue.requestFocusInWindow();
        SysVariableDialog.dialog.okPressed = false;
        dialog.setControls(varDef);
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setVisible(true);
        if (SysVariableDialog.dialog.okPressed) {
            return dialog.updateVar(varDef);
        }
        return false;
    }

    public SysVariableDialog(JFrame parent) {
        super(parent, "\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SysVariableDialog.this.validData()) {
                    dialog.okPressed = true;
                    dialog.setVisible(false);
                }
            }
        };
        DocumentListener editValue = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SysVariableDialog.this.validData();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SysVariableDialog.this.validData();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SysVariableDialog.this.validData();
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.lblName = new JLabel("Name");
        this.lblComment = new JLabel("Comment");
        this.tfValue = new JTextField(8);
        this.tfValue.getDocument().addDocumentListener(editValue);
        this.lblValueError = new DialogErrorLabel("Error");
        pnlContents.add((Component)this.lblName, "span, wrap");
        pnlContents.add((Component)this.lblComment, "span, wrap");
        pnlContents.add((Component)new JLabel("\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), "");
        pnlContents.add((Component)this.tfValue, "gaptop 8px");
        pnlContents.add((Component)this.lblValueError, "newline, span, hidemode 3");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void setControls(VariableDef varDef) {
        this.lblName.setText("<html><strong>" + varDef.getFullName() + "</strong></html>");
        this.lblComment.setText("<html>" + varDef.getCommentHtml() + "</html>");
        this.valueType = varDef.getValueType();
        double v = varDef.getInitValue();
        if (!Double.isNaN(v)) {
            this.tfValue.setText(Utils.numToString(v));
        } else {
            this.tfValue.setText("");
        }
        this.validData();
    }

    boolean updateVar(VariableDef varDef) {
        double v = varDef.getInitValue();
        if (v == this.value || Double.isNaN(v) && Double.isNaN(this.value)) {
            return false;
        }
        varDef.setInitValue(this.value);
        return true;
    }

    boolean validData() {
        this.value = Double.NaN;
        boolean error = false;
        double min = -999999.0;
        double max = 999999.0;
        if (this.valueType == 1) {
            min = 0.0;
            max = 1.0;
        } else if (this.valueType == 1) {
            min = -32768.0;
            max = 32767.0;
        }
        String s = this.tfValue.getText();
        if (!Utils.strEmpty(s)) {
            try {
                this.value = Double.parseDouble(s.replace(',', '.'));
                if (this.value < min || this.value > max) {
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
        }
        if (error) {
            this.lblValueError.setText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e \u043e\u0442 " + Utils.numToString(min) + " \u0434\u043e " + Utils.numToString(max));
            this.lblValueError.setVisible(true);
        } else {
            this.lblValueError.setVisible(false);
        }
        this.btnOk.setEnabled(!error);
        this.pack();
        return !error;
    }
}

