/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.compiler.SyntaxError;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.IdeAction;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.AMenuItemView;
import certa.vics.ide.ui.MenuItemMenuView;
import certa.vics.ide.ui.MenuItemVariableView;
import certa.vics.ide.ui.UiActions;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.json.JSONObject;

public class UiEditor
extends IdeEditor
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private JPopupMenu popupMenu;
    UiActions actions;
    protected final MainFrame mainFrame;
    private MenuItemMenuView mainMenu;
    private JTextPane pane;
    private JScrollPane scroller;

    public UiEditor(MainFrame mainFrame, JMenu menu) {
        super(menu, "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u043c\u0435\u043d\u044e", false);
        this.setBackground(Color.WHITE);
        this.mainFrame = mainFrame;
        this.pane = new JTextPane();
        this.pane.setEditable(false);
        this.scroller = new JScrollPane(this.pane);
        this.scroller.getViewport().setBackground(Color.WHITE);
        this.add((Component)this.scroller, "Center");
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new UiActions(this);
        this.menu.add(new JMenuItem(this.actions.copy));
        this.menu.add(new JMenuItem(this.actions.copyRec));
        this.menu.add(new JMenuItem(this.actions.cut));
        this.menu.add(new JMenuItem(this.actions.paste));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.moveLeft));
        this.menu.add(new JMenuItem(this.actions.moveRight));
        this.menu.add(new JMenuItem(this.actions.relocate));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.addWindow));
        this.menu.add(new JMenuItem(this.actions.addGroup));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.delete));
        this.menu.addSeparator();
        this.menu.add(new JMenuItem(this.actions.editProps));
        this.toolBar.add(MainFrame.instance.actions.exportUi).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.copy).setFocusable(false);
        this.toolBar.add(this.actions.copyRec).setFocusable(false);
        this.toolBar.add(this.actions.cut).setFocusable(false);
        this.toolBar.add(this.actions.paste).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.moveLeft).setFocusable(false);
        this.toolBar.add(this.actions.moveRight).setFocusable(false);
        this.toolBar.add(this.actions.relocate).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.addWindow).setFocusable(false);
        this.toolBar.add(this.actions.addWindowL).setFocusable(false);
        this.toolBar.add(this.actions.addGroup).setFocusable(false);
        this.toolBar.add(this.actions.addWindowR).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.delete).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(this.actions.editProps).setFocusable(false);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(new JMenuItem(this.actions.addWindow));
        this.popupMenu.add(new JMenuItem(this.actions.addWindowL));
        this.popupMenu.add(new JMenuItem(this.actions.addWindowR));
        this.popupMenu.add(new JMenuItem(this.actions.addGroup));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.moveLeft));
        this.popupMenu.add(new JMenuItem(this.actions.moveRight));
        this.popupMenu.add(new JMenuItem(this.actions.relocate));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.copy));
        this.popupMenu.add(new JMenuItem(this.actions.copyRec));
        this.popupMenu.add(new JMenuItem(this.actions.cut));
        this.popupMenu.add(new JMenuItem(this.actions.paste));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.delete));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.actions.editProps));
        return this.actions;
    }

    public void commitAction() {
        this.updateVarRefs();
        this.markModified();
    }

    protected void reset() {
        IdeAction.updateAll();
    }

    @Override
    public void clear() {
        this.reset();
    }

    private void restoreFocus(MenuItemMenuView g) {
    }

    public boolean hasSelection() {
        return false;
    }

    private void delWindow(MenuItemVariableView w) {
    }

    private void delGroup(MenuItemMenuView g) {
    }

    public void deleteSelected() {
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
    }

    private void addItem(AMenuItemView item, String tab) {
        Document doc = this.pane.getDocument();
        try {
            if (item instanceof MenuItemMenuView) {
                doc.insertString(doc.getLength(), tab + "[" + item.name + "]\n", null);
                tab = tab + "    ";
                MenuItemMenuView menu = (MenuItemMenuView)item;
                for (AMenuItemView i : menu.getItems()) {
                    this.addItem(i, tab);
                }
            } else if (item instanceof MenuItemVariableView) {
                MenuItemVariableView vi = (MenuItemVariableView)item;
                if (vi.var != null) {
                    doc.insertString(doc.getLength(), tab + vi.var.fullName() + "\n", null);
                } else {
                    doc.insertString(doc.getLength(), tab + "---\n", null);
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void updateView() {
        this.pane.setText("");
        this.addItem(this.mainMenu, "");
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.mainMenu = new MenuItemMenuView(this, null, 0, "");
        this.mainMenu.loadItems(this.mainFrame.program.mainMenu);
        this.updateView();
        this.updateVarRefs();
        this.reset();
    }

    @Override
    public void initNewProgram() {
        this.mainMenu = new MenuItemMenuView(this, null, 0, "");
        this.updateView();
        this.updateVarRefs();
        this.reset();
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        this.mainFrame.program.mainMenu.clear();
        this.mainMenu.compileItems(this.mainFrame.program.mainMenu);
    }

    @Override
    public void saveProps() {
    }

    @Override
    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearWindowsRefs();
    }

    @Override
    public void updateVarList() {
    }

    @Override
    public void titleClicked() {
        this.initFocus();
    }

    @Override
    public void initFocus() {
    }

    public void copyToClipboard(boolean cut, boolean recursive) {
    }

    public void pasteFromClipboard() {
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

