/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.compiler.AMenuItem;
import certa.vics.compiler.MenuItemMenu;
import certa.vics.compiler.MenuItemVariable;
import certa.vics.ide.ui.AMenuItemView;
import certa.vics.ide.ui.MenuItemVariableView;
import certa.vics.ide.ui.UiEditor;
import java.util.ArrayList;

public class MenuItemMenuView
extends AMenuItemView {
    private ArrayList<AMenuItemView> items = new ArrayList();

    public MenuItemMenuView(UiEditor editor, MenuItemMenuView parent, int access, String name) {
        super(editor, parent, access, name);
    }

    public boolean isMain() {
        return this.parent == null;
    }

    public ArrayList<AMenuItemView> getItems() {
        return this.items;
    }

    @Override
    public void clearStoredFlag() {
        super.clearStoredFlag();
        for (AMenuItemView item : this.items) {
            item.clearStoredFlag();
        }
    }

    public void loadItems(MenuItemMenu menu) {
        this.items.clear();
        for (AMenuItem item : menu.items) {
            AMenuItemView view;
            if (item instanceof MenuItemVariable) {
                view = new MenuItemVariableView(this.editor, this, item.getAccess(), item.getName());
                ((MenuItemVariableView)view).loadItem((MenuItemVariable)item);
                continue;
            }
            if (item instanceof MenuItemMenu) {
                view = new MenuItemMenuView(this.editor, this, item.getAccess(), item.getName());
                ((MenuItemMenuView)view).loadItems((MenuItemMenu)item);
                continue;
            }
            throw new Error("MenuItemMenuView load error (1)");
        }
    }

    public void compileItems(MenuItemMenu parentMenu) {
        for (AMenuItemView view : this.items) {
            if (view instanceof MenuItemVariableView) {
                ((MenuItemVariableView)view).compileItem(parentMenu);
                continue;
            }
            if (!(view instanceof MenuItemMenuView)) continue;
            ((MenuItemMenuView)view).compileItems(new MenuItemMenu(parentMenu, view.access, view.name));
        }
    }

    @Override
    void updateSelection() {
    }
}

