/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ports;

import certa.vics.compiler.Port;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ports.APortView;
import certa.vics.ide.ports.PortsEditor;
import certa.vics.ide.ports.Rs485MasterParamsPanel;
import certa.vics.ide.ports.Rs485SlaveParamsPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class Rs485PortView
extends APortView {
    private static final long serialVersionUID = 1L;
    JPanel pnlModeSelect;
    JComboBox<String> cbxMode;
    static final String[] MODE = new String[]{"Slave", "Master"};
    JPanel cardPanel;
    Rs485SlaveParamsPanel slaveParams;
    Rs485MasterParamsPanel masterParams;
    final int portIndex;
    final Port port;

    private void updateMode() {
        if (this.inUpdate) {
            return;
        }
        String mode = (String)this.cbxMode.getSelectedItem();
        boolean wasMaster = this.port.isRs485Master;
        boolean masterMode = mode == MODE[1];
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, mode);
        if (wasMaster != masterMode) {
            this.port.isRs485Master = masterMode;
            this.markModified();
        }
        this.editor.reloadPorts(this.port);
        this.editor.updateControls();
        MainFrame.instance.actions.update();
    }

    public Rs485PortView(PortsEditor editor, String name, Port port, int portIndex) {
        super(editor, name);
        this.portIndex = portIndex;
        this.port = port;
        this.pnlModeSelect = new JPanel(new MigLayout());
        this.cbxMode = new JComboBox<String>(new DefaultComboBoxModel<String>(MODE));
        this.cbxMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rs485PortView.this.updateMode();
            }
        });
        this.pnlModeSelect.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c:"), "");
        this.pnlModeSelect.add(this.cbxMode, "");
        this.pnlModeSelect.setFocusable(false);
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        this.slaveParams = new Rs485SlaveParamsPanel(editor, port, portIndex);
        this.masterParams = new Rs485MasterParamsPanel(editor, port, portIndex);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlModeSelect, "North");
        this.cardPanel.add((Component)this.slaveParams, MODE[0]);
        this.cardPanel.add((Component)this.masterParams, MODE[1]);
        this.add((Component)this.cardPanel, "Center");
    }

    @Override
    void updateData() {
        if (this.inUpdate) {
            return;
        }
        this.masterParams.updateData();
        this.slaveParams.updateData();
    }

    @Override
    public void loadData(Port portToSkip) {
        if (this.port != portToSkip) {
            this.cbxMode.setSelectedIndex(this.port.isRs485Master ? 1 : 0);
            this.masterParams.loadData(this.editor.mainFrame.getVarsEditor());
            this.slaveParams.loadData(this.editor.mainFrame.program);
        }
    }

    @Override
    public void updateMasterVarRefs() {
        this.masterParams.updateVarRefs();
    }

    @Override
    public void updateVarList() {
        this.masterParams.updateVarList();
    }

    @Override
    public void updateProgram() {
        this.masterParams.saveData();
    }
}

