/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.vics.Utils;
import certa.vics.ide.CommSettingsPanel;
import certa.vics.ide.MainFrame;
import certa.vics.ide.modbus.ConnectionThread;
import certa.vics.ide.modbus.ModbusPollTable;
import certa.vics.ide.modbus.ModbusSlaveEditor;
import certa.vics.ide.modbus.Register;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PollDialog
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    static PollDialog dialog;
    protected ModbusSlaveEditor editor;
    protected CommSettingsPanel comm;
    ModbusPollTable inputs;
    ModbusPollTable coils;
    ModbusPollTable iregs;
    ModbusPollTable hregs;
    ArrayList<ModbusPollTable> tabs = new ArrayList();
    JTabbedPane tabbedPane;
    JPanel pnlStatus;
    JPanel pnlStatusStats;
    JLabel lblStatusNotConnected;
    JLabel lblStatusPort;
    JLabel lblStatusRequests;
    JLabel lblStatusErrors;
    protected ConnectionThread connection;

    public static void showDialog(ModbusSlaveEditor editor, CommSettingsPanel comm, Component owner) {
        if (dialog != null) {
            return;
        }
        dialog = new PollDialog();
        try {
            PollDialog.dialog.editor = editor;
            PollDialog.dialog.comm = comm;
            dialog.loadRegs();
            PollDialog.dialog.connection = new ConnectionThread(dialog);
            dialog.setDisconnectedStatus(null);
            Point p = MainFrame.instance.getClientLocation();
            Dimension d = MainFrame.instance.getClientSize();
            dialog.setSize(new Dimension(d.width / 2, d.height));
            dialog.setLocation(p.x + d.width / 2, p.y);
            dialog.setVisible(true);
        }
        catch (Throwable ex) {
            Utils.ProcessException(ex, false);
            JOptionPane.showMessageDialog(MainFrame.instance, ex.getMessage(), "Error", 0);
        }
    }

    public PollDialog() {
        super("MODBUS");
        this.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(2);
        this.inputs = new ModbusPollTable(this, "INPUTS", true, false);
        this.coils = new ModbusPollTable(this, "COILS", true, true);
        this.iregs = new ModbusPollTable(this, "INPUT REGS", false, false);
        this.hregs = new ModbusPollTable(this, "HOLDING REGS", false, true);
        this.tabbedPane = new JTabbedPane();
        this.addTab(this.inputs, "Inputs", "Read only 1-bit discretes");
        this.addTab(this.coils, "Coils", "Writable 1-bit discretes");
        this.addTab(this.iregs, "Input registers", "Read only 16-bit registers");
        this.addTab(this.hregs, "Holding registers", "Writable 16-bit registers");
        this.add((Component)this.tabbedPane, "Center");
        this.pnlStatus = new JPanel();
        this.pnlStatus.setLayout(new BoxLayout(this.pnlStatus, 0));
        this.pnlStatus.setBorder(BorderFactory.createSoftBevelBorder(1));
        this.pnlStatusStats = new JPanel();
        this.pnlStatusStats.setLayout(new BoxLayout(this.pnlStatusStats, 0));
        this.lblStatusNotConnected = new JLabel("\u041d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
        this.lblStatusPort = new JLabel("");
        this.lblStatusRequests = new JLabel("");
        this.lblStatusErrors = new JLabel("");
        this.pnlStatusStats.add(this.lblStatusPort);
        this.pnlStatusStats.add(new JLabel("      \u0417\u0430\u043f\u0440\u043e\u0441\u044b: "));
        this.pnlStatusStats.add(this.lblStatusRequests);
        this.pnlStatusStats.add(new JLabel("    \u041e\u0448\u0438\u0431\u043a\u0438: "));
        this.pnlStatusStats.add(this.lblStatusErrors);
        this.pnlStatus.add(this.lblStatusNotConnected);
        this.pnlStatus.add(this.pnlStatusStats);
        this.add((Component)this.pnlStatus, "South");
        this.pack();
        this.setLocationByPlatform(false);
        this.setResizable(true);
    }

    public void loadRegs() {
        int i = this.editor.getCurrentProfileIndex();
        this.inputs.setRegList(this.editor.inputs[i].list);
        this.coils.setRegList(this.editor.coils[i].list);
        this.iregs.setRegList(this.editor.iregs[i].list);
        this.hregs.setRegList(this.editor.hregs[i].list);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        dialog = null;
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void initFocus() {
    }

    private void addTab(ModbusPollTable table, String title, String hint) {
        this.tabbedPane.addTab(title, null, table, hint);
        this.tabs.add(table);
    }

    public void connected() {
        this.pnlStatusStats.setVisible(true);
        this.lblStatusNotConnected.setVisible(false);
        this.repaint();
    }

    void setDisconnectedStatus(String error) {
        this.pnlStatusStats.setVisible(false);
        this.lblStatusNotConnected.setVisible(true);
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
        }
        this.repaint();
    }

    public void disconnected(String error) {
        this.connection = null;
        this.setDisconnectedStatus(error);
    }

    private void updateValues(ModbusPollTable table, Register[] regs) {
        for (int i = 0; i < regs.length; ++i) {
            table.values[i] = regs[i].getValue();
            table.bad[i] = !regs[i].isGood();
            table.writing[i] = regs[i].isWriting();
            table.model.fireTableCellUpdated(i, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        if (this.connection != null) {
            ConnectionThread connectionThread = this.connection;
            synchronized (connectionThread) {
                this.lblStatusRequests.setText(Integer.toString(this.connection.requestsCount));
                this.lblStatusErrors.setText(Integer.toString(this.connection.errorsCount));
                this.updateValues(this.inputs, this.connection.inputs);
                this.updateValues(this.coils, this.connection.coils);
                this.updateValues(this.iregs, this.connection.iregs);
                this.updateValues(this.hregs, this.connection.hregs);
            }
        }
    }
}

