/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.modbus.client.ModbusClient;
import certa.modbus.client.ModbusClientTransport;
import certa.modbus.client.RtuOverTcpTransport;
import certa.modbus.client.RtuTransportJSerialComm;
import certa.modbus.client.TcpTransport;
import certa.vics.Utils;
import certa.vics.ide.modbus.PollDialog;
import certa.vics.ide.modbus.Register;
import java.util.List;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionThread
extends SwingWorker<Void, Void> {
    private static final Logger log = LoggerFactory.getLogger(ConnectionThread.class);
    ModbusClientTransport transport;
    int id;
    PollDialog dialog;
    volatile boolean done;
    public final Register[] inputs;
    public final Register[] coils;
    public final Register[] iregs;
    public final Register[] hregs;
    public int requestsCount;
    public int errorsCount;
    private String error = null;
    private ModbusClient modbus;
    private boolean notify = true;

    public ConnectionThread(PollDialog dialog) {
        this.dialog = dialog;
        this.inputs = ConnectionThread.createRegs(dialog.inputs.list.size());
        this.coils = ConnectionThread.createRegs(dialog.coils.list.size());
        this.iregs = ConnectionThread.createRegs(dialog.iregs.list.size());
        this.hregs = ConnectionThread.createRegs(dialog.hregs.list.size());
        try {
            if (dialog.comm.isRtu()) {
                this.transport = new RtuTransportJSerialComm(dialog.comm.getPortName(), dialog.comm.getBaudRate(), 8, dialog.comm.getParity(), dialog.comm.getStopBits(), 800, 50);
            } else if (dialog.comm.isTcp()) {
                this.transport = new TcpTransport(dialog.comm.getTcpHost(), dialog.comm.getTcpPort(), null, 0, 5000, 800, 50, true);
            } else if (dialog.comm.isRtuOverTcp()) {
                this.transport = new RtuOverTcpTransport(dialog.comm.getTcpHost(), dialog.comm.getTcpPort(), null, 0, 5000, 800, 50, true);
            } else {
                throw new Exception("Unknown transport");
            }
            this.id = dialog.comm.getDeviceId();
            this.execute();
        }
        catch (Throwable e) {
            Utils.ProcessException(e, false);
            this.error = e.getMessage();
            if (Utils.strEmpty(this.error)) {
                this.error = e.getClass().getSimpleName();
            }
            this.done();
        }
    }

    public void stop() {
        this.done = true;
    }

    private static Register[] createRegs(int count) {
        Register[] regs = new Register[count];
        for (int i = 0; i < regs.length; ++i) {
            regs[i] = new Register();
        }
        return regs;
    }

    private synchronized void incRequestsCount() {
        ++this.requestsCount;
    }

    private synchronized void incErrorosCount() {
        ++this.errorsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReg(Register reg, int addr, boolean analog) throws Exception {
        boolean write = false;
        int value = 0;
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            write = reg.needWrite;
            value = reg.valueToWrite;
            reg.needWrite = false;
        }
        if (write) {
            log.trace("Write {} at {}", (Object)(analog ? "HR" : "coil"), (Object)addr);
            if (analog) {
                this.modbus.InitWriteRegisterRequest(this.id, addr, value);
            } else {
                this.modbus.InitWriteCoilRequest(this.id, addr, value != 0);
            }
            if (!this.modbus.execRequest()) {
                this.incErrorosCount();
            }
            this.incRequestsCount();
        }
    }

    private void processRegArray(Register[] regs, boolean write, boolean analog) throws Exception {
        int i;
        int count = regs.length;
        if (count == 0) {
            return;
        }
        if (write) {
            for (i = 0; i < count; ++i) {
                this.writeReg(regs[i], i, analog);
            }
        }
        if (analog) {
            i = 0;
            int addr = 0;
            while (i < count) {
                int c = Math.min(count - i, 125);
                if (write) {
                    this.modbus.InitReadHoldingsRequest(this.id, addr, c);
                } else {
                    this.modbus.InitReadAInputsRequest(this.id, addr, c);
                }
                if (!this.modbus.execRequest()) {
                    this.incErrorosCount();
                }
                this.incRequestsCount();
                for (int j = addr; j < addr + c; ++j) {
                    regs[j].updateValue(this.modbus, j, false);
                }
                i += c;
                addr += c;
            }
        } else {
            if (write) {
                this.modbus.InitReadCoilsRequest(this.id, 0, count);
            } else {
                this.modbus.InitReadDInputsRequest(this.id, 0, count);
            }
            if (!this.modbus.execRequest()) {
                this.incErrorosCount();
            }
            this.incRequestsCount();
            for (i = 0; i < count; ++i) {
                regs[i].updateValue(this.modbus, i, false);
            }
        }
    }

    @Override
    protected Void doInBackground() throws Exception {
        block11: {
            try {
                this.modbus = new ModbusClient();
                try {
                    this.modbus.setTransport(this.transport);
                    while (!this.done) {
                        if (!this.done) {
                            this.processRegArray(this.inputs, false, false);
                        }
                        if (!this.done) {
                            this.processRegArray(this.coils, true, false);
                        }
                        if (!this.done) {
                            this.processRegArray(this.iregs, false, true);
                        }
                        if (!this.done) {
                            this.processRegArray(this.hregs, true, true);
                        }
                        this.publish(new Void[0]);
                        Thread.sleep(100L);
                    }
                }
                finally {
                    log.debug("DONE");
                    this.modbus.close();
                }
            }
            catch (InterruptedException e) {
                log.debug("Interrupted");
            }
            catch (Throwable e) {
                Utils.ProcessException(e, false);
                this.error = e.getMessage();
                if (!Utils.strEmpty(this.error)) break block11;
                this.error = e.getClass().getSimpleName();
            }
        }
        return null;
    }

    @Override
    public void done() {
        if (this.modbus != null) {
            this.modbus.close();
        }
        this.dialog.disconnected(this.error);
    }

    @Override
    protected void process(List<Void> chunks) {
        if (this.notify) {
            this.dialog.connected();
            this.notify = false;
        }
        this.dialog.updateData();
    }
}

