/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.Utils;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.fbd.AFbdBlock;
import certa.vics.ide.fbd.BlockDef;
import certa.vics.ide.fbd.BlocksTree;
import certa.vics.ide.fbd.FbdPage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;

public class BlockCreateDialog
extends IdeUtils.IdeDialog
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private static BlockCreateDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JButton btnCancel;
    private BlocksTree blocks;
    private JEditorPane htmlPane;
    private HTMLEditorKit htmlKit;
    private HTMLDocument htmlDoc;
    private static final String blockImageSrc = "file://block.image";
    BlockDef selectedBlockDef;

    public static AFbdBlock showDialog(FbdPage page, Component owner) {
        if (dialog == null) {
            dialog = new BlockCreateDialog(MainFrame.instance);
        }
        BlockCreateDialog.dialog.blocks.tree.requestFocusInWindow();
        BlockCreateDialog.dialog.okPressed = false;
        Main.setDlgLocation(dialog, owner, -1, -1);
        BlockCreateDialog.dialog.btnOk.setVisible(true);
        BlockCreateDialog.dialog.btnCancel.setVisible(true);
        dialog.pack();
        dialog.setVisible(true);
        if (BlockCreateDialog.dialog.okPressed) {
            return BlockCreateDialog.dialog.selectedBlockDef.createBlock(page);
        }
        return null;
    }

    public static void showHelpDialog(Class<? extends AFbdBlock> blockClass, Component owner) {
        if (dialog == null) {
            dialog = new BlockCreateDialog(MainFrame.instance);
        }
        BlockCreateDialog.dialog.blocks.tree.requestFocusInWindow();
        BlockCreateDialog.dialog.okPressed = false;
        Main.setDlgLocation(dialog, owner, -1, -1);
        BlockCreateDialog.dialog.btnOk.setVisible(false);
        BlockCreateDialog.dialog.btnCancel.setVisible(false);
        dialog.pack();
        BlockCreateDialog.dialog.blocks.selectBlockDef(blockClass, BlockCreateDialog.dialog.blocks.root);
        dialog.setVisible(true);
    }

    public static BlockDef getBlockDef(Class<? extends AFbdBlock> blockClass) {
        if (dialog == null) {
            dialog = new BlockCreateDialog(MainFrame.instance);
        }
        return BlockCreateDialog.getBlockDef(blockClass, BlockCreateDialog.dialog.blocks.root);
    }

    public BlockCreateDialog(JFrame parent) {
        super(parent, "\u0411\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0430 \u0431\u043b\u043e\u043a\u043e\u0432");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        final ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BlockCreateDialog.this.selectedBlockDef != null) {
                    dialog.okPressed = true;
                    dialog.setVisible(false);
                }
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 0 0", "[][grow]", "[grow]"));
        pane.add((Component)pnlContents, "grow, wrap");
        this.blocks = new BlocksTree(null, false);
        this.blocks.setPreferredSize(new Dimension(260, 500));
        this.blocks.tree.addTreeSelectionListener(this);
        this.blocks.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && BlockCreateDialog.this.btnOk.isVisible()) {
                    ok.actionPerformed(null);
                }
            }
        });
        this.htmlPane = new JEditorPane("text/html", "");
        this.htmlPane.setEditable(false);
        this.htmlKit = (HTMLEditorKit)this.htmlPane.getEditorKit();
        this.htmlDoc = (HTMLDocument)this.htmlPane.getDocument();
        this.htmlKit.getViewFactory();
        this.initCSS(this.htmlKit);
        Dictionary cache = (Dictionary)this.htmlDoc.getProperty("imageCache");
        if (cache == null) {
            cache = new Hashtable<Object, Object>(){
                private static final long serialVersionUID = 1L;

                @Override
                public synchronized Object get(Object key) {
                    Object v = super.get(key);
                    if (v != null) {
                        return v;
                    }
                    if (key instanceof URL) {
                        return Toolkit.getDefaultToolkit().getImage((URL)key);
                    }
                    return null;
                }
            };
            this.htmlDoc.putProperty("imageCache", cache);
        }
        JScrollPane docView = new JScrollPane(this.htmlPane);
        docView.setPreferredSize(new Dimension(550, 500));
        pnlContents.add((Component)this.blocks, "growy");
        pnlContents.add((Component)docView, "grow");
        this.btnCancel = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        this.btnCancel.addActionListener(cancel);
        pane.add((Component)this.btnCancel, "tag cancel, hidemode 3, gaptop 4px");
        this.btnOk = new JButton("\u041e\u041a");
        this.btnOk.addActionListener(ok);
        pane.add((Component)this.btnOk, "tag ok, hidemode 3, gaptop 4px");
        this.btnOk.setEnabled(false);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
    }

    private void initCSS(HTMLEditorKit kit) {
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule("body { color:#000; font-family:times; margin: 10px; }");
        styleSheet.addRule("h1 { color: black; }");
        styleSheet.addRule("ul { list-style-type: none; }");
        styleSheet.addRule("ul li { margin-bottom: 10px; }");
    }

    protected static BlockDef getBlockDef(Class<? extends AFbdBlock> blockClass, DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getChildAt(i);
            if (n == null) continue;
            if (n.isLeaf()) {
                Object obj = n.getUserObject();
                if (!(obj instanceof BlockDef)) continue;
                BlockDef b = (BlockDef)obj;
                if (b.blockClass != blockClass) continue;
                return b;
            }
            BlockDef b = BlockCreateDialog.getBlockDef(blockClass, n);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.selectedBlockDef = this.blocks.getSelectedBlockDef();
        if (this.selectedBlockDef != null) {
            this.btnOk.setEnabled(this.btnOk.isVisible());
            BufferedImage img = this.updateBlockImage(this.selectedBlockDef);
            int w = img != null ? img.getWidth() : 0;
            int h = img != null ? img.getHeight() : 0;
            this.htmlPane.setText("<html><h1>" + BlockCreateDialog.escapeHTML(this.selectedBlockDef.name) + "</h1><p style='text-align:left; margin: 10px 20px'><img width=" + w + " height=" + h + " src='" + blockImageSrc + "'><p>" + this.selectedBlockDef.doc + "</html>");
            this.htmlPane.setCaretPosition(0);
        } else {
            this.btnOk.setEnabled(false);
            this.htmlPane.setText("");
        }
    }

    public static String escapeHTML(String s) {
        StringBuilder out = new StringBuilder(Math.max(16, s.length()));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private BufferedImage updateBlockImage(BlockDef blockDef) {
        BufferedImage img = null;
        Dictionary cache = (Dictionary)this.htmlDoc.getProperty("imageCache");
        if (cache != null) {
            try {
                URL u = new URL(blockImageSrc);
                cache.remove(u);
                img = this.createBlockImage(blockDef);
                cache.put(u, img);
            }
            catch (MalformedURLException e) {
                Utils.ProcessException(e, false);
            }
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createBlockImage(BlockDef blockDef) {
        AFbdBlock b = blockDef.createBlock(null);
        b.cellBounds.width -= b.padLeft;
        b.padLeft = 0;
        b.cellBounds.height -= b.padTop;
        b.padTop = 0;
        b.updateBounds();
        BufferedImage img = new BufferedImage(b.pxBounds.width + 20, b.pxBounds.height + 2, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        try {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            b.paintShape(g);
            b.paintLinks(g);
            img.flush();
        }
        finally {
            g.dispose();
        }
        return img;
    }
}

