/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AbstractOperation;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.InputPin;
import certa.vics.ide.fbd.OutputPin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ADynOutputsOperation
extends AbstractOperation {
    protected static final String JSON_DYN_OUTPUTS = "dynOutputs";
    private int fixedCount;

    public ADynOutputsOperation(FbdPage page, JSONObject src, String operation, String name) throws JSONException, FbdLoadError {
        super(page, src, operation, name);
    }

    protected abstract int getOutputType();

    protected abstract String getOutputName(int var1);

    public int getFixedOutputsCount() {
        return this.fixedCount;
    }

    public int getDynOutputsCount() {
        return this.outputs.size() - this.fixedCount;
    }

    public void setDynOutputsCount(int count) {
        count += this.fixedCount;
        int oldSize = this.outputs.size();
        this.trimOutputs();
        while (this.outputs.size() < count) {
            this.pushY(true, false, false);
            int i = this.outputs.size();
            this.outputs.add(new OutputPin(this, this.getOutputType(), this.getOutputName(i - this.fixedCount), this.outputs.size()));
            this.pushY(false, false, false);
            this.updateBounds();
        }
        if (this.outputs.size() != oldSize) {
            this.markModified();
        }
    }

    private void trimOutputs() {
        int i;
        while (this.outputs.size() > 2 && !((OutputPin)this.outputs.get(i = this.outputs.size() - 1)).hasTargets()) {
            this.outputs.remove(i);
        }
        this.updateBounds();
    }

    @Override
    protected void createPins(JSONObject src) throws JSONException, FbdLoadError {
        this.fixedCount = this.outputs.size();
        int count = 2;
        if (src != null) {
            count = src.getInt(JSON_DYN_OUTPUTS);
        }
        for (int i = 0; i < count; ++i) {
            this.outputs.add(new OutputPin(this, this.getOutputType(), this.getOutputName(i), this.outputs.size()));
        }
    }

    @Override
    public void paintShape(Graphics2D g2d) {
        super.paintShape(g2d);
        g2d.setColor(Color.BLACK);
        int x0 = this.pxBounds.x + this.pxBounds.width - 12;
        int y0 = this.pxBounds.y + this.pxBounds.height - 6;
        int[] x = new int[]{x0, x0 + 8, x0 + 4};
        int[] y = new int[]{y0, y0, y0 + 4};
        g2d.fillPolygon(x, y, x.length);
    }

    @Override
    public void saveToJson(JSONObject jso) throws JSONException {
        super.saveToJson(jso);
        jso.put(JSON_DYN_OUTPUTS, this.outputs.size() - this.fixedCount);
    }

    @Override
    public void makeSpecificCode(ArrayList<String> code) {
        int i;
        String cmd = this.operation;
        for (InputPin in : this.inputs) {
            cmd = cmd + " " + in.getCompiledVar().fullName();
        }
        for (i = 0; i < this.fixedCount; ++i) {
            cmd = cmd + " " + ((OutputPin)this.outputs.get(i)).getCompiledVar().fullName();
        }
        cmd = cmd + " " + (this.outputs.size() - this.fixedCount);
        for (i = this.fixedCount; i < this.outputs.size(); ++i) {
            cmd = cmd + " " + ((OutputPin)this.outputs.get(i)).getCompiledVar().fullName();
        }
        code.add(cmd);
    }
}

