/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import certa.vics.ide.ActionsBundle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public abstract class IdeAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    static final List<IdeAction> list = new ArrayList<IdeAction>();
    public final KeyStroke accelerator;
    protected final ActionsBundle bundle;

    public static void updateAll() {
        for (IdeAction a : list) {
            a.update();
        }
    }

    public IdeAction(ActionsBundle bundle, String name, String iconName, String desc, int mnemonic, KeyStroke accelerator) {
        super(name);
        this.bundle = bundle;
        this.accelerator = accelerator;
        if (iconName != null) {
            this.putValue("SmallIcon", Utils.loadImageIcon(iconName));
        }
        this.putValue("ShortDescription", desc);
        if (mnemonic != 0) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if (accelerator != null) {
            this.putValue("AcceleratorKey", accelerator);
        }
        if (bundle != null) {
            bundle.list.add(this);
        }
        list.add(this);
    }

    public void update() {
        this.setEnabled((this.bundle == null || this.bundle.available) && this.canExec());
    }

    protected boolean canExec() {
        return true;
    }
}

