/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.AMenuItem;
import certa.vics.compiler.CompilerError;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import java.util.ArrayList;

public class MenuItemMenu
extends AMenuItem {
    public final ArrayList<AMenuItem> items = new ArrayList(0);

    public MenuItemMenu(MenuItemMenu parent, int access, String name) {
        super(parent, access, name);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public void resolveLinks(Program program) throws SyntaxError {
        for (AMenuItem mi : this.items) {
            mi.resolveLinks(program);
        }
    }

    @Override
    public void compileStrings(Program prg) throws CompilerError {
        super.compileStrings(prg);
        for (AMenuItem mi : this.items) {
            mi.compileStrings(prg);
        }
    }

    @Override
    public int compile(Program prg, byte[] buffer, int offset) throws CompilerError {
        int newOffset = super.compile(prg, buffer, offset);
        if (this.getHeaderSize() != 5) {
            throw new CompilerError("MenuItemMenu compile error (1)");
        }
        int pos = offset + this.getHeaderSize();
        buffer[pos] = (byte)this.items.size();
        ++pos;
        for (AMenuItem mi : this.items) {
            pos = mi.compile(prg, buffer, pos);
        }
        if (pos != newOffset) {
            throw new CompilerError("MenuItemMenu compile error (2)");
        }
        return newOffset;
    }

    @Override
    public int getSize() {
        int size = this.getHeaderSize() + 1;
        for (AMenuItem mi : this.items) {
            size += mi.getSize();
        }
        return size;
    }

    @Override
    public int getBinaryType() {
        return 1;
    }
}

