/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.CompilerError;
import certa.vics.compiler.MenuItemMenu;
import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;

public abstract class AMenuItem {
    public int startAddress;
    public final MenuItemMenu parent;
    private int access;
    private String name;

    public AMenuItem(MenuItemMenu parent, int access, String name) {
        this.parent = parent;
        this.access = access;
        this.name = name;
        if (parent != null) {
            parent.items.add(this);
        }
    }

    public int getAccess() {
        return this.access;
    }

    public final String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setAccess(int access) {
        this.access = access;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public void clear() {
    }

    public void resolveLinks(Program program) throws SyntaxError {
    }

    public final int getHeaderSize() {
        return 5;
    }

    public abstract int getSize();

    public abstract int getBinaryType();

    public void compileStrings(Program prg) throws CompilerError {
        prg.menuStrings.compileString(this.getDisplayName());
    }

    public int compile(Program prg, byte[] buffer, int offset) throws CompilerError {
        int size = this.getSize();
        if (buffer != null) {
            buffer[offset + 0] = (byte)((this.access & 3) << 6 | this.getBinaryType() & 0x3F);
            buffer[offset + 1] = (byte)size;
            buffer[offset + 2] = (byte)(size >> 8);
            int sa = prg.menuStrings.getStringAddress(this.getDisplayName());
            buffer[offset + 3] = (byte)sa;
            buffer[offset + 4] = (byte)(sa >> 8);
        }
        return offset + size;
    }
}

