/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.ModbusClientTransport;
import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusClient
extends ModbusPdu
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ModbusClient.class);
    public static final byte RESULT_OK = 0;
    public static final byte RESULT_TIMEOUT = 1;
    public static final byte RESULT_EXCEPTION = 2;
    public static final byte RESULT_BAD_RESPONSE = 3;
    private boolean requestReady = false;
    private boolean responseReady = false;
    private byte srvId;
    private int expectedPduSize;
    private int expectedAddress = -1;
    private int expectedCount = -1;
    private int result;
    private ModbusClientTransport transport;

    public void setTransport(ModbusClientTransport tr) {
        this.transport = tr;
    }

    public byte getServerId() {
        return this.srvId;
    }

    protected int getExpectedPduSize() {
        return this.expectedPduSize;
    }

    protected void initCustomRequest(int newServerId, int newPduSize, byte function, int newExpectedPduSize) {
        this.setPduSize(newPduSize);
        this.writeByteToPDU(0, function);
        this.srvId = (byte)newServerId;
        this.expectedAddress = -1;
        this.expectedCount = -1;
        this.expectedPduSize = newExpectedPduSize;
        this.requestReady = true;
        this.responseReady = false;
    }

    protected void initRequest(int newServerId, int newPduSize, byte function, int param1, int param2, int newExpectedAddress, int newExpectedCount, int newExpectedPduSize) {
        this.setPduSize(newPduSize);
        this.writeByteToPDU(0, function);
        this.writeInt16ToPDU(1, param1);
        this.writeInt16ToPDU(3, param2);
        this.srvId = (byte)newServerId;
        this.expectedAddress = newExpectedAddress;
        this.expectedCount = newExpectedCount;
        this.expectedPduSize = newExpectedPduSize;
        this.requestReady = true;
        this.responseReady = false;
    }

    public void InitReadCoilsRequest(int serverId, int startAddress, int count) {
        if (count < 1 || count > 2000) {
            throw new IllegalArgumentException();
        }
        this.initRequest(serverId, 5, (byte)1, startAddress, count, startAddress, count, 2 + ModbusClient.bytesCount(count));
    }

    public void InitReadDInputsRequest(int serverId, int startAddress, int count) {
        if (count < 1 || count > 2000) {
            throw new IllegalArgumentException();
        }
        this.initRequest(serverId, 5, (byte)2, startAddress, count, startAddress, count, 2 + ModbusClient.bytesCount(count));
    }

    public void InitReadHoldingsRequest(int serverId, int startAddress, int count) {
        if (count < 1 || count > 125) {
            throw new IllegalArgumentException();
        }
        this.initRequest(serverId, 5, (byte)3, startAddress, count, startAddress, count, 2 + count * 2);
    }

    public void InitReadAInputsRequest(int serverId, int startAddress, int count) {
        if (count < 1 || count > 125) {
            throw new IllegalArgumentException();
        }
        this.initRequest(serverId, 5, (byte)4, startAddress, count, startAddress, count, 2 + count * 2);
    }

    public void InitWriteCoilRequest(int serverId, int coilAddress, boolean value) {
        this.initRequest(serverId, 5, (byte)5, coilAddress, value ? 65280 : 0, -1, -1, 5);
    }

    public void InitWriteRegisterRequest(int serverId, int regAddress, int value) {
        this.initRequest(serverId, 5, (byte)6, regAddress, value, -1, -1, 5);
    }

    public void InitWriteCoilsRequest(int serverId, int startAddress, boolean[] values) {
        if (values.length > 1968) {
            throw new IllegalArgumentException();
        }
        int bytes = ModbusClient.bytesCount(values.length);
        this.initRequest(serverId, 6 + bytes, (byte)15, startAddress, values.length, -1, -1, 5);
        this.writeByteToPDU(5, (byte)bytes);
        for (int i = 0; i < bytes; ++i) {
            byte b = 0;
            for (int j = 0; j < 8; ++j) {
                int k = i * 8 + j;
                if (k >= values.length || !values[k]) continue;
                b = (byte)(b | 1 << j);
            }
            this.writeByteToPDU(6 + i, b);
        }
    }

    public void InitWriteRegistersRequest(int serverId, int startAddress, int[] values) {
        if (values.length > 123) {
            throw new IllegalArgumentException();
        }
        int bytes = values.length * 2;
        this.initRequest(serverId, 6 + bytes, (byte)16, startAddress, values.length, -1, -1, 5);
        this.writeByteToPDU(5, (byte)bytes);
        for (int i = 0; i < values.length; ++i) {
            this.writeInt16ToPDU(6 + i * 2, values[i]);
        }
    }

    public boolean execRequest(boolean noResponse) throws Exception {
        if (!this.requestReady) {
            throw new IllegalStateException("Call InitXXXRequest() first.");
        }
        if (this.transport == null) {
            throw new IllegalStateException("Transport is not set.");
        }
        this.transport.sendRequest(this);
        this.requestReady = false;
        if (noResponse) {
            this.result = 0;
            this.responseReady = false;
        } else {
            this.result = this.transport.waitResponse(this);
            boolean bl = this.responseReady = this.result == 0;
            if (!this.responseReady && log != null && log.isWarnEnabled()) {
                if (this.result == 2) {
                    log.warn("Exception 0x{} from {}", (Object)ModbusClient.byteToHex((byte)this.getExceptionCode()), (Object)this.getServerId());
                } else {
                    log.warn(this.getResultAsString() + " from {}", (Object)this.getServerId());
                }
            }
        }
        return this.responseReady;
    }

    public boolean execRequest() throws Exception {
        return this.execRequest(false);
    }

    public int getResult() {
        return this.result;
    }

    public String getResultAsString() {
        switch (this.result) {
            case 0: {
                return "OK";
            }
            case 3: {
                return "Bad response";
            }
            case 2: {
                return "Exception " + this.getExceptionCode();
            }
            case 1: {
                return "Timeout";
            }
        }
        return null;
    }

    public int getExceptionCode() {
        if ((this.getFunction() & 0x80) == 0 || this.getPduSize() < 2) {
            return 0;
        }
        return this.readByteFromPDU(1, true);
    }

    public int getResponseAddress() {
        if (this.responseReady && this.expectedAddress >= 0) {
            return this.expectedAddress;
        }
        throw new IllegalStateException();
    }

    public int getResponseCount() {
        if (this.responseReady && this.expectedCount >= 0) {
            return this.expectedCount;
        }
        throw new IllegalStateException();
    }

    public boolean getResponseBit(int address) {
        if (this.getFunction() == 1 || this.getFunction() == 2) {
            int offset = address - this.getResponseAddress();
            if (offset < 0 || offset >= this.getResponseCount()) {
                throw new IndexOutOfBoundsException();
            }
            byte b = this.readByteFromPDU(2 + offset / 8);
            return (b & 1 << offset % 8) != 0;
        }
        throw new IllegalStateException();
    }

    public int getResponseRegister(int address, boolean unsigned) {
        if (this.getFunction() == 3 || this.getFunction() == 4) {
            int offset = address - this.getResponseAddress();
            if (offset < 0 || offset >= this.getResponseCount()) {
                throw new IndexOutOfBoundsException();
            }
            return this.readInt16FromPDU(2 + offset * 2, unsigned);
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() {
        if (this.transport != null) {
            this.transport.close();
        }
    }
}

