/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.tools;

import certa.vics.Utils;
import certa.vics.compiler.Argument;
import certa.vics.compiler.CodeBlock;
import certa.vics.compiler.Command;
import certa.vics.compiler.Device;
import certa.vics.compiler.ModbusBlock;
import certa.vics.compiler.ModbusMasterBlock;
import certa.vics.compiler.ModbusMasterRequest;
import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.ModbusSlaveBlock;
import certa.vics.compiler.Program;
import certa.vics.compiler.Schedule;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ExportSourceV6 {
    static Device _device;

    private ExportSourceV6() {
    }

    static String fixSysVars(String text) throws Exception {
        if (text.contains("SysIn.i.CycleMax") || text.contains("SysIn.i.CycleMean") || text.contains("SysOut.f.FDO1_PWM") || text.contains("SysOut.f.FDO2_PWM") || text.contains("SysStore.b.FDO1_Config") || text.contains("SysStore.b.FDO2_Config") || text.contains("SysStore.f.AO1_U0") || text.contains("SysStore.f.AO1_U100") || text.contains("SysStore.f.AO2_U0") || text.contains("SysStore.f.AO2_U100") || text.contains("SysStore.f.AO3_U0") || text.contains("SysStore.f.AO3_U100") || text.contains("SysStore.f.AO4_U0") || text.contains("SysStore.f.AO4_U100") || text.contains("SysStore.f.AO5_U0") || text.contains("SysStore.f.AO5_U100") || text.contains("SysStore.f.AO6_U0") || text.contains("SysStore.f.AO6_U100") || text.contains("SysStore.f.AO7_U0") || text.contains("SysStore.f.AO7_U100") || text.contains("SysStore.f.AO8_U0") || text.contains("SysStore.f.AO8_U100")) {
            throw new Exception("\u041d\u0443\u0436\u043d\u043e \u0443\u0431\u0440\u0430\u0442\u044c \u0438\u0437 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0432\u0441\u0435 \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0442\u0430\u043a\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435:\nFDO1_Config,\nFDO2_Config,\nFDO1_PWM,\nFDO2_PWM,\nAO1_U0,\nAO1_U100,\n...\nAO8_U0,\nAO8_U100,\nCycleMax,\nCycleMean");
        }
        return text.replace("SysIn.f.AI1_0-10V", "SysIn.f.AI1_V").replace("SysIn.f.AI2_0-10V", "SysIn.f.AI2_V").replace("SysIn.f.AI3_0-10V", "SysIn.f.AI3_V").replace("SysIn.f.AI4_0-10V", "SysIn.f.AI4_V").replace("SysIn.f.AI5_0-10V", "SysIn.f.AI5_V").replace("SysIn.f.AI6_0-10V", "SysIn.f.AI6_V").replace("SysIn.f.AI7_0-10V", "SysIn.f.AI7_V").replace("SysIn.f.AI8_0-10V", "SysIn.f.AI8_V").replace("SysOut.f.AO1", "SysOut.f.AO1_V").replace("SysOut.f.AO2", "SysOut.f.AO2_V").replace("SysOut.f.AO3", "SysOut.f.AO3_V").replace("SysOut.f.AO4", "SysOut.f.AO4_V").replace("SysStore.i.Net_N1", "SysStore.i.RS485_1_ID").replace("SysStore.i.Net_N2", "SysStore.i.RS485_2_ID").replace("SysStore.i.Net_Speed1", "SysStore.i.RS485_1_Speed").replace("SysStore.i.Net_Speed2", "SysStore.i.RS485_2_Speed").replace("SysStore.i.Net_StopBits1", "SysStore.i.RS485_1_StopBits").replace("SysStore.i.Net_StopBits2", "SysStore.i.RS485_2_StopBits").replace("SysStore.i.Net_Parity1", "SysStore.i.RS485_1_Parity").replace("SysStore.i.Net_Parity2", "SysStore.i.RS485_2_Parity");
    }

    static String fixedFullName(Variable var) throws Exception {
        if (var.block == ExportSourceV6._device.SysOutVars || var.block == ExportSourceV6._device.SysStoreVars || var.block == ExportSourceV6._device.SysExtVars) {
            return ExportSourceV6.fixSysVars(var.fullName());
        }
        return var.fullName();
    }

    static String encodeId(String id) {
        int i;
        for (i = id.length() - 1; i >= 0 && Character.isWhitespace(id.charAt(i)); --i) {
        }
        id = id.substring(0, i + 1);
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c <= ' ' || c > '~') {
                c = '_';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void printSource(Program program, PrintWriter out, boolean fbd) throws Exception {
        _device = program.device;
        out.println("# Exported for ViCS v6.x");
        out.println();
        out.println("# Memory usage (bytes)");
        out.println("#   RAM:         " + program.getRamSize() + ",   (max: " + program.device.RamSize + ")");
        out.println("#   EEPROM:      " + program.getStoreSize() + ",   (max: " + program.device.EepromSize + ")");
        out.println("#   NVRAM:       " + program.getExtSize() + ",   (max: " + program.device.NvramSize + ")");
        out.println("#   FLASH:       " + program.getFlashSize() + ",   (max: " + program.device.FlashSize + ")");
        out.println("#     code:         " + program.getAllCodeSize());
        out.println("#     RAM init:     " + program.getRamInitSize());
        out.println();
        out.println("FileVersion 600");
        out.println("ID " + ExportSourceV6.encodeId(program.getHumanId()));
        out.println("CodeCRC " + program.codeCrc);
        out.println("Target " + program.device.PropsFile);
        ExportSourceV6.printVars(program.device.SysOutVars, out, true);
        ExportSourceV6.printVars(program.device.SysStoreVars, out, true);
        ExportSourceV6.printVars(program.device.SysExtVars, out, true);
        if (!fbd) {
            ExportSourceV6.printVars(program.Constants, out, false);
            ExportSourceV6.printVars(program.RamVars, out, false);
            ExportSourceV6.printVars(program.ExtVars, out, false);
            ExportSourceV6.printVars(program.StoreVars, out, false);
        }
        ExportSourceV6.printModbusSlave("ModbusSlave 1", program.Modbus1, out);
        ExportSourceV6.printModbusSlave("ModbusSlave 2", program.Modbus2, out);
        ExportSourceV6.printModbusSlave("ModbusSlave 3", null, out);
        ExportSourceV6.printRS485Port(1, program.Modbus1, out);
        ExportSourceV6.printRS485Port(2, program.Modbus1, out);
        if (program.hasSchedule()) {
            ExportSourceV6.printSchedules(program, out);
            out.println();
        }
        ExportSourceV6.printMenu(program, out);
        if (!fbd) {
            if (program.codeSource.size() > 0) {
                for (String s : program.codeSource) {
                    out.println(s);
                }
            } else {
                ExportSourceV6.printCodeBlock(program.MainCode, program.device, out);
                ExportSourceV6.printSubs(program, out);
            }
        }
        out.println("End");
        out.println(ExportSourceV6.fixSysVars(program.extraData));
    }

    private static void printVars(VariablesBlock vd, PrintWriter out, boolean sysInit) throws Exception {
        out.println(vd.name);
        for (Variable v : vd.map.values()) {
            if (v.hidden) continue;
            String init = "";
            if (v.hasInitValue()) {
                init = " = ";
                init = v.type == 3 ? init + Utils.numToString(v.initValue) : init + Utils.Round(v.initValue);
                if (v.arrayItems != null) {
                    for (int i = 1; i < v.arrayItems.length; ++i) {
                        Variable v1 = v.arrayItems[i];
                        init = v1.type == 3 ? init + " " + Utils.numToString(v1.initValue) : init + " " + Utils.Round(v1.initValue);
                    }
                }
            } else if (sysInit) continue;
            String comment = !Utils.strEmpty(v.comment) && !sysInit ? " # " + v.comment : "";
            String vname = v.name;
            if (sysInit) {
                vname = ExportSourceV6.fixSysVars(v.fullName()).substring(v.block.name.length() + 3);
            }
            if (v.arrayItems != null) {
                out.println("  " + Variable.typeToString(v.type) + "." + v.arrayName() + "{" + v.arrayItems.length + "}" + init + comment);
                continue;
            }
            out.println("  " + Variable.typeToString(v.type) + "." + vname + init + comment);
        }
        out.println("End" + vd.name);
    }

    private static String mbVar(Variable var) throws Exception {
        if (var != null) {
            return ExportSourceV6.fixedFullName(var);
        }
        return "0";
    }

    private static void printRS485Port(int portNumber, ModbusBlock block, PrintWriter out) throws Exception {
        if (block.master() != null) {
            out.println("Port " + portNumber + " NoTCPGW");
            ModbusMasterBlock mb = block.master();
            out.println("  MASTER " + mb.timeout + " " + mb.pause + " 0");
            for (int i = 0; i < mb.requests.size(); ++i) {
                ModbusMasterRequest rq = mb.requests.get(i);
                out.println("  REQUEST " + rq.func + " " + rq.id + " " + rq.addr + " " + ExportSourceV6.mbVar(rq.varCmd) + " 0 0");
                for (int j = 0; j < rq.registers.size(); ++j) {
                    ModbusReg r = rq.registers.get(j);
                    if (r.var != null) {
                        String k = "";
                        if (r.var.type == 3) {
                            k = " $ " + r.digits;
                        }
                        out.println("    " + ExportSourceV6.fixedFullName(r.var) + k);
                        continue;
                    }
                    out.println("    0");
                }
            }
            out.println("EndPort");
        } else if (block.slave() != null) {
            out.println("Port RS485 " + portNumber);
            out.println("  SLAVE " + portNumber + " 0");
            out.println("EndPort");
        }
    }

    private static void printModbusSlave(String blockName, ModbusBlock block, PrintWriter out) throws Exception {
        ModbusSlaveBlock sb;
        out.println(blockName);
        ModbusSlaveBlock modbusSlaveBlock = sb = block != null ? block.slave() : null;
        if (sb != null) {
            ExportSourceV6.printMbSlaveRegs(sb, sb.Inputs, "input", out);
            ExportSourceV6.printMbSlaveRegs(sb, sb.Coils, "coil", out);
            ExportSourceV6.printMbSlaveRegs(sb, sb.IRs, "ir", out);
            ExportSourceV6.printMbSlaveRegs(sb, sb.HRs, "hr", out);
        }
        out.println("EndModbusSlave");
    }

    private static void printMbSlaveRegs(ModbusSlaveBlock block, ArrayList<ModbusReg> list, String prefix, PrintWriter out) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            ModbusReg r = list.get(i);
            if (!block.isEmpty(r)) {
                String k = "";
                if (r.var.type == 3) {
                    k = " $ " + r.digits;
                }
                out.println("  " + prefix + i + " " + ExportSourceV6.fixedFullName(r.var) + k);
                continue;
            }
            out.println("  " + prefix + i + " 0");
        }
    }

    private static void printCodeBlock(CodeBlock cb, Device device, PrintWriter out) throws Exception {
        out.println(cb.Name);
        ExportSourceV6.printCode(cb, device, out);
        out.println("End" + cb.Name);
    }

    private static void printSubs(Program program, PrintWriter out) throws Exception {
        for (CodeBlock cb : program.Subs.values()) {
            out.println("Sub " + cb.Name);
            ExportSourceV6.printCode(cb, program.device, out);
            out.println("EndSub");
        }
    }

    private static void printCode(CodeBlock cb, Device device, PrintWriter out) throws Exception {
        for (Command ci : cb.Items) {
            for (String lbl : cb.Labels.keySet()) {
                if (cb.Labels.get(lbl) != ci.offset) continue;
                out.println(":" + lbl);
            }
            String s = "  " + ci.cmdDef.Name;
            if (ci.cmdDef == device.CommandMap.get("END") || ci.cmdDef == device.CommandMap.get("ENDI") || ci.cmdDef == device.CommandMap.get("RET")) {
                s = "#" + s;
            }
            for (Argument arg : ci.Args) {
                if (arg.Type == 1) {
                    s = s + " " + (Integer)arg.Value;
                    continue;
                }
                if (arg.Type == 5) continue;
                if (arg.Type == 2) {
                    if (arg.def.IsArray) {
                        s = s + " " + ((Variable)arg.Value).fullArrayName();
                        continue;
                    }
                    s = s + " " + ExportSourceV6.fixedFullName((Variable)arg.Value);
                    continue;
                }
                s = s + " " + (String)arg.Value;
            }
            out.println(s);
        }
    }

    private static void printSchedules(Program program, PrintWriter out) throws Exception {
        for (Schedule s : program.Schedules.items) {
            if (s == null) continue;
            out.println("Schedule " + s.number);
            out.println("  strict " + (s.strict ? "1" : "0"));
            if (s.var != null) {
                out.println("  var " + ExportSourceV6.fixedFullName(s.var));
                if (s.var.type == 3) {
                    out.println("  digits " + Integer.toString(s.digits));
                }
                if (s.var.type == 3 || s.var.type == 2) {
                    out.println("  min " + Utils.FormatDouble(s.min, s.digits));
                    out.println("  max " + Utils.FormatDouble(s.max, s.digits));
                }
            }
            if (s.enabled != null) {
                out.println("  enable " + ExportSourceV6.fixedFullName(s.enabled));
            }
            for (int i = 0; i < 7; ++i) {
                String ts = s.encodeArray(i);
                if (Utils.strEmpty(ts)) continue;
                out.println("  day" + (i + 1) + " " + ts);
            }
            out.println("EndSchedule");
        }
    }

    private static void printMenu(Program program, PrintWriter out) {
        out.println("RootMenu");
        out.println("EndRootMenu\n");
    }

    public static void main(String[] args) {
        block3: {
            try {
                if (args.length == 0) {
                    System.out.println("Source file name is absent");
                    return;
                }
                Program p = new Program();
                p.loadFromFile(args[0], true);
                ExportSourceV6.printSource(p, new PrintWriter(System.out, true), false);
            }
            catch (Throwable e) {
                System.out.println("");
                System.out.println("ERROR: " + e.getMessage());
                System.out.println("");
                if (System.getProperty("debug") == null) break block3;
                e.printStackTrace();
            }
        }
    }
}

