/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.Utils;
import certa.vics.compiler.Program;
import certa.vics.compiler.StringList;
import certa.vics.compiler.WindowString;
import certa.vics.ide.DialogErrorLabel;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.StringsEditor;
import certa.vics.ide.ui.WindowView;
import certa.vics.ide.variables.VariableRef;
import certa.vics.lcd.LcdDisplay;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;

public class WindowPropsDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static WindowPropsDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JPanel pnlPreview;
    LcdDisplay lcdPreview;
    JButton btnEditText;
    JPanel pnlWindowType;
    ButtonGroup rgWindowType;
    JRadioButton rbWndText;
    JRadioButton rbWndDispVar;
    JRadioButton rbWndEditVar;
    JRadioButton rbWndEditXY;
    JRadioButton rbWndArchive;
    JRadioButton rbWndSchedule;
    JRadioButton rbWndAlarms;
    JPanel pnlCommon;
    JCheckBox chbxVisible;
    JComboBox<VariableRef> cmbxVisVar;
    JLabel lblVisVarError;
    JCheckBox chbxShortcut;
    JComboBox<String> cmbxShortcut;
    JPanel pnlVariable;
    JComboBox<VariableRef> cmbxVar;
    JComboBox<VariableRef> cmbxEditVar;
    JLabel lblVarError;
    JPanel pnlVarFormat;
    JComboBox<String> cmbxVarIntFmt;
    JComboBox<String> cmbxVarFloatFmt;
    JButton btnVarStrings;
    JPanel pnlEditVar;
    JLabel lblVarMin;
    JLabel lblVarMax;
    JTextField tfVarMin;
    JTextField tfVarMax;
    JLabel lblVarMinError;
    JLabel lblVarMaxError;
    JTextField tfVarMin0;
    JTextField tfVarMax1;
    JCheckBox chbxVarInstWrite;
    JCheckBox chbxVarInstWriteDis;
    JPanel pnlEditXY;
    JPanel pnlXyTitleFormat;
    JComboBox<VariableRef> cmbxXyTitle;
    JLabel lblXyTitleError;
    JComboBox<String> cmbxXyTitleFmt;
    JPanel pnlXyVarFormat;
    JComboBox<VariableRef> cmbxXyVar;
    JLabel lblXyVarError;
    JComboBox<String> cmbxXyVarFmt;
    JTextField tfXyMin;
    JTextField tfXyMax;
    JLabel lblXyMinError;
    JLabel lblXyMaxError;
    JPanel pnlSchedule;
    JComboBox<String> cmbxSchedule;
    Program program;
    String wndTitle;
    VariableRef wndVisibleVar;
    String wndText;
    VariableRef wndVar;
    VariableRef wndTitleVar;
    StringList wndStrings;
    int wndDigits;
    int wndTitleDigits;
    int wndMin;
    int wndMax;
    int wndSchedule;
    boolean wndArchive;
    private static String[] INT_FORMATS;
    private static String[] FLOAT_FORMATS;
    private static String[] SHORTCUTS;
    boolean inUpdate = false;
    static final int BAD_VALUE = Integer.MIN_VALUE;

    public static boolean showDialog(WindowView wnd) {
        if (dialog == null) {
            dialog = new WindowPropsDialog(MainFrame.instance);
        }
        WindowPropsDialog.dialog.btnOk.requestFocusInWindow();
        WindowPropsDialog.dialog.okPressed = false;
        dialog.setControls(wnd);
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setVisible(true);
        if (WindowPropsDialog.dialog.okPressed) {
            dialog.updateWindow(wnd);
            return true;
        }
        return false;
    }

    public WindowPropsDialog(JFrame parent) {
        super(parent, "\u041e\u043a\u043d\u043e");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WindowPropsDialog.this.validData()) {
                    dialog.okPressed = true;
                    dialog.setVisible(false);
                }
            }
        };
        ActionListener update = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowPropsDialog.this.updatePreview();
            }
        };
        ActionListener updateIntFmt = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WindowPropsDialog.this.inUpdate) {
                    return;
                }
                WindowPropsDialog.this.updatePreview();
                if (WindowPropsDialog.this.cmbxVarIntFmt.getSelectedIndex() == 1 && !WindowPropsDialog.this.editStrings()) {
                    WindowPropsDialog.this.cmbxVarIntFmt.setSelectedIndex(0);
                    WindowPropsDialog.this.updatePreview();
                }
            }
        };
        final ActionListener editText = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.editText();
            }
        };
        ActionListener editStrings = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.editStrings();
            }
        };
        DocumentListener editNum = new DocumentListener(){

            public void doUpdate() {
                if (!WindowPropsDialog.this.inUpdate) {
                    WindowPropsDialog.this.validData();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doUpdate();
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.pnlPreview = new JPanel(new MigLayout("", "[]", "[][grow]"));
        this.pnlPreview.setBorder(BorderFactory.createTitledBorder("\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0432\u0438\u0434"));
        this.lcdPreview = new LcdDisplay(null, 8, 2);
        this.lcdPreview.setBorder(UIManager.getBorder("TextField.border"));
        this.lcdPreview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                editText.actionPerformed(null);
            }
        });
        this.btnEditText = new JButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        this.btnEditText.addActionListener(editText);
        this.pnlPreview.add((Component)this.btnEditText, "wrap");
        this.pnlPreview.add((Component)this.lcdPreview, "wrap, push, align center");
        this.pnlWindowType = new JPanel(new GridLayout(0, 1));
        this.pnlWindowType.setBorder(BorderFactory.createTitledBorder("\u0422\u0438\u043f \u043e\u043a\u043d\u0430"));
        this.rgWindowType = new ButtonGroup();
        this.rbWndText = new JRadioButton("\u0422\u0435\u043a\u0441\u0442");
        this.rbWndDispVar = new JRadioButton("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
        this.rbWndEditVar = new JRadioButton("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439");
        this.rbWndEditXY = new JRadioButton("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 X-Y");
        this.rbWndArchive = new JRadioButton("\u0410\u0440\u0445\u0438\u0432");
        this.rbWndSchedule = new JRadioButton("\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
        this.rgWindowType.add(this.rbWndText);
        this.rgWindowType.add(this.rbWndDispVar);
        this.rgWindowType.add(this.rbWndEditVar);
        this.rgWindowType.add(this.rbWndEditXY);
        this.rgWindowType.add(this.rbWndArchive);
        this.rgWindowType.add(this.rbWndSchedule);
        this.pnlWindowType.add(this.rbWndText);
        this.pnlWindowType.add(this.rbWndDispVar);
        this.pnlWindowType.add(this.rbWndEditVar);
        this.pnlWindowType.add(this.rbWndEditXY);
        this.pnlWindowType.add(this.rbWndArchive);
        this.pnlWindowType.add(this.rbWndSchedule);
        this.rbWndText.addActionListener(update);
        this.rbWndDispVar.addActionListener(update);
        this.rbWndEditVar.addActionListener(update);
        this.rbWndEditXY.addActionListener(update);
        this.rbWndArchive.addActionListener(update);
        this.rbWndSchedule.addActionListener(update);
        this.lblVisVarError = new DialogErrorLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
        this.lblVarError = new DialogErrorLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
        this.lblXyTitleError = new DialogErrorLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
        this.lblXyVarError = new DialogErrorLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e");
        this.lblVarMinError = new DialogErrorLabel("MinError");
        this.lblVarMaxError = new DialogErrorLabel("MaxError");
        this.lblXyMinError = new DialogErrorLabel("YMinError");
        this.lblXyMaxError = new DialogErrorLabel("YMaxError");
        this.pnlCommon = new JPanel(new MigLayout("nogrid", "[grow]", ""));
        this.pnlCommon.setBorder(BorderFactory.createTitledBorder("\u041e\u0431\u0449\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u043a\u043d\u0430"));
        this.chbxVisible = new JCheckBox("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u043f\u0440\u0438 \u0443\u0441\u043b\u043e\u0432\u0438\u0438");
        this.chbxVisible.addActionListener(update);
        this.cmbxVisVar = new JComboBox();
        this.cmbxVisVar.setMaximumRowCount(20);
        this.cmbxVisVar.addActionListener(update);
        this.chbxShortcut = new JCheckBox("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043f\u0440\u0438 \u0443\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0438 \u043a\u043d\u043e\u043f\u043e\u043a");
        this.chbxShortcut.addActionListener(update);
        this.cmbxShortcut = new JComboBox<String>(new DefaultComboBoxModel<String>(SHORTCUTS));
        this.pnlCommon.add((Component)this.chbxVisible, "");
        this.pnlCommon.add((Component)this.lblVisVarError, "hidemode 3");
        this.pnlCommon.add(this.cmbxVisVar, "newline, growx, hidemode 3");
        this.pnlCommon.add((Component)this.chbxShortcut, "newline");
        this.pnlCommon.add(this.cmbxShortcut, "growx, hidemode 3");
        this.pnlVariable = new JPanel(new MigLayout("", "[grow]", "[][nogrid]"));
        this.pnlVariable.setBorder(BorderFactory.createTitledBorder("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f"));
        this.cmbxVar = new JComboBox();
        this.cmbxVar.addActionListener(update);
        this.cmbxEditVar = new JComboBox();
        this.cmbxEditVar.addActionListener(update);
        this.pnlVarFormat = new JPanel(new MigLayout("insets 0", "[grow]", "[nogrid]"));
        this.cmbxVarFloatFmt = new JComboBox<String>(new DefaultComboBoxModel<String>(FLOAT_FORMATS));
        this.cmbxVarFloatFmt.addActionListener(update);
        this.cmbxVarIntFmt = new JComboBox<String>(new DefaultComboBoxModel<String>(INT_FORMATS));
        this.cmbxVarIntFmt.addActionListener(updateIntFmt);
        this.btnVarStrings = new JButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0438");
        this.btnVarStrings.addActionListener(editStrings);
        this.btnVarStrings.setVisible(false);
        this.pnlEditVar = new JPanel(new MigLayout("insets 0", "", ""));
        this.lblVarMin = new JLabel("\u041c\u0438\u043d\u0438\u043c\u0443\u043c:");
        this.tfVarMin = new JTextField(8);
        this.tfVarMin.getDocument().addDocumentListener(editNum);
        this.lblVarMax = new JLabel("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c:");
        this.tfVarMax = new JTextField(8);
        this.tfVarMax.getDocument().addDocumentListener(editNum);
        this.tfVarMin0 = new JTextField("0", 8);
        this.tfVarMin0.setEnabled(false);
        this.tfVarMin0.setVisible(false);
        this.tfVarMax1 = new JTextField("1", 8);
        this.tfVarMax1.setEnabled(false);
        this.tfVarMax1.setVisible(false);
        this.chbxVarInstWrite = new JCheckBox("\u0417\u0430\u043f\u0438\u0441\u044c \u0432 \u043f\u0430\u043c\u044f\u0442\u044c \u0431\u0435\u0437 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f");
        this.chbxVarInstWrite.addActionListener(update);
        this.chbxVarInstWriteDis = new JCheckBox(this.chbxVarInstWrite.getText());
        this.chbxVarInstWriteDis.setEnabled(false);
        this.chbxVarInstWriteDis.setToolTipText("\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0434\u043b\u044f \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u0444\u043e\u0440\u043c\u0430\u0442\u0430");
        this.pnlVariable.add(this.cmbxVar, "growx, wrap, hidemode 3");
        this.pnlVariable.add(this.cmbxEditVar, "growx, wrap, hidemode 3");
        this.pnlVariable.add((Component)this.lblVarError, "wrap, hidemode 3");
        this.pnlVarFormat.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442:"), "");
        this.pnlVarFormat.add(this.cmbxVarFloatFmt, "aligny center, hidemode 3");
        this.pnlVarFormat.add(this.cmbxVarIntFmt, "aligny center, hidemode 3");
        this.pnlVarFormat.add((Component)this.btnVarStrings, "aligny center, hidemode 3");
        this.pnlVariable.add((Component)this.pnlVarFormat, "wrap");
        this.pnlEditVar.add((Component)this.lblVarMin, "");
        this.pnlEditVar.add((Component)this.tfVarMin, "hidemode 2");
        this.pnlEditVar.add((Component)this.tfVarMin0, "hidemode 2, gapright 50");
        this.pnlEditVar.add((Component)this.lblVarMax, "");
        this.pnlEditVar.add((Component)this.tfVarMax, "hidemode 2");
        this.pnlEditVar.add((Component)this.tfVarMax1, "hidemode 2");
        this.pnlEditVar.add((Component)this.lblVarMinError, "cell 0 1, spanx 3, gapright 20, hidemode 2");
        this.pnlEditVar.add((Component)this.lblVarMaxError, "cell 3 1, spanx 3, hidemode 3");
        this.pnlEditVar.add((Component)this.chbxVarInstWrite, "newline, span, hidemode 3");
        this.pnlEditVar.add((Component)this.chbxVarInstWriteDis, "newline, span, hidemode 3");
        this.pnlVariable.add((Component)this.pnlEditVar, "hidemode 3");
        this.pnlEditXY = new JPanel(new MigLayout("insets 0", "[grow]", ""));
        this.cmbxXyTitle = new JComboBox();
        this.cmbxXyTitle.addActionListener(update);
        this.cmbxXyTitleFmt = new JComboBox<String>(new DefaultComboBoxModel<String>(FLOAT_FORMATS));
        this.cmbxXyTitleFmt.addActionListener(update);
        this.cmbxXyVar = new JComboBox();
        this.cmbxXyVar.addActionListener(update);
        this.cmbxXyVarFmt = new JComboBox<String>(new DefaultComboBoxModel<String>(FLOAT_FORMATS));
        this.cmbxXyVarFmt.addActionListener(update);
        this.tfXyMin = new JTextField(8);
        this.tfXyMin.getDocument().addDocumentListener(editNum);
        this.tfXyMax = new JTextField(8);
        this.tfXyMax.getDocument().addDocumentListener(editNum);
        JPanel pnl = new JPanel(new MigLayout("", "[grow]", "[][nogrid]"));
        pnl.setBorder(BorderFactory.createTitledBorder("\u041c\u0430\u0441\u0441\u0438\u0432 \u0425"));
        pnl.add(this.cmbxXyTitle, "growx, span, wrap");
        pnl.add((Component)this.lblXyTitleError, "wrap, hidemode 3");
        this.pnlXyTitleFormat = new JPanel(new MigLayout("insets 0", "[grow]", "[nogrid]"));
        this.pnlXyTitleFormat.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442:"), "");
        this.pnlXyTitleFormat.add(this.cmbxXyTitleFmt, "");
        pnl.add((Component)this.pnlXyTitleFormat, "wrap");
        this.pnlEditXY.add((Component)pnl, "wrap, growx");
        pnl = new JPanel(new MigLayout("", "[grow]", "[][nogrid][nogrid]"));
        pnl.setBorder(BorderFactory.createTitledBorder("\u041c\u0430\u0441\u0441\u0438\u0432 Y"));
        pnl.add(this.cmbxXyVar, "growx, span, wrap");
        pnl.add((Component)this.lblXyVarError, "wrap, hidemode 3");
        this.pnlXyVarFormat = new JPanel(new MigLayout("insets 0", "", "[nogrid][][]"));
        this.pnlXyVarFormat.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442:"), "");
        this.pnlXyVarFormat.add(this.cmbxXyVarFmt, "wrap");
        this.pnlXyVarFormat.add((Component)new JLabel("\u041c\u0438\u043d\u0438\u043c\u0443\u043c:"), "");
        this.pnlXyVarFormat.add((Component)this.tfXyMin, "gapright 50");
        this.pnlXyVarFormat.add((Component)new JLabel("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c:"), "");
        this.pnlXyVarFormat.add((Component)this.tfXyMax, "wrap");
        this.pnlXyVarFormat.add((Component)this.lblXyMinError, "cell 0 2, spanx 2, gapright 20, hidemode 3");
        this.pnlXyVarFormat.add((Component)this.lblXyMaxError, "cell 2 2, spanx 2, hidemode 3");
        pnl.add((Component)this.pnlXyVarFormat, "wrap");
        this.pnlEditXY.add((Component)pnl, "growx");
        this.pnlSchedule = new JPanel(new MigLayout("", "[grow]", "[nogrid]"));
        this.pnlSchedule.setBorder(BorderFactory.createTitledBorder("\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435"));
        this.cmbxSchedule = new JComboBox();
        this.cmbxSchedule.addActionListener(update);
        this.pnlSchedule.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440:"), "");
        this.pnlSchedule.add(this.cmbxSchedule, "growx");
        pnlContents.add((Component)this.pnlWindowType, "growy");
        pnlContents.add((Component)this.pnlPreview, "growy, wrap");
        pnlContents.add((Component)this.pnlCommon, "wrap, span, grow");
        pnlContents.add((Component)this.pnlVariable, "wrap, span, grow, hidemode 3");
        pnlContents.add((Component)this.pnlEditXY, "wrap, span, grow, hidemode 3");
        pnlContents.add((Component)this.pnlSchedule, "wrap, span, grow, hidemode 3");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void editText() {
        String s;
        LcdDisplay lcd = this.lcdPreview;
        if (this.rbWndText.isSelected() || this.rbWndSchedule.isSelected() || this.rbWndArchive.isSelected()) {
            ArrayList<String> lines = new ArrayList<String>(2);
            lines.add(this.wndTitle);
            lines.add(this.wndText);
            if (StringsEditor.editStrings(lines, false, false, lcd.getColumnsCount(), lcd.getLcdFont(), "\u0422\u0435\u043a\u0441\u0442 \u043e\u043a\u043d\u0430", this)) {
                this.wndTitle = lines.get(0);
                this.wndText = lines.get(1);
                this.updatePreview();
            }
        } else if ((this.rbWndDispVar.isSelected() || this.rbWndEditVar.isSelected()) && (s = StringsEditor.editString(this.wndTitle, lcd.getColumnsCount(), lcd.getLcdFont(), "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u043e\u043a\u043d\u0430", this)) != null) {
            this.wndTitle = s;
            this.updatePreview();
        }
    }

    boolean editStrings() {
        int i;
        boolean boolVar;
        if (StringList.isEmpty(this.wndStrings)) {
            this.wndStrings = new StringList((StringList)null, this.program);
            this.wndStrings.ensureSize(2, this.program.device);
        }
        boolean bl = boolVar = this.wndVar != null && this.wndVar.type() == 1;
        if (boolVar) {
            this.wndStrings.ensureSize(2, this.program.device);
        }
        ArrayList<String> sl = new ArrayList<String>(this.wndStrings.Strings.size());
        for (i = 0; !(i >= this.wndStrings.Strings.size() || boolVar && i > 1); ++i) {
            sl.add(this.wndStrings.Strings.get(i).getSource().replace('_', ' '));
        }
        if (StringsEditor.editStrings(sl, true, !boolVar, this.program.device.STRING_SIZE, this.program.device.FONT, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u0442\u0440\u043e\u043a", dialog)) {
            this.wndStrings.Strings.clear();
            for (i = 0; i < sl.size(); ++i) {
                this.wndStrings.Strings.add(new WindowString(sl.get(i).replace(' ', '_'), this.program.device.FONT, this.program.device.STRING_SIZE));
            }
            this.updatePreview();
            return true;
        }
        return false;
    }

    void updatePreview() {
        if (this.inUpdate) {
            return;
        }
        this.inUpdate = true;
        this.pnlSchedule.setVisible(this.rbWndSchedule.isSelected());
        if (this.rbWndText.isSelected() || this.rbWndSchedule.isSelected() || this.rbWndArchive.isSelected()) {
            this.pnlVariable.setVisible(false);
            this.pnlEditXY.setVisible(false);
            WindowView.buildTextPreview(this.lcdPreview.getCharsBuffer(), this.wndTitle, this.wndText);
        } else if (this.rbWndDispVar.isSelected() || this.rbWndEditVar.isSelected()) {
            boolean edit = this.rbWndEditVar.isSelected();
            VariableRef var = null;
            if (edit) {
                var = (VariableRef)this.cmbxEditVar.getSelectedItem();
                this.setVarInCombo(this.cmbxVar, var);
            } else {
                var = (VariableRef)this.cmbxVar.getSelectedItem();
                this.setVarInCombo(this.cmbxEditVar, var);
            }
            this.pnlVariable.setVisible(true);
            this.pnlEditXY.setVisible(false);
            this.cmbxVar.setVisible(!edit);
            this.cmbxEditVar.setVisible(edit);
            this.pnlVarFormat.setVisible(var != null);
            this.pnlEditVar.setVisible(var != null && edit);
            if (var != null) {
                boolean isFloat = var.type() == 3;
                this.cmbxVarIntFmt.setVisible(!isFloat);
                this.cmbxVarFloatFmt.setVisible(isFloat);
                boolean isText = !isFloat && this.cmbxVarIntFmt.getSelectedIndex() == 1;
                this.btnVarStrings.setVisible(isText);
                if (edit) {
                    boolean isBool = var.type() == 1;
                    this.tfVarMin.setVisible(!isText && !isBool);
                    this.tfVarMin0.setVisible(!this.tfVarMin.isVisible());
                    this.lblVarMin.setEnabled(this.tfVarMin.isVisible());
                    this.tfVarMax.setVisible(!isBool && !isText);
                    this.tfVarMax1.setVisible(!this.tfVarMax.isVisible());
                    this.lblVarMax.setEnabled(this.tfVarMax.isVisible());
                    if (isText) {
                        if (var.type() == 2 && !StringList.isEmpty(this.wndStrings)) {
                            this.tfVarMax1.setText(Integer.toString(this.wndStrings.Strings.size() - 1));
                        } else {
                            this.tfVarMax1.setText("1");
                        }
                    }
                    if (var.type() == 1) {
                        this.tfVarMax1.setText("1");
                    }
                    this.chbxVarInstWrite.setVisible(!isText);
                    this.chbxVarInstWriteDis.setVisible(!this.chbxVarInstWrite.isVisible());
                } else {
                    this.tfVarMin.setVisible(false);
                    this.tfVarMax.setVisible(false);
                }
            }
            WindowView.buildVarPreview(this.lcdPreview.getCharsBuffer(), this.wndTitle, var, this.cmbxVarFloatFmt.getSelectedIndex(), this.btnVarStrings.isVisible() ? this.wndStrings : null, edit, this.chbxVarInstWrite.isVisible() && this.chbxVarInstWrite.isSelected());
        } else if (this.rbWndEditXY.isSelected()) {
            this.pnlVariable.setVisible(false);
            this.pnlEditXY.setVisible(true);
            VariableRef varX = (VariableRef)this.cmbxXyTitle.getSelectedItem();
            VariableRef varY = (VariableRef)this.cmbxXyVar.getSelectedItem();
            this.pnlXyTitleFormat.setVisible(varX != null);
            this.pnlXyVarFormat.setVisible(varY != null);
            WindowView.buildTablePreview(this.lcdPreview.getCharsBuffer(), varX, this.cmbxXyTitleFmt.getSelectedIndex(), varY, this.cmbxXyVarFmt.getSelectedIndex());
        }
        this.cmbxVisVar.setVisible(this.chbxVisible.isSelected());
        this.btnEditText.setEnabled(!this.rbWndEditXY.isSelected());
        this.lcdPreview.repaint();
        this.pack();
        this.validData();
        this.inUpdate = false;
    }

    void setVarInCombo(JComboBox<VariableRef> combo, VariableRef var) {
        combo.setSelectedItem(null);
        combo.setSelectedItem(var);
    }

    void updateVarTooltip(JComboBox<VariableRef> combo, VariableRef var) {
        combo.setToolTipText(null);
        if (var != null) {
            combo.setToolTipText("<html>" + var.varDef.getCommentHtml() + "</html>");
        }
    }

    String limToString(int lim) {
        double d = lim;
        int dig = 0;
        if (this.wndVar != null && this.wndVar.type() == 3) {
            dig = this.wndDigits;
            if (this.wndDigits == 1) {
                d /= 10.0;
            } else if (this.wndDigits == 2) {
                d /= 100.0;
            } else if (this.wndDigits == 3) {
                d /= 1000.0;
            }
        }
        return Utils.FormatDouble(d, dig);
    }

    void setControls(WindowView wnd) {
        this.inUpdate = true;
        this.program = wnd.editor.mainFrame.program;
        this.lcdPreview.setLcdFont(WindowView.LCD.font);
        this.lcdPreview.setLcdSize(WindowView.LCD.columnsCount, WindowView.LCD.rowsCount);
        this.wndTitle = wnd.title;
        this.wndText = wnd.text;
        this.wndVisibleVar = wnd.visibleVar;
        this.wndVar = wnd.var;
        this.wndTitleVar = wnd.titleVar;
        this.wndStrings = wnd.strings;
        this.wndDigits = wnd.digits;
        this.wndTitleDigits = wnd.titleDigits;
        this.wndMin = wnd.min;
        this.wndMax = wnd.max;
        this.wndSchedule = wnd.schedule;
        this.wndArchive = wnd.archive;
        this.chbxVisible.setSelected(this.wndVisibleVar != null);
        this.cmbxShortcut.setSelectedIndex(0);
        for (int i = 0; i < this.program.keyWindows.length; ++i) {
            if (wnd.editor.keyWindows[i] != wnd) continue;
            this.cmbxShortcut.setSelectedIndex(i + 1);
            break;
        }
        this.chbxShortcut.setSelected(this.cmbxShortcut.getSelectedIndex() > 0);
        this.cmbxShortcut.setVisible(this.chbxShortcut.isSelected());
        this.tfVarMin.setText(this.limToString(this.wndMin));
        this.tfVarMax.setText(this.limToString(this.wndMax));
        this.chbxVarInstWrite.setSelected(wnd.instEdit);
        this.tfXyMin.setText(this.tfVarMin.getText());
        this.tfXyMax.setText(this.tfVarMax.getText());
        this.cmbxVarIntFmt.setSelectedIndex(this.wndStrings == null ? 0 : 1);
        this.cmbxVarFloatFmt.setSelectedIndex(this.wndDigits);
        this.cmbxXyTitleFmt.setSelectedIndex(this.wndTitleDigits);
        this.cmbxXyVarFmt.setSelectedIndex(this.wndDigits);
        ArrayList<VariableRef> vars = MainFrame.instance.getVarsEditor().getAllVariables(true, 0);
        vars.add(0, null);
        this.cmbxVar.setModel(new DefaultComboBoxModel<VariableRef>(new Vector<VariableRef>(vars)));
        Vector<VariableRef> vector = new Vector<VariableRef>();
        vector.add(null);
        for (VariableRef v : vars) {
            if (v == null || v.type() != 1) continue;
            vector.add(v);
        }
        this.cmbxVisVar.setModel(new DefaultComboBoxModel(vector));
        vector = new Vector();
        vector.add(null);
        for (VariableRef v : vars) {
            if (v == null || v.type() != 3 || !v.isArray()) continue;
            vector.add(v);
        }
        this.cmbxXyTitle.setModel(new DefaultComboBoxModel(vector));
        vector = new Vector();
        vector.add(null);
        for (VariableRef v : vars) {
            if (v == null || !v.isWritable()) continue;
            vector.add(v);
        }
        this.cmbxEditVar.setModel(new DefaultComboBoxModel(vector));
        vector = new Vector();
        vector.add(null);
        for (VariableRef v : vars) {
            if (v == null || v.type() != 3 || !v.isArray() || !v.isWritable()) continue;
            vector.add(v);
        }
        this.cmbxXyVar.setModel(new DefaultComboBoxModel(vector));
        this.setVarInCombo(this.cmbxVisVar, this.wndVisibleVar);
        this.setVarInCombo(this.cmbxVar, this.wndVar);
        this.setVarInCombo(this.cmbxEditVar, this.wndVar);
        this.setVarInCombo(this.cmbxXyTitle, this.wndTitleVar);
        this.setVarInCombo(this.cmbxXyVar, this.wndVar);
        VariableRef[] vl = MainFrame.instance.getScheduleEditor().getVarList();
        String[] scheds = new String[12];
        for (int i = 0; i < scheds.length; ++i) {
            VariableRef var = vl[i];
            scheds[i] = i + 1 + ":  " + (var != null ? var.shortName() : "--");
        }
        this.cmbxSchedule.setModel(new DefaultComboBoxModel<String>(scheds));
        this.cmbxSchedule.setSelectedIndex(this.wndSchedule - 1);
        if (this.wndVar != null) {
            if (wnd.editable) {
                if (this.wndTitleVar != null) {
                    this.rbWndEditXY.setSelected(true);
                } else {
                    this.rbWndEditVar.setSelected(true);
                }
            } else {
                this.rbWndDispVar.setSelected(true);
            }
        } else if (this.wndSchedule > 0 && this.program.hasSchedule()) {
            this.rbWndSchedule.setSelected(true);
        } else if (this.wndArchive && this.program.hasArchive()) {
            this.rbWndArchive.setSelected(true);
        } else {
            this.rbWndText.setSelected(true);
        }
        this.rbWndSchedule.setVisible(this.program.hasSchedule());
        this.rbWndArchive.setVisible(this.program.hasArchive());
        if (wnd.getNestedGroup() == null) {
            this.rbWndEditVar.setEnabled(true);
            this.rbWndEditVar.setToolTipText(null);
            this.rbWndSchedule.setEnabled(true);
            this.rbWndSchedule.setToolTipText(null);
            this.rbWndArchive.setEnabled(true);
            this.rbWndArchive.setToolTipText(null);
        } else {
            this.rbWndEditVar.setEnabled(false);
            this.rbWndEditVar.setToolTipText("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u043c\u0435\u043d\u044e");
            this.rbWndSchedule.setEnabled(false);
            this.rbWndSchedule.setToolTipText("\u041e\u043a\u043d\u043e \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u043c\u0435\u043d\u044e");
            this.rbWndArchive.setEnabled(false);
            this.rbWndArchive.setToolTipText("\u041e\u043a\u043d\u043e \u0430\u0440\u0445\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u043c\u0435\u043d\u044e");
        }
        if (this.rbWndEditVar.isEnabled() && wnd.getParentGroup().getList().size() == 1) {
            this.rbWndEditXY.setEnabled(true);
            this.rbWndEditXY.setToolTipText(null);
        } else {
            this.rbWndEditXY.setEnabled(false);
            this.rbWndEditXY.setToolTipText("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0435\u0434\u0438\u043d\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u043c \u043e\u043a\u043d\u043e\u043c \u0432 \u043c\u0435\u043d\u044e \u0438 \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u043c\u0435\u043d\u044e");
        }
        this.inUpdate = false;
        this.updatePreview();
    }

    void updateWindow(WindowView wnd) {
        int i;
        wnd.visibleVar = this.wndVisibleVar;
        wnd.title = this.wndTitle;
        wnd.text = this.wndText;
        wnd.titleVar = this.wndTitleVar;
        wnd.titleDigits = this.wndTitleDigits;
        wnd.var = this.wndVar;
        wnd.digits = this.wndDigits;
        wnd.strings = this.cmbxVarIntFmt.isVisible() && this.cmbxVarIntFmt.getSelectedIndex() == 1 ? this.wndStrings : null;
        wnd.min = this.wndMin;
        wnd.max = this.wndMax;
        wnd.schedule = this.wndSchedule;
        wnd.archive = this.wndArchive;
        wnd.editable = this.rbWndEditVar.isSelected() || this.rbWndEditXY.isSelected();
        wnd.instEdit = this.chbxVarInstWrite.isVisible() && this.chbxVarInstWrite.isSelected();
        for (i = 0; i < wnd.editor.keyWindows.length; ++i) {
            if (wnd.editor.keyWindows[i] != wnd) continue;
            wnd.editor.keyWindows[i] = null;
            wnd.editor.markModified();
        }
        i = this.cmbxShortcut.getSelectedIndex() - 1;
        if (i >= 0 && this.chbxShortcut.isSelected()) {
            wnd.editor.keyWindows[i] = wnd;
            wnd.editor.markModified();
        }
        wnd.updatePreview();
    }

    VariableRef checkVar(JComboBox<VariableRef> combo, JLabel lbl) {
        VariableRef var = (VariableRef)combo.getSelectedItem();
        lbl.setVisible(var == null);
        return var;
    }

    public static int Round(double d) {
        return d >= 0.0 ? (int)(d + 0.5) : (int)(d - 0.5);
    }

    int getInt(JTextField tf, JLabel lbl) {
        double d;
        int dig = this.wndVar != null && this.wndVar.type() == 3 ? this.wndDigits : 0;
        double min = dig == 0 ? -32768.0 : -9999.0;
        double max = 32767.0;
        if (dig == 1) {
            min /= 10.0;
            max /= 10.0;
        } else if (dig == 2) {
            min /= 100.0;
            max /= 100.0;
        } else if (dig == 3) {
            min /= 1000.0;
            max /= 1000.0;
        }
        try {
            d = Double.parseDouble(tf.getText().replace(',', '.'));
        }
        catch (NumberFormatException e) {
            d = Double.NaN;
        }
        if (d < min || d > max) {
            d = Double.NaN;
        }
        if (Double.isNaN(d)) {
            lbl.setText("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0447\u0438\u0441\u043b\u043e \u043e\u0442 " + Utils.FormatDouble(min, dig) + " \u0434\u043e " + Utils.FormatDouble(max, dig));
            lbl.setVisible(true);
            return Integer.MIN_VALUE;
        }
        lbl.setVisible(false);
        if (dig == 1) {
            return WindowPropsDialog.Round(d * 10.0);
        }
        if (dig == 2) {
            return WindowPropsDialog.Round(d * 100.0);
        }
        if (dig == 3) {
            return WindowPropsDialog.Round(d * 1000.0);
        }
        return WindowPropsDialog.Round(d);
    }

    boolean validData() {
        boolean error = false;
        this.wndVisibleVar = null;
        if (this.chbxVisible.isSelected()) {
            this.wndVisibleVar = this.checkVar(this.cmbxVisVar, this.lblVisVarError);
            error |= this.wndVisibleVar == null;
        } else {
            this.lblVisVarError.setVisible(false);
        }
        this.cmbxShortcut.setVisible(this.chbxShortcut.isSelected());
        this.wndArchive = this.rbWndArchive.isSelected();
        this.wndSchedule = 0;
        if (this.rbWndText.isSelected() || this.rbWndSchedule.isSelected()) {
            this.wndTitleVar = null;
            this.wndVar = null;
            if (this.rbWndSchedule.isSelected()) {
                this.wndSchedule = this.cmbxSchedule.getSelectedIndex() + 1;
            }
        } else if (this.rbWndDispVar.isSelected() || this.rbWndEditVar.isSelected()) {
            this.wndTitleVar = null;
            this.wndVar = this.checkVar(this.cmbxVar, this.lblVarError);
            error |= this.wndVar == null;
            if (this.cmbxVarFloatFmt.isVisible()) {
                this.wndDigits = this.cmbxVarFloatFmt.getSelectedIndex();
            }
            if (this.tfVarMin.isVisible()) {
                this.wndMin = this.getInt(this.tfVarMin, this.lblVarMinError);
                error |= this.wndMin == Integer.MIN_VALUE;
            } else {
                this.lblVarMinError.setVisible(false);
            }
            if (this.tfVarMax.isVisible()) {
                this.wndMax = this.getInt(this.tfVarMax, this.lblVarMaxError);
                error |= this.wndMax == Integer.MIN_VALUE;
                if (this.wndMax != Integer.MIN_VALUE && this.wndMax <= this.wndMin) {
                    this.lblVarMaxError.setText("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c \u043c\u0438\u043d\u0438\u043c\u0443\u043c");
                    this.lblVarMaxError.setVisible(true);
                    error = true;
                }
            } else {
                this.lblVarMaxError.setVisible(false);
            }
        } else if (this.rbWndEditXY.isSelected()) {
            this.wndTitleVar = this.checkVar(this.cmbxXyTitle, this.lblXyTitleError);
            error |= this.wndTitleVar == null;
            this.wndTitleDigits = this.cmbxXyTitleFmt.getSelectedIndex();
            this.wndVar = this.checkVar(this.cmbxXyVar, this.lblXyVarError);
            error |= this.wndVar == null;
            this.lblXyVarError.setText(this.lblXyTitleError.getText());
            if (!(this.wndVar == null || this.wndTitleVar == null || this.wndVar.isArray() && this.wndTitleVar.isArray() && this.wndVar.arraySize() == this.wndTitleVar.arraySize())) {
                this.lblXyVarError.setText("\u041c\u0430\u0441\u0441\u0438\u0432\u044b X \u0438 Y \u0440\u0430\u0437\u043d\u043e\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u0430");
                error = true;
                this.lblXyVarError.setVisible(true);
            }
            this.wndDigits = this.cmbxXyVarFmt.getSelectedIndex();
            this.wndMin = this.getInt(this.tfXyMin, this.lblXyMinError);
            error |= this.wndMin == Integer.MIN_VALUE;
            this.wndMax = this.getInt(this.tfXyMax, this.lblXyMaxError);
            error |= this.wndMax == Integer.MIN_VALUE;
            if (this.wndMax != Integer.MIN_VALUE && this.wndMax < this.wndMin) {
                this.lblXyMaxError.setText("\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u043c\u0435\u043d\u044c\u0448\u0435 \u043c\u0438\u043d\u0438\u043c\u0443\u043c\u0430");
                this.lblXyMaxError.setVisible(true);
                error = true;
            }
        }
        this.btnOk.setEnabled(!error);
        this.pack();
        return !error;
    }

    static {
        INT_FORMATS = new String[]{"\u0427\u0438\u0441\u043b\u043e", "\u0422\u0435\u043a\u0441\u0442"};
        FLOAT_FORMATS = new String[]{"\u0426\u0435\u043b\u044b\u0435 (\u0448\u0430\u0433 1)", "\u0414\u0435\u0441\u044f\u0442\u044b\u0435 (\u0448\u0430\u0433 0.1)", "\u0421\u043e\u0442\u044b\u0435 (\u0448\u0430\u0433 0.01)", "\u0422\u044b\u0441\u044f\u0447\u043d\u044b\u0435 (\u0448\u0430\u0433 0.001)"};
        SHORTCUTS = new String[]{"", "\u0412\u0432\u0435\u0440\u0445 + \u0412\u043d\u0438\u0437", "\u0412\u043b\u0435\u0432\u043e + \u0432\u043f\u0440\u0430\u0432\u043e", "\u0412\u043d\u0438\u0437 + \u0432\u043b\u0435\u0432\u043e", "\u0412\u0432\u0435\u0440\u0445 + \u0432\u043f\u0440\u0430\u0432\u043e"};
    }
}

