/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.vics.Utils;
import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.ModbusSlaveBlock;
import certa.vics.compiler.SyntaxError;
import certa.vics.ide.IdeAction;
import certa.vics.ide.IdeTableCellRenderer;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.modbus.ModbusEditor;
import certa.vics.ide.modbus.RegView;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class ModbusTableView
extends JPanel {
    private static final long serialVersionUID = 1L;
    final String regName;
    boolean isBool;
    boolean isWritable;
    final boolean isMaster;
    final String propsKey;
    public static final int COL_ADDRESS = 0;
    public static final int COL_VAR = 1;
    public static final int COL_DIGITS = 2;
    public static final int COL_COMMENT = 3;
    public static final String[] COLUMNS = new String[]{"\u0410\u0434\u0440\u0435\u0441", "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f", "\u0422\u043e\u0447\u043d\u043e\u0441\u0442\u044c", "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"};
    static final int[] DEF_COLUMNS_W = new int[]{50, 200, 80, 500};
    static final String[] DIGITS = new String[]{"1", "0.1", "0.01", "0.001"};
    ArrayList<RegView> list = new ArrayList();
    final ModbusEditor editor;
    JPanel pnlParams;
    JComboBox<String> cmbxTableSize;
    JTable table;
    ModbusTableModel model;
    JComboBox<VariableRef> cmbxVarlist;
    JComboBox<String> cmbxDigits;
    IdeTableCellRenderer commentRender = new IdeTableCellRenderer(2, 8);
    boolean isModified;
    private int startAddress;
    private MouseListener focuser = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            ModbusTableView.this.table.requestFocusInWindow();
        }
    };
    boolean inUpdate;
    ActionListener updateTableSize = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ModbusTableView.this.inUpdate) {
                return;
            }
            int size = ModbusTableView.this.cmbxTableSize.getSelectedIndex();
            if (size >= 0 && size != ModbusTableView.this.list.size()) {
                int old = ModbusTableView.this.list.size();
                int count = old - size;
                if (count >= 1 && ModbusTableView.this.hasVars(size)) {
                    String msg;
                    String string = msg = count == 1 ? "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440 " + (old - 1) + "?" : "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u044b \u0441 " + (old - count) + " \u043f\u043e " + (old - 1) + "?";
                    if (!IdeUtils.confirmDialog(msg)) {
                        ModbusTableView.this.inUpdate = true;
                        ModbusTableView.this.cmbxTableSize.setSelectedIndex(old);
                        ModbusTableView.this.inUpdate = false;
                        return;
                    }
                }
                while (ModbusTableView.this.list.size() > size) {
                    ModbusTableView.this.list.remove(ModbusTableView.this.list.size() - 1);
                }
                while (ModbusTableView.this.list.size() < size) {
                    ModbusTableView.this.list.add(new RegView(null, 1));
                }
                ModbusTableView.this.markModified();
                ModbusTableView.this.model.fireTableDataChanged();
                ModbusTableView.this.editor.updateVarRefs();
                ModbusTableView.this.updateTableView();
                IdeAction.updateAll();
            }
        }
    };
    static final String PROP_COL_WIDTH = ".colwidth";
    TableColumn digitsColumn;

    public void setStartAddress(int addr, boolean isBool, boolean isWritable, VariablesEditor ved) {
        this.startAddress = addr;
        this.isBool = isBool;
        this.isWritable = isWritable;
        this.updateVarList(ved);
        this.model.fireTableDataChanged();
        this.updateTableView();
    }

    public ModbusTableView(ModbusEditor editor, String regName, boolean isBool, boolean isWritable, String propsKey, boolean isMaster) {
        this.editor = editor;
        this.regName = regName;
        this.isBool = isBool;
        this.isWritable = isWritable;
        this.isMaster = isMaster;
        this.propsKey = propsKey;
        this.model = new ModbusTableModel();
        this.table = new JTable(this.model);
        this.pnlParams = new JPanel(new MigLayout());
        this.cmbxVarlist = new JComboBox();
        this.cmbxTableSize = new JComboBox();
        String[] s = new String[251];
        for (int i = 0; i < s.length; ++i) {
            s[i] = Integer.toString(i);
        }
        this.cmbxTableSize.setModel(new DefaultComboBoxModel<String>(s));
        this.cmbxTableSize.setMaximumRowCount(20);
        this.cmbxTableSize.addActionListener(this.updateTableSize);
        this.cmbxDigits = new JComboBox();
        this.cmbxDigits.setModel(new DefaultComboBoxModel<String>(DIGITS));
        this.setupTable();
        this.loadProps();
        this.pnlParams.add((Component)new JLabel("\u0420\u0430\u0437\u043c\u0435\u0440 \u0442\u0430\u0431\u043b\u0438\u0446\u044b:"), "");
        this.pnlParams.add(this.cmbxTableSize, "");
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlParams, "North");
        JScrollPane scroll = new JScrollPane(this.table);
        this.add((Component)scroll, "Center");
        scroll.addMouseListener(this.focuser);
        this.table.getTableHeader().addMouseListener(this.focuser);
        this.pnlParams.addMouseListener(this.focuser);
    }

    protected void markModified() {
        this.isModified = true;
        this.editor.markModified();
    }

    boolean hasVars(int i0) {
        for (int i = i0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).var == null) continue;
            return true;
        }
        return false;
    }

    private void setupTable() {
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setAutoCreateRowSorter(false);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setCellRenderer(new IdeTableCellRenderer(4, 8));
        cm.getColumn(1).setCellEditor(new DefaultCellEditor(this.cmbxVarlist));
        cm.getColumn(2).setCellRenderer(new IdeTableCellRenderer(2, 8));
        cm.getColumn(2).setCellEditor(new DefaultCellEditor(this.cmbxDigits));
        cm.getColumn(3).setCellRenderer(this.commentRender);
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            TableColumn c = cm.getColumn(i);
            if (c.getCellRenderer() != null) continue;
            c.setCellRenderer(new IdeTableCellRenderer(2, 8));
        }
        int height = this.table.getRowHeight();
        this.table.setRowHeight(height + 6);
    }

    private void updateDigitsColumn() {
        TableColumnModel cm = this.table.getColumnModel();
        if (this.isBool) {
            if (this.digitsColumn == null) {
                TableColumn c = cm.getColumn(2);
                if (c != null) {
                    this.digitsColumn = c;
                }
                this.table.removeColumn(c);
            }
        } else if (this.digitsColumn != null) {
            this.table.addColumn(this.digitsColumn);
            this.digitsColumn = null;
        }
    }

    private void loadProps() {
        TableColumnModel cm = this.table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            cm.getColumn(i).setPreferredWidth(Main.props.getInt(this.propsKey + PROP_COL_WIDTH + i, DEF_COLUMNS_W[i]));
        }
        this.updateDigitsColumn();
    }

    public void saveProps() {
        TableColumnModel cm = this.table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            Main.props.saveInt(this.propsKey + PROP_COL_WIDTH + i, cm.getColumn(i).getPreferredWidth());
        }
    }

    public void updateVarList(VariablesEditor ved) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().cancelCellEditing();
        }
        if (ved == null) {
            return;
        }
        ArrayList<VariableRef> varList = ved.getAllVariables(true, 0);
        Iterator<VariableRef> it = varList.iterator();
        if (this.isBool) {
            while (it.hasNext()) {
                if (it.next().type() == 1) continue;
                it.remove();
            }
        }
        it = varList.iterator();
        if (this.isWritable) {
            while (it.hasNext()) {
                if (!this.isMaster ? it.next().isWritable() : it.next().isWritableInFbd()) continue;
                it.remove();
            }
        }
        varList.add(0, null);
        this.cmbxVarlist.setModel(new DefaultComboBoxModel<VariableRef>(new Vector<VariableRef>(varList)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRegs(ModbusSlaveBlock block, ArrayList<ModbusReg> regs, VariablesEditor ved) {
        this.list.clear();
        int i = 0;
        if (block != null) {
            this.inUpdate = true;
            for (ModbusReg r : regs) {
                if (block.isEmpty(r)) {
                    this.list.add(new RegView(null, 1));
                    continue;
                }
                this.list.add(new RegView(ved.makeRef(r.var), r.digits));
            }
            i = regs.size();
        }
        try {
            this.cmbxTableSize.setSelectedIndex(i);
        }
        finally {
            this.inUpdate = false;
        }
        this.updateVarList(ved);
        this.model.fireTableDataChanged();
        this.updateTableView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegList(int startAddress, ArrayList<RegView> regs, boolean isBool, boolean isWritable, VariablesEditor ved) {
        this.list = regs;
        this.inUpdate = true;
        try {
            this.cmbxTableSize.setSelectedIndex(regs.size());
        }
        finally {
            this.inUpdate = false;
        }
        this.setStartAddress(startAddress, isBool, isWritable, ved);
    }

    public void stopEditing() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    public void compileRegs(ModbusSlaveBlock block, int regType) throws SyntaxError {
        this.stopEditing();
        for (int i = 0; i < this.list.size(); ++i) {
            RegView r = this.list.get(i);
            if (r.var != null) {
                block.alloc(regType, i, r.var.getCompiledVar(), r.digits);
                continue;
            }
            block.alloc(regType, i, null, 0);
        }
    }

    protected void updateTableView() {
        TableColumn col = this.table.getTableHeader().getColumnModel().getColumn(this.table.convertColumnIndexToView(3));
        int w = 100;
        for (int r = 0; r < this.list.size(); ++r) {
            JLabel c = (JLabel)this.commentRender.getTableCellRendererComponent(this.table, this.model.getValueAt(r, 3), false, false, r, 3);
            Dimension ps = c.getPreferredSize();
            this.table.setRowHeight(r, ps.height + 4);
            w = Math.max(w, ps.width + 30);
        }
        col.setMinWidth(w);
        col.setPreferredWidth(w);
    }

    public void printData(PrintWriter pw, boolean scale, boolean init) {
        if (this.list.isEmpty()) {
            pw.println("--");
        } else {
            int w = 30;
            if (scale) {
                w -= 6;
            }
            if (init) {
                w -= 6;
            }
            pw.println("<table>");
            pw.println("<tr><th  style='width:4em'>\u0410\u0434\u0440\u0435\u0441</th><th style='width:" + w + "em'>\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f</th>" + (scale ? "<th style='width:4em'>\u041c\u0430\u0441\u0448\u0442\u0430\u0431</th>" : "") + (init ? "<th style='width:4em'>\u041d\u0430\u0447. \u0437\u043d.</th>" : "") + "<th style='width:30em'>\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439</th></tr>");
            for (int i = 0; i < this.list.size(); ++i) {
                pw.print("<tr><td style='text-align: right;'>");
                pw.print(i);
                pw.print("</td>");
                RegView rv = this.list.get(i);
                if (rv.var != null) {
                    pw.print("<td>");
                    pw.print(rv.var.shortName());
                    if (scale) {
                        pw.print("</td><td>");
                        if (rv.var.type() == 3) {
                            pw.print("x1");
                            for (int j = 0; j < rv.digits; ++j) {
                                pw.print("0");
                            }
                        }
                    }
                    if (init) {
                        pw.print("</td><td style='text-align: right;'>");
                        double v = rv.var.getInitValue();
                        if (!Double.isFinite(v)) {
                            v = 0.0;
                        }
                        if (rv.var.type() == 3) {
                            pw.print(Utils.FormatDouble(v, rv.digits));
                        } else {
                            pw.print(Utils.numToString(v));
                        }
                    }
                    pw.print("</td><td>");
                    pw.print(rv.var.varDef.getCommentHtml());
                } else {
                    pw.print("<td>--</td><td></td>");
                    if (scale) {
                        pw.print("<td></td>");
                    }
                }
                pw.println("</td></tr>");
            }
            pw.println("</table>");
        }
    }

    class ModbusTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<String> DIGITS_LIST = Arrays.asList(DIGITS);

        ModbusTableModel() {
        }

        @Override
        public int getRowCount() {
            return ModbusTableView.this.list.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return VariableRef.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            RegView reg = ModbusTableView.this.list.get(rowIndex);
            return columnIndex == 1 || !ModbusTableView.this.isBool && columnIndex == 2 && reg.var != null && reg.var.type() == 3;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                VariableRef v = null;
                if (aValue instanceof VariableRef) {
                    v = (VariableRef)aValue;
                }
                RegView reg = ModbusTableView.this.list.get(rowIndex);
                if (!VariableRef.sameVar(reg.var, v)) {
                    reg.var = v;
                    ModbusTableView.this.markModified();
                    ModbusTableView.this.editor.updateVarRefs();
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    ModbusTableView.this.updateTableView();
                    IdeAction.updateAll();
                }
            } else if (columnIndex == 2) {
                RegView reg = ModbusTableView.this.list.get(rowIndex);
                int d = this.DIGITS_LIST.indexOf(aValue);
                if (d >= 0 && d != reg.digits) {
                    reg.digits = d;
                    ModbusTableView.this.markModified();
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    ModbusTableView.this.updateTableView();
                    IdeAction.updateAll();
                }
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RegView rv = ModbusTableView.this.list.get(rowIndex);
            if (columnIndex == 0) {
                return Integer.toString(ModbusTableView.this.startAddress + rowIndex);
            }
            if (columnIndex == 1) {
                if (rv.var != null) {
                    return rv.var;
                }
                return null;
            }
            if (columnIndex == 2) {
                if (rv.var != null) {
                    if (rv.var.type() == 3) {
                        return DIGITS[rv.digits];
                    }
                    return "-";
                }
                return null;
            }
            if (columnIndex == 3) {
                if (rv.var != null) {
                    double v = rv.var.getInitValue();
                    return "<html>" + (v == v ? "<i>(" + Utils.numToString(v) + ")</i>&emsp;" : "") + rv.var.varDef.getCommentHtml() + "</html>";
                }
                return " ";
            }
            return null;
        }
    }
}

