/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.modbus;

import certa.vics.Utils;
import certa.vics.compiler.ModbusBlock;
import certa.vics.compiler.ModbusMasterBlock;
import certa.vics.compiler.ModbusMasterRequest;
import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.ModbusSlaveBlock;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.ide.ActionsBundle;
import certa.vics.ide.DialogErrorLabel;
import certa.vics.ide.IdeAction;
import certa.vics.ide.IdeEditor;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.modbus.ModbusActions;
import certa.vics.ide.modbus.ModbusTableView;
import certa.vics.ide.modbus.RegView;
import certa.vics.ide.modbus.RequestView;
import certa.vics.ide.variables.VariableRef;
import certa.vics.ide.variables.VariablesEditor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.json.JSONObject;

public class ModbusEditor
extends IdeEditor {
    private static final long serialVersionUID = 1L;
    ModbusActions actions;
    protected final MainFrame mainFrame;
    final ModbusTableView inputs;
    final ModbusTableView coils;
    final ModbusTableView iregs;
    final ModbusTableView hregs;
    final ArrayList<ModbusTableView> tabs = new ArrayList();
    final ArrayList<RequestView> masterRequests = new ArrayList();
    final ModbusTableView requestRegisters;
    JComboBox<String> cbxMode;
    static final String[] MODE = new String[]{"Slave", "Master"};
    JPanel cardPanel;
    JTabbedPane slaveTabbedPane;
    JPanel masterPropsPanel;
    JTextField tfTimeout;
    JTextField tfPause;
    RequestsListModel requestsModel;
    JList<RequestView> requestsList;
    JScrollPane requestsScroll;
    IdeUtils.BorderedPanel pnlReqList;
    JToolBar reqListToolBar;
    JSplitPane masterSplitter;
    IdeUtils.BorderedPanel pnlReqProps;
    JPanel pnlReqPropsTop;
    JComboBox<String> cbxFunction;
    static final String[] FUNCTIONS = new String[]{"1 (Read Coils)", "2 (Read Discrete Inputs)", "3 (Read Holding Registers)", "4 (Read Input Registers)", "5 (Write Single Coil)", "6 (Write Single Register)", "15 (Write Multiple Coils)", "16 (Write Multiple Registers)"};
    static final int[] FUNCTION_CODES = new int[]{1, 2, 3, 4, 5, 6, 15, 16};
    JTextField tfSlaveId;
    DialogErrorLabel lblSlaveIdError;
    JTextField tfStartAddr;
    DialogErrorLabel lblStartAddrError;
    JComboBox<VariableRef> cbxCmdVar;
    JComboBox<VariableRef> cbxStatusVar;
    static final String PROP_KEY = "modbus";
    final int portNumber;
    private boolean masterMode;
    private int masterTimeout;
    private int masterPause;
    final IdeAction addRequest = new IdeAction(null, "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441", "add_item.png", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441", 0, null){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canExec() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestView r = new RequestView(1, 1, 0, null, null);
            ModbusEditor.this.masterRequests.add(r);
            ModbusEditor.this.markModified();
            ModbusEditor.this.requestsModel.update();
            ModbusEditor.this.requestsList.setSelectedValue(r, true);
        }
    };
    final IdeAction deleteRequest = new IdeAction(null, "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", "delete.png", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441", 0, null){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canExec() {
            return ModbusEditor.this.requestsList.getSelectedValue() != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestView rv = ModbusEditor.this.requestsList.getSelectedValue();
            if (rv != null) {
                if (!IdeUtils.confirmDialog("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 '" + rv.toString() + "'?")) {
                    return;
                }
                ModbusEditor.this.masterRequests.remove(rv);
                ModbusEditor.this.markModified();
                ModbusEditor.this.requestsModel.update();
                ModbusEditor.this.setRequestControls();
            }
        }
    };
    final IdeAction moveRequestUp = new IdeAction(null, "\u0412\u0432\u0435\u0440\u0445", "up.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0432\u044b\u0448\u0435", 0, null){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canExec() {
            int i = ModbusEditor.this.requestsList.getSelectedIndex();
            return i > 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ModbusEditor.this.requestsList.getSelectedIndex();
            if (i > 0) {
                RequestView r = ModbusEditor.this.masterRequests.get(i - 1);
                ModbusEditor.this.masterRequests.set(i - 1, ModbusEditor.this.masterRequests.get(i));
                ModbusEditor.this.masterRequests.set(i, r);
                ModbusEditor.this.markModified();
                ModbusEditor.this.requestsModel.update();
                ModbusEditor.this.requestsList.setSelectedIndex(i - 1);
            }
        }
    };
    final IdeAction moveRequestDown = new IdeAction(null, "\u0412\u043d\u0438\u0437", "down.png", "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u043d\u0438\u0436\u0435", 0, null){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canExec() {
            int i = ModbusEditor.this.requestsList.getSelectedIndex();
            return i >= 0 && i < ModbusEditor.this.masterRequests.size() - 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ModbusEditor.this.requestsList.getSelectedIndex();
            if (i >= 0 && i < ModbusEditor.this.masterRequests.size() - 1) {
                RequestView r = ModbusEditor.this.masterRequests.get(i + 1);
                ModbusEditor.this.masterRequests.set(i + 1, ModbusEditor.this.masterRequests.get(i));
                ModbusEditor.this.masterRequests.set(i, r);
                ModbusEditor.this.markModified();
                ModbusEditor.this.requestsModel.update();
                ModbusEditor.this.requestsList.setSelectedIndex(i + 1);
            }
        }
    };
    InputVerifier inputVerifier = new InputVerifier(){

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            ModbusEditor.this.updateData();
            return true;
        }

        @Override
        public boolean verify(JComponent input) {
            return true;
        }
    };
    private boolean inUpdate;
    ActionListener update = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ModbusEditor.this.updateData();
        }
    };
    DocumentListener masterEditUpdate = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            ModbusEditor.this.updateData();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ModbusEditor.this.updateData();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ModbusEditor.this.updateData();
        }
    };
    static final String PROP_MODBUS_SPLIT = "modbus.split";

    public ModbusEditor(int portNumber, MainFrame mainFrame, JMenu menu) {
        super(menu, "MODBUS \u0434\u043b\u044f \u043f\u043e\u0440\u0442\u0430 \u2116" + portNumber, true);
        this.mainFrame = mainFrame;
        this.portNumber = portNumber;
        this.cbxMode = new JComboBox<String>(new DefaultComboBoxModel<String>(MODE));
        this.cbxMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModbusEditor.this.updateMode();
            }
        });
        this.toolBar.add(IdeUtils.addMargins(new JLabel("\u0420\u0435\u0436\u0438\u043c:"), 0, 10, 0, 8));
        this.toolBar.add(this.cbxMode).setFocusable(false);
        this.masterPropsPanel = new JPanel();
        JLabel lbl = new JLabel("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 (\u043c\u0441):");
        lbl.setToolTipText("\u0412\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441");
        this.masterPropsPanel.add(IdeUtils.addMargins(lbl, 0, 10, 0, 4));
        this.tfTimeout = new JTextField(6);
        this.tfTimeout.getDocument().addDocumentListener(this.masterEditUpdate);
        this.tfTimeout.setInputVerifier(this.inputVerifier);
        this.masterPropsPanel.add(this.tfTimeout);
        lbl = new JLabel("\u041f\u0430\u0443\u0437\u0430 (\u043c\u0441):");
        lbl.setToolTipText("\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u043f\u0435\u0440\u0435\u0434 \u043f\u043e\u0441\u044b\u043b\u043a\u043e\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u043d\u043e\u0433\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        this.masterPropsPanel.add(IdeUtils.addMargins(lbl, 0, 10, 0, 4));
        this.tfPause = new JTextField(6);
        this.tfPause.getDocument().addDocumentListener(this.masterEditUpdate);
        this.tfPause.setInputVerifier(this.inputVerifier);
        this.masterPropsPanel.add(this.tfPause);
        this.toolBar.add(this.masterPropsPanel);
        this.toolBar.addSeparator();
        this.toolBar.add(portNumber == 1 ? MainFrame.instance.actions.connectModbus1 : MainFrame.instance.actions.connectModbus2).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(portNumber == 1 ? MainFrame.instance.actions.exportModbus1 : MainFrame.instance.actions.exportModbus2).setFocusable(false);
        this.toolBar.addSeparator();
        this.toolBar.add(MainFrame.instance.actions.modbusHelp).setFocusable(false);
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(new CardLayout());
        this.inputs = new ModbusTableView(this, "INPUTS", true, false, "modbus.inputs", false);
        this.coils = new ModbusTableView(this, "COILS", true, true, "modbus.coils", false);
        this.iregs = new ModbusTableView(this, "INPUT REGS", false, false, "modbus.iregs", false);
        this.hregs = new ModbusTableView(this, "HOLDING REGS", false, true, "modbus.hregs", false);
        this.slaveTabbedPane = new JTabbedPane();
        this.addTab(this.inputs, "Inputs", "Read only 1-bit discretes");
        this.addTab(this.coils, "Coils", "Writable 1-bit discretes");
        this.addTab(this.iregs, "Input registers", "Read only 16-bit registers");
        this.addTab(this.hregs, "Holding registers", "Writable 16-bit registers");
        this.slaveTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ModbusEditor.this.initFocus();
            }
        });
        this.slaveTabbedPane.addMouseListener(this.focuser);
        this.pnlReqList = new IdeUtils.BorderedPanel(new JPanel(new BorderLayout()), "\u0421\u043f\u0438\u0441\u043e\u043a \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432"){
            private static final long serialVersionUID = 1L;

            @Override
            public void titleClicked() {
                ModbusEditor.this.pnlReqList.requestFocusInWindow();
            }

            @Override
            protected void focusChanged() {
                ModbusEditor.this.actions.update();
            }
        };
        this.reqListToolBar = IdeUtils.newToolBar();
        this.reqListToolBar.add(this.addRequest).setFocusable(false);
        this.reqListToolBar.add(this.moveRequestUp).setFocusable(false);
        this.reqListToolBar.add(this.moveRequestDown).setFocusable(false);
        this.reqListToolBar.addSeparator();
        this.reqListToolBar.add(this.deleteRequest).setFocusable(false);
        this.requestsModel = new RequestsListModel();
        this.requestsList = new JList<RequestView>(this.requestsModel);
        this.requestsList.setSelectionMode(0);
        this.requestsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ModbusEditor.this.setRequestControls();
            }
        });
        MouseListener ml = IdeUtils.createOnClickFocuser(this.requestsList);
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add(this.requestsList);
        pnl.addMouseListener(ml);
        pnl.setBackground(this.requestsList.getBackground());
        JScrollPane scroll = new JScrollPane(pnl);
        this.pnlReqList.addMouseListener(ml);
        this.pnlReqList.add((Component)this.reqListToolBar, "North");
        this.pnlReqList.add((Component)scroll, "Center");
        this.pnlReqProps = new IdeUtils.BorderedPanel(new JPanel(new BorderLayout()), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430"){
            private static final long serialVersionUID = 1L;

            @Override
            public void titleClicked() {
                ModbusEditor.this.pnlReqProps.requestFocusInWindow();
            }

            @Override
            protected void focusChanged() {
                ModbusEditor.this.actions.update();
            }
        };
        this.requestRegisters = new ModbusTableView(this, "Registers", false, false, "modbus.regs", true);
        this.pnlReqPropsTop = new JPanel(new MigLayout("insets 8 8 8 8", "", ""));
        JLabel lbl0 = new JLabel("\u0424\u0443\u043d\u043a\u0446\u0438\u044f:");
        lbl0.setToolTipText("\u041d\u043e\u043c\u0435\u0440 \u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 MODBUS");
        this.cbxFunction = new JComboBox<String>(new DefaultComboBoxModel<String>(FUNCTIONS));
        this.cbxFunction.addActionListener(this.update);
        JLabel lbl1 = new JLabel("ID \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:");
        lbl1.setToolTipText("\u0421\u0435\u0442\u0435\u0432\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 slave-\u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430, \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u0430\u0434\u0440\u0435\u0441\u043e\u0432\u0430\u043d \u0437\u0430\u043f\u0440\u043e\u0441");
        this.tfSlaveId = new JTextField(6);
        this.tfSlaveId.getDocument().addDocumentListener(this.masterEditUpdate);
        this.tfSlaveId.setInputVerifier(this.inputVerifier);
        this.lblSlaveIdError = new DialogErrorLabel("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 ID");
        JLabel lbl2 = new JLabel("\u0410\u0434\u0440\u0435\u0441 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430:");
        lbl2.setToolTipText("\u0410\u0434\u0440\u0435\u0441 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435. \u041e\u0442 0 \u0434\u043e 65535 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0440\u0430\u0437\u043c\u0435\u0440\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b.");
        this.tfStartAddr = new JTextField(6);
        this.tfStartAddr.getDocument().addDocumentListener(this.masterEditUpdate);
        this.tfStartAddr.setInputVerifier(this.inputVerifier);
        this.lblStartAddrError = new DialogErrorLabel("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441");
        JLabel lbl3 = new JLabel("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 (\u0430\u0432\u0442\u043e\u0441\u0431\u0440\u043e\u0441):");
        lbl3.setToolTipText("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0442\u0438\u043f\u0430 BOOL \u0434\u043b\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        this.cbxCmdVar = new JComboBox();
        this.cbxCmdVar.addActionListener(this.update);
        JLabel lbl4 = new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:");
        lbl4.setToolTipText("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0442\u0438\u043f\u0430 INT \u0434\u043b\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        this.cbxStatusVar = new JComboBox();
        this.cbxStatusVar.addActionListener(this.update);
        this.pnlReqPropsTop.add((Component)lbl1, "alignx right");
        this.pnlReqPropsTop.add((Component)this.tfSlaveId, "");
        this.pnlReqPropsTop.add((Component)this.lblSlaveIdError, "");
        this.pnlReqPropsTop.add((Component)lbl0, "newline, alignx right");
        this.pnlReqPropsTop.add(this.cbxFunction, "span");
        this.pnlReqPropsTop.add((Component)lbl2, "newline, alignx right");
        this.pnlReqPropsTop.add((Component)this.tfStartAddr, "");
        this.pnlReqPropsTop.add((Component)this.lblStartAddrError, "");
        this.pnlReqPropsTop.add((Component)lbl3, "newline, alignx right");
        this.pnlReqPropsTop.add(this.cbxCmdVar, "span");
        this.pnlReqPropsTop.add((Component)lbl4, "newline, alignx right");
        this.pnlReqPropsTop.add(this.cbxStatusVar, "span");
        this.pnlReqProps.add((Component)this.pnlReqPropsTop, "North");
        this.pnlReqProps.add((Component)this.requestRegisters, "Center");
        this.masterSplitter = new JSplitPane(1, this.pnlReqList, this.pnlReqProps);
        IdeUtils.setupDivider(this.masterSplitter);
        this.cardPanel.add((Component)this.slaveTabbedPane, MODE[0]);
        this.cardPanel.add((Component)this.masterSplitter, MODE[1]);
        this.add((Component)this.cardPanel, "Center");
        this.loadProps();
    }

    Point getTableLocation() {
        return this.cardPanel.getLocationOnScreen();
    }

    void setControls() {
        this.inUpdate = true;
        this.cbxMode.setSelectedIndex(this.masterMode ? 1 : 0);
        this.tfTimeout.setText(Integer.toString(this.masterTimeout));
        this.tfPause.setText(Integer.toString(this.masterPause));
        if (this.requestsList.getSelectedIndex() < 0 && this.requestsList.getModel().getSize() > 0) {
            this.requestsList.setSelectedIndex(0);
        }
        this.setRequestControls();
        this.inUpdate = false;
    }

    void setRequestControls() {
        this.inUpdate = true;
        RequestView rq = this.requestsList.getSelectedValue();
        this.pnlReqProps.setContentsVisible(rq != null);
        if (rq != null) {
            int t = rq.function;
            if (t >= 1 && t <= 6) {
                this.cbxFunction.setSelectedIndex(t - 1);
            } else if (t == 15 || t == 16) {
                this.cbxFunction.setSelectedIndex(t - 9);
            } else {
                this.cbxFunction.setSelectedIndex(0);
            }
            this.tfSlaveId.setText(Integer.toString(rq.id));
            this.tfStartAddr.setText(Integer.toString(rq.address));
            this.setVarInCombo(this.cbxCmdVar, rq.varCmd);
            this.setVarInCombo(this.cbxStatusVar, rq.varStatus);
            this.requestRegisters.setRegList(rq.address, rq.regs, rq.isDiscrete(), rq.varsWritable(), this.mainFrame.getVarsEditor());
        } else {
            this.requestRegisters.loadRegs(null, null, null);
        }
        this.inUpdate = false;
        this.addRequest.update();
        this.deleteRequest.update();
        this.moveRequestUp.update();
        this.moveRequestDown.update();
        this.updateData();
    }

    void updateData() {
        RequestView rq;
        if (this.inUpdate) {
            return;
        }
        int t = Utils.StringToIntDef(this.tfTimeout.getText(), -1);
        if (t >= 0 && t <= 65535) {
            if (this.masterTimeout != t) {
                this.markModified();
            }
            this.masterTimeout = t;
        }
        if ((t = Utils.StringToIntDef(this.tfPause.getText(), -1)) >= 0 && t <= 65535) {
            if (this.masterPause != t) {
                this.markModified();
            }
            this.masterPause = t;
        }
        if ((rq = this.requestsList.getSelectedValue()) != null) {
            boolean ok;
            t = this.cbxFunction.getSelectedIndex();
            boolean bl = ok = t >= 0;
            if (ok) {
                rq.function = this.updateInt(rq.function, FUNCTION_CODES[t]);
            }
            this.lblSlaveIdError.setVisible(!(ok = RequestView.correctId(t = Utils.StringToIntDef(this.tfSlaveId.getText(), -1))));
            if (ok) {
                rq.id = this.updateInt(rq.id, t);
            }
            this.lblStartAddrError.setVisible(!(ok = RequestView.correctAddress(t = Utils.StringToIntDef(this.tfStartAddr.getText(), -1), this.requestRegisters.list.size())));
            if (ok) {
                rq.address = this.updateInt(rq.address, t);
                this.requestRegisters.setStartAddress(t, rq.isDiscrete(), rq.varsWritable(), this.mainFrame.getVarsEditor());
            }
            rq.varCmd = this.updateVar(rq.varCmd, (VariableRef)this.cbxCmdVar.getSelectedItem());
            rq.varStatus = this.updateVar(rq.varStatus, (VariableRef)this.cbxStatusVar.getSelectedItem());
        }
        this.updateVarRefs();
    }

    private int updateInt(int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.markModified();
        }
        return newValue;
    }

    private VariableRef updateVar(VariableRef oldValue, VariableRef newValue) {
        if (oldValue == null || newValue == null) {
            if (newValue != oldValue) {
                this.markModified();
            }
        } else if (!oldValue.equals(newValue)) {
            this.markModified();
        }
        return newValue;
    }

    public boolean isMaster() {
        return this.masterMode;
    }

    private void addTab(ModbusTableView table, String title, String hint) {
        this.slaveTabbedPane.addTab(title, null, table, hint);
        this.tabs.add(table);
    }

    private void updateMode() {
        if (this.inUpdate) {
            return;
        }
        String mode = (String)this.cbxMode.getSelectedItem();
        boolean wasMaster = this.masterMode;
        this.masterMode = mode == MODE[1];
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, mode);
        this.masterPropsPanel.setVisible(this.masterMode);
        if (wasMaster != this.masterMode) {
            this.markModified();
        }
        this.updateControls();
        MainFrame.instance.actions.update();
    }

    @Override
    protected ActionsBundle createActions() {
        this.actions = new ModbusActions(this);
        return this.actions;
    }

    @Override
    public void titleClicked() {
        if (this.isMaster()) {
            this.pnlReqList.requestFocusInWindow();
        } else {
            int i = this.slaveTabbedPane.getSelectedIndex();
            if (i >= 0) {
                this.tabs.get((int)i).table.requestFocusInWindow();
            }
        }
    }

    @Override
    public void initFocus() {
        if (this.isMaster()) {
            this.requestsList.requestFocusInWindow();
            this.updateVarList();
        } else {
            int i = this.slaveTabbedPane.getSelectedIndex();
            if (i >= 0) {
                ModbusTableView t = this.tabs.get(i);
                t.table.requestFocusInWindow();
                t.updateVarList(this.mainFrame.getVarsEditor());
            }
        }
    }

    @Override
    public void clear() {
        this.inputs.loadRegs(null, null, null);
        this.coils.loadRegs(null, null, null);
        this.iregs.loadRegs(null, null, null);
        this.hregs.loadRegs(null, null, null);
        this.masterRequests.clear();
    }

    @Override
    public void markSavedToDisk() {
        super.markSavedToDisk();
        for (ModbusTableView t : this.tabs) {
            t.isModified = false;
        }
    }

    private void loadData() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ModbusBlock mb = this.portNumber == 2 ? this.mainFrame.program.Modbus2 : this.mainFrame.program.Modbus1;
        ModbusSlaveBlock slave = mb.slave();
        ModbusMasterBlock master = mb.master();
        this.masterMode = mb.isMaster();
        if (slave != null) {
            this.inputs.loadRegs(slave, slave.Inputs, ved);
            this.coils.loadRegs(slave, slave.Coils, ved);
            this.iregs.loadRegs(slave, slave.IRs, ved);
            this.hregs.loadRegs(slave, slave.HRs, ved);
        }
        if (master != null) {
            this.masterTimeout = master.timeout;
            this.masterPause = master.pause;
            for (int i = 0; i < master.requests.size(); ++i) {
                ModbusMasterRequest src = master.requests.get(i);
                RequestView rq = new RequestView(src.func, src.id, src.addr, ved.makeRef(src.varCmd), ved.makeRef(src.varStatus));
                this.masterRequests.add(rq);
                for (int j = 0; j < src.registers.size(); ++j) {
                    ModbusReg sr = src.registers.get(j);
                    rq.regs.add(new RegView(ved.makeRef(sr.var), sr.digits));
                }
            }
        } else {
            this.masterTimeout = 400;
            this.masterPause = 100;
        }
        this.updateVarList();
        this.updateMode();
    }

    @Override
    public void initNewProgram() {
        this.loadData();
        this.updateVarRefs();
    }

    @Override
    public void loadProgram(JSONObject json, int version) {
        this.loadData();
        this.updateVarRefs();
        this.markSavedToDisk();
    }

    Variable getCompiledVar(VariableRef vr, boolean writable, boolean needBool, boolean needInt, boolean needFloat) {
        if (vr == null) {
            return null;
        }
        if (writable && !vr.isWritableInFbd()) {
            return null;
        }
        if (vr.type() == 1 && !needBool) {
            return null;
        }
        if (vr.type() == 2 && !needInt) {
            return null;
        }
        if (vr.type() == 3 && !needFloat) {
            return null;
        }
        return vr.getCompiledVar();
    }

    @Override
    public void updateProgram(JSONObject json) throws SyntaxError {
        ModbusBlock mb = this.portNumber == 2 ? this.mainFrame.program.Modbus2 : this.mainFrame.program.Modbus1;
        mb.init(this.masterMode);
        ModbusSlaveBlock slave = mb.slave();
        ModbusMasterBlock master = mb.master();
        if (slave != null) {
            this.inputs.compileRegs(slave, 1);
            this.coils.compileRegs(slave, 2);
            this.iregs.compileRegs(slave, 3);
            this.hregs.compileRegs(slave, 4);
        }
        if (master != null) {
            master.timeout = this.masterTimeout;
            master.pause = this.masterPause;
            for (int i = 0; i < this.masterRequests.size(); ++i) {
                RequestView rq = this.masterRequests.get(i);
                Variable v1 = this.getCompiledVar(rq.varCmd, false, true, false, false);
                Variable v2 = this.getCompiledVar(rq.varStatus, true, false, true, false);
                master.allocRequest(rq.function, rq.id, rq.address, v1, v2);
                for (int j = 0; j < rq.regs.size(); ++j) {
                    RegView reg = rq.regs.get(j);
                    v1 = this.getCompiledVar(reg.var, rq.varsWritable(), true, true, true);
                    master.allocVar(v1, reg.digits);
                }
            }
        }
    }

    private void loadProps() {
        this.masterSplitter.setDividerLocation(Main.props.getInt(PROP_MODBUS_SPLIT + this.portNumber, 300));
    }

    @Override
    public void saveProps() {
        Main.props.saveInt(PROP_MODBUS_SPLIT + this.portNumber, this.masterSplitter.getDividerLocation());
    }

    public void updateVarRefs() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        ved.clearModbusRefs(this.portNumber);
        for (RequestView rq : this.masterRequests) {
            for (RegView r : rq.regs) {
                if (r.var == null) continue;
                r.var.varDef.addModbusRef(this.portNumber, r, rq.varsWritable());
            }
        }
        for (ModbusTableView t : this.tabs) {
            for (RegView r : t.list) {
                if (r.var == null) continue;
                r.var.varDef.addModbusRef(this.portNumber, r, t.isWritable);
            }
        }
        ved.updateTable();
        this.requestsModel.update();
    }

    void setVarInCombo(JComboBox<VariableRef> combo, VariableRef var) {
        combo.setSelectedItem(null);
        combo.setSelectedItem(var);
    }

    @Override
    public void updateVarList() {
        VariablesEditor ved = this.mainFrame.getVarsEditor();
        this.requestRegisters.updateVarList(ved);
        this.requestRegisters.model.fireTableDataChanged();
        for (ModbusTableView t : this.tabs) {
            t.updateVarList(ved);
            t.model.fireTableDataChanged();
        }
        ArrayList<VariableRef> vars = ved.getAllVariables(true, 0);
        Vector<VariableRef> vector = new Vector<VariableRef>();
        vector.add(null);
        for (VariableRef v : vars) {
            if (v == null || v.type() != 1 || !v.isWritableInFbd()) continue;
            vector.add(v);
        }
        this.cbxCmdVar.setModel(new DefaultComboBoxModel(vector));
        vector = new Vector();
        vector.add(null);
        for (VariableRef v : vars) {
            if (v == null || v.type() != 2 || !v.isWritableInFbd()) continue;
            vector.add(v);
        }
        this.cbxStatusVar.setModel(new DefaultComboBoxModel(vector));
        this.setControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportText(File file) {
        MainFrame.instance.startWaitCursor();
        try {
            try (PrintWriter pw = new PrintWriter(file, "UTF-8");){
                String prgName = MainFrame.instance.getCurrentFile().getName();
                pw.println("<!DOCTYPE html>");
                pw.println("<head>");
                pw.println("<meta charset=\"utf-8\" />");
                pw.println("<title>" + prgName + ", port " + this.portNumber + "</title>");
                pw.println("<style>");
                pw.println("body {padding: 1em;}");
                pw.println("table {border-collapse: collapse; table-layout:fixed;}");
                pw.println("table, th, td {border: 1px solid black;}");
                pw.println("th, td {padding: 0.2em 1em; vertical-align: middle;}");
                pw.println("</style>");
                pw.println("</head>");
                pw.println("<body>");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                pw.println("<h1>" + prgName + ", port " + this.portNumber + "</h1>");
                pw.println("<p>" + dateFormat.format(new Date()));
                pw.println("<p style='font-family:monospace'>" + MainFrame.instance.program.comment.replace("\n", "<br>"));
                pw.println("<h2>Discrete inputs <small>(read function: 2)</small></h2>");
                this.inputs.printData(pw, false, false);
                pw.println("<h2>Coils <small>(read function: 1, write function: 5)</small></h2>");
                this.coils.printData(pw, false, true);
                pw.println("<h2>Input registers <small>(read function: 4)</small></h2>");
                this.iregs.printData(pw, true, false);
                pw.println("<h2>Holding registers <small>(read function: 3, write function: 6)</small></h2>");
                this.hregs.printData(pw, true, true);
                pw.println("</body>");
                pw.println("</html>");
            }
            catch (Exception e) {
                Utils.ProcessException(e, false);
                JOptionPane.showMessageDialog(this, e.getMessage(), e.getClass().getSimpleName(), 0);
            }
        }
        finally {
            MainFrame.instance.stopWaitCursor();
        }
    }

    class RequestsListModel
    extends AbstractListModel<RequestView> {
        private static final long serialVersionUID = 1L;

        RequestsListModel() {
        }

        @Override
        public int getSize() {
            return ModbusEditor.this.masterRequests.size();
        }

        @Override
        public RequestView getElementAt(int index) {
            if (index >= 0 && index < ModbusEditor.this.masterRequests.size()) {
                return ModbusEditor.this.masterRequests.get(index);
            }
            return null;
        }

        void update() {
            this.fireContentsChanged(this, 0, ModbusEditor.this.masterRequests.size());
        }
    }
}

